/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal.undo;

import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.runtime.saveable.SaverScope;
import androidx.compose.runtime.snapshots.SnapshotStateList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\b\u0001\u0018\u0000 \u001e*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001eB1\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u000b\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u000b\u0010\u001c\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001d\u001a\u00020\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Landroidx/compose/foundation/text/input/internal/undo/UndoManager;", "T", "", "initialUndoStack", "", "initialRedoStack", "capacity", "", "<init>", "(Ljava/util/List;Ljava/util/List;I)V", "undoStack", "Landroidx/compose/runtime/snapshots/SnapshotStateList;", "redoStack", "canUndo", "", "getCanUndo$foundation", "()Z", "canRedo", "getCanRedo$foundation", "size", "getSize", "()I", "record", "", "undoableAction", "(Ljava/lang/Object;)V", "undo", "()Ljava/lang/Object;", "redo", "clearHistory", "Companion", "foundation"})
public final class UndoManager<T> {
    public static final Companion Companion = new Companion(null);
    private final int capacity;
    private SnapshotStateList<T> undoStack;
    private SnapshotStateList<T> redoStack;
    public static final int $stable = 8;

    public UndoManager(List<? extends T> list, List<? extends T> list2, int n2) {
        SnapshotStateList snapshotStateList;
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter(list2, (String)"");
        this.capacity = n2;
        n2 = this.capacity >= 0 ? 1 : 0;
        if (n2 == 0) {
            InlineClassHelperKt.throwIllegalArgumentException("Capacity must be a positive integer");
        }
        if ((n2 = list2.size() + list.size() <= this.capacity ? 1 : 0) == 0) {
            InlineClassHelperKt.throwIllegalArgumentException("Initial list of undo and redo operations have a size greater than the given capacity.");
        }
        SnapshotStateList snapshotStateList2 = snapshotStateList = new SnapshotStateList();
        UndoManager undoManager = this;
        snapshotStateList2.addAll((Collection)list);
        undoManager.undoStack = snapshotStateList;
        snapshotStateList2 = snapshotStateList = new SnapshotStateList();
        undoManager = this;
        snapshotStateList2.addAll((Collection)list2);
        undoManager.redoStack = snapshotStateList;
    }

    public /* synthetic */ UndoManager(List list, List list2, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n3 & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n3 & 4) != 0) {
            n2 = 100;
        }
        this(list, list2, n2);
    }

    public final boolean getCanUndo$foundation() {
        return !((Collection)this.undoStack).isEmpty();
    }

    public final boolean getCanRedo$foundation() {
        return !((Collection)this.redoStack).isEmpty();
    }

    public final int getSize() {
        return this.undoStack.size() + this.redoStack.size();
    }

    public final void record(T t2) {
        this.redoStack.clear();
        while (this.getSize() > this.capacity - 1) {
            CollectionsKt.removeFirst((List)((List)this.undoStack));
        }
        this.undoStack.add(t2);
    }

    public final T undo() {
        boolean bl = this.getCanUndo$foundation();
        if (!bl) {
            InlineClassHelperKt.throwIllegalStateException("It's an error to call undo while there is nothing to undo. Please first check `canUndo` value before calling the `undo` function.");
        }
        Object object = CollectionsKt.removeLast((List)((List)this.undoStack));
        this.redoStack.add(object);
        return (T)object;
    }

    public final T redo() {
        boolean bl = this.getCanRedo$foundation();
        if (!bl) {
            InlineClassHelperKt.throwIllegalStateException("It's an error to call redo while there is nothing to redo. Please first check `canRedo` value before calling the `redo` function.");
        }
        Object object = CollectionsKt.removeLast((List)((List)this.redoStack));
        this.undoStack.add(object);
        return (T)object;
    }

    public final void clearHistory() {
        this.undoStack.clear();
        this.redoStack.clear();
    }

    public UndoManager() {
        this(null, null, 0, 7, null);
    }

    public static final /* synthetic */ int access$getCapacity$p(UndoManager undoManager) {
        return undoManager.capacity;
    }

    public static final /* synthetic */ SnapshotStateList access$getUndoStack$p(UndoManager undoManager) {
        return undoManager.undoStack;
    }

    public static final /* synthetic */ SnapshotStateList access$getRedoStack$p(UndoManager undoManager) {
        return undoManager.redoStack;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u0006\u0012\u0004\u0012\u00020\u00010\u0005\"\u0006\b\u0001\u0010\u0007\u0018\u00012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00010\u0005H\u0086\b\u00a8\u0006\t"}, d2={"Landroidx/compose/foundation/text/input/internal/undo/UndoManager$Companion;", "", "<init>", "()V", "createSaver", "Landroidx/compose/runtime/saveable/Saver;", "Landroidx/compose/foundation/text/input/internal/undo/UndoManager;", "T", "itemSaver", "foundation"})
    public static final class Companion {
        private Companion() {
        }

        public final /* synthetic */ <T> Saver<UndoManager<T>, Object> createSaver(Saver<T, Object> saver) {
            Intrinsics.checkNotNullParameter(saver, (String)"");
            Intrinsics.needClassReification();
            return new Saver<UndoManager<T>, Object>(saver){
                final /* synthetic */ Saver<T, Object> $itemSaver;
                {
                    this.$itemSaver = saver;
                }

                public final Object save(SaverScope saverScope, UndoManager<T> undoManager) {
                    Saver<T, Object> saver;
                    E e;
                    int n2;
                    List list;
                    Intrinsics.checkNotNullParameter((Object)saverScope, (String)"");
                    Intrinsics.checkNotNullParameter(undoManager, (String)"");
                    Saver<T, Object> saver2 = this.$itemSaver;
                    List list2 = list = CollectionsKt.createListBuilder();
                    list.add(UndoManager.access$getCapacity$p(undoManager));
                    list2.add(UndoManager.access$getUndoStack$p(undoManager).size());
                    list2.add(UndoManager.access$getRedoStack$p(undoManager).size());
                    List list3 = (List)UndoManager.access$getUndoStack$p(undoManager);
                    int n3 = ((Collection)list3).size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        e = list3.get(n2);
                        saver = saver2;
                        list2.add(saver.save(saverScope, e));
                    }
                    list3 = (List)UndoManager.access$getRedoStack$p(undoManager);
                    n3 = ((Collection)list3).size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        e = list3.get(n2);
                        saver = saver2;
                        list2.add(saver.save(saverScope, e));
                    }
                    return CollectionsKt.build((List)list);
                }

                public final UndoManager<T> restore(Object object) {
                    int n2;
                    Saver<T, Object> saver;
                    Intrinsics.checkNotNullParameter((Object)object, (String)"");
                    object = (List)object;
                    List list = object;
                    int n3 = ((Number)object.get(0)).intValue();
                    int n4 = ((Number)list.get(1)).intValue();
                    int n5 = ((Number)list.get(2)).intValue();
                    Object object2 = this.$itemSaver;
                    Object object3 = saver = CollectionsKt.createListBuilder();
                    for (n2 = 3; n2 < n4 + 3; ++n2) {
                        Object object4 = object2.restore(object.get(n2));
                        Intrinsics.checkNotNull((Object)object4);
                        object3.add(object4);
                    }
                    List list2 = CollectionsKt.build((List)saver);
                    saver = this.$itemSaver;
                    object3 = CollectionsKt.createListBuilder();
                    object2 = object3;
                    while (n2 < n4 + n5 + 3) {
                        Object object5 = saver.restore(object.get(n2));
                        Intrinsics.checkNotNull((Object)object5);
                        object2.add(object5);
                        ++n2;
                    }
                    object2 = CollectionsKt.build(object3);
                    return new UndoManager<T>(list2, object2, n3);
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

