/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.foundation.text.StringHelpersKt;
import androidx.compose.foundation.text.StringHelpers_skikoKt;
import androidx.compose.foundation.text.selection.TextPreparedSelectionState;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b3\b!\u0018\u0000 c*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u00020\u0002:\u0001cB1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ>\u0010&\u001a\u00028\u0000\"\u0004\b\u0001\u0010'*\u0002H'2\b\b\u0002\u0010(\u001a\u00020)2\u0017\u0010*\u001a\u0013\u0012\u0004\u0012\u0002H'\u0012\u0004\u0012\u00020,0+\u00a2\u0006\u0002\b-H\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\u00020,2\u0006\u00100\u001a\u000201H\u0004J\u0018\u00102\u001a\u00020,2\u0006\u00103\u001a\u0002012\u0006\u00104\u001a\u000201H\u0004J\u000b\u00105\u001a\u00028\u0000\u00a2\u0006\u0002\u00106J\u000b\u00107\u001a\u00028\u0000\u00a2\u0006\u0002\u00106J\u000b\u00108\u001a\u00028\u0000\u00a2\u0006\u0002\u00106J\u000b\u00109\u001a\u00028\u0000\u00a2\u0006\u0002\u00106J$\u0010:\u001a\u00028\u00002\u0017\u0010;\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020,0+\u00a2\u0006\u0002\b-\u00a2\u0006\u0002\u0010<J$\u0010=\u001a\u00028\u00002\u0017\u0010;\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020,0+\u00a2\u0006\u0002\b-\u00a2\u0006\u0002\u0010<J\u0006\u0010>\u001a\u000201J\u0006\u0010?\u001a\u000201J\u0006\u0010@\u001a\u000201J\r\u0010A\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00106J\r\u0010B\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00106J\u000b\u0010C\u001a\u00028\u0000\u00a2\u0006\u0002\u00106J\u000b\u0010D\u001a\u00028\u0000\u00a2\u0006\u0002\u00106J\u000b\u0010E\u001a\u00028\u0000\u00a2\u0006\u0002\u00106J\u000b\u0010F\u001a\u00028\u0000\u00a2\u0006\u0002\u00106J\r\u0010G\u001a\u0004\u0018\u000101\u00a2\u0006\u0002\u0010HJ\r\u0010I\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00106J\r\u0010J\u001a\u0004\u0018\u000101\u00a2\u0006\u0002\u0010HJ\r\u0010K\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00106J\u000b\u0010L\u001a\u00028\u0000\u00a2\u0006\u0002\u00106J\u000b\u0010M\u001a\u00028\u0000\u00a2\u0006\u0002\u00106J\u000b\u0010N\u001a\u00028\u0000\u00a2\u0006\u0002\u00106J\u000b\u0010O\u001a\u00028\u0000\u00a2\u0006\u0002\u00106J\r\u0010P\u001a\u0004\u0018\u000101\u00a2\u0006\u0002\u0010HJ\u000b\u0010Q\u001a\u00028\u0000\u00a2\u0006\u0002\u00106J\r\u0010R\u001a\u0004\u0018\u000101\u00a2\u0006\u0002\u0010HJ\u000b\u0010S\u001a\u00028\u0000\u00a2\u0006\u0002\u00106J\u000b\u0010T\u001a\u00028\u0000\u00a2\u0006\u0002\u00106J\u000b\u0010U\u001a\u00028\u0000\u00a2\u0006\u0002\u00106J\u000b\u0010V\u001a\u00028\u0000\u00a2\u0006\u0002\u00106J\b\u0010W\u001a\u00020)H\u0002J\u0017\u0010X\u001a\u000201*\u00020\b2\b\b\u0002\u0010Y\u001a\u000201H\u0082\u0010J\u0017\u0010Z\u001a\u000201*\u00020\b2\b\b\u0002\u0010Y\u001a\u000201H\u0082\u0010J\u0016\u0010[\u001a\u000201*\u00020\b2\b\b\u0002\u0010Y\u001a\u000201H\u0002J\u0016\u0010\\\u001a\u000201*\u00020\b2\b\b\u0002\u0010Y\u001a\u000201H\u0002J\u0014\u0010]\u001a\u000201*\u00020\b2\u0006\u0010^\u001a\u000201H\u0002J\b\u0010_\u001a\u000201H\u0002J\b\u0010`\u001a\u000201H\u0002J\b\u0010a\u001a\u000201H\u0002J\u0010\u0010b\u001a\u0002012\u0006\u00100\u001a\u000201H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u001b\u0010\u0012\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0010\"\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006d"}, d2={"Landroidx/compose/foundation/text/selection/BaseTextPreparedSelection;", "T", "", "originalText", "Landroidx/compose/ui/text/AnnotatedString;", "originalSelection", "Landroidx/compose/ui/text/TextRange;", "layoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "offsetMapping", "Landroidx/compose/ui/text/input/OffsetMapping;", "state", "Landroidx/compose/foundation/text/selection/TextPreparedSelectionState;", "<init>", "(Landroidx/compose/ui/text/AnnotatedString;JLandroidx/compose/ui/text/TextLayoutResult;Landroidx/compose/ui/text/input/OffsetMapping;Landroidx/compose/foundation/text/selection/TextPreparedSelectionState;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getOriginalText", "()Landroidx/compose/ui/text/AnnotatedString;", "getOriginalSelection-d9O1mEE", "()J", "J", "getLayoutResult", "()Landroidx/compose/ui/text/TextLayoutResult;", "getOffsetMapping", "()Landroidx/compose/ui/text/input/OffsetMapping;", "getState", "()Landroidx/compose/foundation/text/selection/TextPreparedSelectionState;", "selection", "getSelection-d9O1mEE", "setSelection-5zc-tL8", "(J)V", "annotatedString", "getAnnotatedString", "setAnnotatedString", "(Landroidx/compose/ui/text/AnnotatedString;)V", "text", "", "getText$foundation", "()Ljava/lang/String;", "apply", "U", "resetCachedX", "", "block", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Object;ZLkotlin/jvm/functions/Function1;)Landroidx/compose/foundation/text/selection/BaseTextPreparedSelection;", "setCursor", "offset", "", "setSelection", "start", "end", "selectAll", "()Landroidx/compose/foundation/text/selection/BaseTextPreparedSelection;", "deselect", "moveCursorLeft", "moveCursorRight", "collapseLeftOr", "or", "(Lkotlin/jvm/functions/Function1;)Landroidx/compose/foundation/text/selection/BaseTextPreparedSelection;", "collapseRightOr", "getPrecedingCodePointOrEmojiStartIndex", "getPrecedingCharacterIndex", "getNextCharacterIndex", "moveCursorPrev", "moveCursorNext", "moveCursorToHome", "moveCursorToEnd", "moveCursorLeftByWord", "moveCursorRightByWord", "getNextWordOffset", "()Ljava/lang/Integer;", "moveCursorNextByWord", "getPreviousWordOffset", "moveCursorPrevByWord", "moveCursorPrevByParagraph", "moveCursorNextByParagraph", "moveCursorUpByLine", "moveCursorDownByLine", "getLineStartByOffset", "moveCursorToLineStart", "getLineEndByOffset", "moveCursorToLineEnd", "moveCursorToLineLeftSide", "moveCursorToLineRightSide", "selectMovement", "isLtr", "getNextWordOffsetForLayout", "currentOffset", "getPrevWordOffset", "getLineStartByOffsetForLayout", "getLineEndByOffsetForLayout", "jumpByLinesOffset", "linesAmount", "transformedEndOffset", "transformedMinOffset", "transformedMaxOffset", "charOffset", "Companion", "foundation"})
public abstract class BaseTextPreparedSelection<T extends BaseTextPreparedSelection<T>> {
    public static final Companion Companion = new Companion(null);
    private final AnnotatedString originalText;
    private final long originalSelection;
    private final TextLayoutResult layoutResult;
    private final OffsetMapping offsetMapping;
    private final TextPreparedSelectionState state;
    private long selection;
    private AnnotatedString annotatedString;
    public static final int $stable = 8;
    public static final int NoCharacterFound = -1;

    private BaseTextPreparedSelection(AnnotatedString annotatedString, long l2, TextLayoutResult textLayoutResult, OffsetMapping offsetMapping, TextPreparedSelectionState textPreparedSelectionState) {
        Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"");
        Intrinsics.checkNotNullParameter((Object)offsetMapping, (String)"");
        Intrinsics.checkNotNullParameter((Object)textPreparedSelectionState, (String)"");
        this.originalText = annotatedString;
        this.originalSelection = l2;
        this.layoutResult = textLayoutResult;
        this.offsetMapping = offsetMapping;
        this.state = textPreparedSelectionState;
        this.selection = this.originalSelection;
        this.annotatedString = this.originalText;
    }

    public final AnnotatedString getOriginalText() {
        return this.originalText;
    }

    public final long getOriginalSelection-d9O1mEE() {
        return this.originalSelection;
    }

    public final TextLayoutResult getLayoutResult() {
        return this.layoutResult;
    }

    public final OffsetMapping getOffsetMapping() {
        return this.offsetMapping;
    }

    public final TextPreparedSelectionState getState() {
        return this.state;
    }

    public final long getSelection-d9O1mEE() {
        return this.selection;
    }

    public final void setSelection-5zc-tL8(long l2) {
        this.selection = l2;
    }

    public final AnnotatedString getAnnotatedString() {
        return this.annotatedString;
    }

    public final void setAnnotatedString(AnnotatedString annotatedString) {
        Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"");
        this.annotatedString = annotatedString;
    }

    public final String getText$foundation() {
        return this.annotatedString.getText();
    }

    protected final <U> T apply(U u2, boolean bl, Function1<? super U, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        if (bl) {
            this.getState().resetCachedX();
        }
        if (((CharSequence)this.getText$foundation()).length() > 0) {
            function1.invoke(u2);
        }
        Intrinsics.checkNotNull(u2);
        return (T)((BaseTextPreparedSelection)u2);
    }

    public static /* synthetic */ BaseTextPreparedSelection apply$default(BaseTextPreparedSelection baseTextPreparedSelection, Object object, boolean bl, Function1 function1, int n2, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: apply");
        }
        if ((n2 & 1) != 0) {
            bl = true;
        }
        Intrinsics.checkNotNullParameter((Object)function1, (String)"");
        if (bl) {
            baseTextPreparedSelection.getState().resetCachedX();
        }
        if (((CharSequence)baseTextPreparedSelection.getText$foundation()).length() > 0) {
            function1.invoke(object);
        }
        Intrinsics.checkNotNull((Object)object);
        return (BaseTextPreparedSelection)object;
    }

    protected final void setCursor(int n2) {
        int n3 = n2;
        this.setSelection(n3, n3);
    }

    protected final void setSelection(int n2, int n3) {
        this.selection = TextRangeKt.TextRange((int)n2, (int)n3);
    }

    public final T selectAll() {
        this.getState().resetCachedX();
        if (((CharSequence)this.getText$foundation()).length() > 0) {
            BaseTextPreparedSelection baseTextPreparedSelection = this;
            baseTextPreparedSelection.setSelection(0, baseTextPreparedSelection.getText$foundation().length());
        }
        Intrinsics.checkNotNull((Object)this);
        return (T)this;
    }

    public final T deselect() {
        this.getState().resetCachedX();
        if (((CharSequence)this.getText$foundation()).length() > 0) {
            BaseTextPreparedSelection baseTextPreparedSelection = this;
            baseTextPreparedSelection.setCursor(TextRange.getEnd-impl((long)baseTextPreparedSelection.selection));
        }
        Intrinsics.checkNotNull((Object)this);
        return (T)this;
    }

    public final T moveCursorLeft() {
        this.getState().resetCachedX();
        if (((CharSequence)this.getText$foundation()).length() > 0) {
            BaseTextPreparedSelection baseTextPreparedSelection = this;
            if (baseTextPreparedSelection.isLtr()) {
                baseTextPreparedSelection.moveCursorPrev();
            } else {
                baseTextPreparedSelection.moveCursorNext();
            }
        }
        Intrinsics.checkNotNull((Object)this);
        return (T)this;
    }

    public final T moveCursorRight() {
        this.getState().resetCachedX();
        if (((CharSequence)this.getText$foundation()).length() > 0) {
            BaseTextPreparedSelection baseTextPreparedSelection = this;
            if (baseTextPreparedSelection.isLtr()) {
                baseTextPreparedSelection.moveCursorNext();
            } else {
                baseTextPreparedSelection.moveCursorPrev();
            }
        }
        Intrinsics.checkNotNull((Object)this);
        return (T)this;
    }

    public final T collapseLeftOr(Function1<? super T, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.getState().resetCachedX();
        if (((CharSequence)this.getText$foundation()).length() > 0) {
            BaseTextPreparedSelection baseTextPreparedSelection = this;
            if (TextRange.getCollapsed-impl((long)baseTextPreparedSelection.selection)) {
                Intrinsics.checkNotNull((Object)baseTextPreparedSelection);
                function1.invoke((Object)baseTextPreparedSelection);
            } else if (baseTextPreparedSelection.isLtr()) {
                BaseTextPreparedSelection baseTextPreparedSelection2 = baseTextPreparedSelection;
                baseTextPreparedSelection2.setCursor(TextRange.getMin-impl((long)baseTextPreparedSelection2.selection));
            } else {
                BaseTextPreparedSelection baseTextPreparedSelection3 = baseTextPreparedSelection;
                baseTextPreparedSelection3.setCursor(TextRange.getMax-impl((long)baseTextPreparedSelection3.selection));
            }
        }
        Intrinsics.checkNotNull((Object)this);
        return (T)this;
    }

    public final T collapseRightOr(Function1<? super T, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.getState().resetCachedX();
        if (((CharSequence)this.getText$foundation()).length() > 0) {
            BaseTextPreparedSelection baseTextPreparedSelection = this;
            if (TextRange.getCollapsed-impl((long)baseTextPreparedSelection.selection)) {
                Intrinsics.checkNotNull((Object)baseTextPreparedSelection);
                function1.invoke((Object)baseTextPreparedSelection);
            } else if (baseTextPreparedSelection.isLtr()) {
                BaseTextPreparedSelection baseTextPreparedSelection2 = baseTextPreparedSelection;
                baseTextPreparedSelection2.setCursor(TextRange.getMax-impl((long)baseTextPreparedSelection2.selection));
            } else {
                BaseTextPreparedSelection baseTextPreparedSelection3 = baseTextPreparedSelection;
                baseTextPreparedSelection3.setCursor(TextRange.getMin-impl((long)baseTextPreparedSelection3.selection));
            }
        }
        Intrinsics.checkNotNull((Object)this);
        return (T)this;
    }

    public final int getPrecedingCodePointOrEmojiStartIndex() {
        return StringHelpers_skikoKt.findCodePointOrEmojiStartBefore(this.annotatedString.getText(), TextRange.getEnd-impl((long)this.selection), -1);
    }

    public final int getPrecedingCharacterIndex() {
        return StringHelpers_skikoKt.findPrecedingBreak(this.annotatedString.getText(), TextRange.getEnd-impl((long)this.selection));
    }

    public final int getNextCharacterIndex() {
        return StringHelpers_skikoKt.findFollowingBreak(this.annotatedString.getText(), TextRange.getEnd-impl((long)this.selection));
    }

    private final T moveCursorPrev() {
        BaseTextPreparedSelection baseTextPreparedSelection;
        int n2;
        this.getState().resetCachedX();
        if (((CharSequence)this.getText$foundation()).length() > 0 && (n2 = (baseTextPreparedSelection = this).getPrecedingCharacterIndex()) != -1) {
            baseTextPreparedSelection.setCursor(n2);
        }
        Intrinsics.checkNotNull((Object)this);
        return (T)this;
    }

    private final T moveCursorNext() {
        BaseTextPreparedSelection baseTextPreparedSelection;
        int n2;
        this.getState().resetCachedX();
        if (((CharSequence)this.getText$foundation()).length() > 0 && (n2 = (baseTextPreparedSelection = this).getNextCharacterIndex()) != -1) {
            baseTextPreparedSelection.setCursor(n2);
        }
        Intrinsics.checkNotNull((Object)this);
        return (T)this;
    }

    public final T moveCursorToHome() {
        this.getState().resetCachedX();
        if (((CharSequence)this.getText$foundation()).length() > 0) {
            BaseTextPreparedSelection baseTextPreparedSelection = this;
            baseTextPreparedSelection.setCursor(0);
        }
        Intrinsics.checkNotNull((Object)this);
        return (T)this;
    }

    public final T moveCursorToEnd() {
        this.getState().resetCachedX();
        if (((CharSequence)this.getText$foundation()).length() > 0) {
            BaseTextPreparedSelection baseTextPreparedSelection = this;
            baseTextPreparedSelection.setCursor(baseTextPreparedSelection.getText$foundation().length());
        }
        Intrinsics.checkNotNull((Object)this);
        return (T)this;
    }

    public final T moveCursorLeftByWord() {
        this.getState().resetCachedX();
        if (((CharSequence)this.getText$foundation()).length() > 0) {
            BaseTextPreparedSelection baseTextPreparedSelection = this;
            if (baseTextPreparedSelection.isLtr()) {
                baseTextPreparedSelection.moveCursorPrevByWord();
            } else {
                baseTextPreparedSelection.moveCursorNextByWord();
            }
        }
        Intrinsics.checkNotNull((Object)this);
        return (T)this;
    }

    public final T moveCursorRightByWord() {
        this.getState().resetCachedX();
        if (((CharSequence)this.getText$foundation()).length() > 0) {
            BaseTextPreparedSelection baseTextPreparedSelection = this;
            if (baseTextPreparedSelection.isLtr()) {
                baseTextPreparedSelection.moveCursorNextByWord();
            } else {
                baseTextPreparedSelection.moveCursorPrevByWord();
            }
        }
        Intrinsics.checkNotNull((Object)this);
        return (T)this;
    }

    public final Integer getNextWordOffset() {
        TextLayoutResult textLayoutResult = this.layoutResult;
        if (textLayoutResult != null) {
            return BaseTextPreparedSelection.getNextWordOffsetForLayout$default(this, textLayoutResult, 0, 1, null);
        }
        return null;
    }

    private final T moveCursorNextByWord() {
        this.getState().resetCachedX();
        if (((CharSequence)this.getText$foundation()).length() > 0) {
            BaseTextPreparedSelection baseTextPreparedSelection = this;
            Integer n2 = baseTextPreparedSelection.getNextWordOffset();
            if (n2 != null) {
                int n3 = ((Number)n2).intValue();
                baseTextPreparedSelection.setCursor(n3);
            }
        }
        Intrinsics.checkNotNull((Object)this);
        return (T)this;
    }

    public final Integer getPreviousWordOffset() {
        TextLayoutResult textLayoutResult = this.layoutResult;
        if (textLayoutResult != null) {
            return BaseTextPreparedSelection.getPrevWordOffset$default(this, textLayoutResult, 0, 1, null);
        }
        return null;
    }

    private final T moveCursorPrevByWord() {
        this.getState().resetCachedX();
        if (((CharSequence)this.getText$foundation()).length() > 0) {
            BaseTextPreparedSelection baseTextPreparedSelection = this;
            Integer n2 = baseTextPreparedSelection.getPreviousWordOffset();
            if (n2 != null) {
                int n3 = ((Number)n2).intValue();
                baseTextPreparedSelection.setCursor(n3);
            }
        }
        Intrinsics.checkNotNull((Object)this);
        return (T)this;
    }

    public final T moveCursorPrevByParagraph() {
        this.getState().resetCachedX();
        if (((CharSequence)this.getText$foundation()).length() > 0) {
            BaseTextPreparedSelection baseTextPreparedSelection = this;
            int n2 = StringHelpersKt.findParagraphStart(baseTextPreparedSelection.getText$foundation(), TextRange.getMin-impl((long)baseTextPreparedSelection.selection));
            if (n2 == TextRange.getMin-impl((long)baseTextPreparedSelection.selection) && n2 != 0) {
                n2 = StringHelpersKt.findParagraphStart(baseTextPreparedSelection.getText$foundation(), n2 - 1);
            }
            baseTextPreparedSelection.setCursor(n2);
        }
        Intrinsics.checkNotNull((Object)this);
        return (T)this;
    }

    public final T moveCursorNextByParagraph() {
        this.getState().resetCachedX();
        if (((CharSequence)this.getText$foundation()).length() > 0) {
            BaseTextPreparedSelection baseTextPreparedSelection = this;
            int n2 = StringHelpersKt.findParagraphEnd(baseTextPreparedSelection.getText$foundation(), TextRange.getMax-impl((long)baseTextPreparedSelection.selection));
            if (n2 == TextRange.getMax-impl((long)baseTextPreparedSelection.selection) && n2 != baseTextPreparedSelection.getText$foundation().length()) {
                n2 = StringHelpersKt.findParagraphEnd(baseTextPreparedSelection.getText$foundation(), n2 + 1);
            }
            baseTextPreparedSelection.setCursor(n2);
        }
        Intrinsics.checkNotNull((Object)this);
        return (T)this;
    }

    public final T moveCursorUpByLine() {
        BaseTextPreparedSelection baseTextPreparedSelection = this;
        BaseTextPreparedSelection baseTextPreparedSelection2 = this;
        if (((CharSequence)baseTextPreparedSelection.getText$foundation()).length() > 0) {
            baseTextPreparedSelection = baseTextPreparedSelection2;
            TextLayoutResult textLayoutResult = baseTextPreparedSelection.layoutResult;
            if (textLayoutResult != null) {
                int n2 = baseTextPreparedSelection.jumpByLinesOffset(textLayoutResult, -1);
                baseTextPreparedSelection.setCursor(n2);
            }
        }
        Intrinsics.checkNotNull((Object)baseTextPreparedSelection2);
        return (T)baseTextPreparedSelection2;
    }

    public final T moveCursorDownByLine() {
        BaseTextPreparedSelection baseTextPreparedSelection = this;
        BaseTextPreparedSelection baseTextPreparedSelection2 = this;
        if (((CharSequence)baseTextPreparedSelection.getText$foundation()).length() > 0) {
            baseTextPreparedSelection = baseTextPreparedSelection2;
            TextLayoutResult textLayoutResult = baseTextPreparedSelection.layoutResult;
            if (textLayoutResult != null) {
                int n2 = baseTextPreparedSelection.jumpByLinesOffset(textLayoutResult, 1);
                baseTextPreparedSelection.setCursor(n2);
            }
        }
        Intrinsics.checkNotNull((Object)baseTextPreparedSelection2);
        return (T)baseTextPreparedSelection2;
    }

    public final Integer getLineStartByOffset() {
        TextLayoutResult textLayoutResult = this.layoutResult;
        if (textLayoutResult != null) {
            return BaseTextPreparedSelection.getLineStartByOffsetForLayout$default(this, textLayoutResult, 0, 1, null);
        }
        return null;
    }

    public final T moveCursorToLineStart() {
        this.getState().resetCachedX();
        if (((CharSequence)this.getText$foundation()).length() > 0) {
            BaseTextPreparedSelection baseTextPreparedSelection = this;
            Integer n2 = baseTextPreparedSelection.getLineStartByOffset();
            if (n2 != null) {
                int n3 = ((Number)n2).intValue();
                baseTextPreparedSelection.setCursor(n3);
            }
        }
        Intrinsics.checkNotNull((Object)this);
        return (T)this;
    }

    public final Integer getLineEndByOffset() {
        TextLayoutResult textLayoutResult = this.layoutResult;
        if (textLayoutResult != null) {
            return BaseTextPreparedSelection.getLineEndByOffsetForLayout$default(this, textLayoutResult, 0, 1, null);
        }
        return null;
    }

    public final T moveCursorToLineEnd() {
        this.getState().resetCachedX();
        if (((CharSequence)this.getText$foundation()).length() > 0) {
            BaseTextPreparedSelection baseTextPreparedSelection = this;
            Integer n2 = baseTextPreparedSelection.getLineEndByOffset();
            if (n2 != null) {
                int n3 = ((Number)n2).intValue();
                baseTextPreparedSelection.setCursor(n3);
            }
        }
        Intrinsics.checkNotNull((Object)this);
        return (T)this;
    }

    public final T moveCursorToLineLeftSide() {
        this.getState().resetCachedX();
        if (((CharSequence)this.getText$foundation()).length() > 0) {
            BaseTextPreparedSelection baseTextPreparedSelection = this;
            if (baseTextPreparedSelection.isLtr()) {
                baseTextPreparedSelection.moveCursorToLineStart();
            } else {
                baseTextPreparedSelection.moveCursorToLineEnd();
            }
        }
        Intrinsics.checkNotNull((Object)this);
        return (T)this;
    }

    public final T moveCursorToLineRightSide() {
        this.getState().resetCachedX();
        if (((CharSequence)this.getText$foundation()).length() > 0) {
            BaseTextPreparedSelection baseTextPreparedSelection = this;
            if (baseTextPreparedSelection.isLtr()) {
                baseTextPreparedSelection.moveCursorToLineEnd();
            } else {
                baseTextPreparedSelection.moveCursorToLineStart();
            }
        }
        Intrinsics.checkNotNull((Object)this);
        return (T)this;
    }

    public final T selectMovement() {
        BaseTextPreparedSelection baseTextPreparedSelection = this;
        BaseTextPreparedSelection baseTextPreparedSelection2 = this;
        if (((CharSequence)baseTextPreparedSelection.getText$foundation()).length() > 0) {
            baseTextPreparedSelection = baseTextPreparedSelection2;
            baseTextPreparedSelection2.selection = TextRangeKt.TextRange((int)TextRange.getStart-impl((long)baseTextPreparedSelection.originalSelection), (int)TextRange.getEnd-impl((long)baseTextPreparedSelection.selection));
        }
        Intrinsics.checkNotNull((Object)baseTextPreparedSelection2);
        return (T)baseTextPreparedSelection2;
    }

    private final boolean isLtr() {
        TextLayoutResult textLayoutResult = this.layoutResult;
        ResolvedTextDirection resolvedTextDirection = textLayoutResult != null ? textLayoutResult.getParagraphDirection(this.transformedEndOffset()) : null;
        return resolvedTextDirection != ResolvedTextDirection.Rtl;
    }

    private final int getNextWordOffsetForLayout(TextLayoutResult textLayoutResult, int n2) {
        long l2;
        BaseTextPreparedSelection baseTextPreparedSelection = this;
        while (true) {
            if (n2 >= baseTextPreparedSelection.originalText.length()) {
                return baseTextPreparedSelection.originalText.length();
            }
            l2 = textLayoutResult.getWordBoundary--jx7JFs(baseTextPreparedSelection.charOffset(n2));
            if (TextRange.getEnd-impl((long)l2) > n2) break;
            ++n2;
        }
        return baseTextPreparedSelection.offsetMapping.transformedToOriginal(TextRange.getEnd-impl((long)l2));
    }

    static /* synthetic */ int getNextWordOffsetForLayout$default(BaseTextPreparedSelection baseTextPreparedSelection, TextLayoutResult textLayoutResult, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getNextWordOffsetForLayout");
        }
        if ((n3 & 1) != 0) {
            n2 = baseTextPreparedSelection.transformedEndOffset();
        }
        return baseTextPreparedSelection.getNextWordOffsetForLayout(textLayoutResult, n2);
    }

    private final int getPrevWordOffset(TextLayoutResult textLayoutResult, int n2) {
        long l2;
        BaseTextPreparedSelection baseTextPreparedSelection = this;
        while (true) {
            if (n2 <= 0) {
                return 0;
            }
            l2 = textLayoutResult.getWordBoundary--jx7JFs(baseTextPreparedSelection.charOffset(n2));
            if (TextRange.getStart-impl((long)l2) < n2) break;
            --n2;
        }
        return baseTextPreparedSelection.offsetMapping.transformedToOriginal(TextRange.getStart-impl((long)l2));
    }

    static /* synthetic */ int getPrevWordOffset$default(BaseTextPreparedSelection baseTextPreparedSelection, TextLayoutResult textLayoutResult, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getPrevWordOffset");
        }
        if ((n3 & 1) != 0) {
            n2 = baseTextPreparedSelection.transformedEndOffset();
        }
        return baseTextPreparedSelection.getPrevWordOffset(textLayoutResult, n2);
    }

    private final int getLineStartByOffsetForLayout(TextLayoutResult textLayoutResult, int n2) {
        n2 = textLayoutResult.getLineForOffset(n2);
        return this.offsetMapping.transformedToOriginal(textLayoutResult.getLineStart(n2));
    }

    static /* synthetic */ int getLineStartByOffsetForLayout$default(BaseTextPreparedSelection baseTextPreparedSelection, TextLayoutResult textLayoutResult, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getLineStartByOffsetForLayout");
        }
        if ((n3 & 1) != 0) {
            n2 = baseTextPreparedSelection.transformedMinOffset();
        }
        return baseTextPreparedSelection.getLineStartByOffsetForLayout(textLayoutResult, n2);
    }

    private final int getLineEndByOffsetForLayout(TextLayoutResult textLayoutResult, int n2) {
        n2 = textLayoutResult.getLineForOffset(n2);
        return this.offsetMapping.transformedToOriginal(textLayoutResult.getLineEnd(n2, true));
    }

    static /* synthetic */ int getLineEndByOffsetForLayout$default(BaseTextPreparedSelection baseTextPreparedSelection, TextLayoutResult textLayoutResult, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getLineEndByOffsetForLayout");
        }
        if ((n3 & 1) != 0) {
            n2 = baseTextPreparedSelection.transformedMaxOffset();
        }
        return baseTextPreparedSelection.getLineEndByOffsetForLayout(textLayoutResult, n2);
    }

    private final int jumpByLinesOffset(TextLayoutResult textLayoutResult, int n2) {
        int n3 = this.transformedEndOffset();
        if (this.state.getCachedX() == null) {
            this.state.setCachedX(Float.valueOf(textLayoutResult.getCursorRect(n3).getLeft()));
        }
        if ((n2 = textLayoutResult.getLineForOffset(n3) + n2) < 0) {
            return 0;
        }
        if (n2 >= textLayoutResult.getLineCount()) {
            return this.getText$foundation().length();
        }
        float f2 = textLayoutResult.getLineBottom(n2) - 1.0f;
        Float f3 = this.state.getCachedX();
        Intrinsics.checkNotNull((Object)f3);
        Float f4 = f3;
        float f5 = ((Number)f3).floatValue();
        if (this.isLtr() && f5 >= textLayoutResult.getLineRight(n2) || !this.isLtr() && f5 <= textLayoutResult.getLineLeft(n2)) {
            return textLayoutResult.getLineEnd(n2, true);
        }
        float f6 = ((Number)f4).floatValue();
        long l2 = Float.floatToRawIntBits(f6);
        long l3 = Float.floatToRawIntBits(f2);
        int n4 = textLayoutResult.getOffsetForPosition-k-4lQ0M(Offset.constructor-impl((long)(l2 << 32 | l3 & 0xFFFFFFFFL)));
        int n5 = this.offsetMapping.transformedToOriginal(n4);
        return n5;
    }

    private final int transformedEndOffset() {
        return this.offsetMapping.originalToTransformed(TextRange.getEnd-impl((long)this.selection));
    }

    private final int transformedMinOffset() {
        return this.offsetMapping.originalToTransformed(TextRange.getMin-impl((long)this.selection));
    }

    private final int transformedMaxOffset() {
        return this.offsetMapping.originalToTransformed(TextRange.getMax-impl((long)this.selection));
    }

    private final int charOffset(int n2) {
        return RangesKt.coerceAtMost((int)n2, (int)(this.getText$foundation().length() - 1));
    }

    public /* synthetic */ BaseTextPreparedSelection(AnnotatedString annotatedString, long l2, TextLayoutResult textLayoutResult, OffsetMapping offsetMapping, TextPreparedSelectionState textPreparedSelectionState, DefaultConstructorMarker defaultConstructorMarker) {
        this(annotatedString, l2, textLayoutResult, offsetMapping, textPreparedSelectionState);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/compose/foundation/text/selection/BaseTextPreparedSelection$Companion;", "", "<init>", "()V", "NoCharacterFound", "", "foundation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

