/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.icons.FlatCapsLockIcon;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatTextFieldUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PasswordView;
import javax.swing.text.View;

public class FlatPasswordFieldUI
extends FlatTextFieldUI {
    private static final String KEY_REVEAL_SELECTED = "FlatLaf.internal.FlatPasswordFieldUI.revealSelected";
    private Character echoChar;
    @FlatStylingSupport.Styleable
    protected boolean showCapsLock;
    @FlatStylingSupport.Styleable
    protected boolean showRevealButton;
    protected Icon capsLockIcon;
    protected Icon revealIcon;
    private KeyListener capsLockListener;
    private boolean capsLockIconShared = true;
    private JToggleButton revealButton;
    private boolean uninstallEchoChar;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatPasswordFieldUI();
    }

    @Override
    protected String getPropertyPrefix() {
        return "PasswordField";
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installRevealButton();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallRevealButton();
        super.uninstallUI(jComponent);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        String string = this.getPropertyPrefix();
        this.echoChar = (Character)UIManager.get(string + ".echoChar");
        if (this.echoChar != null) {
            LookAndFeel.installProperty(this.getComponent(), "echoChar", this.echoChar);
        }
        this.showCapsLock = UIManager.getBoolean("PasswordField.showCapsLock");
        this.showRevealButton = UIManager.getBoolean("PasswordField.showRevealButton");
        this.capsLockIcon = UIManager.getIcon("PasswordField.capsLockIcon");
        this.revealIcon = UIManager.getIcon("PasswordField.revealIcon");
        this.capsLockIconShared = true;
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.capsLockIcon = null;
        this.revealIcon = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.capsLockListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                this.repaint(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                this.repaint(keyEvent);
            }

            private void repaint(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 20) {
                    keyEvent.getComponent().repaint();
                    FlatPasswordFieldUI.this.scrollCaretToVisible();
                }
            }
        };
        this.getComponent().addKeyListener(this.capsLockListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeKeyListener(this.capsLockListener);
        this.capsLockListener = null;
    }

    @Override
    protected void installKeyboardActions() {
        Action action;
        super.installKeyboardActions();
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.getComponent());
        if (actionMap != null && actionMap.get("select-word") != null && (action = actionMap.get("select-line")) != null) {
            actionMap.put("select-word", action);
        }
    }

    @Override
    String getStyleType() {
        return "PasswordField";
    }

    @Override
    protected void applyStyle(Object object) {
        boolean bl = this.showRevealButton;
        super.applyStyle(object);
        if (this.showRevealButton != bl) {
            this.uninstallRevealButton();
            this.installRevealButton();
        }
    }

    @Override
    protected Object applyStyleProperty(String string, Object object) {
        if (string.equals("capsLockIconColor") && this.capsLockIcon instanceof FlatCapsLockIcon) {
            if (this.capsLockIconShared) {
                this.capsLockIcon = FlatStylingSupport.cloneIcon(this.capsLockIcon);
                this.capsLockIconShared = false;
            }
            return ((FlatCapsLockIcon)this.capsLockIcon).applyStyleProperty(string, object);
        }
        return super.applyStyleProperty(string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent object) {
        object = super.getStyleableInfos((JComponent)object);
        object.put((String)"capsLockIconColor", Color.class);
        return object;
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        if (string.equals("capsLockIconColor") && this.capsLockIcon instanceof FlatCapsLockIcon) {
            return ((FlatCapsLockIcon)this.capsLockIcon).getStyleableValue(string);
        }
        return super.getStyleableValue(jComponent, string);
    }

    @Override
    public View create(Element element) {
        return new PasswordView(element);
    }

    @Override
    protected void paintIcons(Graphics graphics, Rectangle rectangle) {
        super.paintIcons(graphics, rectangle);
        if (this.isCapsLockVisible()) {
            this.paintCapsLock(graphics, rectangle);
        }
    }

    protected void paintCapsLock(Graphics graphics, Rectangle rectangle) {
        JTextComponent jTextComponent = this.getComponent();
        int n = jTextComponent.getComponentOrientation().isLeftToRight() ? rectangle.x + rectangle.width - this.capsLockIcon.getIconWidth() : rectangle.x;
        int n2 = rectangle.y + Math.round((float)(rectangle.height - this.capsLockIcon.getIconHeight()) / 2.0f);
        this.capsLockIcon.paintIcon(jTextComponent, graphics, n, n2);
    }

    @Override
    protected boolean hasTrailingIcon() {
        return super.hasTrailingIcon() || this.isCapsLockVisible();
    }

    @Override
    protected int getTrailingIconWidth() {
        return super.getTrailingIconWidth() + (this.isCapsLockVisible() ? this.capsLockIcon.getIconWidth() + UIScale.scale(this.iconTextGap) : 0);
    }

    protected boolean isCapsLockVisible() {
        if (!this.showCapsLock) {
            return false;
        }
        return FlatUIUtils.isPermanentFocusOwner(this.getComponent()) && Toolkit.getDefaultToolkit().getLockingKeyState(20);
    }

    protected void installRevealButton() {
        if (this.showRevealButton) {
            this.revealButton = this.createRevealButton();
            this.updateRevealButton();
            this.installLayout();
            this.getComponent().add(this.revealButton);
        }
    }

    protected JToggleButton createRevealButton() {
        JPasswordField jPasswordField = (JPasswordField)this.getComponent();
        JToggleButton jToggleButton = new JToggleButton(this.revealIcon, !jPasswordField.echoCharIsSet());
        jToggleButton.setName("PasswordField.revealButton");
        this.prepareLeadingOrTrailingComponent(jToggleButton);
        jToggleButton.putClientProperty("FlatLaf.styleClass", "inTextField revealButton");
        if (FlatClientProperties.clientPropertyBoolean(jPasswordField, KEY_REVEAL_SELECTED, false)) {
            jToggleButton.setSelected(true);
            this.updateEchoChar(true);
        }
        jToggleButton.addActionListener(actionEvent -> {
            boolean bl = jToggleButton.isSelected();
            this.updateEchoChar(bl);
            jPasswordField.putClientProperty(KEY_REVEAL_SELECTED, bl);
        });
        return jToggleButton;
    }

    protected void updateRevealButton() {
        if (this.revealButton == null) {
            return;
        }
        JTextComponent jTextComponent = this.getComponent();
        boolean bl = jTextComponent.isEnabled();
        if (bl != this.revealButton.isVisible()) {
            this.revealButton.setVisible(bl);
            jTextComponent.revalidate();
            jTextComponent.repaint();
            if (!bl) {
                this.revealButton.setSelected(false);
                this.updateEchoChar(false);
                this.getComponent().putClientProperty(KEY_REVEAL_SELECTED, null);
            }
        }
    }

    @Override
    protected void propertyChange(PropertyChangeEvent object) {
        super.propertyChange((PropertyChangeEvent)object);
        switch (((PropertyChangeEvent)object).getPropertyName()) {
            case "enabled": {
                this.updateRevealButton();
            }
        }
    }

    private void updateEchoChar(boolean bl) {
        JPasswordField jPasswordField;
        char c = bl ? (char)'\u0000' : (this.echoChar != null ? (char)this.echoChar.charValue() : (char)'*');
        if (c == (jPasswordField = (JPasswordField)this.getComponent()).getEchoChar()) {
            return;
        }
        LookAndFeel.installProperty(jPasswordField, "echoChar", Character.valueOf(c));
        char c2 = jPasswordField.getEchoChar();
        if (c2 != c) {
            if (bl && c2 != '\u0000') {
                this.echoChar = Character.valueOf(c2);
                this.uninstallEchoChar = true;
            }
            jPasswordField.setEchoChar(c);
        }
    }

    protected void uninstallRevealButton() {
        if (this.revealButton != null) {
            if (this.uninstallEchoChar && this.revealButton.isSelected()) {
                ((JPasswordField)this.getComponent()).setEchoChar(this.echoChar.charValue());
            }
            this.getComponent().remove(this.revealButton);
            this.revealButton = null;
        }
    }

    @Override
    protected JComponent[] getTrailingComponents() {
        return new JComponent[]{this.trailingComponent, this.revealButton, this.clearButton};
    }
}

