/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatDropShadowBorder;
import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.ui.FlatNativeMacLibrary;
import com.formdev.flatlaf.ui.FlatNativeWindowsLibrary;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.StackUtils;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowFocusListener;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicComboPopup;

public class FlatPopupFactory
extends PopupFactory {
    static final String KEY_POPUP_USES_NATIVE_BORDER = "FlatLaf.internal.FlatPopupFactory.popupUsesNativeBorder";
    private MethodHandle java8getPopupMethod;
    private MethodHandle java9getPopupMethod;

    @Override
    public Popup getPopup(Component component, Component component2, int n, int n2) {
        Point point = this.fixToolTipLocation(component, component2, n, n2);
        if (point != null) {
            n = point.x;
            n2 = point.y;
        }
        FlatPopupFactory.fixLinuxWaylandJava21focusIssue(component);
        boolean bl = FlatPopupFactory.isOptionEnabled(component, component2, "Popup.forceHeavyWeight", "Popup.forceHeavyWeight");
        if (!FlatPopupFactory.isOptionEnabled(component, component2, "Popup.dropShadowPainted", "Popup.dropShadowPainted") || SystemInfo.isProjector || SystemInfo.isWebswing) {
            return new NonFlashingPopup(this.getPopupForScreenOfOwner(component, component2, n, n2, bl), component2);
        }
        if (SystemInfo.isMacOS || SystemInfo.isLinux) {
            NonFlashingPopup nonFlashingPopup = new NonFlashingPopup(this.getPopupForScreenOfOwner(component, component2, n, n2, true), component2);
            if (nonFlashingPopup.popupWindow != null && SystemInfo.isMacOS && FlatNativeMacLibrary.isLoaded()) {
                FlatPopupFactory.setupRoundedBorder(nonFlashingPopup.popupWindow, component, component2);
            }
            return nonFlashingPopup;
        }
        if (FlatPopupFactory.isWindows11BorderSupported() && FlatPopupFactory.getBorderCornerRadius(component, component2) > 0) {
            NonFlashingPopup nonFlashingPopup = new NonFlashingPopup(this.getPopupForScreenOfOwner(component, component2, n, n2, true), component2);
            if (nonFlashingPopup.popupWindow != null) {
                FlatPopupFactory.setupRoundedBorder(nonFlashingPopup.popupWindow, component, component2);
            }
            return nonFlashingPopup;
        }
        if (!bl && FlatPopupFactory.overlapsHeavyWeightComponent(component, component2, n, n2)) {
            bl = true;
        }
        FlatPopupFactory flatPopupFactory = this;
        return flatPopupFactory.new DropShadowPopup(flatPopupFactory.getPopupForScreenOfOwner(component, component2, n, n2, bl), component, component2);
    }

    private Popup getPopupForScreenOfOwner(Component component, Component component2, int n, int n2, boolean bl) {
        int n3 = 0;
        while (true) {
            Popup popup = bl ? this.getHeavyWeightPopup(component, component2, n, n2) : super.getPopup(component, component2, n, n2);
            Window window = SwingUtilities.windowForComponent(component2);
            if (window == null || component == null || window.getGraphicsConfiguration() == component.getGraphicsConfiguration()) {
                return popup;
            }
            if (++n3 > 10) {
                return popup;
            }
            if (window instanceof JWindow) {
                ((JWindow)window).getContentPane().removeAll();
            }
            window.dispose();
        }
    }

    private Popup getHeavyWeightPopup(Component component, Component component2, int n, int n2) {
        try {
            if (SystemInfo.isJava_9_orLater) {
                if (this.java9getPopupMethod == null) {
                    MethodType methodType = MethodType.methodType(Popup.class, Component.class, Component.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                    this.java9getPopupMethod = MethodHandles.lookup().findVirtual(PopupFactory.class, "getPopup", methodType);
                }
                return this.java9getPopupMethod.invoke(this, component, component2, n, n2, true);
            }
            if (this.java8getPopupMethod == null) {
                Method method = PopupFactory.class.getDeclaredMethod("getPopup", Component.class, Component.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                method.setAccessible(true);
                this.java8getPopupMethod = MethodHandles.lookup().unreflect(method);
            }
            return this.java8getPopupMethod.invoke(this, component, component2, n, n2, 2);
        }
        catch (Throwable throwable) {
            return super.getPopup(component, component2, n, n2);
        }
    }

    private static boolean isOptionEnabled(Component object, Component component, String string, String string2) {
        if ((object = FlatPopupFactory.getOption((Component)object, component, string, string2)) instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    private static Object getOption(Component componentArray, Component component, String string, String string2) {
        componentArray = new Component[]{componentArray, component};
        int cfr_ignored_0 = componentArray.length;
        for (int i = 0; i < 2; ++i) {
            Object object = componentArray[i];
            if (!(object instanceof JComponent) || (object = ((JComponent)object).getClientProperty(string)) == null) continue;
            return object;
        }
        return UIManager.get(string2);
    }

    private Point fixToolTipLocation(Component component, Component serializable, int n, int n2) {
        if (!(serializable instanceof JToolTip) || !this.wasInvokedFromToolTipManager() || this.hasTipLocation(component)) {
            return null;
        }
        Object object = MouseInfo.getPointerInfo();
        if (object == null) {
            return null;
        }
        object = ((PointerInfo)object).getLocation();
        serializable = ((Component)serializable).getPreferredSize();
        Object object2 = new Rectangle(n, n2, ((Dimension)serializable).width, ((Dimension)serializable).height);
        if (!((Rectangle)object2).contains((Point)object)) {
            return null;
        }
        object2 = null;
        for (GraphicsDevice graphicsDevice : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            GraphicsConfiguration n4 = graphicsDevice.getDefaultConfiguration();
            if (!n4.getBounds().contains((Point)object)) continue;
            object2 = n4;
            break;
        }
        if (object2 == null) {
            object2 = component.getGraphicsConfiguration();
        }
        if (object2 == null) {
            return null;
        }
        Rectangle rectangle = ((GraphicsConfiguration)object2).getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)object2);
        int n3 = rectangle.y + insets.top;
        int n4 = ((Point)object).y - ((Dimension)serializable).height - UIScale.scale(20);
        if (n4 < n3) {
            return null;
        }
        return new Point(n, n4);
    }

    private boolean wasInvokedFromToolTipManager() {
        return StackUtils.wasInvokedFrom(ToolTipManager.class.getName(), "showTipWindow", 8);
    }

    private boolean hasTipLocation(Component component) {
        if (!(component instanceof JComponent)) {
            return false;
        }
        Object object = EventQueue.getCurrentEvent();
        if (object instanceof MouseEvent) {
            object = (MouseEvent)object;
        } else {
            object = MouseInfo.getPointerInfo();
            if (object == null) {
                return false;
            }
            object = new Point(((PointerInfo)object).getLocation());
            SwingUtilities.convertPointFromScreen((Point)object, component);
            object = new MouseEvent(component, 503, System.currentTimeMillis(), 0, ((Point)object).x, ((Point)object).y, 0, false);
        }
        return ((EventObject)object).getSource() == component && ((JComponent)component).getToolTipLocation((MouseEvent)object) != null;
    }

    private static boolean isWindows11BorderSupported() {
        return SystemInfo.isWindows_11_orLater && FlatNativeWindowsLibrary.isLoaded();
    }

    private static void setupRoundedBorder(Window window, Component component, Component component2) {
        if (!window.isDisplayable()) {
            window.addNotify();
        }
        int n = FlatPopupFactory.getBorderCornerRadius(component, component2);
        float f = FlatPopupFactory.getRoundedBorderWidth(component, component2);
        Color color = null;
        if (component2 instanceof JComponent) {
            Border border = ((JComponent)component2).getBorder();
            if ((border = FlatUIUtils.unwrapNonUIResourceBorder(border)) instanceof FlatLineBorder) {
                color = ((FlatLineBorder)border).getLineColor();
            } else if (border instanceof LineBorder) {
                color = ((LineBorder)border).getLineColor();
            } else if (border instanceof EmptyBorder) {
                color = FlatNativeWindowsLibrary.COLOR_NONE;
            }
            ((JComponent)component2).putClientProperty(KEY_POPUP_USES_NATIVE_BORDER, Boolean.TRUE);
        }
        if (SystemInfo.isWindows) {
            long l = FlatNativeWindowsLibrary.getHWND(window);
            int n2 = n <= 4 ? 3 : 2;
            FlatNativeWindowsLibrary.setWindowCornerPreference(l, n2);
            FlatNativeWindowsLibrary.dwmSetWindowAttributeCOLORREF(l, 34, color);
            return;
        }
        if (SystemInfo.isMacOS) {
            if (color == null || color == FlatNativeWindowsLibrary.COLOR_NONE) {
                f = 0.0f;
            }
            FlatNativeMacLibrary.setWindowRoundedBorder(window, n, f, color != null ? color.getRGB() : 0);
        }
    }

    private static void resetWindows11Border(Window window) {
        long l = FlatNativeWindowsLibrary.getHWND(window);
        if (l == 0L) {
            return;
        }
        FlatNativeWindowsLibrary.setWindowCornerPreference(l, 1);
    }

    private static int getBorderCornerRadius(Component object, Component component) {
        String string = component instanceof BasicComboPopup ? "ComboBox.borderCornerRadius" : (component instanceof JPopupMenu ? "PopupMenu.borderCornerRadius" : (component instanceof JToolTip ? "ToolTip.borderCornerRadius" : "Popup.borderCornerRadius"));
        if ((object = FlatPopupFactory.getOption((Component)object, component, "Popup.borderCornerRadius", string)) instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    private static float getRoundedBorderWidth(Component object, Component component) {
        String string = component instanceof BasicComboPopup ? "ComboBox.roundedBorderWidth" : (component instanceof JPopupMenu ? "PopupMenu.roundedBorderWidth" : (component instanceof JToolTip ? "ToolTip.roundedBorderWidth" : "Popup.roundedBorderWidth"));
        if ((object = FlatPopupFactory.getOption((Component)object, component, "Popup.roundedBorderWidth", string)) instanceof Number) {
            return ((Number)object).floatValue();
        }
        return 0.0f;
    }

    private static boolean overlapsHeavyWeightComponent(Component component, Component serializable, int n, int n2) {
        if (component == null) {
            return false;
        }
        if ((component = SwingUtilities.getWindowAncestor(component)) == null) {
            return false;
        }
        serializable = new Rectangle(new Point(n, n2), serializable.getPreferredSize());
        return FlatPopupFactory.overlapsHeavyWeightComponent(component, (Rectangle)serializable);
    }

    private static boolean overlapsHeavyWeightComponent(Component componentArray, Rectangle rectangle) {
        if (!componentArray.isVisible() || !rectangle.intersects(componentArray.getBounds())) {
            return false;
        }
        if (!componentArray.isLightweight() && !(componentArray instanceof Window)) {
            return true;
        }
        if (componentArray instanceof Container) {
            rectangle = new Rectangle(rectangle.x - componentArray.getX(), rectangle.y - componentArray.getY(), rectangle.width, rectangle.height);
            for (Component component : ((Container)componentArray).getComponents()) {
                if (!FlatPopupFactory.overlapsHeavyWeightComponent(component, rectangle)) continue;
                return true;
            }
        }
        return false;
    }

    private static void fixLinuxWaylandJava21focusIssue(Component component) {
        if (component == null || !SystemInfo.isLinux || SystemInfo.javaVersion < SystemInfo.toVersion(21, 0, 0, 0)) {
            return;
        }
        if ((component = SwingUtilities.getWindowAncestor(component)) == null) {
            return;
        }
        for (WindowFocusListener windowFocusListener : ((Window)component).getWindowFocusListeners()) {
            if (!"sun.awt.UNIXToolkit$1".equals(windowFocusListener.getClass().getName())) continue;
            ((Window)component).removeWindowFocusListener(windowFocusListener);
            return;
        }
    }

    private static void showPopupAndFixLocation(Popup popup, Window window) {
        if (window != null) {
            int n = window.getX();
            int n2 = window.getY();
            popup.show();
            if (window.getX() != n || window.getY() != n2) {
                window.setLocation(n, n2);
            }
            return;
        }
        popup.show();
    }

    private class DropShadowPopup
    extends NonFlashingPopup {
        private final Component owner;
        private JComponent lightComp;
        private Border oldBorder;
        private boolean oldOpaque;
        private boolean mediumWeightShown;
        private Panel mediumWeightPanel;
        private JPanel dropShadowPanel;
        private ComponentListener mediumPanelListener;
        private Popup dropShadowDelegate;
        private Window dropShadowWindow;
        private Color oldDropShadowWindowBackground;

        DropShadowPopup(Popup object, Component component, Component serializable) {
            super((Popup)object, (Component)serializable);
            this.owner = component;
            object = serializable.getPreferredSize();
            if (((Dimension)object).width <= 0 || ((Dimension)object).height <= 0) {
                return;
            }
            if (this.popupWindow != null) {
                object = new JPanel();
                ((JComponent)object).setBorder(this.createDropShadowBorder());
                ((JComponent)object).setOpaque(false);
                serializable = this.popupWindow.getPreferredSize();
                Insets insets = ((JComponent)object).getInsets();
                ((JComponent)object).setPreferredSize(new Dimension(((Dimension)serializable).width + insets.left + insets.right, ((Dimension)serializable).height + insets.top + insets.bottom));
                int n = this.popupWindow.getX() - insets.left;
                int n2 = this.popupWindow.getY() - insets.top;
                this.dropShadowDelegate = FlatPopupFactory.this.getPopupForScreenOfOwner(component, (Component)object, n, n2, true);
                this.dropShadowWindow = SwingUtilities.windowForComponent((Component)object);
                if (this.dropShadowWindow != null) {
                    this.oldDropShadowWindowBackground = this.dropShadowWindow.getBackground();
                    this.dropShadowWindow.setBackground(new Color(0, true));
                }
                if (FlatPopupFactory.isWindows11BorderSupported()) {
                    FlatPopupFactory.resetWindows11Border(this.popupWindow);
                    if (this.dropShadowWindow != null) {
                        FlatPopupFactory.resetWindows11Border(this.dropShadowWindow);
                    }
                }
                return;
            }
            this.mediumWeightPanel = (Panel)SwingUtilities.getAncestorOfClass(Panel.class, serializable);
            if (this.mediumWeightPanel != null) {
                this.dropShadowPanel = new JPanel();
                this.dropShadowPanel.setBorder(this.createDropShadowBorder());
                this.dropShadowPanel.setOpaque(false);
                this.dropShadowPanel.setSize(FlatUIUtils.addInsets(this.mediumWeightPanel.getSize(), this.dropShadowPanel.getInsets()));
                return;
            }
            object = serializable.getParent();
            if (!(object instanceof JComponent)) {
                return;
            }
            this.lightComp = (JComponent)object;
            this.oldBorder = this.lightComp.getBorder();
            this.oldOpaque = this.lightComp.isOpaque();
            this.lightComp.setBorder(this.createDropShadowBorder());
            this.lightComp.setOpaque(false);
            this.lightComp.setSize(this.lightComp.getPreferredSize());
        }

        private Border createDropShadowBorder() {
            return new FlatDropShadowBorder(UIManager.getColor("Popup.dropShadowColor"), UIManager.getInsets("Popup.dropShadowInsets"), FlatUIUtils.getUIFloat("Popup.dropShadowOpacity", 0.5f));
        }

        @Override
        public void show() {
            if (this.dropShadowDelegate != null) {
                FlatPopupFactory.showPopupAndFixLocation(this.dropShadowDelegate, this.dropShadowWindow);
            }
            if (this.mediumWeightPanel != null) {
                this.showMediumWeightDropShadow();
            }
            super.show();
            if (this.lightComp != null) {
                Insets insets = this.lightComp.getInsets();
                if (insets.left != 0 || insets.top != 0) {
                    this.lightComp.setLocation(this.lightComp.getX() - insets.left, this.lightComp.getY() - insets.top);
                }
            }
        }

        @Override
        public void hide() {
            if (this.dropShadowDelegate != null) {
                this.dropShadowDelegate.hide();
                this.dropShadowDelegate = null;
            }
            if (this.mediumWeightPanel != null) {
                this.hideMediumWeightDropShadow();
                this.dropShadowPanel = null;
                this.mediumWeightPanel = null;
            }
            super.hide();
            if (this.dropShadowWindow != null) {
                this.dropShadowWindow.setBackground(this.oldDropShadowWindowBackground);
                this.dropShadowWindow = null;
            }
            if (this.lightComp != null) {
                this.lightComp.setBorder(this.oldBorder);
                this.lightComp.setOpaque(this.oldOpaque);
                this.lightComp = null;
            }
        }

        private void showMediumWeightDropShadow() {
            if (this.mediumWeightShown) {
                return;
            }
            this.mediumWeightShown = true;
            if (this.owner == null) {
                return;
            }
            Container container = SwingUtilities.windowForComponent(this.owner);
            if (!(container instanceof RootPaneContainer)) {
                return;
            }
            this.dropShadowPanel.setVisible(false);
            container = ((RootPaneContainer)((Object)container)).getLayeredPane();
            container.add(this.dropShadowPanel, JLayeredPane.POPUP_LAYER, 0);
            this.moveMediumWeightDropShadow();
            this.resizeMediumWeightDropShadow();
            this.mediumPanelListener = new ComponentListener(){

                @Override
                public void componentShown(ComponentEvent componentEvent) {
                    if (DropShadowPopup.this.dropShadowPanel != null) {
                        DropShadowPopup.this.dropShadowPanel.setVisible(true);
                    }
                }

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                    if (DropShadowPopup.this.dropShadowPanel != null) {
                        DropShadowPopup.this.dropShadowPanel.setVisible(false);
                    }
                }

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                    DropShadowPopup.this.moveMediumWeightDropShadow();
                }

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    DropShadowPopup.this.resizeMediumWeightDropShadow();
                }
            };
            this.mediumWeightPanel.addComponentListener(this.mediumPanelListener);
        }

        private void hideMediumWeightDropShadow() {
            this.mediumWeightPanel.removeComponentListener(this.mediumPanelListener);
            Container container = this.dropShadowPanel.getParent();
            if (container != null) {
                Rectangle rectangle = this.dropShadowPanel.getBounds();
                container.remove(this.dropShadowPanel);
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        private void moveMediumWeightDropShadow() {
            if (this.dropShadowPanel != null && this.mediumWeightPanel != null) {
                Point point = this.mediumWeightPanel.getLocation();
                Insets insets = this.dropShadowPanel.getInsets();
                this.dropShadowPanel.setLocation(point.x - insets.left, point.y - insets.top);
            }
        }

        private void resizeMediumWeightDropShadow() {
            if (this.dropShadowPanel != null && this.mediumWeightPanel != null) {
                this.dropShadowPanel.setSize(FlatUIUtils.addInsets(this.mediumWeightPanel.getSize(), this.dropShadowPanel.getInsets()));
            }
        }
    }

    private static class NonFlashingPopup
    extends Popup {
        private Popup delegate;
        private Component contents;
        protected Window popupWindow;
        private Color oldPopupWindowBackground;

        NonFlashingPopup(Popup popup, Component component) {
            this.delegate = popup;
            this.contents = component;
            this.popupWindow = SwingUtilities.windowForComponent(component);
            if (this.popupWindow != null) {
                this.oldPopupWindowBackground = this.popupWindow.getBackground();
                this.popupWindow.setBackground(component.getBackground());
            }
        }

        @Override
        public void show() {
            if (this.delegate != null) {
                Dimension dimension;
                Container container;
                FlatPopupFactory.showPopupAndFixLocation(this.delegate, this.popupWindow);
                if (this.contents instanceof JToolTip && this.popupWindow == null && (container = this.contents.getParent()) instanceof JPanel && !(dimension = container.getPreferredSize()).equals(container.getSize())) {
                    Container container2 = SwingUtilities.getAncestorOfClass(Panel.class, container);
                    container = container2 != null ? container2 : container;
                    container.setSize(dimension);
                    container.validate();
                }
            }
        }

        @Override
        public void hide() {
            if (this.contents instanceof JComponent) {
                ((JComponent)this.contents).putClientProperty(FlatPopupFactory.KEY_POPUP_USES_NATIVE_BORDER, null);
            }
            if (this.delegate != null) {
                this.delegate.hide();
                this.delegate = null;
                this.contents = null;
            }
            if (this.popupWindow != null) {
                this.popupWindow.setBackground(this.oldPopupWindowBackground);
                this.popupWindow = null;
            }
        }
    }
}

