/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.icons.FlatTabbedPaneCloseIcon;
import com.formdev.flatlaf.ui.FlatArrowButton;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatTitlePane;
import com.formdev.flatlaf.ui.FlatUIAction;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.Animator;
import com.formdev.flatlaf.util.CubicBezierEasing;
import com.formdev.flatlaf.util.JavaCompatibility;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.StringUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

public class FlatTabbedPaneUI
extends BasicTabbedPaneUI
implements FlatStylingSupport.StyleableUI,
FlatTitlePane.TitleBarCaptionHitTest {
    protected static final int TAB_TYPE_UNDERLINED = 0;
    protected static final int TAB_TYPE_CARD = 1;
    protected static final int NEVER = 0;
    protected static final int AS_NEEDED = 2;
    protected static final int AS_NEEDED_SINGLE = 3;
    protected static final int BOTH = 100;
    protected static final int FILL = 100;
    protected static final int WIDTH_MODE_PREFERRED = 0;
    protected static final int WIDTH_MODE_EQUAL = 1;
    protected static final int WIDTH_MODE_COMPACT = 2;
    protected static final int NONE = -1;
    protected static final int AUTO = -2;
    private static Set<KeyStroke> focusForwardTraversalKeys;
    private static Set<KeyStroke> focusBackwardTraversalKeys;
    protected Color foreground;
    @FlatStylingSupport.Styleable
    protected Color disabledForeground;
    @FlatStylingSupport.Styleable
    protected Color selectedBackground;
    @FlatStylingSupport.Styleable
    protected Color selectedForeground;
    @FlatStylingSupport.Styleable
    protected Color underlineColor;
    @FlatStylingSupport.Styleable
    protected Color inactiveUnderlineColor;
    @FlatStylingSupport.Styleable
    protected Color disabledUnderlineColor;
    @FlatStylingSupport.Styleable
    protected Color hoverColor;
    @FlatStylingSupport.Styleable
    protected Color hoverForeground;
    @FlatStylingSupport.Styleable
    protected Color focusColor;
    @FlatStylingSupport.Styleable
    protected Color focusForeground;
    @FlatStylingSupport.Styleable
    protected Color tabSeparatorColor;
    @FlatStylingSupport.Styleable
    protected Color contentAreaColor;
    private int textIconGapUnscaled;
    @FlatStylingSupport.Styleable
    protected int minimumTabWidth;
    @FlatStylingSupport.Styleable
    protected int maximumTabWidth;
    @FlatStylingSupport.Styleable
    protected int tabHeight;
    @FlatStylingSupport.Styleable
    protected int tabSelectionHeight;
    @FlatStylingSupport.Styleable
    protected int cardTabSelectionHeight;
    @FlatStylingSupport.Styleable
    protected int tabArc;
    @FlatStylingSupport.Styleable
    protected int tabSelectionArc;
    @FlatStylingSupport.Styleable
    protected int cardTabArc;
    @FlatStylingSupport.Styleable
    protected Insets selectedInsets;
    @FlatStylingSupport.Styleable
    protected Insets tabSelectionInsets;
    @FlatStylingSupport.Styleable
    protected int contentSeparatorHeight;
    @FlatStylingSupport.Styleable
    protected boolean showTabSeparators;
    @FlatStylingSupport.Styleable
    protected boolean tabSeparatorsFullHeight;
    @FlatStylingSupport.Styleable
    protected boolean hasFullBorder;
    @FlatStylingSupport.Styleable
    protected boolean tabsOpaque = true;
    @FlatStylingSupport.Styleable
    protected boolean rotateTabRuns = true;
    @FlatStylingSupport.Styleable(type=String.class)
    private int tabType;
    @FlatStylingSupport.Styleable(type=String.class)
    private int tabsPopupPolicy;
    @FlatStylingSupport.Styleable(type=String.class)
    private int scrollButtonsPolicy;
    @FlatStylingSupport.Styleable(type=String.class)
    private int scrollButtonsPlacement;
    @FlatStylingSupport.Styleable(type=String.class)
    private int tabAreaAlignment;
    @FlatStylingSupport.Styleable(type=String.class)
    private int tabAlignment;
    @FlatStylingSupport.Styleable(type=String.class)
    private int tabWidthMode;
    @FlatStylingSupport.Styleable(type=String.class)
    private int tabRotation;
    protected Icon closeIcon;
    @FlatStylingSupport.Styleable
    protected String arrowType;
    @FlatStylingSupport.Styleable
    protected Insets buttonInsets;
    @FlatStylingSupport.Styleable
    protected int buttonArc;
    @FlatStylingSupport.Styleable
    protected Color buttonHoverBackground;
    @FlatStylingSupport.Styleable
    protected Color buttonPressedBackground;
    @FlatStylingSupport.Styleable
    protected String moreTabsButtonToolTipText;
    @FlatStylingSupport.Styleable
    protected String tabCloseToolTipText;
    @FlatStylingSupport.Styleable
    protected boolean showContentSeparator = true;
    @FlatStylingSupport.Styleable
    protected boolean hideTabAreaWithOneTab;
    @FlatStylingSupport.Styleable
    protected boolean tabClosable;
    @FlatStylingSupport.Styleable
    protected int tabIconPlacement = 10;
    protected JViewport tabViewport;
    protected FlatWheelTabScroller wheelTabScroller;
    private JButton tabCloseButton;
    private JButton moreTabsButton;
    private Container leadingComponent;
    private Container trailingComponent;
    private Dimension scrollBackwardButtonPrefSize;
    private Handler handler;
    private boolean blockRollover;
    private boolean rolloverTabClose;
    private boolean pressedTabClose;
    private boolean inBasicLayoutContainer;
    private Object[] oldRenderingHints;
    private Map<String, Object> oldStyleValues;
    private boolean closeIconShared = true;
    private boolean repaintRolloverPending;
    private boolean inCalculateEqual;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatTabbedPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        String string = UIManager.getString("TabbedPane.tabLayoutPolicy");
        if (string != null) {
            int n;
            int n2 = -1;
            switch (string.hashCode()) {
                case 3657802: {
                    if (!string.equals("wrap")) break;
                    n2 = 1;
                    break;
                }
                case -907680051: {
                    if (!string.equals("scroll")) break;
                    n2 = 2;
                }
            }
            switch (n2) {
                default: {
                    n = 0;
                    break;
                }
                case 2: {
                    n = 1;
                }
            }
            ((JTabbedPane)jComponent).setTabLayoutPolicy(n);
        }
        this.arrowType = UIManager.getString("TabbedPane.arrowType");
        this.foreground = UIManager.getColor("TabbedPane.foreground");
        this.disabledForeground = UIManager.getColor("TabbedPane.disabledForeground");
        this.buttonHoverBackground = UIManager.getColor("TabbedPane.buttonHoverBackground");
        this.buttonPressedBackground = UIManager.getColor("TabbedPane.buttonPressedBackground");
        super.installUI(jComponent);
        FlatSelectedTabRepainter.install();
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        Object object;
        if (UIManager.getBoolean("TabbedPane.tabsOverlapBorder")) {
            object = UIManager.put("TabbedPane.tabsOverlapBorder", Boolean.FALSE);
            super.installDefaults();
            UIManager.put("TabbedPane.tabsOverlapBorder", object);
        } else {
            super.installDefaults();
        }
        this.selectedBackground = UIManager.getColor("TabbedPane.selectedBackground");
        this.selectedForeground = UIManager.getColor("TabbedPane.selectedForeground");
        this.underlineColor = UIManager.getColor("TabbedPane.underlineColor");
        this.inactiveUnderlineColor = FlatUIUtils.getUIColor("TabbedPane.inactiveUnderlineColor", this.underlineColor);
        this.disabledUnderlineColor = UIManager.getColor("TabbedPane.disabledUnderlineColor");
        this.hoverColor = UIManager.getColor("TabbedPane.hoverColor");
        this.hoverForeground = UIManager.getColor("TabbedPane.hoverForeground");
        this.focusColor = UIManager.getColor("TabbedPane.focusColor");
        this.focusForeground = UIManager.getColor("TabbedPane.focusForeground");
        this.tabSeparatorColor = UIManager.getColor("TabbedPane.tabSeparatorColor");
        this.contentAreaColor = UIManager.getColor("TabbedPane.contentAreaColor");
        this.textIconGapUnscaled = UIManager.getInt("TabbedPane.textIconGap");
        this.minimumTabWidth = UIManager.getInt("TabbedPane.minimumTabWidth");
        this.maximumTabWidth = UIManager.getInt("TabbedPane.maximumTabWidth");
        this.tabHeight = UIManager.getInt("TabbedPane.tabHeight");
        this.tabSelectionHeight = UIManager.getInt("TabbedPane.tabSelectionHeight");
        this.cardTabSelectionHeight = UIManager.getInt("TabbedPane.cardTabSelectionHeight");
        this.tabArc = UIManager.getInt("TabbedPane.tabArc");
        this.tabSelectionArc = UIManager.getInt("TabbedPane.tabSelectionArc");
        this.cardTabArc = UIManager.getInt("TabbedPane.cardTabArc");
        this.selectedInsets = UIManager.getInsets("TabbedPane.selectedInsets");
        this.tabSelectionInsets = UIManager.getInsets("TabbedPane.tabSelectionInsets");
        this.contentSeparatorHeight = UIManager.getInt("TabbedPane.contentSeparatorHeight");
        this.showTabSeparators = UIManager.getBoolean("TabbedPane.showTabSeparators");
        this.tabSeparatorsFullHeight = UIManager.getBoolean("TabbedPane.tabSeparatorsFullHeight");
        this.hasFullBorder = UIManager.getBoolean("TabbedPane.hasFullBorder");
        this.tabsOpaque = UIManager.getBoolean("TabbedPane.tabsOpaque");
        this.rotateTabRuns = FlatUIUtils.getUIBoolean("TabbedPane.rotateTabRuns", true);
        this.tabType = FlatTabbedPaneUI.parseTabType(UIManager.getString("TabbedPane.tabType"));
        this.tabsPopupPolicy = FlatTabbedPaneUI.parseTabsPopupPolicy(UIManager.getString("TabbedPane.tabsPopupPolicy"));
        this.scrollButtonsPolicy = FlatTabbedPaneUI.parseScrollButtonsPolicy(UIManager.getString("TabbedPane.scrollButtonsPolicy"));
        this.scrollButtonsPlacement = FlatTabbedPaneUI.parseScrollButtonsPlacement(UIManager.getString("TabbedPane.scrollButtonsPlacement"));
        this.tabAreaAlignment = FlatTabbedPaneUI.parseAlignment(UIManager.getString("TabbedPane.tabAreaAlignment"), 10);
        this.tabAlignment = FlatTabbedPaneUI.parseAlignment(UIManager.getString("TabbedPane.tabAlignment"), 0);
        this.tabWidthMode = FlatTabbedPaneUI.parseTabWidthMode(UIManager.getString("TabbedPane.tabWidthMode"));
        this.tabRotation = FlatTabbedPaneUI.parseTabRotation(UIManager.getString("TabbedPane.tabRotation"));
        this.closeIcon = UIManager.getIcon("TabbedPane.closeIcon");
        this.closeIconShared = true;
        this.buttonInsets = UIManager.getInsets("TabbedPane.buttonInsets");
        this.buttonArc = UIManager.getInt("TabbedPane.buttonArc");
        object = this.tabPane.getLocale();
        this.moreTabsButtonToolTipText = UIManager.getString((Object)"TabbedPane.moreTabsButtonToolTipText", (Locale)object);
        this.tabCloseToolTipText = UIManager.getString((Object)"TabbedPane.tabCloseToolTipText", (Locale)object);
        this.textIconGap = UIScale.scale(this.textIconGapUnscaled);
        if (focusForwardTraversalKeys == null) {
            focusForwardTraversalKeys = Collections.singleton(KeyStroke.getKeyStroke(9, 0));
            focusBackwardTraversalKeys = Collections.singleton(KeyStroke.getKeyStroke(9, 64));
        }
        this.tabPane.setFocusTraversalKeys(0, focusForwardTraversalKeys);
        this.tabPane.setFocusTraversalKeys(1, focusBackwardTraversalKeys);
        MigLayoutVisualPadding.install(this.tabPane, null);
    }

    @Override
    protected void uninstallDefaults() {
        this.tabPane.setFocusTraversalKeys(0, null);
        this.tabPane.setFocusTraversalKeys(1, null);
        super.uninstallDefaults();
        this.foreground = null;
        this.disabledForeground = null;
        this.selectedBackground = null;
        this.selectedForeground = null;
        this.underlineColor = null;
        this.inactiveUnderlineColor = null;
        this.disabledUnderlineColor = null;
        this.hoverColor = null;
        this.hoverForeground = null;
        this.focusColor = null;
        this.focusForeground = null;
        this.tabSeparatorColor = null;
        this.contentAreaColor = null;
        this.closeIcon = null;
        this.buttonHoverBackground = null;
        this.buttonPressedBackground = null;
        this.oldStyleValues = null;
        MigLayoutVisualPadding.uninstall(this.tabPane);
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        this.tabViewport = null;
        if (this.isScrollTabLayout()) {
            for (Component component : this.tabPane.getComponents()) {
                if (!(component instanceof JViewport) || !component.getClass().getName().equals("javax.swing.plaf.basic.BasicTabbedPaneUI$ScrollableTabViewport")) continue;
                this.tabViewport = (JViewport)component;
                break;
            }
        }
        this.installHiddenTabsNavigation();
        this.installLeadingComponent();
        this.installTrailingComponent();
    }

    @Override
    protected void uninstallComponents() {
        this.uninstallHiddenTabsNavigation();
        this.uninstallLeadingComponent();
        this.uninstallTrailingComponent();
        super.uninstallComponents();
        this.tabCloseButton = null;
        this.tabViewport = null;
    }

    protected void installHiddenTabsNavigation() {
        if (!this.isScrollTabLayout() || this.tabViewport == null) {
            return;
        }
        FlatTabbedPaneUI flatTabbedPaneUI = this;
        this.tabPane.setLayout(flatTabbedPaneUI.createScrollLayoutManager((BasicTabbedPaneUI.TabbedPaneLayout)flatTabbedPaneUI.tabPane.getLayout()));
        this.moreTabsButton = this.createMoreTabsButton();
        this.tabPane.add(this.moreTabsButton);
    }

    protected void uninstallHiddenTabsNavigation() {
        if (this.tabPane.getLayout() instanceof FlatTabbedPaneScrollLayout) {
            this.tabPane.setLayout(((FlatTabbedPaneScrollLayout)this.tabPane.getLayout()).delegate);
        }
        if (this.moreTabsButton != null) {
            this.tabPane.remove(this.moreTabsButton);
            this.moreTabsButton = null;
        }
    }

    protected void installLeadingComponent() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.leadingComponent");
        if (object instanceof Component) {
            this.leadingComponent = new ContainerUIResource((Component)object);
            this.tabPane.add(this.leadingComponent);
        }
    }

    protected void uninstallLeadingComponent() {
        if (this.leadingComponent != null) {
            this.tabPane.remove(this.leadingComponent);
            this.leadingComponent = null;
        }
    }

    protected void installTrailingComponent() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.trailingComponent");
        if (object instanceof Component) {
            this.trailingComponent = new ContainerUIResource((Component)object);
            this.tabPane.add(this.trailingComponent);
        }
    }

    protected void uninstallTrailingComponent() {
        if (this.trailingComponent != null) {
            this.tabPane.remove(this.trailingComponent);
            this.trailingComponent = null;
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.getHandler().installListeners();
        if (this.tabViewport != null && (this.wheelTabScroller = this.createWheelTabScroller()) != null) {
            this.tabPane.addMouseWheelListener(this.wheelTabScroller);
            this.tabPane.addMouseMotionListener(this.wheelTabScroller);
            this.tabPane.addMouseListener(this.wheelTabScroller);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.handler != null) {
            this.handler.uninstallListeners();
            this.handler = null;
        }
        if (this.wheelTabScroller != null) {
            this.wheelTabScroller.uninstall();
            this.tabPane.removeMouseWheelListener(this.wheelTabScroller);
            this.tabPane.removeMouseMotionListener(this.wheelTabScroller);
            this.tabPane.removeMouseListener(this.wheelTabScroller);
            this.wheelTabScroller = null;
        }
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.tabPane);
        if (actionMap != null) {
            RunWithOriginalLayoutManagerDelegateAction.install(actionMap, "scrollTabsForwardAction");
            RunWithOriginalLayoutManagerDelegateAction.install(actionMap, "scrollTabsBackwardAction");
        }
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected FlatWheelTabScroller createWheelTabScroller() {
        return new FlatWheelTabScroller();
    }

    @Override
    protected MouseListener createMouseListener() {
        Handler handler = this.getHandler();
        this.getHandler().mouseDelegate = super.createMouseListener();
        return handler;
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        Handler handler = this.getHandler();
        this.getHandler().propertyChangeDelegate = super.createPropertyChangeListener();
        return handler;
    }

    @Override
    protected ChangeListener createChangeListener() {
        Handler handler = this.getHandler();
        this.getHandler().changeDelegate = super.createChangeListener();
        return handler;
    }

    @Override
    protected FocusListener createFocusListener() {
        Handler handler = this.getHandler();
        this.getHandler().focusDelegate = super.createFocusListener();
        return handler;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            return new FlatTabbedPaneLayout();
        }
        return super.createLayoutManager();
    }

    protected LayoutManager createScrollLayoutManager(BasicTabbedPaneUI.TabbedPaneLayout tabbedPaneLayout) {
        return new FlatTabbedPaneScrollLayout(tabbedPaneLayout);
    }

    protected JButton createMoreTabsButton() {
        return new FlatMoreTabsButton();
    }

    @Override
    protected JButton createScrollButton(int n) {
        return new FlatScrollableTabButton(n);
    }

    protected void installStyle() {
        try {
            FlatTabbedPaneUI flatTabbedPaneUI = this;
            flatTabbedPaneUI.applyStyle(FlatStylingSupport.getResolvedStyle(flatTabbedPaneUI.tabPane, "TabbedPane"));
            return;
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
            return;
        }
    }

    protected void applyStyle(Object componentArray) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, componentArray, this::applyStyleProperty);
        for (Component component : this.tabPane.getComponents()) {
            if (!(component instanceof FlatTabAreaButton)) continue;
            ((FlatTabAreaButton)component).updateStyle();
        }
    }

    protected Object applyStyleProperty(String string, Object object) {
        if (string.startsWith("close")) {
            if (!(this.closeIcon instanceof FlatTabbedPaneCloseIcon)) {
                return new FlatStylingSupport.UnknownStyleException(string);
            }
            if (this.closeIconShared) {
                this.closeIcon = FlatStylingSupport.cloneIcon(this.closeIcon);
                this.closeIconShared = false;
            }
            return ((FlatTabbedPaneCloseIcon)this.closeIcon).applyStyleProperty(string, object);
        }
        if (object instanceof String) {
            switch (string) {
                case "tabType": {
                    object = FlatTabbedPaneUI.parseTabType((String)object);
                    break;
                }
                case "tabsPopupPolicy": {
                    object = FlatTabbedPaneUI.parseTabsPopupPolicy((String)object);
                    break;
                }
                case "scrollButtonsPolicy": {
                    object = FlatTabbedPaneUI.parseScrollButtonsPolicy((String)object);
                    break;
                }
                case "scrollButtonsPlacement": {
                    object = FlatTabbedPaneUI.parseScrollButtonsPlacement((String)object);
                    break;
                }
                case "tabAreaAlignment": {
                    object = FlatTabbedPaneUI.parseAlignment((String)object, 10);
                    break;
                }
                case "tabAlignment": {
                    object = FlatTabbedPaneUI.parseAlignment((String)object, 0);
                    break;
                }
                case "tabWidthMode": {
                    object = FlatTabbedPaneUI.parseTabWidthMode((String)object);
                    break;
                }
                case "tabRotation": {
                    object = FlatTabbedPaneUI.parseTabRotation((String)object);
                    break;
                }
                case "tabIconPlacement": {
                    object = FlatTabbedPaneUI.parseTabIconPlacement((String)object);
                }
            }
        } else {
            switch (string) {
                case "tabInsets": {
                    Insets insets = this.tabInsets;
                    this.tabInsets = (Insets)object;
                    return insets;
                }
                case "tabAreaInsets": {
                    Insets insets = this.tabAreaInsets;
                    this.tabAreaInsets = (Insets)object;
                    return insets;
                }
                case "textIconGap": {
                    Integer n = this.textIconGapUnscaled;
                    this.textIconGapUnscaled = (Integer)object;
                    this.textIconGap = UIScale.scale(this.textIconGapUnscaled);
                    return n;
                }
            }
        }
        FlatTabbedPaneUI flatTabbedPaneUI = this;
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(flatTabbedPaneUI, flatTabbedPaneUI.tabPane, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent serializable) {
        serializable = new FlatStylingSupport.StyleableInfosMap<String, Class<Insets>>();
        serializable.put("tabInsets", Insets.class);
        serializable.put("tabAreaInsets", Insets.class);
        serializable.put("textIconGap", Integer.TYPE);
        FlatStylingSupport.collectAnnotatedStyleableInfos(this, serializable);
        if (this.closeIcon instanceof FlatTabbedPaneCloseIcon) {
            serializable.putAll(((FlatTabbedPaneCloseIcon)this.closeIcon).getStyleableInfos());
        }
        return serializable;
    }

    @Override
    public Object getStyleableValue(JComponent object, String string) {
        if (string.startsWith("close")) {
            if (this.closeIcon instanceof FlatTabbedPaneCloseIcon) {
                return ((FlatTabbedPaneCloseIcon)this.closeIcon).getStyleableValue(string);
            }
            return null;
        }
        switch (string) {
            case "tabInsets": {
                return this.tabInsets;
            }
            case "tabAreaInsets": {
                return this.tabAreaInsets;
            }
            case "textIconGap": {
                return this.textIconGapUnscaled;
            }
            case "tabType": {
                switch (this.tabType) {
                    default: {
                        return "underlined";
                    }
                    case 1: 
                }
                return "card";
            }
            case "tabsPopupPolicy": {
                switch (this.tabsPopupPolicy) {
                    default: {
                        return "asNeeded";
                    }
                    case 0: 
                }
                return "never";
            }
            case "scrollButtonsPolicy": {
                switch (this.scrollButtonsPolicy) {
                    default: {
                        return "asNeededSingle";
                    }
                    case 2: {
                        return "asNeeded";
                    }
                    case 0: 
                }
                return "never";
            }
            case "scrollButtonsPlacement": {
                switch (this.scrollButtonsPlacement) {
                    default: {
                        return "both";
                    }
                    case 11: 
                }
                return "trailing";
            }
            case "tabAreaAlignment": {
                return FlatTabbedPaneUI.alignmentToString(this.tabAreaAlignment, "leading");
            }
            case "tabAlignment": {
                return FlatTabbedPaneUI.alignmentToString(this.tabAlignment, "center");
            }
            case "tabWidthMode": {
                switch (this.tabWidthMode) {
                    default: {
                        return "preferred";
                    }
                    case 1: {
                        return "equal";
                    }
                    case 2: 
                }
                return "compact";
            }
            case "tabRotation": {
                switch (this.tabRotation) {
                    default: {
                        return "none";
                    }
                    case -2: {
                        return "auto";
                    }
                    case 2: {
                        return "left";
                    }
                    case 4: 
                }
                return "right";
            }
            case "tabIconPlacement": {
                switch (this.tabIconPlacement) {
                    default: {
                        return "leading";
                    }
                    case 11: {
                        return "trailing";
                    }
                    case 1: {
                        return "top";
                    }
                    case 3: 
                }
                return "bottom";
            }
        }
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    protected void setRolloverTab(int n, int n2) {
        FlatTabbedPaneUI flatTabbedPaneUI = this;
        flatTabbedPaneUI.setRolloverTab(flatTabbedPaneUI.tabForCoordinate(this.tabPane, n, n2));
    }

    @Override
    protected void setRolloverTab(int n) {
        if (this.blockRollover) {
            return;
        }
        int n2 = this.getRolloverTab();
        super.setRolloverTab(n);
        if (n != n2) {
            this.repaintRolloverLaterOnce(n2);
        }
    }

    private void repaintRolloverLaterOnce(int n) {
        if (this.repaintRolloverPending) {
            return;
        }
        this.repaintRolloverPending = true;
        EventQueue.invokeLater(() -> {
            this.repaintRolloverPending = false;
            if (this.tabPane == null) {
                return;
            }
            int n2 = this.getRolloverTab();
            if (n2 != n) {
                this.repaintTab(n);
                this.repaintTab(n2);
            }
        });
    }

    protected boolean isRolloverTabClose() {
        return this.rolloverTabClose;
    }

    protected void setRolloverTabClose(boolean bl) {
        if (this.rolloverTabClose == bl) {
            return;
        }
        this.rolloverTabClose = bl;
        FlatTabbedPaneUI flatTabbedPaneUI = this;
        flatTabbedPaneUI.repaintTab(flatTabbedPaneUI.getRolloverTab());
    }

    protected boolean isPressedTabClose() {
        return this.pressedTabClose;
    }

    protected void setPressedTabClose(boolean bl) {
        if (this.pressedTabClose == bl) {
            return;
        }
        this.pressedTabClose = bl;
        FlatTabbedPaneUI flatTabbedPaneUI = this;
        flatTabbedPaneUI.repaintTab(flatTabbedPaneUI.getRolloverTab());
    }

    private void repaintTab(int n) {
        if (n < 0 || n >= this.tabPane.getTabCount()) {
            return;
        }
        FlatTabbedPaneUI flatTabbedPaneUI = this;
        Rectangle rectangle = flatTabbedPaneUI.getTabBounds(flatTabbedPaneUI.tabPane, n);
        if (rectangle == null) {
            return;
        }
        if (this.contentSeparatorHeight > 0 && FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.showContentSeparator", true)) {
            int n2 = UIScale.scale(this.contentSeparatorHeight);
            switch (this.tabPane.getTabPlacement()) {
                default: {
                    rectangle.height += n2;
                    break;
                }
                case 3: {
                    rectangle.height += n2;
                    rectangle.y -= n2;
                    break;
                }
                case 2: {
                    rectangle.width += n2;
                    break;
                }
                case 4: {
                    rectangle.width += n2;
                    rectangle.x -= n2;
                }
            }
        }
        this.tabPane.repaint(rectangle);
    }

    @Override
    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        if (this.getRealTabRotation(n) == -1) {
            return this.calculateTabWidthImpl(n, n2, fontMetrics, false);
        }
        return this.calculateTabHeightImpl(n, n2, fontMetrics.getHeight(), true);
    }

    private int calculateTabWidthImpl(int n, int n2, FontMetrics fontMetrics, boolean n3) {
        Icon icon;
        int n4 = this.getTabWidthMode();
        if (n4 == 1 && this.isHorizontalOrRotated(n) && !this.inCalculateEqual) {
            this.inCalculateEqual = true;
            try {
                n4 = this.isHorizontalTabPlacement(n) ? this.calculateMaxTabWidth(n) : this.calculateMaxTabHeight(n);
                return n4;
            }
            finally {
                this.inCalculateEqual = false;
            }
        }
        this.textIconGap = UIScale.scale(this.textIconGapUnscaled);
        if (n4 == 2 && n2 != this.tabPane.getSelectedIndex() && this.isHorizontalOrRotated(n) && this.tabPane.getTabComponentAt(n2) == null && (icon = this.getIconForTab(n2)) != null) {
            Insets insets = this.getTabInsets(n, n2);
            n4 = icon.getIconWidth() + insets.left + insets.right;
        } else {
            Icon icon2;
            int n5 = FlatClientProperties.clientPropertyInt(this.tabPane, "JTabbedPane.tabIconPlacement", this.tabIconPlacement);
            if ((n5 == 1 || n5 == 3) && this.tabPane.getTabComponentAt(n2) == null && (icon2 = this.getIconForTab(n2)) != null) {
                n4 = icon2.getIconWidth();
                Object object = this.getTextViewForTab(n2);
                if (object != null) {
                    n4 = Math.max(n4, (int)((View)object).getPreferredSpan(0));
                } else {
                    object = this.tabPane.getTitleAt(n2);
                    if (object != null) {
                        n4 = Math.max(n4, fontMetrics.stringWidth((String)object));
                    }
                }
                object = this.getTabInsets(n, n2);
                n4 += ((Insets)object).left + ((Insets)object).right;
            } else {
                Serializable serializable;
                n4 = super.calculateTabWidth(n, n2, fontMetrics) - 3;
                if (n3 != 0 && (serializable = this.tabPane.getTabComponentAt(n2)) != null) {
                    serializable = serializable.getPreferredSize();
                    n4 = n4 - ((Dimension)serializable).width + ((Dimension)serializable).height;
                }
            }
        }
        if (this.isTabClosable(n2)) {
            n4 += this.closeIcon.getIconWidth();
        }
        int n6 = this.getTabClientPropertyInt(n2, "JTabbedPane.minimumTabWidth", this.minimumTabWidth);
        n3 = this.getTabClientPropertyInt(n2, "JTabbedPane.maximumTabWidth", this.maximumTabWidth);
        if (n6 > 0) {
            n4 = Math.max(n4, UIScale.scale(n6));
        }
        if (n3 > 0 && this.tabPane.getTabComponentAt(n2) == null) {
            n4 = Math.min(n4, UIScale.scale(n3));
        }
        return n4;
    }

    @Override
    protected int calculateTabHeight(int n, int n2, int n3) {
        if (this.getRealTabRotation(n) == -1) {
            return this.calculateTabHeightImpl(n, n2, n3, false);
        }
        return this.calculateTabWidthImpl(n, n2, this.getFontMetrics(), true);
    }

    private int calculateTabHeightImpl(int n, int n2, int n3, boolean bl) {
        Icon icon;
        int n4 = FlatClientProperties.clientPropertyInt(this.tabPane, "JTabbedPane.tabIconPlacement", this.tabIconPlacement);
        if ((n4 == 1 || n4 == 3) && this.tabPane.getTabComponentAt(n2) == null && (icon = this.getIconForTab(n2)) != null) {
            n4 = icon.getIconHeight();
            View view = this.getTextViewForTab(n2);
            if (view != null) {
                n4 += (int)view.getPreferredSpan(1) + UIScale.scale(this.textIconGapUnscaled);
            } else if (this.tabPane.getTitleAt(n2) != null) {
                n4 += n3 + UIScale.scale(this.textIconGapUnscaled);
            }
            Insets insets = this.getTabInsets(n, n2);
            n4 += insets.top + insets.bottom;
        } else {
            Component component;
            n4 = super.calculateTabHeight(n, n2, n3) - 2;
            if (bl && (component = this.tabPane.getTabComponentAt(n2)) != null) {
                Dimension dimension = component.getPreferredSize();
                n4 = n4 - dimension.height + dimension.width;
            }
        }
        return Math.max(n4, UIScale.scale(FlatClientProperties.clientPropertyInt(this.tabPane, "JTabbedPane.tabHeight", this.tabHeight)));
    }

    @Override
    protected int calculateMaxTabWidth(int n) {
        if (this.hideTabArea()) {
            return 0;
        }
        return super.calculateMaxTabWidth(n);
    }

    @Override
    protected int calculateMaxTabHeight(int n) {
        if (this.hideTabArea()) {
            return 0;
        }
        return super.calculateMaxTabHeight(n);
    }

    @Override
    protected int calculateTabAreaWidth(int n, int n2, int n3) {
        if (this.hideTabArea()) {
            return 0;
        }
        return super.calculateTabAreaWidth(n, n2, n3);
    }

    @Override
    protected int calculateTabAreaHeight(int n, int n2, int n3) {
        if (this.hideTabArea()) {
            return 0;
        }
        return super.calculateTabAreaHeight(n, n2, n3);
    }

    @Override
    protected Insets getTabInsets(int n, int n2) {
        Object object = this.getTabClientProperty(n2, "JTabbedPane.tabInsets");
        return UIScale.scale(object instanceof Insets ? (Insets)object : super.getTabInsets(n, n2));
    }

    protected Insets getTabInsetsRotated(int n, int n2, int n3) {
        Insets insets = this.getTabInsets(n, n2);
        switch (n3) {
            case 2: {
                return new Insets(insets.right, insets.top, insets.left, insets.bottom);
            }
            case 4: {
                return new Insets(insets.left, insets.bottom, insets.right, insets.top);
            }
        }
        return insets;
    }

    @Override
    protected Insets getSelectedTabPadInsets(int n) {
        return new Insets(0, 0, 0, 0);
    }

    protected Insets getRealTabAreaInsets(int n) {
        if (this.tabAreaInsets == null) {
            this.tabAreaInsets = new Insets(0, 0, 0, 0);
        }
        Insets insets = super.getTabAreaInsets(n);
        Insets insets2 = (Insets)insets.clone();
        Object object = this.tabPane.getClientProperty("JTabbedPane.tabAreaInsets");
        if (object instanceof Insets) {
            FlatTabbedPaneUI.rotateInsets((Insets)object, insets2, n);
        }
        Insets insets3 = insets;
        insets3.left = -10000;
        insets3.top = -10000;
        insets2 = UIScale.scale(insets2);
        return insets2;
    }

    @Override
    protected Insets getTabAreaInsets(int n) {
        Insets insets = this.getRealTabAreaInsets(n);
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            if (this.isHorizontalTabPlacement(n)) {
                insets.left += this.getLeadingPreferredWidth();
                insets.right += this.getTrailingPreferredWidth();
            } else {
                insets.top += this.getLeadingPreferredHeight();
                insets.bottom += this.getTrailingPreferredHeight();
            }
        }
        return insets;
    }

    @Override
    protected Insets getContentBorderInsets(int n) {
        Insets insets;
        if (this.hideTabArea() || this.contentSeparatorHeight == 0 || !FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.showContentSeparator", this.showContentSeparator)) {
            return new Insets(0, 0, 0, 0);
        }
        boolean bl = FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.hasFullBorder", this.hasFullBorder);
        int n2 = UIScale.scale(this.contentSeparatorHeight);
        if (bl) {
            int n3 = n2;
            int n4 = n2;
            insets = new Insets(n3, n3, n4, n4);
        } else {
            insets = new Insets(n2, 0, 0, 0);
        }
        Insets insets2 = insets;
        Insets insets3 = new Insets(0, 0, 0, 0);
        FlatTabbedPaneUI.rotateInsets(insets2, insets3, n);
        return insets3;
    }

    @Override
    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        if (this.isTabClosable(n2) && this.getRealTabRotation(n) == -1) {
            n = this.closeIcon.getIconWidth() / 2;
            if (this.isLeftToRight()) {
                return -n;
            }
            return n;
        }
        return 0;
    }

    @Override
    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        if (this.isTabClosable(n2) && this.getRealTabRotation(n) != -1) {
            n = this.closeIcon.getIconHeight() / 2;
            if (this.isLeftToRight()) {
                return n;
            }
            return -n;
        }
        return 0;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        this.oldRenderingHints = FlatUIUtils.setRenderingHints(graphics);
        super.update(graphics, jComponent);
        FlatUIUtils.resetRenderingHints(graphics, this.oldRenderingHints);
        this.oldRenderingHints = null;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.hideTabArea()) {
            return;
        }
        this.ensureCurrentLayout();
        int n = this.tabPane.getTabPlacement();
        int n2 = this.tabPane.getSelectedIndex();
        this.paintContentBorder(graphics, n, n2);
        if (this.tabsOpaque && !this.tabPane.isOpaque() && this.tabPane.getTabCount() > 0) {
            Rectangle rectangle = null;
            if (this.isScrollTabLayout()) {
                rectangle = this.tabViewport.getBounds();
                for (Component component : this.tabPane.getComponents()) {
                    if (!(component instanceof FlatTabAreaButton) || !component.isVisible()) continue;
                    rectangle = rectangle.union(component.getBounds());
                }
            } else {
                Rectangle[] rectangleArray = this.rects;
                int n3 = this.rects.length;
                for (int i = 0; i < n3; ++i) {
                    Rectangle rectangle2 = rectangleArray[i];
                    rectangle = rectangle != null ? rectangle.union(rectangle2) : rectangle2;
                }
            }
            if (rectangle != null) {
                graphics.setColor(this.tabPane.getBackground());
                if (this.getTabType() == 1 && this.cardTabArc > 0) {
                    ((Graphics2D)graphics).fill(this.createCardTabOuterPath(n, rectangle.x, rectangle.y, rectangle.width, rectangle.height));
                } else {
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
        }
        if (!this.isScrollTabLayout()) {
            this.paintTabArea(graphics, n, n2);
        }
    }

    @Override
    protected void paintTabArea(Graphics graphics, int n, int n2) {
        Object[] objectArray = FlatUIUtils.setRenderingHints(graphics);
        super.paintTabArea(graphics, n, n2);
        FlatUIUtils.resetRenderingHints(graphics, objectArray);
    }

    @Override
    protected void paintTab(Graphics graphics, int n, Rectangle[] object, int n2, Rectangle rectangle, Rectangle rectangle2) {
        boolean bl;
        object = object[n2];
        int n3 = object.x;
        int n4 = object.y;
        int n5 = object.width;
        int n6 = object.height;
        boolean bl2 = bl = n2 == this.tabPane.getSelectedIndex();
        if (this.tabsOpaque || this.tabPane.isOpaque()) {
            this.paintTabBackground(graphics, n, n2, n3, n4, n5, n6, bl);
        }
        this.paintTabBorder(graphics, n, n2, n3, n4, n5, n6, bl);
        if (this.isTabClosable(n2)) {
            this.paintTabCloseButton(graphics, n2, n3, n4, n5, n6);
        }
        if (bl) {
            this.paintTabSelection(graphics, n, n2, n3, n4, n5, n6);
        }
        if (this.tabPane.getTabComponentAt(n2) != null) {
            return;
        }
        String string = this.tabPane.getTitleAt(n2);
        Icon icon = this.getIconForTab(n2);
        Font font = this.tabPane.getFont();
        FontMetrics fontMetrics = this.tabPane.getFontMetrics(font);
        boolean bl3 = icon != null && !bl && this.getTabWidthMode() == 2 && this.isHorizontalOrRotated(n);
        if (bl3) {
            string = null;
        }
        object = this.layoutAndClipLabel(n, fontMetrics, n2, string, icon, (Rectangle)object, rectangle, rectangle2, bl);
        if (this.tabViewport != null && (n == 1 || n == 3)) {
            Rectangle rectangle3 = this.tabViewport.getViewRect();
            rectangle3.width -= 4;
            if (!rectangle3.contains(rectangle2)) {
                Rectangle rectangle4 = rectangle3.intersection(rectangle2);
                if (rectangle4.x > rectangle3.x) {
                    object = JavaCompatibility.getClippedString(null, fontMetrics, string, rectangle4.width);
                }
            }
        }
        if (!bl3) {
            this.paintText(graphics, n, font, fontMetrics, n2, (String)object, rectangle2, bl);
        }
        this.paintIcon(graphics, n, n2, icon, rectangle, bl);
    }

    @Override
    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        graphics.setFont(font);
        FlatUIUtils.runWithoutRenderingHints(graphics, this.oldRenderingHints, () -> {
            View view = this.getTextViewForTab(n2);
            if (view != null) {
                AffineTransform affineTransform = this.rotateGraphics(graphics, n, rectangle);
                Rectangle rectangle2 = affineTransform != null ? new Rectangle(rectangle.x, rectangle.y, rectangle.height, rectangle.width) : rectangle;
                view.paint(graphics, rectangle2);
                if (affineTransform != null) {
                    ((Graphics2D)graphics).setTransform(affineTransform);
                }
                return;
            }
            AffineTransform affineTransform = this.rotateGraphics(graphics, n, rectangle);
            int n3 = FlatLaf.isShowMnemonics() ? this.tabPane.getDisplayedMnemonicIndexAt(n2) : -1;
            graphics.setColor(this.getTabForeground(n, n2, bl));
            FlatUIUtils.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
            if (affineTransform != null) {
                ((Graphics2D)graphics).setTransform(affineTransform);
            }
        });
    }

    @Override
    protected void paintIcon(Graphics graphics, int n, int n2, Icon icon, Rectangle rectangle, boolean bl) {
        if (icon == null) {
            return;
        }
        Shape shape = graphics.getClip();
        ((Graphics2D)graphics).clip(rectangle);
        AffineTransform affineTransform = this.rotateGraphics(graphics, n, rectangle);
        icon.paintIcon(this.tabPane, graphics, rectangle.x, rectangle.y);
        if (affineTransform != null) {
            ((Graphics2D)graphics).setTransform(affineTransform);
        }
        graphics.setClip(shape);
    }

    private AffineTransform rotateGraphics(Graphics graphics, int n, Rectangle rectangle) {
        graphics = (Graphics2D)graphics;
        AffineTransform affineTransform = null;
        if ((n = this.getRealTabRotation(n)) == 2) {
            affineTransform = ((Graphics2D)graphics).getTransform();
            ((Graphics2D)graphics).translate(0, rectangle.height);
            ((Graphics2D)graphics).rotate(Math.toRadians(270.0), rectangle.x, rectangle.y);
        } else if (n == 4) {
            affineTransform = ((Graphics2D)graphics).getTransform();
            ((Graphics2D)graphics).translate(rectangle.width, 0);
            ((Graphics2D)graphics).rotate(Math.toRadians(90.0), rectangle.x, rectangle.y);
        }
        return affineTransform;
    }

    protected Color getTabForeground(int n, int n2, boolean bl) {
        if (!this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(n2)) {
            return this.disabledForeground;
        }
        if (this.hoverForeground != null && this.getRolloverTab() == n2) {
            return this.hoverForeground;
        }
        Color color = this.tabPane.getForegroundAt(n2);
        if (color != this.tabPane.getForeground()) {
            return color;
        }
        if (this.focusForeground != null && bl && FlatUIUtils.isPermanentFocusOwner(this.tabPane)) {
            return this.focusForeground;
        }
        if (this.selectedForeground != null && bl) {
            return this.selectedForeground;
        }
        return color;
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Serializable serializable;
        boolean bl2 = this.getTabType() == 1;
        if (!bl2 && this.selectedInsets != null) {
            serializable = new Insets(0, 0, 0, 0);
            FlatTabbedPaneUI.rotateInsets(this.selectedInsets, (Insets)serializable, this.tabPane.getTabPlacement());
            n3 += UIScale.scale(((Insets)serializable).left);
            n4 += UIScale.scale(((Insets)serializable).top);
            n5 -= UIScale.scale(((Insets)serializable).left + ((Insets)serializable).right);
            n6 -= UIScale.scale(((Insets)serializable).top + ((Insets)serializable).bottom);
        }
        if ((serializable = this.getTabBackground(n, n2, bl)) != this.tabPane.getBackground()) {
            graphics.setColor(FlatUIUtils.deriveColor(serializable, this.tabPane.getBackground()));
            if (!bl2 && this.tabArc > 0) {
                float f;
                float f2 = f = UIScale.scale((float)this.tabArc) / 2.0f;
                float f3 = f;
                FlatUIUtils.paintSelection((Graphics2D)graphics, n3, n4, n5, n6, null, f2, f2, f3, f3, 0);
                return;
            }
            if (bl2 && this.cardTabArc > 0) {
                ((Graphics2D)graphics).fill(this.createCardTabOuterPath(n, n3, n4, n5, n6));
                return;
            }
            graphics.fillRect(n3, n4, n5, n6);
        }
    }

    protected Color getTabBackground(int n, int n2, boolean bl) {
        Color color = this.tabPane.getBackgroundAt(n2);
        if (!this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(n2)) {
            return color;
        }
        if (this.hoverColor != null && this.getRolloverTab() == n2) {
            return this.hoverColor;
        }
        if (color != this.tabPane.getBackground()) {
            return color;
        }
        if (this.focusColor != null && bl && FlatUIUtils.isPermanentFocusOwner(this.tabPane)) {
            return this.focusColor;
        }
        if (this.selectedBackground != null && bl) {
            return this.selectedBackground;
        }
        return color;
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.showTabSeparators", this.showTabSeparators) && !this.isLastInRun(n2)) {
            if (this.getTabType() == 1) {
                int n7 = this.tabPane.getSelectedIndex();
                if (n2 != n7 - 1 && n2 != n7) {
                    this.paintTabSeparator(graphics, n, n3, n4, n5, n6);
                }
            } else {
                this.paintTabSeparator(graphics, n, n3, n4, n5, n6);
            }
        }
        if (bl && this.getTabType() == 1) {
            this.paintCardTabBorder(graphics, n, n2, n3, n4, n5, n6);
        }
    }

    protected void paintCardTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Path2D.Float float_ = new Path2D.Float(0);
        float_.append(this.createCardTabOuterPath(n, n3, n4, n5, n6), false);
        float_.append(this.createCardTabInnerPath(n, n3, n4, n5, n6), false);
        graphics.setColor(this.tabSeparatorColor != null ? this.tabSeparatorColor : this.contentAreaColor);
        graphics2D.fill(float_);
    }

    protected Shape createCardTabOuterPath(int n, int n2, int n3, int n4, int n5) {
        float f = UIScale.scale((float)this.cardTabArc) / 2.0f;
        switch (n) {
            default: {
                float f2 = f;
                return FlatUIUtils.createRoundRectanglePath(n2, n3, n4, n5, f2, f2, 0.0f, 0.0f);
            }
            case 3: {
                float f3 = f;
                return FlatUIUtils.createRoundRectanglePath(n2, n3, n4, n5, 0.0f, 0.0f, f3, f3);
            }
            case 2: {
                return FlatUIUtils.createRoundRectanglePath(n2, n3, n4, n5, f, 0.0f, f, 0.0f);
            }
            case 4: 
        }
        return FlatUIUtils.createRoundRectanglePath(n2, n3, n4, n5, 0.0f, f, 0.0f, f);
    }

    protected Shape createCardTabInnerPath(int n, int n2, int n3, int n4, int n5) {
        float f = UIScale.scale((float)this.contentSeparatorHeight);
        float f2 = UIScale.scale((float)this.cardTabArc) / 2.0f - f;
        switch (n) {
            default: {
                float f3 = f2;
                return FlatUIUtils.createRoundRectanglePath((float)n2 + f, (float)n3 + f, (float)n4 - f * 2.0f, (float)n5 - f, f3, f3, 0.0f, 0.0f);
            }
            case 3: {
                float f4 = f2;
                return FlatUIUtils.createRoundRectanglePath((float)n2 + f, n3, (float)n4 - f * 2.0f, (float)n5 - f, 0.0f, 0.0f, f4, f4);
            }
            case 2: {
                return FlatUIUtils.createRoundRectanglePath((float)n2 + f, (float)n3 + f, (float)n4 - f, (float)n5 - f * 2.0f, f2, 0.0f, f2, 0.0f);
            }
            case 4: 
        }
        return FlatUIUtils.createRoundRectanglePath(n2, (float)n3 + f, (float)n4 - f, (float)n5 - f * 2.0f, 0.0f, f2, 0.0f, f2);
    }

    protected void paintTabCloseButton(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (this.tabCloseButton == null) {
            this.tabCloseButton = new TabCloseButton();
            this.tabCloseButton.setVisible(false);
        }
        boolean bl = n == this.getRolloverTab();
        ButtonModel buttonModel = this.tabCloseButton.getModel();
        buttonModel.setRollover(bl && this.isRolloverTabClose());
        buttonModel.setPressed(bl && this.isPressedTabClose());
        this.tabCloseButton.setBackground(this.tabPane.getBackground());
        this.tabCloseButton.setForeground(this.tabPane.getForeground());
        Rectangle rectangle = this.getTabCloseBounds(n, n2, n3, n4, n5, this.calcRect);
        this.closeIcon.paintIcon(this.tabCloseButton, graphics, rectangle.x, rectangle.y);
    }

    protected void paintTabSeparator(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        float f = UIScale.scale(1.0f);
        float f2 = this.tabSeparatorsFullHeight ? 0.0f : UIScale.scale(5.0f);
        graphics.setColor(this.tabSeparatorColor != null ? this.tabSeparatorColor : this.contentAreaColor);
        if (n == 2 || n == 4) {
            ((Graphics2D)graphics).fill(new Rectangle2D.Float((float)n2 + f2, (float)(n3 + n5) - f, (float)n4 - f2 * 2.0f, f));
            return;
        }
        if (this.isLeftToRight()) {
            ((Graphics2D)graphics).fill(new Rectangle2D.Float((float)(n2 + n4) - f, (float)n3 + f2, f, (float)n5 - f2 * 2.0f));
            return;
        }
        ((Graphics2D)graphics).fill(new Rectangle2D.Float(n2, (float)n3 + f2, f, (float)n5 - f2 * 2.0f));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void paintTabSelection(Graphics var1_1, int var2_2, int var3_3, int var4_5, int var5_6, int var6_7, int var7_8) {
        block11: {
            block10: {
                var1_1.setColor(this.tabPane.isEnabled() ? (this.isTabbedPaneOrChildFocused() ? this.underlineColor : this.inactiveUnderlineColor) : this.disabledUnderlineColor);
                var8_9 = this.getTabType() == 1;
                var9_10 = var8_9 == false;
                if (!var9_10) break block10;
                if (this.rotateTabRuns || this.runCount <= 1 || this.isScrollTabLayout()) ** GOTO lbl-1000
                v0 = this;
                if (v0.getRunForTab(v0.tabPane.getTabCount(), var3_3) > 0) {
                    v1 = new Insets(0, 0, 0, 0);
                } else lbl-1000:
                // 2 sources

                {
                    v1 = this.getContentBorderInsets(var2_2);
                }
                break block11;
            }
            v1 = null;
        }
        var3_4 /* !! */  = v1;
        var10_11 = UIScale.scale(var8_9 != false ? this.cardTabSelectionHeight : this.tabSelectionHeight);
        var11_12 = UIScale.scale((float)(var8_9 != false ? this.cardTabArc : this.tabSelectionArc)) / 2.0f;
        var12_13 = var4_5;
        var13_14 = var5_6;
        var14_15 = var6_7;
        var15_16 = var7_8;
        switch (var2_2) {
            default: {
                var13_14 = var9_10 != false ? var5_6 + var7_8 + var3_4 /* !! */ .top - var10_11 : var5_6;
                var15_16 = var10_11;
                break;
            }
            case 3: {
                var13_14 = var9_10 != false ? var5_6 - var3_4 /* !! */ .bottom : var5_6 + var7_8 - var10_11;
                var15_16 = var10_11;
                break;
            }
            case 2: {
                var12_13 = var9_10 != false ? var4_5 + var6_7 + var3_4 /* !! */ .left - var10_11 : var4_5;
                var14_15 = var10_11;
                break;
            }
            case 4: {
                var12_13 = var9_10 != false ? var4_5 - var3_4 /* !! */ .right : var4_5 + var6_7 - var10_11;
                var14_15 = var10_11;
            }
        }
        if (!var8_9 && this.tabSelectionInsets != null) {
            var3_4 /* !! */  = new Insets(0, 0, 0, 0);
            FlatTabbedPaneUI.rotateInsets(this.tabSelectionInsets, var3_4 /* !! */ , this.tabPane.getTabPlacement());
            var12_13 += UIScale.scale(var3_4 /* !! */ .left);
            var13_14 += UIScale.scale(var3_4 /* !! */ .top);
            var14_15 -= UIScale.scale(var3_4 /* !! */ .left + var3_4 /* !! */ .right);
            var15_16 -= UIScale.scale(var3_4 /* !! */ .top + var3_4 /* !! */ .bottom);
        }
        if (var11_12 <= 0.0f) {
            var1_1.fillRect(var12_13, var13_14, var14_15, var15_16);
            return;
        }
        if (var8_9) {
            var3_4 /* !! */  = new Area(this.createCardTabOuterPath(var2_2, var4_5, var5_6, var6_7, var7_8));
            var3_4 /* !! */ .intersect(new Area(new Rectangle2D.Float(var12_13, var13_14, var14_15, var15_16)));
            ((Graphics2D)var1_1).fill((Shape)var3_4 /* !! */ );
            return;
        }
        v2 = var11_12;
        v3 = var11_12;
        FlatUIUtils.paintSelection((Graphics2D)var1_1, var12_13, var13_14, var14_15, var15_16, null, v2, v2, v3, v3, 0);
    }

    protected boolean isTabbedPaneOrChildFocused() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Object object = this.tabPane.getClientProperty("JComponent.focusOwner");
        if (object instanceof Predicate) {
            return ((Predicate)object).test(this.tabPane) && FlatUIUtils.isInActiveWindow(this.tabPane, keyboardFocusManager.getActiveWindow());
        }
        object = keyboardFocusManager.getPermanentFocusOwner();
        return object != null && SwingUtilities.isDescendingFrom((Component)object, this.tabPane) && FlatUIUtils.isInActiveWindow((Component)object, keyboardFocusManager.getActiveWindow());
    }

    @Override
    protected void paintContentBorder(Graphics graphics, int n, int n2) {
        Rectangle2D rectangle2D;
        Insets insets;
        if (this.tabPane.getTabCount() <= 0 || this.contentSeparatorHeight == 0 || !FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.showContentSeparator", this.showContentSeparator)) {
            return;
        }
        Insets insets2 = this.tabPane.getInsets();
        Insets insets3 = this.getTabAreaInsets(n);
        int n3 = insets2.left;
        int n4 = insets2.top;
        int n5 = this.tabPane.getWidth() - insets2.right - insets2.left;
        int n6 = this.tabPane.getHeight() - insets2.top - insets2.bottom;
        switch (n) {
            default: {
                n4 += this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                n6 -= (n4 -= insets3.bottom) - insets2.top;
                break;
            }
            case 3: {
                n6 -= this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                n6 += insets3.top;
                break;
            }
            case 2: {
                n3 += this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                n5 -= (n3 -= insets3.right) - insets2.left;
                break;
            }
            case 4: {
                n5 -= this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                n5 += insets3.left;
            }
        }
        boolean bl = FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.hasFullBorder", this.hasFullBorder);
        int n7 = UIScale.scale(this.contentSeparatorHeight * 100);
        Object object = new Insets(0, 0, 0, 0);
        if (bl) {
            int n8 = n7;
            int n9 = n7;
            insets = new Insets(n8, n8, n9, n9);
        } else {
            insets = new Insets(n7, 0, 0, 0);
        }
        FlatTabbedPaneUI.rotateInsets(insets, (Insets)object, n);
        Path2D.Float float_ = new Path2D.Float(0);
        float_.append(new Rectangle2D.Float(n3, n4, n5, n6), false);
        float_.append(new Rectangle2D.Float((float)n3 + (float)((Insets)object).left / 100.0f, (float)n4 + (float)((Insets)object).top / 100.0f, (float)n5 - (float)((Insets)object).left / 100.0f - (float)((Insets)object).right / 100.0f, (float)n6 - (float)((Insets)object).top / 100.0f - (float)((Insets)object).bottom / 100.0f), false);
        if (this.getTabType() == 1) {
            float f = UIScale.scale((float)this.contentSeparatorHeight);
            FlatTabbedPaneUI flatTabbedPaneUI = this;
            object = flatTabbedPaneUI.getTabBounds(flatTabbedPaneUI.tabPane, n2);
            rectangle2D = new Rectangle2D.Float((float)((Rectangle)object).x + f, (float)((Rectangle)object).y + f, (float)((Rectangle)object).width - f * 2.0f, (float)((Rectangle)object).height - f * 2.0f);
            if (this.tabViewport != null) {
                Rectangle2D rectangle2D2 = rectangle2D;
                Rectangle2D.intersect(this.tabViewport.getBounds(), rectangle2D2, rectangle2D2);
            }
            object = null;
            if (this.isHorizontalTabPlacement(n)) {
                if (((Rectangle2D.Float)rectangle2D).width > 0.0f) {
                    float f2 = n == 1 ? (float)n4 : (float)(n4 + n6) - f;
                    object = new Rectangle2D.Float(((Rectangle2D.Float)rectangle2D).x, f2, ((Rectangle2D.Float)rectangle2D).width, f);
                }
            } else if (((Rectangle2D.Float)rectangle2D).height > 0.0f) {
                float f3 = n == 2 ? (float)n3 : (float)(n3 + n5) - f;
                object = new Rectangle2D.Float(f3, ((Rectangle2D.Float)rectangle2D).y, f, ((Rectangle2D.Float)rectangle2D).height);
            }
            if (object != null) {
                float_.append((Shape)object, false);
                Color color = this.getTabBackground(n, n2, true);
                graphics.setColor(FlatUIUtils.deriveColor(color, this.tabPane.getBackground()));
                ((Graphics2D)graphics).fill((Shape)object);
            }
        }
        graphics.setColor(this.contentAreaColor);
        ((Graphics2D)graphics).fill(float_);
        if (this.isScrollTabLayout() && n2 >= 0 && this.tabViewport != null) {
            FlatTabbedPaneUI flatTabbedPaneUI = this;
            Rectangle rectangle = flatTabbedPaneUI.getTabBounds(flatTabbedPaneUI.tabPane, n2);
            object = graphics.getClip();
            rectangle2D = this.tabViewport.getBounds();
            if (this.isHorizontalTabPlacement(n)) {
                graphics.clipRect(rectangle2D.x, 0, rectangle2D.width, this.tabPane.getHeight());
            } else {
                graphics.clipRect(0, rectangle2D.y, this.tabPane.getWidth(), rectangle2D.height);
            }
            this.paintTabSelection(graphics, n, n2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setClip((Shape)object);
        }
    }

    @Override
    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
    }

    protected String layoutAndClipLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean n3) {
        n3 = this.getRealTabRotation(n);
        int n4 = this.isLeftToRight();
        rectangle = FlatUIUtils.subtractInsets(rectangle, this.getTabInsetsRotated(n, n2, n3));
        if (this.isTabClosable(n2)) {
            if (n3 == -1) {
                n = this.closeIcon.getIconWidth();
                rectangle.width -= n;
                if (n4 == 0) {
                    rectangle.x += n;
                }
            } else {
                n = this.closeIcon.getIconHeight();
                rectangle.height -= n;
                if (n3 == 2 && n4 != 0 || n3 == 4 && n4 == 0) {
                    rectangle.y += n;
                }
            }
        }
        switch (FlatClientProperties.clientPropertyInt(this.tabPane, "JTabbedPane.tabIconPlacement", this.tabIconPlacement)) {
            default: {
                n = 0;
                n4 = 11;
                break;
            }
            case 11: {
                n = 0;
                n4 = 10;
                break;
            }
            case 1: {
                n = 3;
                n4 = 0;
                break;
            }
            case 3: {
                n = 1;
                n4 = 0;
            }
        }
        rectangle3.setBounds(0, 0, 0, 0);
        rectangle2.setBounds(0, 0, 0, 0);
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            this.tabPane.putClientProperty("html", view);
        }
        String string2 = n3 == -1 ? SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, this.getTabAlignment(n2), n, n4, rectangle, rectangle2, rectangle3, UIScale.scale(this.textIconGapUnscaled)) : this.layoutVerticalCompoundLabel(n3, this.tabPane, fontMetrics, string, icon, 0, this.getTabAlignment(n2), n, n4, rectangle, rectangle2, rectangle3, UIScale.scale(this.textIconGapUnscaled));
        this.tabPane.putClientProperty("html", null);
        return string2;
    }

    private String layoutVerticalCompoundLabel(int n, JComponent object, FontMetrics fontMetrics, String string, Icon icon, int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n6) {
        Rectangle rectangle4 = new Rectangle(rectangle.height, rectangle.width);
        object = SwingUtilities.layoutCompoundLabel((JComponent)object, fontMetrics, string, icon, n2, n3, n4, n5, rectangle4, rectangle2, rectangle3, n6);
        if (n == 2) {
            this.rotateLeft(rectangle, rectangle2);
            this.rotateLeft(rectangle, rectangle3);
        } else {
            this.rotateRight(rectangle, rectangle2);
            this.rotateRight(rectangle, rectangle3);
        }
        return object;
    }

    private void rotateLeft(Rectangle rectangle, Rectangle rectangle2) {
        int n = rectangle.x + rectangle2.y;
        int n2 = rectangle.y + (rectangle.height - (rectangle2.x + rectangle2.width));
        rectangle2.setBounds(n, n2, rectangle2.height, rectangle2.width);
    }

    private void rotateRight(Rectangle rectangle, Rectangle rectangle2) {
        int n = rectangle.x + (rectangle.width - (rectangle2.y + rectangle2.height));
        int n2 = rectangle.y + rectangle2.x;
        rectangle2.setBounds(n, n2, rectangle2.height, rectangle2.width);
    }

    protected int getRealTabRotation(int n) {
        int n2 = this.getTabRotation();
        int n3 = n2 == -2 ? (n == 2 ? 2 : (n == 4 ? 4 : -1)) : (n = n2 == 2 || n2 == 4 ? n2 : -1);
        assert (n == -1 || n == 2 || n == 4);
        return n;
    }

    @Override
    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        if (this.moreTabsButton != null) {
            Point point = this.tabViewport.getViewPosition();
            n = n - this.tabViewport.getX() + point.x;
            n2 = n2 - this.tabViewport.getY() + point.y;
            if (!this.tabViewport.getViewRect().contains(n, n2)) {
                return -1;
            }
        }
        return super.tabForCoordinate(jTabbedPane, n, n2);
    }

    @Override
    protected Rectangle getTabBounds(int n, Rectangle rectangle) {
        if (this.moreTabsButton != null) {
            rectangle.setBounds(this.rects[n]);
            Point point = this.tabViewport.getViewPosition();
            rectangle.x = rectangle.x + this.tabViewport.getX() - point.x;
            rectangle.y = rectangle.y + this.tabViewport.getY() - point.y;
            return rectangle;
        }
        return super.getTabBounds(n, rectangle);
    }

    protected Rectangle getTabCloseBounds(int n, int n2, int n3, int n4, int n5, Rectangle rectangle) {
        int n6;
        Rectangle rectangle2;
        int n7 = this.closeIcon.getIconWidth();
        int n8 = this.closeIcon.getIconHeight();
        int n9 = this.tabPane.getTabPlacement();
        int n10 = this.getRealTabRotation(n9);
        Insets insets = this.getTabInsetsRotated(n9, n, n10);
        n9 = this.isLeftToRight() ? 1 : 0;
        if (n10 == -1) {
            rectangle.x = n9 != 0 ? n2 + n4 - (insets.right / 3 << 1) - n7 : n2 + (insets.left / 3 << 1);
            rectangle2 = rectangle;
            n6 = n3 + (n5 - n8) / 2;
        } else {
            rectangle.x = n2 + (n4 - n7) / 2;
            rectangle2 = rectangle;
            n6 = n10 == 4 && n9 != 0 || n10 == 2 && n9 == 0 ? n3 + n5 - (insets.bottom / 3 << 1) - n8 : n3 + (insets.top / 3 << 1);
        }
        rectangle2.y = n6;
        rectangle.width = n7;
        rectangle.height = n8;
        return rectangle;
    }

    protected Rectangle getTabCloseHitArea(int n) {
        FlatTabbedPaneUI flatTabbedPaneUI = this;
        Rectangle rectangle = flatTabbedPaneUI.getTabBounds(flatTabbedPaneUI.tabPane, n);
        Rectangle rectangle2 = this.getTabCloseBounds(n, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.calcRect);
        FlatTabbedPaneUI flatTabbedPaneUI2 = this;
        if (flatTabbedPaneUI2.getRealTabRotation(flatTabbedPaneUI2.tabPane.getTabPlacement()) == -1) {
            return new Rectangle(rectangle2.x, rectangle.y, rectangle2.width, rectangle.height);
        }
        return new Rectangle(rectangle.x, rectangle2.y, rectangle.width, rectangle2.height);
    }

    protected boolean isTabClosable(int n) {
        if (n < 0) {
            return false;
        }
        Object object = this.getTabClientProperty(n, "JTabbedPane.tabClosable");
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return this.tabClosable;
    }

    protected void closeTab(int n) {
        Object object = this.getTabClientProperty(n, "JTabbedPane.tabCloseCallback");
        if (object instanceof IntConsumer) {
            ((IntConsumer)object).accept(n);
            return;
        }
        if (object instanceof BiConsumer) {
            ((BiConsumer)object).accept(this.tabPane, n);
            return;
        }
        throw new RuntimeException("Missing tab close callback. Set client property 'JTabbedPane.tabCloseCallback' to a 'java.util.function.IntConsumer' or 'java.util.function.BiConsumer<JTabbedPane, Integer>'");
    }

    protected Object getTabClientProperty(int n, String string) {
        if (n < 0) {
            return null;
        }
        Object object = this.tabPane.getComponentAt(n);
        if (object instanceof JComponent && (object = ((JComponent)object).getClientProperty(string)) != null) {
            return object;
        }
        return this.tabPane.getClientProperty(string);
    }

    protected int getTabClientPropertyInt(int n, String string, int n2) {
        Object object = this.getTabClientProperty(n, string);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return n2;
    }

    protected void ensureCurrentLayout() {
        FlatTabbedPaneUI flatTabbedPaneUI = this;
        super.getTabRunCount(flatTabbedPaneUI.tabPane);
    }

    @Override
    protected boolean shouldRotateTabRuns(int n) {
        return this.rotateTabRuns;
    }

    private boolean isLastInRun(int n) {
        FlatTabbedPaneUI flatTabbedPaneUI = this;
        int n2 = flatTabbedPaneUI.getRunForTab(flatTabbedPaneUI.tabPane.getTabCount(), n);
        FlatTabbedPaneUI flatTabbedPaneUI2 = this;
        return flatTabbedPaneUI2.lastTabInRun(flatTabbedPaneUI2.tabPane.getTabCount(), n2) == n;
    }

    private boolean isScrollTabLayout() {
        return this.tabPane.getTabLayoutPolicy() == 1;
    }

    private boolean isLeftToRight() {
        return this.tabPane.getComponentOrientation().isLeftToRight();
    }

    protected boolean isHorizontalTabPlacement(int n) {
        return n == 1 || n == 3;
    }

    private boolean isHorizontalOrRotated(int n) {
        return this.isHorizontalTabPlacement(n) == (this.getRealTabRotation(n) == -1);
    }

    protected boolean isSmoothScrollingEnabled() {
        if (!Animator.useAnimation()) {
            return false;
        }
        return UIManager.getBoolean("ScrollPane.smoothScrolling");
    }

    protected boolean hideTabArea() {
        return this.tabPane.getTabCount() == 1 && this.leadingComponent == null && this.trailingComponent == null && FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.hideTabAreaWithOneTab", this.hideTabAreaWithOneTab);
    }

    protected int getTabType() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.tabType");
        if (object instanceof String) {
            return FlatTabbedPaneUI.parseTabType((String)object);
        }
        return this.tabType;
    }

    protected int getTabsPopupPolicy() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.tabsPopupPolicy");
        if (object instanceof String) {
            return FlatTabbedPaneUI.parseTabsPopupPolicy((String)object);
        }
        return this.tabsPopupPolicy;
    }

    protected int getScrollButtonsPolicy() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.scrollButtonsPolicy");
        if (object instanceof String) {
            return FlatTabbedPaneUI.parseScrollButtonsPolicy((String)object);
        }
        return this.scrollButtonsPolicy;
    }

    protected int getScrollButtonsPlacement() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.scrollButtonsPlacement");
        if (object instanceof String) {
            return FlatTabbedPaneUI.parseScrollButtonsPlacement((String)object);
        }
        return this.scrollButtonsPlacement;
    }

    protected int getTabAreaAlignment() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.tabAreaAlignment");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            return FlatTabbedPaneUI.parseAlignment((String)object, 10);
        }
        return this.tabAreaAlignment;
    }

    protected int getTabAlignment(int n) {
        Object object = this.getTabClientProperty(n, "JTabbedPane.tabAlignment");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            return FlatTabbedPaneUI.parseAlignment((String)object, 0);
        }
        return this.tabAlignment;
    }

    protected int getTabWidthMode() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.tabWidthMode");
        if (object instanceof String) {
            return FlatTabbedPaneUI.parseTabWidthMode((String)object);
        }
        return this.tabWidthMode;
    }

    protected int getTabRotation() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.tabRotation");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            return FlatTabbedPaneUI.parseTabRotation((String)object);
        }
        return this.tabRotation;
    }

    protected static int parseTabType(String string) {
        if (string == null) {
            return 0;
        }
        int n = -1;
        switch (string.hashCode()) {
            case -1771105512: {
                if (!string.equals("underlined")) break;
                n = 1;
                break;
            }
            case 3046160: {
                if (!string.equals("card")) break;
                n = 2;
            }
        }
        switch (n) {
            default: {
                return 0;
            }
            case 2: 
        }
        return 1;
    }

    protected static int parseTabsPopupPolicy(String string) {
        if (string == null) {
            return 2;
        }
        int n = -1;
        switch (string.hashCode()) {
            case -1432923513: {
                if (!string.equals("asNeeded")) break;
                n = 1;
                break;
            }
            case 104712844: {
                if (!string.equals("never")) break;
                n = 2;
            }
        }
        switch (n) {
            default: {
                return 2;
            }
            case 2: 
        }
        return 0;
    }

    protected static int parseScrollButtonsPolicy(String string) {
        if (string == null) {
            return 3;
        }
        int n = -1;
        switch (string.hashCode()) {
            case 1431863727: {
                if (!string.equals("asNeededSingle")) break;
                n = 1;
                break;
            }
            case -1432923513: {
                if (!string.equals("asNeeded")) break;
                n = 2;
                break;
            }
            case 104712844: {
                if (!string.equals("never")) break;
                n = 3;
            }
        }
        switch (n) {
            default: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 3: 
        }
        return 0;
    }

    protected static int parseScrollButtonsPlacement(String string) {
        if (string == null) {
            return 100;
        }
        int n = -1;
        switch (string.hashCode()) {
            case 3029889: {
                if (!string.equals("both")) break;
                n = 1;
                break;
            }
            case 1276059676: {
                if (!string.equals("trailing")) break;
                n = 2;
            }
        }
        switch (n) {
            default: {
                return 100;
            }
            case 2: 
        }
        return 11;
    }

    protected static int parseAlignment(String string, int n) {
        if (string == null) {
            return n;
        }
        int n2 = -1;
        switch (string.hashCode()) {
            case 50359046: {
                if (!string.equals("leading")) break;
                n2 = 0;
                break;
            }
            case 1276059676: {
                if (!string.equals("trailing")) break;
                n2 = 1;
                break;
            }
            case -1364013995: {
                if (!string.equals("center")) break;
                n2 = 2;
                break;
            }
            case 3143043: {
                if (!string.equals("fill")) break;
                n2 = 3;
            }
        }
        switch (n2) {
            case 0: {
                return 10;
            }
            case 1: {
                return 11;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 100;
            }
        }
        return n;
    }

    private static String alignmentToString(int n, String string) {
        switch (n) {
            case 10: {
                return "leading";
            }
            case 11: {
                return "trailing";
            }
            case 0: {
                return "center";
            }
            case 100: {
                return "fill";
            }
        }
        return string;
    }

    protected static int parseTabWidthMode(String string) {
        if (string == null) {
            return 0;
        }
        int n = -1;
        switch (string.hashCode()) {
            case -1294005119: {
                if (!string.equals("preferred")) break;
                n = 1;
                break;
            }
            case 96757556: {
                if (!string.equals("equal")) break;
                n = 2;
                break;
            }
            case 950483747: {
                if (!string.equals("compact")) break;
                n = 3;
            }
        }
        switch (n) {
            default: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
        }
        return 2;
    }

    protected static int parseTabRotation(String string) {
        if (string == null) {
            return 0;
        }
        int n = -1;
        switch (string.hashCode()) {
            case 3387192: {
                if (!string.equals("none")) break;
                n = 1;
                break;
            }
            case 3005871: {
                if (!string.equals("auto")) break;
                n = 2;
                break;
            }
            case 3317767: {
                if (!string.equals("left")) break;
                n = 3;
                break;
            }
            case 108511772: {
                if (!string.equals("right")) break;
                n = 4;
            }
        }
        switch (n) {
            default: {
                return -1;
            }
            case 2: {
                return -2;
            }
            case 3: {
                return 2;
            }
            case 4: 
        }
        return 4;
    }

    protected static int parseTabIconPlacement(String string) {
        if (string == null) {
            return 10;
        }
        int n = -1;
        switch (string.hashCode()) {
            case 50359046: {
                if (!string.equals("leading")) break;
                n = 1;
                break;
            }
            case 1276059676: {
                if (!string.equals("trailing")) break;
                n = 2;
                break;
            }
            case 115029: {
                if (!string.equals("top")) break;
                n = 3;
                break;
            }
            case -1383228885: {
                if (!string.equals("bottom")) break;
                n = 4;
            }
        }
        switch (n) {
            default: {
                return 10;
            }
            case 2: {
                return 11;
            }
            case 3: {
                return 1;
            }
            case 4: 
        }
        return 3;
    }

    private void runWithOriginalLayoutManager(Runnable runnable) {
        LayoutManager layoutManager = this.tabPane.getLayout();
        if (layoutManager instanceof FlatTabbedPaneScrollLayout) {
            this.tabPane.setLayout(((FlatTabbedPaneScrollLayout)layoutManager).delegate);
            runnable.run();
            this.tabPane.setLayout(layoutManager);
            return;
        }
        runnable.run();
    }

    protected void ensureSelectedTabIsVisibleLater() {
        if (!this.tabPane.isDisplayable() || !EventQueue.isDispatchThread()) {
            return;
        }
        EventQueue.invokeLater(() -> this.ensureSelectedTabIsVisible());
    }

    protected void ensureSelectedTabIsVisible() {
        if (this.tabPane == null || this.tabViewport == null || !this.tabPane.isDisplayable()) {
            return;
        }
        this.ensureCurrentLayout();
        int n = this.tabPane.getSelectedIndex();
        if (n < 0 || n >= this.rects.length) {
            return;
        }
        ((JComponent)this.tabViewport.getView()).scrollRectToVisible((Rectangle)this.rects[n].clone());
    }

    private int getLeadingPreferredWidth() {
        if (this.leadingComponent != null) {
            return this.leadingComponent.getPreferredSize().width;
        }
        return 0;
    }

    private int getLeadingPreferredHeight() {
        if (this.leadingComponent != null) {
            return this.leadingComponent.getPreferredSize().height;
        }
        return 0;
    }

    private int getTrailingPreferredWidth() {
        if (this.trailingComponent != null) {
            return this.trailingComponent.getPreferredSize().width;
        }
        return 0;
    }

    private int getTrailingPreferredHeight() {
        if (this.trailingComponent != null) {
            return this.trailingComponent.getPreferredSize().height;
        }
        return 0;
    }

    private void shiftTabs(int n, int n2) {
        if (n == 0 && n2 == 0) {
            return;
        }
        for (int i = 0; i < this.rects.length; ++i) {
            this.rects[i].x += n;
            this.rects[i].y += n2;
        }
    }

    private void stretchTabsWidth(int n, boolean bl) {
        int n2;
        int n3 = n / this.rects.length;
        int n4 = this.rects[0].x - (bl ? 0 : n3);
        for (n2 = 0; n2 < this.rects.length; ++n2) {
            this.rects[n2].x = n4;
            this.rects[n2].width += n3;
            if (bl) {
                n4 += this.rects[n2].width;
                continue;
            }
            if (n2 + 1 >= this.rects.length) continue;
            n4 = this.rects[n2].x - this.rects[n2 + 1].width - n3;
        }
        n2 = n - n3 * this.rects.length;
        this.rects[this.rects.length - 1].width += n2;
        if (!bl) {
            this.rects[this.rects.length - 1].x -= n2;
        }
    }

    private void stretchTabsHeight(int n) {
        int n2 = n / this.rects.length;
        int n3 = this.rects[0].y;
        for (int i = 0; i < this.rects.length; ++i) {
            this.rects[i].y = n3;
            this.rects[i].height += n2;
            n3 += this.rects[i].height;
        }
        this.rects[this.rects.length - 1].height += n - n2 * this.rects.length;
    }

    private int rectsTotalWidth(boolean bl) {
        int n = this.rects.length - 1;
        if (bl) {
            return this.rects[n].x + this.rects[n].width - this.rects[0].x;
        }
        return this.rects[0].x + this.rects[0].width - this.rects[n].x;
    }

    private int rectsTotalHeight() {
        int n = this.rects.length - 1;
        return this.rects[n].y + this.rects[n].height - this.rects[0].y;
    }

    @Override
    public Boolean isTitleBarCaptionAt(int n, int n2) {
        FlatTabbedPaneUI flatTabbedPaneUI = this;
        if (flatTabbedPaneUI.tabForCoordinate(flatTabbedPaneUI.tabPane, n, n2) >= 0) {
            return Boolean.FALSE;
        }
        return null;
    }

    private static class FlatSelectedTabRepainter
    implements PropertyChangeListener {
        private static FlatSelectedTabRepainter instance;
        private KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();

        static void install() {
            Class<FlatSelectedTabRepainter> clazz = FlatSelectedTabRepainter.class;
            synchronized (FlatSelectedTabRepainter.class) {
                if (instance != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                instance = new FlatSelectedTabRepainter();
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        FlatSelectedTabRepainter() {
            this.keyboardFocusManager.addPropertyChangeListener(this);
        }

        private void uninstall() {
            Class<FlatSelectedTabRepainter> clazz = FlatSelectedTabRepainter.class;
            synchronized (FlatSelectedTabRepainter.class) {
                if (instance == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                this.keyboardFocusManager.removePropertyChangeListener(this);
                this.keyboardFocusManager = null;
                instance = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent object) {
            if (!(UIManager.getLookAndFeel() instanceof FlatLaf)) {
                this.uninstall();
                return;
            }
            switch (((PropertyChangeEvent)object).getPropertyName()) {
                case "permanentFocusOwner": {
                    Object object2 = ((PropertyChangeEvent)object).getOldValue();
                    object = ((PropertyChangeEvent)object).getNewValue();
                    if (object2 instanceof Component) {
                        this.repaintSelectedTabs((Component)object2);
                    }
                    if (!(object instanceof Component)) break;
                    this.repaintSelectedTabs((Component)object);
                    return;
                }
                case "activeWindow": {
                    object = this.keyboardFocusManager.getPermanentFocusOwner();
                    if (object == null) break;
                    this.repaintSelectedTabs((Component)object);
                }
            }
        }

        private void repaintSelectedTabs(Component component) {
            EventQueue.invokeLater(() -> {
                if (!component.isDisplayable()) {
                    return;
                }
                if (component instanceof JTabbedPane) {
                    this.repaintSelectedTab((JTabbedPane)component);
                }
                while ((component = SwingUtilities.getAncestorOfClass(JTabbedPane.class, component)) != null) {
                    this.repaintSelectedTab((JTabbedPane)component);
                }
            });
        }

        private void repaintSelectedTab(JTabbedPane jTabbedPane) {
            TabbedPaneUI tabbedPaneUI = jTabbedPane.getUI();
            if (tabbedPaneUI instanceof FlatTabbedPaneUI) {
                ((FlatTabbedPaneUI)tabbedPaneUI).repaintTab(jTabbedPane.getSelectedIndex());
            }
        }
    }

    private static class RunWithOriginalLayoutManagerDelegateAction
    extends FlatUIAction {
        static void install(ActionMap actionMap, String string) {
            Action action = actionMap.get(string);
            if (action == null || action instanceof RunWithOriginalLayoutManagerDelegateAction) {
                return;
            }
            actionMap.put(string, new RunWithOriginalLayoutManagerDelegateAction(action));
        }

        private RunWithOriginalLayoutManagerDelegateAction(Action action) {
            super(action);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = (JTabbedPane)actionEvent.getSource();
            if ((object = ((JTabbedPane)object).getUI()) instanceof FlatTabbedPaneUI) {
                ((FlatTabbedPaneUI)object).runWithOriginalLayoutManager(() -> this.delegate.actionPerformed(actionEvent));
                return;
            }
            this.delegate.actionPerformed(actionEvent);
        }
    }

    protected class FlatTabbedPaneScrollLayout
    extends FlatTabbedPaneLayout
    implements LayoutManager {
        private final BasicTabbedPaneUI.TabbedPaneLayout delegate;

        protected FlatTabbedPaneScrollLayout(BasicTabbedPaneUI.TabbedPaneLayout tabbedPaneLayout) {
            this.delegate = tabbedPaneLayout;
        }

        @Override
        public void calculateLayoutInfo() {
            this.delegate.calculateLayoutInfo();
        }

        @Override
        protected Dimension calculateTabAreaSize() {
            Dimension dimension = super.calculateTabAreaSize();
            if (FlatTabbedPaneUI.this.isHorizontalTabPlacement(FlatTabbedPaneUI.this.tabPane.getTabPlacement())) {
                dimension.width = Math.min(dimension.width, UIScale.scale(100));
            } else {
                dimension.height = Math.min(dimension.height, UIScale.scale(100));
            }
            return dimension;
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            if (this.isContentEmpty()) {
                return this.calculateTabAreaSize();
            }
            return this.delegate.preferredLayoutSize(container);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            if (this.isContentEmpty()) {
                return this.calculateTabAreaSize();
            }
            return this.delegate.minimumLayoutSize(container);
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            this.delegate.addLayoutComponent(string, component);
        }

        @Override
        public void removeLayoutComponent(Component component) {
            this.delegate.removeLayoutComponent(component);
        }

        @Override
        protected void layoutContainerImpl() {
            int n;
            int n2;
            Cloneable cloneable;
            Serializable serializable;
            int n3;
            this.layoutChildComponents();
            int n4 = FlatTabbedPaneUI.this.getTabsPopupPolicy();
            int n5 = FlatTabbedPaneUI.this.getScrollButtonsPolicy();
            int n6 = FlatTabbedPaneUI.this.getScrollButtonsPlacement();
            n4 = n4 == 2 ? 1 : 0;
            boolean bl = n5 == 2 || n5 == 3;
            n5 = n5 == 3 && n6 == 100 ? 1 : 0;
            n6 = n6 == 11 ? 1 : 0;
            boolean bl2 = FlatTabbedPaneUI.this.isLeftToRight();
            if (!bl2 && FlatTabbedPaneUI.this.isHorizontalTabPlacement(FlatTabbedPaneUI.this.tabPane.getTabPlacement())) {
                n4 = 1;
                bl = false;
            }
            JButton jButton = null;
            JButton jButton2 = null;
            for (Component component : FlatTabbedPaneUI.this.tabPane.getComponents()) {
                if (!(component instanceof FlatScrollableTabButton)) continue;
                n3 = ((FlatScrollableTabButton)component).getDirection();
                if (n3 == 7 || n3) {
                    jButton = (JButton)component;
                    continue;
                }
                if (n3 != 3 && n3 != 5) continue;
                jButton2 = (JButton)component;
            }
            if (jButton == null || jButton2 == null) {
                return;
            }
            int n7 = FlatTabbedPaneUI.this.tabPane.getTabPlacement();
            int n8 = FlatTabbedPaneUI.this.getTabAreaAlignment();
            Insets insets = FlatTabbedPaneUI.this.getRealTabAreaInsets(n7);
            boolean bl3 = false;
            n3 = 0;
            boolean bl4 = false;
            if (insets.left != 0 || insets.top != 0) {
                FlatTabbedPaneUI.this.shiftTabs(-insets.left, -insets.top);
                serializable = FlatTabbedPaneUI.this.tabViewport.getView();
                cloneable = ((Component)serializable).getPreferredSize();
                n2 = n7 == 1 || n7 == 3 ? 1 : 0;
                ((Component)serializable).setPreferredSize(new Dimension(cloneable.width - (n2 != 0 ? insets.left : 0), cloneable.height - (n2 != 0 ? 0 : insets.top)));
            }
            serializable = this.getTabAreaLayoutBounds(n7, insets);
            if (n7 == 1 || n7 == 3) {
                if (bl && n5 != 0) {
                    cloneable = FlatTabbedPaneUI.this.tabViewport.getViewPosition();
                    if (((Point)cloneable).x <= jButton.getPreferredSize().width) {
                        FlatTabbedPaneUI.this.tabViewport.setViewPosition(new Point(0, ((Point)cloneable).y));
                    }
                }
                n = ((Rectangle)serializable).width - FlatTabbedPaneUI.this.getLeadingPreferredWidth() - FlatTabbedPaneUI.this.getTrailingPreferredWidth() - insets.left - insets.right;
                n2 = FlatTabbedPaneUI.this.rects.length > 0 ? FlatTabbedPaneUI.this.rectsTotalWidth(bl2) : 0;
                n7 = n2 < n ? 1 : 0;
                Rectangle rectangle = this.layoutLeftAndRightComponents((Rectangle)serializable, n8, insets, n7 != 0, false, bl2);
                if (FlatTabbedPaneUI.this.rects.length > 0) {
                    int n9 = rectangle.x + (bl2 ? insets.left : insets.right);
                    n7 = rectangle.width - insets.left - insets.right;
                    int n10 = rectangle.y;
                    int n11 = rectangle.height;
                    if (n7 < n2) {
                        if (n4 != 0) {
                            n4 = ((FlatTabbedPaneUI)FlatTabbedPaneUI.this).moreTabsButton.getPreferredSize().width;
                            FlatTabbedPaneUI.this.moreTabsButton.setBounds(bl2 ? n9 + n7 - n4 : n9, n10, n4, n11);
                            n9 += bl2 ? 0 : n4;
                            n7 -= n4;
                            bl3 = true;
                        }
                        if (bl) {
                            Point point = FlatTabbedPaneUI.this.tabViewport.getViewPosition();
                            Dimension dimension = FlatTabbedPaneUI.this.tabViewport.getViewSize();
                            if (n5 == 0 || dimension.width - point.x > n7) {
                                int n12 = jButton2.getPreferredSize().width;
                                jButton2.setBounds(n9 + n7 - n12, n10, n12, n11);
                                n7 -= n12;
                                bl4 = true;
                            }
                            if (n5 == 0 || point.x > 0) {
                                int n13 = jButton.getPreferredSize().width;
                                if (n6 != 0) {
                                    jButton.setBounds(n9 + n7 - n13, n10, n13, n11);
                                } else {
                                    jButton.setBounds(n9, n10, n13, n11);
                                    n9 += n13;
                                }
                                n7 -= n13;
                                n3 = 1;
                            }
                        }
                    }
                    FlatTabbedPaneUI.this.tabViewport.setBounds(n9, n10, n7, n11);
                    if (!bl2) {
                        FlatTabbedPaneUI.this.tabViewport.doLayout();
                        FlatTabbedPaneUI.this.shiftTabs(FlatTabbedPaneUI.this.tabViewport.getView().getWidth() - (((FlatTabbedPaneUI)FlatTabbedPaneUI.this).rects[0].x + ((FlatTabbedPaneUI)FlatTabbedPaneUI.this).rects[0].width), 0);
                    }
                }
            } else {
                if (bl && n5 != 0) {
                    cloneable = FlatTabbedPaneUI.this.tabViewport.getViewPosition();
                    if (((Point)cloneable).y <= jButton.getPreferredSize().height) {
                        FlatTabbedPaneUI.this.tabViewport.setViewPosition(new Point(((Point)cloneable).x, 0));
                    }
                }
                n = ((Rectangle)serializable).height - FlatTabbedPaneUI.this.getLeadingPreferredHeight() - FlatTabbedPaneUI.this.getTrailingPreferredHeight() - insets.top - insets.bottom;
                n2 = FlatTabbedPaneUI.this.rects.length > 0 ? FlatTabbedPaneUI.this.rectsTotalHeight() : 0;
                n7 = n2 < n ? 1 : 0;
                Rectangle rectangle = this.layoutTopAndBottomComponents((Rectangle)serializable, n8, insets, n7 != 0, false);
                if (FlatTabbedPaneUI.this.rects.length > 0) {
                    int n14 = rectangle.y + insets.top;
                    n7 = rectangle.height - insets.top - insets.bottom;
                    int n15 = rectangle.x;
                    int n16 = rectangle.width;
                    if (n7 < n2) {
                        if (n4 != 0) {
                            n4 = ((FlatTabbedPaneUI)FlatTabbedPaneUI.this).moreTabsButton.getPreferredSize().height;
                            FlatTabbedPaneUI.this.moreTabsButton.setBounds(n15, n14 + n7 - n4, n16, n4);
                            n7 -= n4;
                            bl3 = true;
                        }
                        if (bl) {
                            Point point = FlatTabbedPaneUI.this.tabViewport.getViewPosition();
                            Dimension dimension = FlatTabbedPaneUI.this.tabViewport.getViewSize();
                            if (n5 == 0 || dimension.height - point.y > n7) {
                                int n17 = jButton2.getPreferredSize().height;
                                jButton2.setBounds(n15, n14 + n7 - n17, n16, n17);
                                n7 -= n17;
                                bl4 = true;
                            }
                            if (n5 == 0 || point.y > 0) {
                                int n18 = jButton.getPreferredSize().height;
                                if (n6 != 0) {
                                    jButton.setBounds(n15, n14 + n7 - n18, n16, n18);
                                } else {
                                    jButton.setBounds(n15, n14, n16, n18);
                                    n14 += n18;
                                }
                                n7 -= n18;
                                n3 = 1;
                            }
                        }
                    }
                    FlatTabbedPaneUI.this.tabViewport.setBounds(n15, n14, n16, n7);
                }
            }
            Component component = FlatTabbedPaneUI.this.tabViewport.getView();
            if (component instanceof Container && ((Container)component).getComponentCount() > 0) {
                for (Component component2 : ((Container)component).getComponents()) {
                    if (!this.isTabContainer(component2)) continue;
                    this.layoutTabComponents(component2);
                    break;
                }
            }
            FlatTabbedPaneUI.this.tabViewport.setVisible(FlatTabbedPaneUI.this.rects.length > 0);
            FlatTabbedPaneUI.this.moreTabsButton.setVisible(bl3);
            jButton.setVisible(n3 != 0);
            jButton2.setVisible(bl4);
            FlatTabbedPaneUI.this.scrollBackwardButtonPrefSize = jButton.getPreferredSize();
        }

        @Override
        protected void layoutChildComponent(Component component, Rectangle rectangle) {
            if (component == FlatTabbedPaneUI.this.tabViewport || component instanceof FlatTabAreaButton || component == FlatTabbedPaneUI.this.leadingComponent || component == FlatTabbedPaneUI.this.trailingComponent) {
                return;
            }
            component.setBounds(rectangle);
        }
    }

    protected class FlatTabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        protected FlatTabbedPaneLayout() {
            super(FlatTabbedPaneUI.this);
        }

        @Override
        protected Dimension calculateSize(boolean bl) {
            if (this.isContentEmpty()) {
                return this.calculateTabAreaSize();
            }
            return super.calculateSize(bl);
        }

        protected boolean isContentEmpty() {
            int n = FlatTabbedPaneUI.this.tabPane.getTabCount();
            if (n == 0) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                Serializable serializable = FlatTabbedPaneUI.this.tabPane.getComponentAt(i);
                if (serializable == null) continue;
                serializable = serializable.getPreferredSize();
                if (((Dimension)serializable).width == 0 && ((Dimension)serializable).height == 0) continue;
                return false;
            }
            return true;
        }

        protected Dimension calculateTabAreaSize() {
            int n = FlatTabbedPaneUI.this.tabPane.getTabPlacement();
            boolean bl = FlatTabbedPaneUI.this.isHorizontalTabPlacement(n);
            FontMetrics fontMetrics = FlatTabbedPaneUI.this.getFontMetrics();
            int n2 = fontMetrics.getHeight();
            int n3 = 0;
            int n4 = 0;
            int n5 = FlatTabbedPaneUI.this.tabPane.getTabCount();
            for (int i = 0; i < n5; ++i) {
                if (bl) {
                    n3 += FlatTabbedPaneUI.this.calculateTabWidth(n, i, fontMetrics);
                    n4 = Math.max(n4, FlatTabbedPaneUI.this.calculateTabHeight(n, i, n2));
                    continue;
                }
                n3 = Math.max(n3, FlatTabbedPaneUI.this.calculateTabWidth(n, i, fontMetrics));
                n4 += FlatTabbedPaneUI.this.calculateTabHeight(n, i, n2);
            }
            if (bl) {
                n4 += UIScale.scale(FlatTabbedPaneUI.this.contentSeparatorHeight);
            } else {
                n3 += UIScale.scale(FlatTabbedPaneUI.this.contentSeparatorHeight);
            }
            Insets insets = FlatTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = FlatTabbedPaneUI.this.getTabAreaInsets(n);
            return new Dimension(n3 + insets.left + insets.right + insets2.left + insets2.right, n4 + insets.bottom + insets.top + insets2.top + insets2.bottom);
        }

        @Override
        public void layoutContainer(Container container) {
            Object object;
            FlatTabbedPaneUI.this.setRolloverTab(-1);
            this.calculateLayoutInfo();
            boolean bl = false;
            int n = FlatTabbedPaneUI.this.tabPane.getSelectedIndex();
            if (n >= 0) {
                object = FlatTabbedPaneUI.this.getVisibleComponent();
                Component component = FlatTabbedPaneUI.this.tabPane.getComponentAt(n);
                if (component != null && component != object) {
                    bl = SwingUtilities.findFocusOwner((Component)object) != null;
                    FlatTabbedPaneUI.this.setVisibleComponent(component);
                }
            } else {
                FlatTabbedPaneUI.this.setVisibleComponent(null);
            }
            this.layoutContainerImpl();
            if (bl && (object = FlatTabbedPaneUI.this.tabPane.getActionMap().get("requestFocusForVisibleComponent")) != null) {
                object.actionPerformed(new ActionEvent(FlatTabbedPaneUI.this.tabPane, 1001, null));
            }
        }

        protected void layoutContainerImpl() {
            int n = FlatTabbedPaneUI.this.tabPane.getTabPlacement();
            int n2 = FlatTabbedPaneUI.this.getTabAreaAlignment();
            Insets insets = FlatTabbedPaneUI.this.getRealTabAreaInsets(n);
            boolean bl = FlatTabbedPaneUI.this.isLeftToRight();
            Rectangle rectangle = this.getTabAreaLayoutBounds(n, insets);
            if (n == 1 || n == 3) {
                if (!bl) {
                    FlatTabbedPaneUI.this.shiftTabs(((FlatTabbedPaneUI)FlatTabbedPaneUI.this).tabPane.getInsets().left + insets.right + FlatTabbedPaneUI.this.getTrailingPreferredWidth(), 0);
                }
                this.layoutLeftAndRightComponents(rectangle, n2, insets, FlatTabbedPaneUI.this.runCount == 1, true, bl);
            } else {
                this.layoutTopAndBottomComponents(rectangle, n2, insets, FlatTabbedPaneUI.this.runCount == 1, true);
            }
            this.layoutChildComponents();
        }

        protected void layoutChildComponents() {
            if (FlatTabbedPaneUI.this.tabPane.getComponentCount() == 0) {
                return;
            }
            FlatTabbedPaneLayout flatTabbedPaneLayout = this;
            Rectangle rectangle = flatTabbedPaneLayout.getContentAreaLayoutBounds(flatTabbedPaneLayout.FlatTabbedPaneUI.this.tabPane.getTabPlacement(), FlatTabbedPaneUI.this.tabAreaInsets);
            for (Component component : FlatTabbedPaneUI.this.tabPane.getComponents()) {
                this.layoutChildComponent(component, rectangle);
            }
        }

        protected void layoutChildComponent(Component component, Rectangle rectangle) {
            if (component == FlatTabbedPaneUI.this.leadingComponent || component == FlatTabbedPaneUI.this.trailingComponent) {
                return;
            }
            if (this.isTabContainer(component)) {
                this.layoutTabContainer(component);
                return;
            }
            component.setBounds(rectangle);
        }

        boolean isTabContainer(Component component) {
            return component.getClass().getName().equals("javax.swing.plaf.basic.BasicTabbedPaneUI$TabContainer");
        }

        private void layoutTabContainer(Component component) {
            int n;
            int n2;
            int n3;
            int n4 = FlatTabbedPaneUI.this.tabPane.getTabPlacement();
            Rectangle rectangle = FlatTabbedPaneUI.this.tabPane.getBounds();
            Insets insets = FlatTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = FlatTabbedPaneUI.this.getContentBorderInsets(n4);
            int n5 = FlatTabbedPaneUI.this.isHorizontalTabPlacement(n4);
            if (n5 == 0) {
                FlatTabbedPaneUI flatTabbedPaneUI = FlatTabbedPaneUI.this;
                n3 = flatTabbedPaneUI.calculateTabAreaWidth(n4, flatTabbedPaneUI.runCount, FlatTabbedPaneUI.this.maxTabWidth);
            } else {
                n3 = n2 = 0;
            }
            if (n5 != 0) {
                FlatTabbedPaneUI flatTabbedPaneUI = FlatTabbedPaneUI.this;
                n = flatTabbedPaneUI.calculateTabAreaHeight(n4, flatTabbedPaneUI.runCount, FlatTabbedPaneUI.this.maxTabHeight);
            } else {
                n = 0;
            }
            n5 = n;
            n2 = n2 != 0 ? n2 + insets.left + insets.right + insets2.left + insets2.right : rectangle.width;
            int n6 = n5 != 0 ? n5 + insets.top + insets.bottom + insets2.top + insets2.bottom : rectangle.height;
            int n7 = n4 == 4 ? rectangle.width - n2 : 0;
            n4 = n4 == 3 ? rectangle.height - n6 : 0;
            component.setBounds(n7, n4, n2, n6);
            this.layoutTabComponents(component);
        }

        void layoutTabComponents(Component component) {
            if (component instanceof Container && ((Container)component).getComponentCount() == 0) {
                return;
            }
            int n = FlatTabbedPaneUI.this.tabPane.getTabPlacement();
            int n2 = FlatTabbedPaneUI.this.tabPane.getSelectedIndex();
            Rectangle rectangle = new Rectangle();
            int n3 = -component.getX();
            int n4 = -component.getY();
            if (FlatTabbedPaneUI.this.isScrollTabLayout()) {
                Point point = FlatTabbedPaneUI.this.tabViewport.getViewPosition();
                n3 = n3 - FlatTabbedPaneUI.this.tabViewport.getX() + point.x;
                n4 = n4 - FlatTabbedPaneUI.this.tabViewport.getY() + point.y;
            }
            int n5 = FlatTabbedPaneUI.this.tabPane.getTabCount();
            for (int i = 0; i < n5; ++i) {
                Component component2 = FlatTabbedPaneUI.this.tabPane.getTabComponentAt(i);
                if (component2 == null) continue;
                Rectangle rectangle2 = FlatTabbedPaneUI.this.getTabBounds(i, rectangle);
                Cloneable cloneable = FlatTabbedPaneUI.this.getTabInsets(n, i);
                int n6 = rectangle2.x + cloneable.left + n3;
                int n7 = rectangle2.y + cloneable.top + n4;
                int n8 = rectangle2.width - cloneable.left - cloneable.right;
                int n9 = rectangle2.height - cloneable.top - cloneable.bottom;
                cloneable = component2.getPreferredSize();
                n6 += (n8 - ((Dimension)cloneable).width) / 2;
                n9 = n7 + (n9 - ((Dimension)cloneable).height) / 2;
                n7 = i == n2 ? 1 : 0;
                component2.setBounds(n6 += FlatTabbedPaneUI.this.getTabLabelShiftX(n, i, n7 != 0), n9 += FlatTabbedPaneUI.this.getTabLabelShiftY(n, i, n7 != 0), ((Dimension)cloneable).width, ((Dimension)cloneable).height);
            }
        }

        Rectangle getContentAreaLayoutBounds(int n, Insets insets) {
            int n2;
            int n3;
            int n4;
            int n5 = FlatTabbedPaneUI.this.tabPane.getWidth();
            int n6 = FlatTabbedPaneUI.this.tabPane.getHeight();
            Insets insets2 = FlatTabbedPaneUI.this.tabPane.getInsets();
            Insets insets3 = FlatTabbedPaneUI.this.getContentBorderInsets(n);
            int n7 = FlatTabbedPaneUI.this.isHorizontalTabPlacement(n);
            if (n7 == 0) {
                FlatTabbedPaneUI flatTabbedPaneUI = FlatTabbedPaneUI.this;
                n4 = flatTabbedPaneUI.calculateTabAreaWidth(n, flatTabbedPaneUI.runCount, FlatTabbedPaneUI.this.maxTabWidth);
            } else {
                n4 = n3 = 0;
            }
            if (n7 != 0) {
                FlatTabbedPaneUI flatTabbedPaneUI = FlatTabbedPaneUI.this;
                n2 = flatTabbedPaneUI.calculateTabAreaHeight(n, flatTabbedPaneUI.runCount, FlatTabbedPaneUI.this.maxTabHeight);
            } else {
                n2 = 0;
            }
            n7 = n2;
            Rectangle rectangle = new Rectangle();
            new Rectangle().x = insets2.left + insets3.left;
            rectangle.y = insets2.top + insets3.top;
            rectangle.width = n5 - insets2.left - insets2.right - insets3.left - insets3.right - n3;
            rectangle.height = n6 - insets2.top - insets2.bottom - insets3.top - insets3.bottom - n7;
            if (n == 1) {
                rectangle.y += n7;
            } else if (n == 2) {
                rectangle.x += n3;
            }
            return rectangle;
        }

        Rectangle getTabAreaLayoutBounds(int n, Insets insets) {
            int n2 = FlatTabbedPaneUI.this.tabPane.getWidth();
            int n3 = FlatTabbedPaneUI.this.tabPane.getHeight();
            Insets insets2 = FlatTabbedPaneUI.this.tabPane.getInsets();
            Rectangle rectangle = new Rectangle();
            if (n == 1 || n == 3) {
                int n4 = FlatTabbedPaneUI.this.maxTabHeight > 0 ? FlatTabbedPaneUI.this.maxTabHeight : Math.max(Math.max(FlatTabbedPaneUI.this.getLeadingPreferredHeight(), FlatTabbedPaneUI.this.getTrailingPreferredHeight()), UIScale.scale(FlatClientProperties.clientPropertyInt(FlatTabbedPaneUI.this.tabPane, "JTabbedPane.tabHeight", FlatTabbedPaneUI.this.tabHeight)));
                rectangle.x = insets2.left;
                rectangle.y = n == 1 ? insets2.top + insets.top : n3 - insets2.bottom - insets.bottom - n4;
                rectangle.width = n2 - insets2.left - insets2.right;
                rectangle.height = n4;
            } else {
                int n5 = FlatTabbedPaneUI.this.maxTabWidth > 0 ? FlatTabbedPaneUI.this.maxTabWidth : Math.max(FlatTabbedPaneUI.this.getLeadingPreferredWidth(), FlatTabbedPaneUI.this.getTrailingPreferredWidth());
                rectangle.x = n == 2 ? insets2.left + insets.left : n2 - insets2.right - insets.right - n5;
                rectangle.y = insets2.top;
                rectangle.width = n5;
                rectangle.height = n3 - insets2.top - insets2.bottom;
            }
            return rectangle;
        }

        /*
         * WARNING - void declaration
         */
        Rectangle layoutLeftAndRightComponents(Rectangle rectangle, int n, Insets insets, boolean bl, boolean bl2, boolean bl3) {
            int n2;
            void var6_10;
            int n3 = FlatTabbedPaneUI.this.getLeadingPreferredWidth();
            int n4 = FlatTabbedPaneUI.this.getTrailingPreferredWidth();
            if (bl && FlatTabbedPaneUI.this.rects.length > 0) {
                int n42 = rectangle.width - n3 - n4 - insets.left - insets.right;
                int n5 = FlatTabbedPaneUI.this.rectsTotalWidth((boolean)var6_10);
                n42 -= n5;
                switch (n) {
                    case 10: {
                        n4 += n42;
                        break;
                    }
                    case 11: {
                        void var5_9;
                        if (var5_9 != false) {
                            FlatTabbedPaneUI.this.shiftTabs(var6_10 != false ? n42 : -n42, 0);
                        }
                        n3 += n42;
                        break;
                    }
                    case 0: {
                        void var5_9;
                        if (var5_9 != false) {
                            FlatTabbedPaneUI.this.shiftTabs((var6_10 != false ? n42 : -n42) / 2, 0);
                        }
                        n3 += n42 / 2;
                        int n6 = n42;
                        n4 += n6 - n6 / 2;
                        break;
                    }
                    case 100: {
                        FlatTabbedPaneUI.this.stretchTabsWidth(n42, (boolean)var6_10);
                    }
                }
            } else if (FlatTabbedPaneUI.this.rects.length == 0) {
                n4 = rectangle.width - n3;
            }
            Container container = var6_10 != false ? FlatTabbedPaneUI.this.leadingComponent : FlatTabbedPaneUI.this.trailingComponent;
            int n7 = n2 = var6_10 != false ? n3 : n4;
            if (container != null) {
                container.setBounds(rectangle.x, rectangle.y, n2, rectangle.height);
            }
            container = var6_10 != false ? FlatTabbedPaneUI.this.trailingComponent : FlatTabbedPaneUI.this.leadingComponent;
            int n8 = n = var6_10 != false ? n4 : n3;
            if (container != null) {
                container.setBounds(rectangle.x + rectangle.width - n, rectangle.y, n, rectangle.height);
            }
            rectangle = new Rectangle(rectangle);
            rectangle.x += n2;
            rectangle.width -= n2 + n;
            return rectangle;
        }

        /*
         * WARNING - void declaration
         */
        Rectangle layoutTopAndBottomComponents(Rectangle rectangle, int n, Insets insets, boolean bl, boolean bl2) {
            int n2 = FlatTabbedPaneUI.this.getLeadingPreferredHeight();
            int n3 = FlatTabbedPaneUI.this.getTrailingPreferredHeight();
            if (bl && FlatTabbedPaneUI.this.rects.length > 0) {
                int n4 = rectangle.height - n2 - n3 - insets.top - insets.bottom;
                int n5 = FlatTabbedPaneUI.this.rectsTotalHeight();
                n4 -= n5;
                switch (n) {
                    case 10: {
                        n3 += n4;
                        break;
                    }
                    case 11: {
                        void var5_8;
                        if (var5_8 != false) {
                            FlatTabbedPaneUI.this.shiftTabs(0, n4);
                        }
                        n2 += n4;
                        break;
                    }
                    case 0: {
                        void var5_8;
                        if (var5_8 != false) {
                            FlatTabbedPaneUI.this.shiftTabs(0, n4 / 2);
                        }
                        n2 += n4 / 2;
                        int n6 = n4;
                        n3 += n6 - n6 / 2;
                        break;
                    }
                    case 100: {
                        FlatTabbedPaneUI.this.stretchTabsHeight(n4);
                    }
                }
            } else if (FlatTabbedPaneUI.this.rects.length == 0) {
                n3 = rectangle.height - n2;
            }
            if (FlatTabbedPaneUI.this.leadingComponent != null) {
                FlatTabbedPaneUI.this.leadingComponent.setBounds(rectangle.x, rectangle.y, rectangle.width, n2);
            }
            if (FlatTabbedPaneUI.this.trailingComponent != null) {
                FlatTabbedPaneUI.this.trailingComponent.setBounds(rectangle.x, rectangle.y + rectangle.height - n3, rectangle.width, n3);
            }
            Rectangle rectangle2 = new Rectangle(rectangle);
            rectangle2.y += n2;
            rectangle2.height -= n2 + n3;
            return rectangle2;
        }
    }

    private class Handler
    implements ComponentListener,
    ContainerListener,
    FocusListener,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener,
    ChangeListener {
        MouseListener mouseDelegate;
        PropertyChangeListener propertyChangeDelegate;
        ChangeListener changeDelegate;
        FocusListener focusDelegate;
        private final PropertyChangeListener contentListener = this::contentPropertyChange;
        private int pressedTabIndex = -1;
        private int lastTipTabIndex = -1;
        private String lastTip;

        private Handler() {
        }

        void installListeners() {
            FlatTabbedPaneUI.this.tabPane.addMouseMotionListener(this);
            FlatTabbedPaneUI.this.tabPane.addComponentListener(this);
            FlatTabbedPaneUI.this.tabPane.addContainerListener(this);
            for (Component component : FlatTabbedPaneUI.this.tabPane.getComponents()) {
                if (component instanceof UIResource) continue;
                component.addPropertyChangeListener(this.contentListener);
            }
        }

        void uninstallListeners() {
            FlatTabbedPaneUI.this.tabPane.removeMouseMotionListener(this);
            FlatTabbedPaneUI.this.tabPane.removeComponentListener(this);
            FlatTabbedPaneUI.this.tabPane.removeContainerListener(this);
            for (Component component : FlatTabbedPaneUI.this.tabPane.getComponents()) {
                if (component instanceof UIResource) continue;
                component.removePropertyChangeListener(this.contentListener);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.mouseDelegate.mouseClicked(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.updateRollover(mouseEvent);
            if (!FlatTabbedPaneUI.this.isPressedTabClose() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.mouseDelegate.mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (FlatTabbedPaneUI.this.isPressedTabClose()) {
                this.updateRollover(mouseEvent);
                if (this.pressedTabIndex >= 0 && this.pressedTabIndex == FlatTabbedPaneUI.this.getRolloverTab()) {
                    this.restoreTabToolTip();
                    FlatTabbedPaneUI.this.closeTab(this.pressedTabIndex);
                }
            } else {
                this.mouseDelegate.mouseReleased(mouseEvent);
            }
            this.pressedTabIndex = -1;
            this.updateRollover(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.updateRollover(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.updateRollover(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.updateRollover(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.updateRollover(mouseEvent);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void updateRollover(MouseEvent object) {
            boolean bl;
            int n = ((MouseEvent)object).getX();
            int n2 = ((MouseEvent)object).getY();
            int n3 = FlatTabbedPaneUI.this.tabForCoordinate(FlatTabbedPaneUI.this.tabPane, n, n2);
            FlatTabbedPaneUI.this.setRolloverTab(n3);
            boolean bl2 = bl = FlatTabbedPaneUI.this.isTabClosable(n3) && FlatTabbedPaneUI.this.getTabCloseHitArea(n3).contains(n, n2);
            if (((AWTEvent)object).getID() == 501 && SwingUtilities.isLeftMouseButton((MouseEvent)object)) {
                this.pressedTabIndex = bl ? n3 : -1;
            }
            FlatTabbedPaneUI.this.setRolloverTabClose(bl);
            FlatTabbedPaneUI.this.setPressedTabClose(bl && n3 == this.pressedTabIndex);
            if (n3 >= 0 && bl) {
                object = FlatTabbedPaneUI.this.getTabClientProperty(n3, "JTabbedPane.tabCloseToolTipText");
                if (object == null) {
                    object = FlatTabbedPaneUI.this.tabCloseToolTipText;
                }
                if (object instanceof String) {
                    this.setCloseToolTip(n3, (String)object);
                    return;
                }
                this.restoreTabToolTip();
                return;
            }
            this.restoreTabToolTip();
        }

        private void setCloseToolTip(int n, String string) {
            if (n == this.lastTipTabIndex) {
                return;
            }
            this.restoreTabToolTip();
            this.lastTipTabIndex = n;
            this.lastTip = FlatTabbedPaneUI.this.tabPane.getToolTipTextAt(this.lastTipTabIndex);
            FlatTabbedPaneUI.this.tabPane.setToolTipTextAt(this.lastTipTabIndex, string);
        }

        private void restoreTabToolTip() {
            if (this.lastTipTabIndex < 0) {
                return;
            }
            if (this.lastTipTabIndex < FlatTabbedPaneUI.this.tabPane.getTabCount()) {
                FlatTabbedPaneUI.this.tabPane.setToolTipTextAt(this.lastTipTabIndex, this.lastTip);
            }
            this.lastTip = null;
            this.lastTipTabIndex = -1;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            switch (propertyChangeEvent.getPropertyName()) {
                case "tabPlacement": 
                case "opaque": 
                case "background": 
                case "indexForTabComponent": {
                    FlatTabbedPaneUI.this.runWithOriginalLayoutManager(() -> this.propertyChangeDelegate.propertyChange(propertyChangeEvent));
                    break;
                }
                default: {
                    this.propertyChangeDelegate.propertyChange(propertyChangeEvent);
                }
            }
            switch (propertyChangeEvent.getPropertyName()) {
                case "tabPlacement": {
                    if (!(FlatTabbedPaneUI.this.moreTabsButton instanceof FlatMoreTabsButton)) break;
                    ((FlatMoreTabsButton)FlatTabbedPaneUI.this.moreTabsButton).updateDirection();
                    return;
                }
                case "componentOrientation": {
                    FlatTabbedPaneUI.this.ensureSelectedTabIsVisibleLater();
                    return;
                }
                case "JTabbedPane.showTabSeparators": 
                case "JTabbedPane.tabType": {
                    FlatTabbedPaneUI.this.tabPane.repaint();
                    return;
                }
                case "JTabbedPane.showContentSeparator": 
                case "JTabbedPane.hasFullBorder": 
                case "JTabbedPane.hideTabAreaWithOneTab": 
                case "JTabbedPane.minimumTabWidth": 
                case "JTabbedPane.maximumTabWidth": 
                case "JTabbedPane.tabHeight": 
                case "JTabbedPane.tabInsets": 
                case "JTabbedPane.tabAreaInsets": 
                case "JTabbedPane.tabsPopupPolicy": 
                case "JTabbedPane.scrollButtonsPolicy": 
                case "JTabbedPane.scrollButtonsPlacement": 
                case "JTabbedPane.tabAreaAlignment": 
                case "JTabbedPane.tabAlignment": 
                case "JTabbedPane.tabWidthMode": 
                case "JTabbedPane.tabRotation": 
                case "JTabbedPane.tabIconPlacement": 
                case "JTabbedPane.tabClosable": {
                    FlatTabbedPaneUI.this.tabPane.revalidate();
                    FlatTabbedPaneUI.this.tabPane.repaint();
                    return;
                }
                case "JTabbedPane.leadingComponent": {
                    FlatTabbedPaneUI.this.uninstallLeadingComponent();
                    FlatTabbedPaneUI.this.installLeadingComponent();
                    FlatTabbedPaneUI.this.tabPane.revalidate();
                    FlatTabbedPaneUI.this.tabPane.repaint();
                    FlatTabbedPaneUI.this.ensureSelectedTabIsVisibleLater();
                    return;
                }
                case "JTabbedPane.trailingComponent": {
                    FlatTabbedPaneUI.this.uninstallTrailingComponent();
                    FlatTabbedPaneUI.this.installTrailingComponent();
                    FlatTabbedPaneUI.this.tabPane.revalidate();
                    FlatTabbedPaneUI.this.tabPane.repaint();
                    FlatTabbedPaneUI.this.ensureSelectedTabIsVisibleLater();
                    return;
                }
                case "FlatLaf.style": 
                case "FlatLaf.styleClass": {
                    FlatTabbedPaneUI.this.installStyle();
                    FlatTabbedPaneUI.this.tabPane.revalidate();
                    FlatTabbedPaneUI.this.tabPane.repaint();
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.changeDelegate.stateChanged(changeEvent);
            if (FlatTabbedPaneUI.this.moreTabsButton != null) {
                FlatTabbedPaneUI.this.ensureSelectedTabIsVisible();
            }
        }

        protected void contentPropertyChange(PropertyChangeEvent object) {
            switch (((PropertyChangeEvent)object).getPropertyName()) {
                case "JTabbedPane.minimumTabWidth": 
                case "JTabbedPane.maximumTabWidth": 
                case "JTabbedPane.tabInsets": 
                case "JTabbedPane.tabAlignment": 
                case "JTabbedPane.tabClosable": {
                    FlatTabbedPaneUI.this.tabPane.revalidate();
                    FlatTabbedPaneUI.this.tabPane.repaint();
                }
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            FlatTabbedPaneUI.this.ensureSelectedTabIsVisibleLater();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void componentAdded(ContainerEvent serializable) {
            if (!((serializable = ((ContainerEvent)serializable).getChild()) instanceof UIResource)) {
                ((Component)serializable).addPropertyChangeListener(this.contentListener);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent serializable) {
            if (!((serializable = ((ContainerEvent)serializable).getChild()) instanceof UIResource)) {
                ((Component)serializable).removePropertyChangeListener(this.contentListener);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.focusDelegate.focusGained(focusEvent);
            FlatTabbedPaneUI.this.repaintTab(FlatTabbedPaneUI.this.tabPane.getSelectedIndex());
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.focusDelegate.focusLost(focusEvent);
            FlatTabbedPaneUI.this.repaintTab(FlatTabbedPaneUI.this.tabPane.getSelectedIndex());
        }
    }

    protected class FlatWheelTabScroller
    extends MouseAdapter {
        private int lastMouseX;
        private int lastMouseY;
        private boolean inViewport;
        private boolean scrolled;
        private Timer rolloverTimer;
        private Timer exitedTimer;
        private Animator animator;
        private Point startViewPosition;
        private Point targetViewPosition;

        protected FlatWheelTabScroller() {
        }

        protected void uninstall() {
            if (this.rolloverTimer != null) {
                this.rolloverTimer.stop();
            }
            if (this.exitedTimer != null) {
                this.exitedTimer.stop();
            }
            if (this.animator != null) {
                this.animator.cancel();
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (FlatTabbedPaneUI.this.tabPane.getMouseWheelListeners().length > 1) {
                return;
            }
            if (!this.isInViewport(mouseWheelEvent.getX(), mouseWheelEvent.getY())) {
                return;
            }
            this.lastMouseX = mouseWheelEvent.getX();
            this.lastMouseY = mouseWheelEvent.getY();
            double d = mouseWheelEvent.getPreciseWheelRotation();
            boolean bl = d != 0.0 && d != (double)mouseWheelEvent.getWheelRotation();
            int n = (int)((double)FlatTabbedPaneUI.this.maxTabHeight * d);
            if (n == 0) {
                if (d > 0.0) {
                    n = 1;
                } else if (d < 0.0) {
                    n = -1;
                }
            }
            Point point = this.targetViewPosition != null ? this.targetViewPosition : FlatTabbedPaneUI.this.tabViewport.getViewPosition();
            Cloneable cloneable = FlatTabbedPaneUI.this.tabViewport.getViewSize();
            boolean bl2 = FlatTabbedPaneUI.this.isHorizontalTabPlacement(FlatTabbedPaneUI.this.tabPane.getTabPlacement());
            int n2 = point.x;
            int n3 = point.y;
            if (bl2) {
                n2 += FlatTabbedPaneUI.this.isLeftToRight() ? n : -n;
            } else {
                n3 += n;
            }
            if (bl && FlatTabbedPaneUI.this.getScrollButtonsPlacement() == 100 && FlatTabbedPaneUI.this.getScrollButtonsPolicy() == 3 && (FlatTabbedPaneUI.this.isLeftToRight() || !bl2) && FlatTabbedPaneUI.this.scrollBackwardButtonPrefSize != null) {
                if (bl2) {
                    if (point.x == 0 && n2 > 0) {
                        n2 += ((FlatTabbedPaneUI)FlatTabbedPaneUI.this).scrollBackwardButtonPrefSize.width;
                    } else if (n < 0 && n2 <= ((FlatTabbedPaneUI)FlatTabbedPaneUI.this).scrollBackwardButtonPrefSize.width) {
                        n2 = 0;
                    }
                } else if (point.y == 0 && n3 > 0) {
                    n3 += ((FlatTabbedPaneUI)FlatTabbedPaneUI.this).scrollBackwardButtonPrefSize.height;
                } else if (n < 0 && n3 <= ((FlatTabbedPaneUI)FlatTabbedPaneUI.this).scrollBackwardButtonPrefSize.height) {
                    n3 = 0;
                }
            }
            if (bl2) {
                n2 = Math.min(Math.max(n2, 0), cloneable.width - FlatTabbedPaneUI.this.tabViewport.getWidth());
            } else {
                n3 = Math.min(Math.max(n3, 0), cloneable.height - FlatTabbedPaneUI.this.tabViewport.getHeight());
            }
            cloneable = new Point(n2, n3);
            if (((Point)cloneable).equals(point)) {
                return;
            }
            if (bl) {
                if (this.animator != null) {
                    this.animator.stop();
                }
                FlatTabbedPaneUI.this.tabViewport.setViewPosition((Point)cloneable);
                this.updateRolloverDelayed();
            } else {
                this.setViewPositionAnimated((Point)cloneable);
            }
            this.scrolled = true;
        }

        protected void setViewPositionAnimated(Point point) {
            if (point.equals(FlatTabbedPaneUI.this.tabViewport.getViewPosition())) {
                return;
            }
            if (!FlatTabbedPaneUI.this.isSmoothScrollingEnabled()) {
                FlatTabbedPaneUI.this.tabViewport.setViewPosition(point);
                this.updateRolloverDelayed();
                return;
            }
            this.startViewPosition = FlatTabbedPaneUI.this.tabViewport.getViewPosition();
            this.targetViewPosition = point;
            if (this.animator == null) {
                this.animator = new Animator(200, f -> {
                    if (FlatTabbedPaneUI.this.tabViewport == null || !FlatTabbedPaneUI.this.tabViewport.isShowing()) {
                        this.animator.stop();
                        return;
                    }
                    int n = this.startViewPosition.x + Math.round((float)(this.targetViewPosition.x - this.startViewPosition.x) * f);
                    int n2 = this.startViewPosition.y + Math.round((float)(this.targetViewPosition.y - this.startViewPosition.y) * f);
                    FlatTabbedPaneUI.this.tabViewport.setViewPosition(new Point(n, n2));
                }, () -> {
                    FlatWheelTabScroller flatWheelTabScroller = this;
                    flatWheelTabScroller.targetViewPosition = null;
                    flatWheelTabScroller.startViewPosition = null;
                    if (FlatTabbedPaneUI.this.tabPane != null) {
                        FlatTabbedPaneUI.this.setRolloverTab(this.lastMouseX, this.lastMouseY);
                    }
                });
                this.animator.setResolution(10);
                this.animator.setInterpolator(new CubicBezierEasing(0.5f, 0.5f, 0.5f, 1.0f));
            }
            this.animator.restart();
        }

        protected void updateRolloverDelayed() {
            int n;
            FlatTabbedPaneUI.this.blockRollover = true;
            int n2 = FlatTabbedPaneUI.this.getRolloverTab();
            if (n2 >= 0 && (n = FlatTabbedPaneUI.this.tabForCoordinate(FlatTabbedPaneUI.this.tabPane, this.lastMouseX, this.lastMouseY)) >= 0 && n != n2) {
                FlatTabbedPaneUI.this.blockRollover = false;
                FlatTabbedPaneUI.this.setRolloverTab(-1);
                FlatTabbedPaneUI.this.blockRollover = true;
            }
            if (this.rolloverTimer == null) {
                this.rolloverTimer = new Timer(150, actionEvent -> {
                    FlatTabbedPaneUI.this.blockRollover = false;
                    if (FlatTabbedPaneUI.this.tabPane != null) {
                        FlatTabbedPaneUI.this.setRolloverTab(this.lastMouseX, this.lastMouseY);
                    }
                });
                this.rolloverTimer.setRepeats(false);
            }
            this.rolloverTimer.restart();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.checkViewportExited(mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.checkViewportExited(mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            FlatTabbedPaneUI.this.setRolloverTab(mouseEvent.getX(), mouseEvent.getY());
        }

        protected boolean isInViewport(int n, int n2) {
            return FlatTabbedPaneUI.this.tabViewport != null && FlatTabbedPaneUI.this.tabViewport.getBounds().contains(n, n2);
        }

        protected void checkViewportExited(int n, int n2) {
            this.lastMouseX = n;
            this.lastMouseY = n2;
            boolean bl = this.inViewport;
            this.inViewport = this.isInViewport(n, n2);
            if (this.inViewport != bl) {
                if (!this.inViewport) {
                    this.viewportExited();
                    return;
                }
                if (this.exitedTimer != null) {
                    this.exitedTimer.stop();
                }
            }
        }

        protected void viewportExited() {
            if (!this.scrolled) {
                return;
            }
            if (this.exitedTimer == null) {
                this.exitedTimer = new Timer(500, actionEvent -> this.ensureSelectedTabVisible());
                this.exitedTimer.setRepeats(false);
            }
            this.exitedTimer.start();
        }

        protected void ensureSelectedTabVisible() {
            if (FlatTabbedPaneUI.this.tabPane == null || FlatTabbedPaneUI.this.tabViewport == null) {
                return;
            }
            if (!this.scrolled) {
                return;
            }
            this.scrolled = false;
            FlatTabbedPaneUI.this.ensureSelectedTabIsVisible();
        }
    }

    protected class FlatScrollableTabButton
    extends FlatTabAreaButton
    implements MouseListener {
        private Timer autoRepeatTimer;

        protected FlatScrollableTabButton(int n) {
            super(n);
            FlatScrollableTabButton flatScrollableTabButton = this;
            flatScrollableTabButton.addMouseListener(flatScrollableTabButton);
        }

        @Override
        protected void fireActionPerformed(ActionEvent actionEvent) {
            FlatTabbedPaneUI.this.runWithOriginalLayoutManager(() -> super.fireActionPerformed(actionEvent));
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.isEnabled()) {
                if (this.autoRepeatTimer == null) {
                    this.autoRepeatTimer = new Timer(60, actionEvent -> {
                        if (this.isEnabled()) {
                            this.doClick();
                        }
                    });
                    this.autoRepeatTimer.setInitialDelay(300);
                }
                this.autoRepeatTimer.start();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.autoRepeatTimer != null) {
                this.autoRepeatTimer.stop();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (this.autoRepeatTimer != null && this.isPressed()) {
                this.autoRepeatTimer.start();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (this.autoRepeatTimer != null) {
                this.autoRepeatTimer.stop();
            }
        }
    }

    protected class FlatMoreTabsButton
    extends FlatTabAreaButton
    implements ActionListener,
    PopupMenuListener {
        private boolean popupVisible;

        public FlatMoreTabsButton() {
            super(5);
            this.updateDirection();
            this.setToolTipText(FlatTabbedPaneUI.this.moreTabsButtonToolTipText);
            FlatMoreTabsButton flatMoreTabsButton = this;
            flatMoreTabsButton.addActionListener(flatMoreTabsButton);
        }

        protected void updateDirection() {
            int n;
            switch (FlatTabbedPaneUI.this.tabPane.getTabPlacement()) {
                default: {
                    n = 5;
                    break;
                }
                case 3: {
                    n = 1;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 4: {
                    n = 7;
                }
            }
            this.setDirection(n);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            boolean bl = this.direction == 5 || this.direction == 1;
            int n = UIScale.scale(8);
            return new Dimension(dimension.width + (bl ? n : 0), dimension.height + (bl ? 0 : n));
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.direction == 3 || this.direction == 7) {
                int n = Math.max(UIScale.unscale((this.getWidth() - this.getHeight()) / 2) - 4, 0);
                FlatMoreTabsButton flatMoreTabsButton = this;
                flatMoreTabsButton.setXOffset(flatMoreTabsButton.direction == 3 ? (float)n : (float)(-n));
            } else {
                this.setXOffset(0.0f);
            }
            super.paint(graphics);
        }

        @Override
        protected boolean isHover() {
            return super.isHover() || this.popupVisible;
        }

        @Override
        public void actionPerformed(ActionEvent serializable) {
            int n;
            if (FlatTabbedPaneUI.this.tabViewport == null) {
                return;
            }
            serializable = new JPopupMenu();
            ((JPopupMenu)serializable).addPopupMenuListener(this);
            Rectangle rectangle = FlatTabbedPaneUI.this.tabViewport.getViewRect();
            int n2 = -1;
            for (n = 0; n < FlatTabbedPaneUI.this.rects.length; ++n) {
                if (rectangle.contains(FlatTabbedPaneUI.this.rects[n])) continue;
                if (n2 >= 0 && n2 + 1 != n) {
                    ((JPopupMenu)serializable).addSeparator();
                }
                n2 = n;
                ((JPopupMenu)serializable).add(this.createTabMenuItem(n));
            }
            n = this.getWidth();
            int n3 = this.getHeight();
            Dimension dimension = ((JComponent)serializable).getPreferredSize();
            int n4 = FlatTabbedPaneUI.this.isLeftToRight() ? n - dimension.width : 0;
            int n5 = n3 - dimension.height;
            switch (FlatTabbedPaneUI.this.tabPane.getTabPlacement()) {
                default: {
                    n5 = n3;
                    break;
                }
                case 3: {
                    n5 = -dimension.height;
                    break;
                }
                case 2: {
                    n4 = n;
                    break;
                }
                case 4: {
                    n4 = -dimension.width;
                }
            }
            ((JPopupMenu)serializable).show(this, n4, n5);
        }

        protected JMenuItem createTabMenuItem(int n) {
            Component component;
            Object object = FlatTabbedPaneUI.this.tabPane.getTitleAt(n);
            if (StringUtils.isEmpty((String)object)) {
                component = FlatTabbedPaneUI.this.tabPane.getTabComponentAt(n);
                if (component != null) {
                    object = this.findTabTitle(component);
                }
                if (StringUtils.isEmpty((String)object)) {
                    object = FlatTabbedPaneUI.this.tabPane.getAccessibleContext().getAccessibleChild(n).getAccessibleContext().getAccessibleName();
                }
                if (StringUtils.isEmpty((String)object) && component instanceof Accessible) {
                    object = this.findTabTitleInAccessible((Accessible)((Object)component));
                }
                if (StringUtils.isEmpty((String)object)) {
                    object = n + 1 + ". Tab";
                }
            }
            component = new JMenuItem((String)object, FlatTabbedPaneUI.this.tabPane.getIconAt(n));
            ((AbstractButton)component).setDisabledIcon(FlatTabbedPaneUI.this.tabPane.getDisabledIconAt(n));
            ((JComponent)component).setToolTipText(FlatTabbedPaneUI.this.tabPane.getToolTipTextAt(n));
            object = FlatTabbedPaneUI.this.tabPane.getForegroundAt(n);
            if (object != FlatTabbedPaneUI.this.tabPane.getForeground()) {
                ((JComponent)component).setForeground((Color)object);
            }
            if ((object = FlatTabbedPaneUI.this.tabPane.getBackgroundAt(n)) != FlatTabbedPaneUI.this.tabPane.getBackground()) {
                ((JComponent)component).setBackground((Color)object);
                ((JComponent)component).setOpaque(true);
            }
            if (!FlatTabbedPaneUI.this.tabPane.isEnabled() || !FlatTabbedPaneUI.this.tabPane.isEnabledAt(n)) {
                ((JMenuItem)component).setEnabled(false);
            }
            ((AbstractButton)component).addActionListener(actionEvent -> this.selectTab(n));
            return component;
        }

        /*
         * WARNING - void declaration
         */
        private String findTabTitle(Component componentArray) {
            void var2_5;
            Object object2 = null;
            if (componentArray instanceof JLabel) {
                String string = ((JLabel)componentArray).getText();
            } else if (componentArray instanceof JTextComponent) {
                String string = ((JTextComponent)componentArray).getText();
            }
            if (!StringUtils.isEmpty((String)var2_5)) {
                return var2_5;
            }
            if (componentArray instanceof Container) {
                for (Component component : ((Container)componentArray).getComponents()) {
                    String string = this.findTabTitle(component);
                    if (string == null) continue;
                    return string;
                }
            }
            return null;
        }

        private String findTabTitleInAccessible(Accessible object) {
            if ((object = object.getAccessibleContext()) == null) {
                return null;
            }
            String string = ((AccessibleContext)object).getAccessibleName();
            if (!StringUtils.isEmpty(string)) {
                return string;
            }
            int n = ((AccessibleContext)object).getAccessibleChildrenCount();
            for (int i = 0; i < n; ++i) {
                string = this.findTabTitleInAccessible(((AccessibleContext)object).getAccessibleChild(i));
                if (string == null) continue;
                return string;
            }
            return null;
        }

        protected void selectTab(int n) {
            FlatTabbedPaneUI.this.tabPane.setSelectedIndex(n);
            FlatTabbedPaneUI.this.ensureSelectedTabIsVisible();
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            this.popupVisible = true;
            this.repaint();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            this.popupVisible = false;
            this.repaint();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            this.popupVisible = false;
            this.repaint();
        }
    }

    protected class FlatTabAreaButton
    extends FlatArrowButton {
        public FlatTabAreaButton(int n) {
            super(n, FlatTabbedPaneUI.this.arrowType, FlatTabbedPaneUI.this.foreground, FlatTabbedPaneUI.this.disabledForeground, null, FlatTabbedPaneUI.this.buttonHoverBackground, null, FlatTabbedPaneUI.this.buttonPressedBackground);
            this.setArrowWidth(11);
        }

        protected void updateStyle() {
            FlatTabAreaButton flatTabAreaButton = this;
            flatTabAreaButton.updateStyle(flatTabAreaButton.FlatTabbedPaneUI.this.arrowType, FlatTabbedPaneUI.this.foreground, FlatTabbedPaneUI.this.disabledForeground, null, FlatTabbedPaneUI.this.buttonHoverBackground, null, FlatTabbedPaneUI.this.buttonPressedBackground);
        }

        @Override
        protected Color deriveBackground(Color color) {
            return FlatUIUtils.deriveColor(color, FlatTabbedPaneUI.this.tabPane.getBackground());
        }

        @Override
        protected void paintBackground(Graphics2D graphics2D) {
            Insets insets = new Insets(0, 0, 0, 0);
            FlatTabbedPaneUI.rotateInsets(FlatTabbedPaneUI.this.buttonInsets, insets, FlatTabbedPaneUI.this.tabPane.getTabPlacement());
            int n = UIScale.scale2(insets.top);
            int n2 = UIScale.scale2(insets.left);
            int n3 = UIScale.scale2(insets.bottom);
            int n4 = UIScale.scale2(insets.right);
            FlatUIUtils.paintComponentBackground(graphics2D, n2, n, this.getWidth() - n2 - n4, this.getHeight() - n - n3, 0.0f, UIScale.scale((float)FlatTabbedPaneUI.this.buttonArc));
        }
    }

    private class ContainerUIResource
    extends JPanel
    implements UIResource {
        private ContainerUIResource(Component component) {
            super(new BorderLayout());
            this.add(component);
        }

        @Override
        public void reshape(int n, int n2, int n3, int n4) {
            if (FlatTabbedPaneUI.this.inBasicLayoutContainer) {
                return;
            }
            super.reshape(n, n2, n3, n4);
        }
    }

    private static class TabCloseButton
    extends JButton
    implements UIResource {
        private TabCloseButton() {
        }
    }
}

