/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.icons.FlatCheckBoxIcon;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatTableHeaderUI;
import com.formdev.flatlaf.ui.FlatUIAction;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.FlatViewportUI;
import com.formdev.flatlaf.ui.StackUtils;
import com.formdev.flatlaf.util.Graphics2DProxy;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class FlatTableUI
extends BasicTableUI
implements FlatStylingSupport.StyleableUI,
FlatViewportUI.ViewportPainter {
    protected boolean showHorizontalLines;
    protected boolean showVerticalLines;
    @FlatStylingSupport.Styleable
    protected boolean showTrailingVerticalLine;
    protected Dimension intercellSpacing;
    @FlatStylingSupport.Styleable
    protected Color selectionBackground;
    @FlatStylingSupport.Styleable
    protected Color selectionForeground;
    @FlatStylingSupport.Styleable
    protected Color selectionInactiveBackground;
    @FlatStylingSupport.Styleable
    protected Color selectionInactiveForeground;
    @FlatStylingSupport.Styleable
    protected Insets cellMargins;
    @FlatStylingSupport.Styleable
    protected Color cellFocusColor;
    @FlatStylingSupport.Styleable
    protected Boolean showCellFocusIndicator;
    private boolean oldShowHorizontalLines;
    private boolean oldShowVerticalLines;
    private Dimension oldIntercellSpacing;
    private TableCellRenderer oldBooleanRenderer;
    private PropertyChangeListener propertyChangeListener;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatTableUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        FlatTablePropertyWatcher flatTablePropertyWatcher;
        super.installDefaults();
        this.showHorizontalLines = UIManager.getBoolean("Table.showHorizontalLines");
        this.showVerticalLines = UIManager.getBoolean("Table.showVerticalLines");
        this.showTrailingVerticalLine = UIManager.getBoolean("Table.showTrailingVerticalLine");
        this.intercellSpacing = UIManager.getDimension("Table.intercellSpacing");
        this.selectionBackground = UIManager.getColor("Table.selectionBackground");
        this.selectionForeground = UIManager.getColor("Table.selectionForeground");
        this.selectionInactiveBackground = UIManager.getColor("Table.selectionInactiveBackground");
        this.selectionInactiveForeground = UIManager.getColor("Table.selectionInactiveForeground");
        this.toggleSelectionColors();
        int n = FlatUIUtils.getUIInt("Table.rowHeight", 16);
        if (n > 0) {
            LookAndFeel.installProperty(this.table, "rowHeight", UIScale.scale(n));
        }
        if ((flatTablePropertyWatcher = FlatTablePropertyWatcher.get(this.table)) != null) {
            flatTablePropertyWatcher.enabled = false;
        }
        if (!(this.showHorizontalLines || flatTablePropertyWatcher != null && flatTablePropertyWatcher.showHorizontalLinesChanged)) {
            this.oldShowHorizontalLines = this.table.getShowHorizontalLines();
            this.table.setShowHorizontalLines(false);
        }
        if (!(this.showVerticalLines || flatTablePropertyWatcher != null && flatTablePropertyWatcher.showVerticalLinesChanged)) {
            this.oldShowVerticalLines = this.table.getShowVerticalLines();
            this.table.setShowVerticalLines(false);
        }
        if (!(this.intercellSpacing == null || flatTablePropertyWatcher != null && flatTablePropertyWatcher.intercellSpacingChanged)) {
            this.oldIntercellSpacing = this.table.getIntercellSpacing();
            this.table.setIntercellSpacing(this.intercellSpacing);
        }
        if (flatTablePropertyWatcher != null) {
            flatTablePropertyWatcher.enabled = true;
        } else {
            this.table.addPropertyChangeListener(new FlatTablePropertyWatcher());
        }
        this.oldBooleanRenderer = this.table.getDefaultRenderer(Boolean.class);
        if (this.oldBooleanRenderer instanceof UIResource) {
            this.table.setDefaultRenderer(Boolean.class, new FlatBooleanRenderer());
            return;
        }
        this.oldBooleanRenderer = null;
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.selectionInactiveBackground = null;
        this.selectionInactiveForeground = null;
        this.oldStyleValues = null;
        FlatTablePropertyWatcher flatTablePropertyWatcher = FlatTablePropertyWatcher.get(this.table);
        if (flatTablePropertyWatcher != null) {
            flatTablePropertyWatcher.enabled = false;
        }
        if (!(this.showHorizontalLines || !this.oldShowHorizontalLines || this.table.getShowHorizontalLines() || flatTablePropertyWatcher != null && flatTablePropertyWatcher.showHorizontalLinesChanged)) {
            this.table.setShowHorizontalLines(true);
        }
        if (!(this.showVerticalLines || !this.oldShowVerticalLines || this.table.getShowVerticalLines() || flatTablePropertyWatcher != null && flatTablePropertyWatcher.showVerticalLinesChanged)) {
            this.table.setShowVerticalLines(true);
        }
        if (this.intercellSpacing != null && this.table.getIntercellSpacing().equals(this.intercellSpacing) && (flatTablePropertyWatcher == null || !flatTablePropertyWatcher.intercellSpacingChanged)) {
            this.table.setIntercellSpacing(this.oldIntercellSpacing);
        }
        if (flatTablePropertyWatcher != null) {
            flatTablePropertyWatcher.enabled = true;
        }
        if (this.table.getDefaultRenderer(Boolean.class) instanceof FlatBooleanRenderer) {
            if (this.oldBooleanRenderer instanceof Component) {
                SwingUtilities.updateComponentTreeUI((Component)((Object)this.oldBooleanRenderer));
            }
            this.table.setDefaultRenderer(Boolean.class, this.oldBooleanRenderer);
        }
        this.oldBooleanRenderer = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = object -> {
            switch (((PropertyChangeEvent)object).getPropertyName()) {
                case "JComponent.focusOwner": {
                    this.toggleSelectionColors();
                    return;
                }
                case "FlatLaf.style": 
                case "FlatLaf.styleClass": {
                    this.installStyle();
                    this.table.revalidate();
                    this.table.repaint();
                }
            }
        };
        this.table.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.table.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    @Override
    protected FocusListener createFocusListener() {
        return new BasicTableUI.FocusHandler(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                super.focusGained(focusEvent);
                FlatTableUI.this.toggleSelectionColors();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                super.focusLost(focusEvent);
                EventQueue.invokeLater(() -> FlatTableUI.this.toggleSelectionColors());
            }
        };
    }

    @Override
    protected void installKeyboardActions() {
        ActionMap actionMap;
        super.installKeyboardActions();
        if (UIManager.getBoolean("Table.editorSelectAllOnStartEditing") && (actionMap = SwingUtilities.getUIActionMap(this.table)) != null) {
            StartEditingAction.install(actionMap, "startEditing");
        }
    }

    protected void installStyle() {
        try {
            FlatTableUI flatTableUI = this;
            flatTableUI.applyStyle(FlatStylingSupport.getResolvedStyle(flatTableUI.table, "Table"));
            return;
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
            return;
        }
    }

    protected void applyStyle(Object object) {
        Color color = this.selectionBackground;
        Color color2 = this.selectionForeground;
        Color color3 = this.selectionInactiveBackground;
        Color color4 = this.selectionInactiveForeground;
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
        if (this.selectionBackground != color) {
            object = this.table.getSelectionBackground();
            if (object == color) {
                this.table.setSelectionBackground(this.selectionBackground);
            } else if (object == color3) {
                this.table.setSelectionBackground(this.selectionInactiveBackground);
            }
        }
        if (this.selectionForeground != color2) {
            object = this.table.getSelectionForeground();
            if (object == color2) {
                this.table.setSelectionForeground(this.selectionForeground);
                return;
            }
            if (object == color4) {
                this.table.setSelectionForeground(this.selectionInactiveForeground);
            }
        }
    }

    protected Object applyStyleProperty(String string, Object object) {
        if ("rowHeight".equals(string) && object instanceof Integer) {
            object = UIScale.scale((Integer)object);
        }
        FlatTableUI flatTableUI = this;
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(flatTableUI, flatTableUI.table, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    private void toggleSelectionColors() {
        if (this.table == null) {
            return;
        }
        if (FlatUIUtils.isPermanentFocusOwner(this.table)) {
            if (this.table.getSelectionBackground() == this.selectionInactiveBackground) {
                this.table.setSelectionBackground(this.selectionBackground);
            }
            if (this.table.getSelectionForeground() == this.selectionInactiveForeground) {
                this.table.setSelectionForeground(this.selectionForeground);
                return;
            }
        } else {
            if (this.table.getSelectionBackground() == this.selectionBackground) {
                this.table.setSelectionBackground(this.selectionInactiveBackground);
            }
            if (this.table.getSelectionForeground() == this.selectionForeground) {
                this.table.setSelectionForeground(this.selectionInactiveForeground);
            }
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        FlatTableHeaderUI.fixDraggedAndResizingColumns(this.table.getTableHeader());
        final boolean bl = this.table.getShowHorizontalLines();
        final boolean bl2 = this.table.getShowVerticalLines();
        if (bl || bl2) {
            final boolean bl3 = this.hideLastVerticalLine();
            final int n = this.table.getWidth();
            JTableHeader jTableHeader = this.table.getTableHeader();
            final boolean bl4 = jTableHeader != null && jTableHeader.getDraggedColumn() != null;
            double d = UIScale.getSystemScaleFactor((Graphics2D)graphics);
            final double d2 = 1.0 / d * (double)((int)d);
            graphics = new Graphics2DProxy((Graphics2D)graphics){

                @Override
                public void drawLine(int n5, int n2, int n3, int n4) {
                    if (bl3 && bl2 && n5 == n3 && n2 == 0 && n5 == n - 1 && this.wasInvokedFromPaintGrid()) {
                        return;
                    }
                    if (bl4 && SystemInfo.isJava_9_orLater && (bl && n2 == n4 || bl2 && n5 == n3) && this.wasInvokedFromMethod("paintDraggedArea")) {
                        if (n2 == n4) {
                            super.fill(new Rectangle2D.Double(n5, n2, n3 - n5 + 1, d2));
                            return;
                        }
                        if (n5 == n3) {
                            super.fill(new Rectangle2D.Double(n5, n2, d2, n4 - n2 + 1));
                        }
                        return;
                    }
                    super.drawLine(n5, n2, n3, n4);
                }

                @Override
                public void fillRect(int n5, int n2, int n3, int n4) {
                    if (bl3 && bl2 && n3 == 1 && n2 == 0 && n5 == n - 1 && this.wasInvokedFromPaintGrid()) {
                        return;
                    }
                    if (d2 != 1.0) {
                        if (bl && n4 == 1 && this.wasInvokedFromPaintGrid()) {
                            super.fill(new Rectangle2D.Double(n5, n2, n3, d2));
                            return;
                        }
                        if (bl2 && n3 == 1 && n2 == 0 && this.wasInvokedFromPaintGrid()) {
                            super.fill(new Rectangle2D.Double(n5, n2, d2, n4));
                            return;
                        }
                    }
                    super.fillRect(n5, n2, n3, n4);
                }

                private boolean wasInvokedFromPaintGrid() {
                    return this.wasInvokedFromMethod("paintGrid");
                }

                private boolean wasInvokedFromMethod(String string) {
                    return StackUtils.wasInvokedFrom(BasicTableUI.class.getName(), string, 8);
                }
            };
        }
        super.paint(graphics, jComponent);
    }

    protected boolean hideLastVerticalLine() {
        if (this.showTrailingVerticalLine) {
            return false;
        }
        Container container = SwingUtilities.getUnwrappedParent(this.table);
        Container container2 = container != null ? container.getParent() : null;
        if (!(container2 instanceof JScrollPane)) {
            return false;
        }
        if (this.table.getX() + this.table.getWidth() < container.getWidth()) {
            return false;
        }
        container2 = (JScrollPane)container2;
        JViewport jViewport = ((JScrollPane)container2).getRowHeader();
        if (container2.getComponentOrientation().isLeftToRight()) {
            return container != jViewport;
        }
        return container == jViewport || jViewport == null;
    }

    @Override
    public void paintViewport(Graphics graphics, JComponent jComponent, JViewport jViewport) {
        Color color;
        int n = jViewport.getWidth();
        int n2 = jViewport.getHeight();
        if (jViewport.isOpaque()) {
            graphics.setColor(this.table.getBackground());
            graphics.fillRect(0, 0, n, n2);
        }
        boolean bl = UIManager.getBoolean("Table.paintOutsideAlternateRows");
        n = bl ? 1 : 0;
        if (bl && (color = UIManager.getColor("Table.alternateRowColor")) != null) {
            graphics.setColor(color);
            int n3 = this.table.getRowCount();
            int n4 = this.table.getHeight();
            if (n4 < n2) {
                int n5 = this.table.getWidth();
                int n6 = this.table.getRowHeight();
                while (n4 < n2) {
                    if (n3 % 2 != 0) {
                        graphics.fillRect(0, n4, n5, n6);
                    }
                    n4 += n6;
                    ++n3;
                }
            }
        }
    }

    private static class StartEditingAction
    extends FlatUIAction {
        static void install(ActionMap actionMap, String string) {
            Action action = actionMap.get(string);
            if (action == null || action instanceof StartEditingAction) {
                return;
            }
            actionMap.put(string, new StartEditingAction(action));
        }

        private StartEditingAction(Action action) {
            super(action);
        }

        @Override
        public void actionPerformed(ActionEvent serializable) {
            JTable jTable = (JTable)serializable.getSource();
            Component component = jTable.getEditorComponent();
            this.delegate.actionPerformed((ActionEvent)serializable);
            serializable = jTable.getEditorComponent();
            if (component == null && serializable instanceof JTextField) {
                ((JTextField)serializable).selectAll();
            }
        }
    }

    private static class FlatBooleanRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        private boolean selected;

        FlatBooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setIcon(new FlatCheckBoxIcon(){

                @Override
                protected boolean isSelected(Component component) {
                    return selected;
                }
            });
        }

        @Override
        protected void setValue(Object object) {
            this.selected = object != null && (Boolean)object != false;
        }
    }

    private static class FlatTablePropertyWatcher
    implements PropertyChangeListener {
        boolean enabled = true;
        boolean showHorizontalLinesChanged;
        boolean showVerticalLinesChanged;
        boolean intercellSpacingChanged;

        private FlatTablePropertyWatcher() {
        }

        static FlatTablePropertyWatcher get(JTable propertyChangeListenerArray) {
            for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray.getPropertyChangeListeners()) {
                if (!(propertyChangeListener instanceof FlatTablePropertyWatcher)) continue;
                return (FlatTablePropertyWatcher)propertyChangeListener;
            }
            return null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent object) {
            if (!this.enabled) {
                return;
            }
            switch (((PropertyChangeEvent)object).getPropertyName()) {
                case "showHorizontalLines": {
                    this.showHorizontalLinesChanged = true;
                    return;
                }
                case "showVerticalLines": {
                    this.showVerticalLinesChanged = true;
                    return;
                }
                case "rowMargin": {
                    this.intercellSpacingChanged = true;
                }
            }
        }
    }
}

