/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatNativeWindowBorder;
import com.formdev.flatlaf.ui.FlatNativeWindowsLibrary;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

class FlatWindowsNativeWindowBorder
implements FlatNativeWindowBorder.Provider {
    private final Map<Window, WndProc> windowsMap = Collections.synchronizedMap(new IdentityHashMap());
    private final EventListenerList listenerList = new EventListenerList();
    private Timer fireStateChangedTimer;
    private boolean colorizationUpToDate;
    private boolean colorizationColorAffectsBorders;
    private Color colorizationColor;
    private int colorizationColorBalance;
    private static FlatWindowsNativeWindowBorder instance;

    static FlatNativeWindowBorder.Provider getInstance() {
        if (!SystemInfo.isWindows_10_orLater) {
            return null;
        }
        if (!FlatNativeWindowsLibrary.isLoaded()) {
            return null;
        }
        if (instance == null) {
            instance = new FlatWindowsNativeWindowBorder();
        }
        return instance;
    }

    private FlatWindowsNativeWindowBorder() {
    }

    @Override
    public boolean hasCustomDecoration(Window window) {
        return this.windowsMap.containsKey(window);
    }

    @Override
    public void setHasCustomDecoration(Window window, boolean bl) {
        if (bl) {
            this.install(window);
            return;
        }
        this.uninstall(window);
    }

    private void install(Window window) {
        if (!SystemInfo.isWindows_10_orLater) {
            return;
        }
        if (!(window instanceof JFrame) && !(window instanceof JDialog)) {
            return;
        }
        if (window instanceof Frame && ((Frame)window).isUndecorated() || window instanceof Dialog && ((Dialog)window).isUndecorated()) {
            return;
        }
        if (this.windowsMap.containsKey(window)) {
            return;
        }
        try {
            WndProc wndProc = new WndProc(window);
            if (wndProc.hwnd == 0L) {
                return;
            }
            this.windowsMap.put(window, wndProc);
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            LoggingFacade.INSTANCE.logSevere(null, unsatisfiedLinkError);
            return;
        }
    }

    private void uninstall(Window object) {
        if ((object = this.windowsMap.remove(object)) != null) {
            ((WndProc)object).uninstall();
        }
    }

    @Override
    public void updateTitleBarInfo(Window object, int n, Predicate<Point> predicate, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4) {
        if ((object = this.windowsMap.get(object)) == null) {
            return;
        }
        ((WndProc)object).titleBarHeight = n;
        ((WndProc)object).captionHitTestCallback = predicate;
        ((WndProc)object).appIconBounds = FlatWindowsNativeWindowBorder.cloneRectange(rectangle);
        ((WndProc)object).minimizeButtonBounds = FlatWindowsNativeWindowBorder.cloneRectange(rectangle2);
        ((WndProc)object).maximizeButtonBounds = FlatWindowsNativeWindowBorder.cloneRectange(rectangle3);
        ((WndProc)object).closeButtonBounds = FlatWindowsNativeWindowBorder.cloneRectange(rectangle4);
    }

    private static Rectangle cloneRectange(Rectangle rectangle) {
        if (rectangle != null) {
            return new Rectangle(rectangle);
        }
        return null;
    }

    @Override
    public boolean showWindow(Window object, int n) {
        if ((object = this.windowsMap.get(object)) == null) {
            return false;
        }
        Object object2 = object;
        ((WndProc)object2).showWindow(((WndProc)object2).hwnd, n);
        return true;
    }

    @Override
    public boolean isColorizationColorAffectsBorders() {
        this.updateColorization();
        return this.colorizationColorAffectsBorders;
    }

    @Override
    public Color getColorizationColor() {
        this.updateColorization();
        return this.colorizationColor;
    }

    @Override
    public int getColorizationColorBalance() {
        this.updateColorization();
        return this.colorizationColorBalance;
    }

    private void updateColorization() {
        if (this.colorizationUpToDate) {
            return;
        }
        this.colorizationUpToDate = true;
        String string = "SOFTWARE\\Microsoft\\Windows\\DWM";
        int n = FlatWindowsNativeWindowBorder.registryGetIntValue("SOFTWARE\\Microsoft\\Windows\\DWM", "ColorPrevalence", -1);
        this.colorizationColorAffectsBorders = n > 0;
        n = FlatWindowsNativeWindowBorder.registryGetIntValue(string, "ColorizationColor", -1);
        this.colorizationColor = n != -1 ? new Color(n) : null;
        this.colorizationColorBalance = FlatWindowsNativeWindowBorder.registryGetIntValue(string, "ColorizationColorBalance", -1);
    }

    private static native int registryGetIntValue(String var0, String var1, int var2);

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    private void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        if (objectArray.length == 0) {
            return;
        }
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    void fireStateChangedLaterOnce() {
        EventQueue.invokeLater(() -> {
            if (this.fireStateChangedTimer != null) {
                this.fireStateChangedTimer.restart();
                return;
            }
            this.fireStateChangedTimer = new Timer(300, actionEvent -> {
                this.fireStateChangedTimer = null;
                this.colorizationUpToDate = false;
                this.fireStateChanged();
            });
            this.fireStateChangedTimer.setRepeats(false);
            this.fireStateChangedTimer.start();
        });
    }

    private class WndProc
    implements PropertyChangeListener {
        private static final int HTCLIENT = 1;
        private static final int HTCAPTION = 2;
        private static final int HTSYSMENU = 3;
        private static final int HTMINBUTTON = 8;
        private static final int HTMAXBUTTON = 9;
        private static final int HTTOP = 12;
        private static final int HTCLOSE = 20;
        private Window window;
        private final long hwnd;
        private int titleBarHeight;
        private Predicate<Point> captionHitTestCallback;
        private Rectangle appIconBounds;
        private Rectangle minimizeButtonBounds;
        private Rectangle maximizeButtonBounds;
        private Rectangle closeButtonBounds;

        WndProc(Window window) {
            this.window = window;
            this.hwnd = this.installImpl(window);
            if (this.hwnd == 0L) {
                return;
            }
            WndProc wndProc = this;
            wndProc.updateFrame(wndProc.hwnd, window instanceof JFrame ? ((JFrame)window).getExtendedState() : 0);
            this.updateWindowBackground();
            window.addPropertyChangeListener("background", this);
        }

        void uninstall() {
            this.window.removePropertyChangeListener("background", this);
            WndProc wndProc = this;
            wndProc.uninstallImpl(wndProc.hwnd);
            this.window = null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateWindowBackground();
        }

        private void updateWindowBackground() {
            Color color = this.window.getBackground();
            if (color != null) {
                WndProc wndProc = this;
                wndProc.setWindowBackground(wndProc.hwnd, color.getRed(), color.getGreen(), color.getBlue());
            }
        }

        private native long installImpl(Window var1);

        private native void uninstallImpl(long var1);

        private native void updateFrame(long var1, int var3);

        private native void setWindowBackground(long var1, int var3, int var4, int var5);

        private native void showWindow(long var1, int var3);

        private int onNcHitTest(int n, int n2, boolean bl) {
            Point point = this.scaleDown(n, n2);
            WndProc wndProc = this;
            if (wndProc.contains(wndProc.appIconBounds, point)) {
                return 3;
            }
            WndProc wndProc2 = this;
            if (wndProc2.contains(wndProc2.minimizeButtonBounds, point)) {
                return 8;
            }
            WndProc wndProc3 = this;
            if (wndProc3.contains(wndProc3.maximizeButtonBounds, point)) {
                return 9;
            }
            WndProc wndProc4 = this;
            if (wndProc4.contains(wndProc4.closeButtonBounds, point)) {
                return 20;
            }
            if (bl) {
                return 12;
            }
            n2 = point.y < this.titleBarHeight ? 1 : 0;
            if (n2 != 0) {
                try {
                    if (this.captionHitTestCallback != null && !this.captionHitTestCallback.test(point)) {
                        return 1;
                    }
                }
                catch (Throwable throwable) {}
                return 2;
            }
            return 1;
        }

        private boolean contains(Rectangle rectangle, Point point) {
            return rectangle != null && rectangle.contains(point);
        }

        private Point scaleDown(int n, int n2) {
            Object object = this.window.getGraphicsConfiguration();
            if (object == null) {
                return new Point(n, n2);
            }
            object = ((GraphicsConfiguration)object).getDefaultTransform();
            return new Point(this.clipRound((double)n / ((AffineTransform)object).getScaleX()), this.clipRound((double)n2 / ((AffineTransform)object).getScaleY()));
        }

        private int clipRound(double d) {
            double d2;
            d -= 0.5;
            if (d2 < -2.147483648E9) {
                return Integer.MIN_VALUE;
            }
            if (d > 2.147483647E9) {
                return Integer.MAX_VALUE;
            }
            return (int)Math.ceil(d);
        }

        private boolean isFullscreen() {
            GraphicsConfiguration graphicsConfiguration = this.window.getGraphicsConfiguration();
            if (graphicsConfiguration == null) {
                return false;
            }
            return graphicsConfiguration.getDevice().getFullScreenWindow() == this.window;
        }

        private void fireStateChangedLaterOnce() {
            FlatWindowsNativeWindowBorder.this.fireStateChangedLaterOnce();
        }
    }
}

