/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.BrotliEncoder;
import io.netty.handler.codec.compression.BrotliOptions;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.compression.DeflateOptions;
import io.netty.handler.codec.compression.GzipOptions;
import io.netty.handler.codec.compression.SnappyFrameEncoder;
import io.netty.handler.codec.compression.SnappyOptions;
import io.netty.handler.codec.compression.StandardCompressionOptions;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.compression.Zstd;
import io.netty.handler.codec.compression.ZstdEncoder;
import io.netty.handler.codec.compression.ZstdOptions;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http2.DecoratingHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;

public class CompressorHttp2ConnectionEncoder
extends DecoratingHttp2ConnectionEncoder {
    public static final int DEFAULT_COMPRESSION_LEVEL = 6;
    public static final int DEFAULT_WINDOW_BITS = 15;
    public static final int DEFAULT_MEM_LEVEL = 8;
    private int compressionLevel;
    private int windowBits;
    private int memLevel;
    private final Http2Connection.PropertyKey propertyKey;
    private final boolean supportsCompressionOptions;
    private BrotliOptions brotliOptions;
    private GzipOptions gzipCompressionOptions;
    private DeflateOptions deflateOptions;
    private ZstdOptions zstdOptions;
    private SnappyOptions snappyOptions;

    public CompressorHttp2ConnectionEncoder(Http2ConnectionEncoder http2ConnectionEncoder) {
        this(http2ConnectionEncoder, CompressorHttp2ConnectionEncoder.defaultCompressionOptions());
    }

    private static CompressionOptions[] defaultCompressionOptions() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(StandardCompressionOptions.gzip());
        arrayList.add(StandardCompressionOptions.deflate());
        arrayList.add(StandardCompressionOptions.snappy());
        if (Brotli.isAvailable()) {
            arrayList.add(StandardCompressionOptions.brotli());
        }
        if (Zstd.isAvailable()) {
            arrayList.add(StandardCompressionOptions.zstd());
        }
        return arrayList.toArray(new CompressionOptions[0]);
    }

    @Deprecated
    public CompressorHttp2ConnectionEncoder(Http2ConnectionEncoder http2ConnectionEncoder, int n, int n2, int n3) {
        super(http2ConnectionEncoder);
        this.compressionLevel = ObjectUtil.checkInRange((int)n, (int)0, (int)9, (String)"compressionLevel");
        this.windowBits = ObjectUtil.checkInRange((int)n2, (int)9, (int)15, (String)"windowBits");
        this.memLevel = ObjectUtil.checkInRange((int)n3, (int)1, (int)9, (String)"memLevel");
        this.propertyKey = this.connection().newKey();
        this.connection().addListener(new Http2ConnectionAdapter(){

            @Override
            public void onStreamRemoved(Http2Stream http2Stream) {
                EmbeddedChannel embeddedChannel = (EmbeddedChannel)http2Stream.getProperty(CompressorHttp2ConnectionEncoder.this.propertyKey);
                if (embeddedChannel != null) {
                    CompressorHttp2ConnectionEncoder.this.cleanup(http2Stream, embeddedChannel);
                }
            }
        });
        this.supportsCompressionOptions = false;
    }

    public CompressorHttp2ConnectionEncoder(Http2ConnectionEncoder compressionOptionsArray, CompressionOptions ... compressionOptionsArray2) {
        super((Http2ConnectionEncoder)compressionOptionsArray);
        ObjectUtil.checkNotNull((Object)compressionOptionsArray2, (String)"CompressionOptions");
        ObjectUtil.deepCheckNotNull((String)"CompressionOptions", (Object[])compressionOptionsArray2);
        compressionOptionsArray = compressionOptionsArray2;
        int n = compressionOptionsArray2.length;
        for (int i = 0; i < n; ++i) {
            CompressionOptions compressionOptions = compressionOptionsArray[i];
            if (Brotli.isAvailable() && compressionOptions instanceof BrotliOptions) {
                this.brotliOptions = (BrotliOptions)compressionOptions;
                continue;
            }
            if (compressionOptions instanceof GzipOptions) {
                this.gzipCompressionOptions = (GzipOptions)compressionOptions;
                continue;
            }
            if (compressionOptions instanceof DeflateOptions) {
                this.deflateOptions = (DeflateOptions)compressionOptions;
                continue;
            }
            if (compressionOptions instanceof ZstdOptions) {
                this.zstdOptions = (ZstdOptions)compressionOptions;
                continue;
            }
            if (compressionOptions instanceof SnappyOptions) {
                this.snappyOptions = (SnappyOptions)compressionOptions;
                continue;
            }
            throw new IllegalArgumentException("Unsupported " + CompressionOptions.class.getSimpleName() + ": " + compressionOptions);
        }
        this.supportsCompressionOptions = true;
        this.propertyKey = this.connection().newKey();
        this.connection().addListener(new Http2ConnectionAdapter(){

            @Override
            public void onStreamRemoved(Http2Stream http2Stream) {
                EmbeddedChannel embeddedChannel = (EmbeddedChannel)http2Stream.getProperty(CompressorHttp2ConnectionEncoder.this.propertyKey);
                if (embeddedChannel != null) {
                    CompressorHttp2ConnectionEncoder.this.cleanup(http2Stream, embeddedChannel);
                }
            }
        });
    }

    @Override
    public ChannelFuture writeData(ChannelHandlerContext channelHandlerContext, int n, ByteBuf byteBuf, int n2, boolean bl, ChannelPromise channelPromise) {
        Http2Stream http2Stream = this.connection().stream(n);
        EmbeddedChannel embeddedChannel = http2Stream == null ? null : (EmbeddedChannel)http2Stream.getProperty(this.propertyKey);
        if (embeddedChannel == null) {
            return super.writeData(channelHandlerContext, n, byteBuf, n2, bl, channelPromise);
        }
        try {
            embeddedChannel.writeOutbound(new Object[]{byteBuf});
            byteBuf = CompressorHttp2ConnectionEncoder.nextReadableBuf(embeddedChannel);
            if (byteBuf == null) {
                if (bl) {
                    if (embeddedChannel.finish()) {
                        byteBuf = CompressorHttp2ConnectionEncoder.nextReadableBuf(embeddedChannel);
                    }
                    ChannelFuture channelFuture = super.writeData(channelHandlerContext, n, byteBuf == null ? Unpooled.EMPTY_BUFFER : byteBuf, n2, true, channelPromise);
                    return channelFuture;
                }
                channelPromise.setSuccess();
                ChannelPromise channelPromise2 = channelPromise;
                return channelPromise2;
            }
            PromiseCombiner promiseCombiner = new PromiseCombiner(channelHandlerContext.executor());
            while (true) {
                ByteBuf byteBuf2;
                boolean bl2;
                if ((bl2 = (byteBuf2 = CompressorHttp2ConnectionEncoder.nextReadableBuf(embeddedChannel)) == null && bl) && embeddedChannel.finish()) {
                    byteBuf2 = CompressorHttp2ConnectionEncoder.nextReadableBuf(embeddedChannel);
                    bl2 = byteBuf2 == null;
                }
                ChannelPromise channelPromise3 = channelHandlerContext.newPromise();
                promiseCombiner.add((Promise)channelPromise3);
                super.writeData(channelHandlerContext, n, byteBuf, n2, bl2, channelPromise3);
                if (byteBuf2 == null) break;
                n2 = 0;
                byteBuf = byteBuf2;
            }
            promiseCombiner.finish((Promise)channelPromise);
        }
        catch (Throwable throwable) {
            channelPromise.tryFailure(throwable);
        }
        finally {
            if (bl) {
                this.cleanup(http2Stream, embeddedChannel);
            }
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, boolean bl, ChannelPromise channelPromise) {
        try {
            EmbeddedChannel embeddedChannel = this.newCompressor(channelHandlerContext, http2Headers, bl);
            channelHandlerContext = super.writeHeaders(channelHandlerContext, n, http2Headers, n2, bl, channelPromise);
            this.bindCompressorToStream(embeddedChannel, n);
            return channelHandlerContext;
        }
        catch (Throwable throwable) {
            channelPromise.tryFailure(throwable);
            return channelPromise;
        }
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, short s, boolean bl, int n3, boolean bl2, ChannelPromise channelPromise) {
        try {
            EmbeddedChannel embeddedChannel = this.newCompressor(channelHandlerContext, http2Headers, bl2);
            channelHandlerContext = super.writeHeaders(channelHandlerContext, n, http2Headers, n2, s, bl, n3, bl2, channelPromise);
            this.bindCompressorToStream(embeddedChannel, n);
            return channelHandlerContext;
        }
        catch (Throwable throwable) {
            channelPromise.tryFailure(throwable);
            return channelPromise;
        }
    }

    protected EmbeddedChannel newContentCompressor(ChannelHandlerContext channelHandlerContext, CharSequence charSequence) {
        if (HttpHeaderValues.GZIP.contentEqualsIgnoreCase(charSequence) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase(charSequence)) {
            return this.newCompressionChannel(channelHandlerContext, ZlibWrapper.GZIP);
        }
        if (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase(charSequence) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase(charSequence)) {
            return this.newCompressionChannel(channelHandlerContext, ZlibWrapper.ZLIB);
        }
        if (Brotli.isAvailable() && this.brotliOptions != null && HttpHeaderValues.BR.contentEqualsIgnoreCase(charSequence)) {
            return new EmbeddedChannel(channelHandlerContext.channel().id(), channelHandlerContext.channel().metadata().hasDisconnect(), channelHandlerContext.channel().config(), new ChannelHandler[]{new BrotliEncoder(this.brotliOptions.parameters())});
        }
        if (this.zstdOptions != null && HttpHeaderValues.ZSTD.contentEqualsIgnoreCase(charSequence)) {
            return new EmbeddedChannel(channelHandlerContext.channel().id(), channelHandlerContext.channel().metadata().hasDisconnect(), channelHandlerContext.channel().config(), new ChannelHandler[]{new ZstdEncoder(this.zstdOptions.compressionLevel(), this.zstdOptions.blockSize(), this.zstdOptions.maxEncodeSize())});
        }
        if (this.snappyOptions != null && HttpHeaderValues.SNAPPY.contentEqualsIgnoreCase(charSequence)) {
            return new EmbeddedChannel(channelHandlerContext.channel().id(), channelHandlerContext.channel().metadata().hasDisconnect(), channelHandlerContext.channel().config(), new ChannelHandler[]{new SnappyFrameEncoder()});
        }
        return null;
    }

    protected CharSequence getTargetContentEncoding(CharSequence charSequence) {
        return charSequence;
    }

    private EmbeddedChannel newCompressionChannel(ChannelHandlerContext channelHandlerContext, ZlibWrapper zlibWrapper) {
        if (this.supportsCompressionOptions) {
            if (zlibWrapper == ZlibWrapper.GZIP && this.gzipCompressionOptions != null) {
                return new EmbeddedChannel(channelHandlerContext.channel().id(), channelHandlerContext.channel().metadata().hasDisconnect(), channelHandlerContext.channel().config(), new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)zlibWrapper, (int)this.gzipCompressionOptions.compressionLevel(), (int)this.gzipCompressionOptions.windowBits(), (int)this.gzipCompressionOptions.memLevel())});
            }
            if (zlibWrapper == ZlibWrapper.ZLIB && this.deflateOptions != null) {
                return new EmbeddedChannel(channelHandlerContext.channel().id(), channelHandlerContext.channel().metadata().hasDisconnect(), channelHandlerContext.channel().config(), new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)zlibWrapper, (int)this.deflateOptions.compressionLevel(), (int)this.deflateOptions.windowBits(), (int)this.deflateOptions.memLevel())});
            }
            throw new IllegalArgumentException("Unsupported ZlibWrapper: " + zlibWrapper);
        }
        return new EmbeddedChannel(channelHandlerContext.channel().id(), channelHandlerContext.channel().metadata().hasDisconnect(), channelHandlerContext.channel().config(), new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)zlibWrapper, (int)this.compressionLevel, (int)this.windowBits, (int)this.memLevel)});
    }

    private EmbeddedChannel newCompressor(ChannelHandlerContext channelHandlerContext, Http2Headers http2Headers, boolean bl) {
        if (bl) {
            return null;
        }
        CharSequence charSequence = (CharSequence)http2Headers.get(HttpHeaderNames.CONTENT_ENCODING);
        if (charSequence == null) {
            charSequence = HttpHeaderValues.IDENTITY;
        }
        if ((channelHandlerContext = this.newContentCompressor(channelHandlerContext, charSequence)) != null) {
            if (HttpHeaderValues.IDENTITY.contentEqualsIgnoreCase(charSequence = this.getTargetContentEncoding(charSequence))) {
                http2Headers.remove(HttpHeaderNames.CONTENT_ENCODING);
            } else {
                http2Headers.set(HttpHeaderNames.CONTENT_ENCODING, charSequence);
            }
            http2Headers.remove(HttpHeaderNames.CONTENT_LENGTH);
        }
        return channelHandlerContext;
    }

    private void bindCompressorToStream(EmbeddedChannel embeddedChannel, int n) {
        Http2Stream http2Stream;
        if (embeddedChannel != null && (http2Stream = this.connection().stream(n)) != null) {
            http2Stream.setProperty(this.propertyKey, embeddedChannel);
        }
    }

    void cleanup(Http2Stream http2Stream, EmbeddedChannel embeddedChannel) {
        embeddedChannel.finishAndReleaseAll();
        http2Stream.removeProperty(this.propertyKey);
    }

    private static ByteBuf nextReadableBuf(EmbeddedChannel embeddedChannel) {
        ByteBuf byteBuf;
        while (true) {
            if ((byteBuf = (ByteBuf)embeddedChannel.readOutbound()) == null) {
                return null;
            }
            if (byteBuf.isReadable()) break;
            byteBuf.release();
        }
        return byteBuf;
    }
}

