/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.BrotliDecoder;
import io.netty.handler.codec.compression.SnappyFrameDecoder;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.compression.Zstd;
import io.netty.handler.codec.compression.ZstdDecoder;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameListenerDecorator;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.internal.ObjectUtil;

public class DelegatingDecompressorFrameListener
extends Http2FrameListenerDecorator {
    private final Http2Connection connection;
    private final boolean strict;
    private boolean flowControllerInitialized;
    private final Http2Connection.PropertyKey propertyKey;

    public DelegatingDecompressorFrameListener(Http2Connection http2Connection, Http2FrameListener http2FrameListener) {
        this(http2Connection, http2FrameListener, true);
    }

    public DelegatingDecompressorFrameListener(Http2Connection http2Connection, Http2FrameListener http2FrameListener, boolean bl) {
        super(http2FrameListener);
        this.connection = http2Connection;
        this.strict = bl;
        this.propertyKey = http2Connection.newKey();
        http2Connection.addListener(new Http2ConnectionAdapter(){

            @Override
            public void onStreamRemoved(Http2Stream object) {
                if ((object = DelegatingDecompressorFrameListener.this.decompressor((Http2Stream)object)) != null) {
                    DelegatingDecompressorFrameListener.cleanup((Http2Decompressor)object);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int onDataRead(ChannelHandlerContext channelHandlerContext, int n, ByteBuf object, int n2, boolean bl) {
        void var5_13;
        boolean bl2;
        Http2Stream http2Stream = this.connection.stream(n);
        Http2Decompressor http2Decompressor = this.decompressor(http2Stream);
        if (http2Decompressor == null) {
            return this.listener.onDataRead(channelHandlerContext, n, (ByteBuf)object, bl2 ? 1 : 0, (boolean)var5_13);
        }
        EmbeddedChannel embeddedChannel = http2Decompressor.decompressor();
        int n3 = object.readableBytes() + bl2;
        http2Decompressor.incrementCompressedBytes(n3);
        try {
            void var3_8;
            void var3_7;
            embeddedChannel.writeInbound(new Object[]{object.retain()});
            ByteBuf byteBuf = DelegatingDecompressorFrameListener.nextReadableBuf(embeddedChannel);
            if (byteBuf == null && var5_13 != false && embeddedChannel.finish()) {
                ByteBuf byteBuf2 = DelegatingDecompressorFrameListener.nextReadableBuf(embeddedChannel);
            }
            if (var3_7 == null) {
                if (var5_13 != false) {
                    this.listener.onDataRead(channelHandlerContext, n, Unpooled.EMPTY_BUFFER, bl2 ? 1 : 0, true);
                }
                http2Decompressor.incrementDecompressedBytes(n3);
                return n3;
            }
            try {
                Http2LocalFlowController http2LocalFlowController = this.connection.local().flowController();
                http2Decompressor.incrementDecompressedBytes(bl2 ? 1 : 0);
                while (true) {
                    ByteBuf byteBuf3;
                    boolean bl3;
                    if ((bl3 = (byteBuf3 = DelegatingDecompressorFrameListener.nextReadableBuf(embeddedChannel)) == null && var5_13 != false) && embeddedChannel.finish()) {
                        byteBuf3 = DelegatingDecompressorFrameListener.nextReadableBuf(embeddedChannel);
                        bl3 = byteBuf3 == null;
                    }
                    http2Decompressor.incrementDecompressedBytes(var3_8.readableBytes());
                    http2LocalFlowController.consumeBytes(http2Stream, this.listener.onDataRead(channelHandlerContext, n, (ByteBuf)var3_8, bl2 ? 1 : 0, bl3));
                    if (byteBuf3 != null) {
                        bl2 = false;
                        var3_8.release();
                        ByteBuf byteBuf4 = byteBuf3;
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                var3_7.release();
                throw throwable;
            }
            var3_8.release();
            return 0;
        }
        catch (Http2Exception http2Exception) {
            Http2Exception http2Exception2 = http2Exception;
            throw http2Exception;
        }
        catch (Throwable throwable) {
            throw Http2Exception.streamError(http2Stream.id(), Http2Error.INTERNAL_ERROR, throwable, "Decompressor error detected while delegating data read on streamId %d", http2Stream.id());
        }
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, boolean bl) {
        this.initDecompressor(channelHandlerContext, n, http2Headers, bl);
        this.listener.onHeadersRead(channelHandlerContext, n, http2Headers, n2, bl);
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, short s, boolean bl, int n3, boolean bl2) {
        this.initDecompressor(channelHandlerContext, n, http2Headers, bl2);
        this.listener.onHeadersRead(channelHandlerContext, n, http2Headers, n2, s, bl, n3, bl2);
    }

    protected EmbeddedChannel newContentDecompressor(ChannelHandlerContext channelHandlerContext, CharSequence charSequence) {
        if (HttpHeaderValues.GZIP.contentEqualsIgnoreCase(charSequence) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase(charSequence)) {
            return new EmbeddedChannel(channelHandlerContext.channel().id(), channelHandlerContext.channel().metadata().hasDisconnect(), channelHandlerContext.channel().config(), new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.GZIP)});
        }
        if (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase(charSequence) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase(charSequence)) {
            charSequence = this.strict ? ZlibWrapper.ZLIB : ZlibWrapper.ZLIB_OR_NONE;
            return new EmbeddedChannel(channelHandlerContext.channel().id(), channelHandlerContext.channel().metadata().hasDisconnect(), channelHandlerContext.channel().config(), new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)charSequence)});
        }
        if (Brotli.isAvailable() && HttpHeaderValues.BR.contentEqualsIgnoreCase(charSequence)) {
            return new EmbeddedChannel(channelHandlerContext.channel().id(), channelHandlerContext.channel().metadata().hasDisconnect(), channelHandlerContext.channel().config(), new ChannelHandler[]{new BrotliDecoder()});
        }
        if (HttpHeaderValues.SNAPPY.contentEqualsIgnoreCase(charSequence)) {
            return new EmbeddedChannel(channelHandlerContext.channel().id(), channelHandlerContext.channel().metadata().hasDisconnect(), channelHandlerContext.channel().config(), new ChannelHandler[]{new SnappyFrameDecoder()});
        }
        if (Zstd.isAvailable() && HttpHeaderValues.ZSTD.contentEqualsIgnoreCase(charSequence)) {
            return new EmbeddedChannel(channelHandlerContext.channel().id(), channelHandlerContext.channel().metadata().hasDisconnect(), channelHandlerContext.channel().config(), new ChannelHandler[]{new ZstdDecoder()});
        }
        return null;
    }

    protected CharSequence getTargetContentEncoding(CharSequence charSequence) {
        return HttpHeaderValues.IDENTITY;
    }

    private void initDecompressor(ChannelHandlerContext object, int n, Http2Headers http2Headers, boolean bl) {
        Http2Stream http2Stream = this.connection.stream(n);
        if (http2Stream == null) {
            return;
        }
        Http2Decompressor http2Decompressor = this.decompressor(http2Stream);
        if (http2Decompressor == null && !bl) {
            CharSequence charSequence = (CharSequence)http2Headers.get(HttpHeaderNames.CONTENT_ENCODING);
            if (charSequence == null) {
                charSequence = HttpHeaderValues.IDENTITY;
            }
            if ((object = this.newContentDecompressor((ChannelHandlerContext)object, charSequence)) != null) {
                http2Decompressor = new Http2Decompressor((EmbeddedChannel)object);
                http2Stream.setProperty(this.propertyKey, http2Decompressor);
                object = this.getTargetContentEncoding(charSequence);
                if (HttpHeaderValues.IDENTITY.contentEqualsIgnoreCase((CharSequence)object)) {
                    http2Headers.remove(HttpHeaderNames.CONTENT_ENCODING);
                } else {
                    http2Headers.set(HttpHeaderNames.CONTENT_ENCODING, object);
                }
            }
        }
        if (http2Decompressor != null) {
            http2Headers.remove(HttpHeaderNames.CONTENT_LENGTH);
            if (!this.flowControllerInitialized) {
                this.flowControllerInitialized = true;
                DelegatingDecompressorFrameListener delegatingDecompressorFrameListener = this;
                this.connection.local().flowController(delegatingDecompressorFrameListener.new ConsumedBytesConverter(delegatingDecompressorFrameListener.connection.local().flowController()));
            }
        }
    }

    Http2Decompressor decompressor(Http2Stream http2Stream) {
        if (http2Stream == null) {
            return null;
        }
        return (Http2Decompressor)http2Stream.getProperty(this.propertyKey);
    }

    private static void cleanup(Http2Decompressor http2Decompressor) {
        http2Decompressor.decompressor().finishAndReleaseAll();
    }

    private static ByteBuf nextReadableBuf(EmbeddedChannel embeddedChannel) {
        ByteBuf byteBuf;
        while (true) {
            if ((byteBuf = (ByteBuf)embeddedChannel.readInbound()) == null) {
                return null;
            }
            if (byteBuf.isReadable()) break;
            byteBuf.release();
        }
        return byteBuf;
    }

    private static final class Http2Decompressor {
        private final EmbeddedChannel decompressor;
        private int compressed;
        private int decompressed;

        Http2Decompressor(EmbeddedChannel embeddedChannel) {
            this.decompressor = embeddedChannel;
        }

        final EmbeddedChannel decompressor() {
            return this.decompressor;
        }

        final void incrementCompressedBytes(int n) {
            assert (n >= 0);
            this.compressed += n;
        }

        final void incrementDecompressedBytes(int n) {
            assert (n >= 0);
            this.decompressed += n;
        }

        final int consumeBytes(int n, int n2) {
            ObjectUtil.checkPositiveOrZero((int)n2, (String)"decompressedBytes");
            if (this.decompressed - n2 < 0) {
                throw Http2Exception.streamError(n, Http2Error.INTERNAL_ERROR, "Attempting to return too many bytes for stream %d. decompressed: %d decompressedBytes: %d", n, this.decompressed, n2);
            }
            double d = (double)n2 / (double)this.decompressed;
            int n3 = Math.min(this.compressed, (int)Math.ceil((double)this.compressed * d));
            if (this.compressed - n3 < 0) {
                throw Http2Exception.streamError(n, Http2Error.INTERNAL_ERROR, "overflow when converting decompressed bytes to compressed bytes for stream %d.decompressedBytes: %d decompressed: %d compressed: %d consumedCompressed: %d", n, n2, this.decompressed, this.compressed, n3);
            }
            this.decompressed -= n2;
            this.compressed -= n3;
            return n3;
        }
    }

    private final class ConsumedBytesConverter
    implements Http2LocalFlowController {
        private final Http2LocalFlowController flowController;

        ConsumedBytesConverter(Http2LocalFlowController http2LocalFlowController) {
            this.flowController = (Http2LocalFlowController)ObjectUtil.checkNotNull((Object)http2LocalFlowController, (String)"flowController");
        }

        @Override
        public final Http2LocalFlowController frameWriter(Http2FrameWriter http2FrameWriter) {
            return this.flowController.frameWriter(http2FrameWriter);
        }

        @Override
        public final void channelHandlerContext(ChannelHandlerContext channelHandlerContext) {
            this.flowController.channelHandlerContext(channelHandlerContext);
        }

        @Override
        public final void initialWindowSize(int n) {
            this.flowController.initialWindowSize(n);
        }

        @Override
        public final int initialWindowSize() {
            return this.flowController.initialWindowSize();
        }

        @Override
        public final int windowSize(Http2Stream http2Stream) {
            return this.flowController.windowSize(http2Stream);
        }

        @Override
        public final void incrementWindowSize(Http2Stream http2Stream, int n) {
            this.flowController.incrementWindowSize(http2Stream, n);
        }

        @Override
        public final void receiveFlowControlledFrame(Http2Stream http2Stream, ByteBuf byteBuf, int n, boolean bl) {
            this.flowController.receiveFlowControlledFrame(http2Stream, byteBuf, n, bl);
        }

        @Override
        public final boolean consumeBytes(Http2Stream http2Stream, int n) {
            Http2Decompressor http2Decompressor = DelegatingDecompressorFrameListener.this.decompressor(http2Stream);
            if (http2Decompressor != null) {
                n = http2Decompressor.consumeBytes(http2Stream.id(), n);
            }
            try {
                return this.flowController.consumeBytes(http2Stream, n);
            }
            catch (Http2Exception http2Exception) {
                Http2Exception http2Exception2 = http2Exception;
                throw http2Exception;
            }
            catch (Throwable throwable) {
                throw Http2Exception.streamError(http2Stream.id(), Http2Error.INTERNAL_ERROR, throwable, "Error while returning bytes to flow control window", new Object[0]);
            }
        }

        @Override
        public final int unconsumedBytes(Http2Stream http2Stream) {
            return this.flowController.unconsumedBytes(http2Stream);
        }

        @Override
        public final int initialWindowSize(Http2Stream http2Stream) {
            return this.flowController.initialWindowSize(http2Stream);
        }
    }
}

