/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.HpackUtil;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;

final class HpackHuffmanEncoder {
    private final int[] codes;
    private final byte[] lengths;
    private final EncodedLengthProcessor encodedLengthProcessor = new EncodedLengthProcessor();
    private final EncodeProcessor encodeProcessor = new EncodeProcessor();

    HpackHuffmanEncoder() {
        this(HpackUtil.HUFFMAN_CODES, HpackUtil.HUFFMAN_CODE_LENGTHS);
    }

    private HpackHuffmanEncoder(int[] nArray, byte[] byArray) {
        this.codes = nArray;
        this.lengths = byArray;
    }

    public final void encode(ByteBuf object, CharSequence charSequence) {
        ObjectUtil.checkNotNull((Object)object, (String)"out");
        if (charSequence instanceof AsciiString) {
            charSequence = (AsciiString)charSequence;
            try {
                this.encodeProcessor.out = object;
                charSequence.forEachByte(this.encodeProcessor);
            }
            catch (Exception exception) {
                object = exception;
                PlatformDependent.throwException((Throwable)exception);
            }
            finally {
                this.encodeProcessor.end();
            }
        } else {
            this.encodeSlowPath((ByteBuf)object, charSequence);
        }
    }

    private void encodeSlowPath(ByteBuf byteBuf, CharSequence charSequence) {
        long l = 0L;
        int n = 0;
        for (int i = 0; i < charSequence.length(); ++i) {
            int n2 = AsciiString.c2b((char)charSequence.charAt(i)) & 0xFF;
            int n3 = this.codes[n2];
            n2 = this.lengths[n2];
            l <<= n2;
            l |= (long)n3;
            n += n2;
            while (n >= 8) {
                byteBuf.writeByte((int)(l >> (n -= 8)));
            }
        }
        if (n > 0) {
            l <<= 8 - n;
            byteBuf.writeByte((int)(l |= (long)(255 >>> n)));
        }
    }

    final int getEncodedLength(CharSequence object) {
        if (object instanceof AsciiString) {
            object = (AsciiString)object;
            try {
                this.encodedLengthProcessor.reset();
                object.forEachByte((ByteProcessor)this.encodedLengthProcessor);
                return this.encodedLengthProcessor.length();
            }
            catch (Exception exception) {
                object = exception;
                PlatformDependent.throwException((Throwable)exception);
                return -1;
            }
        }
        return this.getEncodedLengthSlowPath((CharSequence)object);
    }

    private int getEncodedLengthSlowPath(CharSequence charSequence) {
        long l = 0L;
        for (int i = 0; i < charSequence.length(); ++i) {
            l += (long)this.lengths[AsciiString.c2b((char)charSequence.charAt(i)) & 0xFF];
        }
        return (int)(l + 7L >> 3);
    }

    private final class EncodedLengthProcessor
    implements ByteProcessor {
        private long len;

        private EncodedLengthProcessor() {
        }

        public final boolean process(byte by) {
            this.len += (long)HpackHuffmanEncoder.this.lengths[by & 0xFF];
            return true;
        }

        final void reset() {
            this.len = 0L;
        }

        final int length() {
            return (int)(this.len + 7L >> 3);
        }
    }

    private final class EncodeProcessor
    implements ByteProcessor {
        ByteBuf out;
        private long current;
        private int n;

        private EncodeProcessor() {
        }

        public final boolean process(byte by) {
            by = (byte)(by & 0xFF);
            byte by2 = HpackHuffmanEncoder.this.lengths[by];
            this.current <<= by2;
            this.current |= (long)HpackHuffmanEncoder.this.codes[by];
            this.n += by2;
            while (this.n >= 8) {
                this.n -= 8;
                this.out.writeByte((int)(this.current >> this.n));
            }
            return true;
        }

        final void end() {
            try {
                if (this.n > 0) {
                    this.current <<= 8 - this.n;
                    this.current |= (long)(255 >>> this.n);
                    this.out.writeByte((int)this.current);
                }
                return;
            }
            finally {
                this.out = null;
                this.current = 0L;
                this.n = 0;
            }
        }
    }
}

