/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.DefaultHttp2PingFrame;
import io.netty.handler.codec.http2.DefaultHttp2PriorityFrame;
import io.netty.handler.codec.http2.DefaultHttp2PushPromiseFrame;
import io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import io.netty.handler.codec.http2.DefaultHttp2SettingsFrame;
import io.netty.handler.codec.http2.DefaultHttp2UnknownFrame;
import io.netty.handler.codec.http2.DefaultHttp2WindowUpdateFrame;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2FrameStreamEvent;
import io.netty.handler.codec.http2.Http2FrameStreamException;
import io.netty.handler.codec.http2.Http2FrameStreamVisitor;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2NoMoreStreamIdsException;
import io.netty.handler.codec.http2.Http2PingFrame;
import io.netty.handler.codec.http2.Http2PriorityFrame;
import io.netty.handler.codec.http2.Http2PushPromiseFrame;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2SettingsAckFrame;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.handler.codec.http2.Http2UnknownFrame;
import io.netty.handler.codec.http2.Http2WindowUpdateFrame;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.InboundHttpToHttp2Adapter;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class Http2FrameCodec
extends Http2ConnectionHandler {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(Http2FrameCodec.class);
    private static final Class<?>[] SUPPORTED_MESSAGES = new Class[]{Http2DataFrame.class, Http2HeadersFrame.class, Http2WindowUpdateFrame.class, Http2ResetFrame.class, Http2PingFrame.class, Http2SettingsFrame.class, Http2SettingsAckFrame.class, Http2GoAwayFrame.class, Http2PushPromiseFrame.class, Http2PriorityFrame.class, Http2UnknownFrame.class};
    protected final Http2Connection.PropertyKey streamKey;
    private final Http2Connection.PropertyKey upgradeKey;
    private final Integer initialFlowControlWindowSize;
    ChannelHandlerContext ctx;
    private int numBufferedStreams;
    private final IntObjectMap<DefaultHttp2FrameStream> frameStreamToInitializeMap = new IntObjectHashMap(8);

    protected Http2FrameCodec(Http2ConnectionEncoder http2ConnectionEncoder, Http2ConnectionDecoder http2ConnectionDecoder, Http2Settings http2Settings, boolean bl, boolean bl2) {
        super(http2ConnectionDecoder, http2ConnectionEncoder, http2Settings, bl, bl2);
        http2ConnectionDecoder.frameListener(new FrameListener());
        this.connection().addListener(new ConnectionListener());
        this.connection().remote().flowController().listener(new Http2RemoteFlowControllerListener());
        this.streamKey = this.connection().newKey();
        this.upgradeKey = this.connection().newKey();
        this.initialFlowControlWindowSize = http2Settings.initialWindowSize();
    }

    DefaultHttp2FrameStream newStream() {
        return new DefaultHttp2FrameStream();
    }

    final void forEachActiveStream(final Http2FrameStreamVisitor http2FrameStreamVisitor) {
        assert (this.ctx.executor().inEventLoop());
        if (this.connection().numActiveStreams() > 0) {
            this.connection().forEachActiveStream(new Http2StreamVisitor(){

                @Override
                public boolean visit(Http2Stream http2Stream) {
                    try {
                        return http2FrameStreamVisitor.visit((Http2FrameStream)http2Stream.getProperty(Http2FrameCodec.this.streamKey));
                    }
                    catch (Throwable throwable) {
                        Http2FrameCodec.this.onError(Http2FrameCodec.this.ctx, false, throwable);
                        return false;
                    }
                }
            });
        }
    }

    int numInitializingStreams() {
        return this.frameStreamToInitializeMap.size();
    }

    @Override
    public final void handlerAdded(ChannelHandlerContext object) {
        this.ctx = object;
        super.handlerAdded((ChannelHandlerContext)object);
        this.handlerAdded0((ChannelHandlerContext)object);
        object = this.connection();
        if (object.isServer()) {
            this.tryExpandConnectionFlowControlWindow((Http2Connection)object);
        }
    }

    private void tryExpandConnectionFlowControlWindow(Http2Connection object) {
        if (this.initialFlowControlWindowSize != null) {
            Http2Stream http2Stream = object.connectionStream();
            object = object.local().flowController();
            int n = this.initialFlowControlWindowSize - object.initialWindowSize(http2Stream);
            if (n > 0) {
                object.incrementWindowSize(http2Stream, Math.max(n << 1, n));
                Http2FrameCodec http2FrameCodec = this;
                http2FrameCodec.flush(http2FrameCodec.ctx);
            }
        }
    }

    void handlerAdded0(ChannelHandlerContext channelHandlerContext) {
    }

    public final void userEventTriggered(final ChannelHandlerContext channelHandlerContext, final Object object) {
        if (object == Http2ConnectionPrefaceAndSettingsFrameWrittenEvent.INSTANCE) {
            Http2FrameCodec http2FrameCodec = this;
            http2FrameCodec.tryExpandConnectionFlowControlWindow(http2FrameCodec.connection());
            channelHandlerContext.executor().execute(new Runnable(){

                @Override
                public void run() {
                    channelHandlerContext.fireUserEventTriggered(object);
                }
            });
            return;
        }
        if (object instanceof HttpServerUpgradeHandler.UpgradeEvent) {
            object = (HttpServerUpgradeHandler.UpgradeEvent)object;
            try {
                this.onUpgradeEvent(channelHandlerContext, object.retain());
                Http2Stream http2Stream = this.connection().stream(1);
                if (http2Stream.getProperty(this.streamKey) == null) {
                    this.onStreamActive0(http2Stream);
                }
                object.upgradeRequest().headers().setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 1);
                http2Stream.setProperty(this.upgradeKey, Boolean.TRUE);
                InboundHttpToHttp2Adapter.handle(channelHandlerContext, this.connection(), this.decoder().frameListener(), (FullHttpMessage)object.upgradeRequest().retain());
            }
            finally {
                object.release();
            }
        } else {
            this.onUserEventTriggered(channelHandlerContext, object);
            channelHandlerContext.fireUserEventTriggered(object);
        }
    }

    void onUserEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (object instanceof Http2DataFrame) {
            object = (Http2DataFrame)object;
            this.encoder().writeData(channelHandlerContext, object.stream().id(), object.content(), object.padding(), object.isEndStream(), channelPromise);
            return;
        }
        if (object instanceof Http2HeadersFrame) {
            this.writeHeadersFrame(channelHandlerContext, (Http2HeadersFrame)object, channelPromise);
            return;
        }
        if (object instanceof Http2WindowUpdateFrame) {
            object = (Http2WindowUpdateFrame)object;
            Http2FrameStream http2FrameStream = object.stream();
            try {
                if (http2FrameStream == null) {
                    this.increaseInitialConnectionWindow(object.windowSizeIncrement());
                } else {
                    this.consumeBytes(http2FrameStream.id(), object.windowSizeIncrement());
                }
                channelPromise.setSuccess();
                return;
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
                return;
            }
        }
        if (object instanceof Http2ResetFrame) {
            object = (Http2ResetFrame)object;
            int n = object.stream().id();
            if (this.connection().streamMayHaveExisted(n)) {
                this.encoder().writeRstStream(channelHandlerContext, object.stream().id(), object.errorCode(), channelPromise);
                return;
            }
            ReferenceCountUtil.release((Object)object);
            channelPromise.setFailure((Throwable)Http2Exception.streamError(object.stream().id(), Http2Error.PROTOCOL_ERROR, "Stream never existed", new Object[0]));
            return;
        }
        if (object instanceof Http2PingFrame) {
            object = (Http2PingFrame)object;
            this.encoder().writePing(channelHandlerContext, object.ack(), object.content(), channelPromise);
            return;
        }
        if (object instanceof Http2SettingsFrame) {
            this.encoder().writeSettings(channelHandlerContext, ((Http2SettingsFrame)object).settings(), channelPromise);
            return;
        }
        if (object instanceof Http2SettingsAckFrame) {
            this.encoder().writeSettingsAck(channelHandlerContext, channelPromise);
            return;
        }
        if (object instanceof Http2GoAwayFrame) {
            this.writeGoAwayFrame(channelHandlerContext, (Http2GoAwayFrame)object, channelPromise);
            return;
        }
        if (object instanceof Http2PushPromiseFrame) {
            object = (Http2PushPromiseFrame)object;
            this.writePushPromise(channelHandlerContext, (Http2PushPromiseFrame)object, channelPromise);
            return;
        }
        if (object instanceof Http2PriorityFrame) {
            object = (Http2PriorityFrame)object;
            this.encoder().writePriority(channelHandlerContext, object.stream().id(), object.streamDependency(), object.weight(), object.exclusive(), channelPromise);
            return;
        }
        if (object instanceof Http2UnknownFrame) {
            object = (Http2UnknownFrame)object;
            this.encoder().writeFrame(channelHandlerContext, object.frameType(), object.stream().id(), object.flags(), object.content(), channelPromise);
            return;
        }
        if (!(object instanceof Http2Frame)) {
            channelHandlerContext.write(object, channelPromise);
            return;
        }
        ReferenceCountUtil.release((Object)object);
        throw new UnsupportedMessageTypeException(object, (Class[])SUPPORTED_MESSAGES);
    }

    private void increaseInitialConnectionWindow(int n) {
        this.connection().local().flowController().incrementWindowSize(this.connection().connectionStream(), n);
    }

    final boolean consumeBytes(int n, int n2) {
        Boolean bl;
        Http2Stream http2Stream = this.connection().stream(n);
        if (http2Stream != null && n == 1 && Boolean.TRUE.equals(bl = (Boolean)http2Stream.getProperty(this.upgradeKey))) {
            return false;
        }
        return this.connection().local().flowController().consumeBytes(http2Stream, n2);
    }

    private void writeGoAwayFrame(ChannelHandlerContext channelHandlerContext, Http2GoAwayFrame http2GoAwayFrame, ChannelPromise channelPromise) {
        if (http2GoAwayFrame.lastStreamId() >= 0) {
            http2GoAwayFrame.release();
            throw new IllegalArgumentException("Last stream id must not be set on GOAWAY frame");
        }
        int n = this.connection().remote().lastStreamCreated();
        long l = (long)n + ((long)http2GoAwayFrame.extraStreamIds() << 1);
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        this.goAway(channelHandlerContext, (int)l, http2GoAwayFrame.errorCode(), http2GoAwayFrame.content(), channelPromise);
    }

    private void writeHeadersFrame(ChannelHandlerContext channelHandlerContext, Http2HeadersFrame http2HeadersFrame, ChannelPromise channelPromise) {
        if (Http2CodecUtil.isStreamIdValid(http2HeadersFrame.stream().id())) {
            this.encoder().writeHeaders(channelHandlerContext, http2HeadersFrame.stream().id(), http2HeadersFrame.headers(), http2HeadersFrame.padding(), http2HeadersFrame.isEndStream(), channelPromise);
            return;
        }
        if (this.initializeNewStream(channelHandlerContext, (DefaultHttp2FrameStream)http2HeadersFrame.stream(), channelPromise)) {
            channelPromise = channelPromise.unvoid();
            final int n = http2HeadersFrame.stream().id();
            this.encoder().writeHeaders(channelHandlerContext, n, http2HeadersFrame.headers(), http2HeadersFrame.padding(), http2HeadersFrame.isEndStream(), channelPromise);
            if (!channelPromise.isDone()) {
                ++this.numBufferedStreams;
                channelPromise.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture channelFuture) {
                        Http2FrameCodec.this.numBufferedStreams--;
                        Http2FrameCodec.this.handleHeaderFuture(channelFuture, n);
                    }
                });
                return;
            }
            this.handleHeaderFuture((ChannelFuture)channelPromise, n);
        }
    }

    private void writePushPromise(ChannelHandlerContext channelHandlerContext, Http2PushPromiseFrame http2PushPromiseFrame, ChannelPromise channelPromise) {
        if (Http2CodecUtil.isStreamIdValid(http2PushPromiseFrame.pushStream().id())) {
            this.encoder().writePushPromise(channelHandlerContext, http2PushPromiseFrame.stream().id(), http2PushPromiseFrame.pushStream().id(), http2PushPromiseFrame.http2Headers(), http2PushPromiseFrame.padding(), channelPromise);
            return;
        }
        if (this.initializeNewStream(channelHandlerContext, (DefaultHttp2FrameStream)http2PushPromiseFrame.pushStream(), channelPromise)) {
            final int n = http2PushPromiseFrame.stream().id();
            this.encoder().writePushPromise(channelHandlerContext, n, http2PushPromiseFrame.pushStream().id(), http2PushPromiseFrame.http2Headers(), http2PushPromiseFrame.padding(), channelPromise);
            if (channelPromise.isDone()) {
                this.handleHeaderFuture((ChannelFuture)channelPromise, n);
                return;
            }
            ++this.numBufferedStreams;
            channelPromise.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) {
                    Http2FrameCodec.this.numBufferedStreams--;
                    Http2FrameCodec.this.handleHeaderFuture(channelFuture, n);
                }
            });
        }
    }

    private boolean initializeNewStream(ChannelHandlerContext object, DefaultHttp2FrameStream defaultHttp2FrameStream, ChannelPromise channelPromise) {
        Http2Connection http2Connection = this.connection();
        int n = http2Connection.local().incrementAndGetNextStreamId();
        if (n < 0) {
            channelPromise.setFailure((Throwable)new Http2NoMoreStreamIdsException());
            this.onHttp2Frame((ChannelHandlerContext)object, new DefaultHttp2GoAwayFrame(http2Connection.isServer() ? Integer.MAX_VALUE : 0x7FFFFFFE, Http2Error.NO_ERROR.code(), ByteBufUtil.writeAscii((ByteBufAllocator)object.alloc(), (CharSequence)"Stream IDs exhausted on local stream creation")));
            return false;
        }
        defaultHttp2FrameStream.id = n;
        object = this.frameStreamToInitializeMap.put(n, (Object)defaultHttp2FrameStream);
        assert (object == null);
        return true;
    }

    private void handleHeaderFuture(ChannelFuture channelFuture, int n) {
        if (!channelFuture.isSuccess()) {
            this.frameStreamToInitializeMap.remove(n);
        }
    }

    private void onStreamActive0(Http2Stream object) {
        if (object.id() != 1 && this.connection().local().isValidStreamId(object.id())) {
            return;
        }
        object = this.newStream().setStreamAndProperty(this.streamKey, (Http2Stream)object);
        Http2FrameCodec http2FrameCodec = this;
        http2FrameCodec.onHttp2StreamStateChanged(http2FrameCodec.ctx, (DefaultHttp2FrameStream)object);
    }

    @Override
    protected void onConnectionError(ChannelHandlerContext channelHandlerContext, boolean bl, Throwable throwable, Http2Exception http2Exception) {
        if (!bl) {
            channelHandlerContext.fireExceptionCaught(throwable);
        }
        super.onConnectionError(channelHandlerContext, bl, throwable, http2Exception);
    }

    @Override
    protected final void onStreamError(ChannelHandlerContext channelHandlerContext, boolean bl, Throwable throwable, Http2Exception.StreamException streamException) {
        int n = streamException.streamId();
        Object object = this.connection().stream(n);
        if (object == null) {
            Http2FrameCodec.onHttp2UnknownStreamError(channelHandlerContext, throwable, streamException);
            super.onStreamError(channelHandlerContext, bl, throwable, streamException);
            return;
        }
        if ((object = (Http2FrameStream)object.getProperty(this.streamKey)) == null) {
            LOG.warn("Stream exception thrown without stream object attached.", throwable);
            super.onStreamError(channelHandlerContext, bl, throwable, streamException);
            return;
        }
        if (!bl) {
            this.onHttp2FrameStreamException(channelHandlerContext, new Http2FrameStreamException((Http2FrameStream)object, streamException.error(), throwable));
        }
    }

    private static void onHttp2UnknownStreamError(ChannelHandlerContext channelHandlerContext, Throwable throwable, Http2Exception.StreamException streamException) {
        LOG.log(InternalLogLevel.DEBUG, "Stream exception thrown for unknown stream {}.", (Object)streamException.streamId(), (Object)throwable);
    }

    @Override
    protected final boolean isGracefulShutdownComplete() {
        return super.isGracefulShutdownComplete() && this.numBufferedStreams == 0;
    }

    private void onUpgradeEvent(ChannelHandlerContext channelHandlerContext, HttpServerUpgradeHandler.UpgradeEvent upgradeEvent) {
        channelHandlerContext.fireUserEventTriggered((Object)upgradeEvent);
    }

    private void onHttp2StreamWritabilityChanged(ChannelHandlerContext channelHandlerContext, DefaultHttp2FrameStream defaultHttp2FrameStream, boolean bl) {
        channelHandlerContext.fireUserEventTriggered((Object)defaultHttp2FrameStream.writabilityChanged);
    }

    void onHttp2StreamStateChanged(ChannelHandlerContext channelHandlerContext, DefaultHttp2FrameStream defaultHttp2FrameStream) {
        channelHandlerContext.fireUserEventTriggered((Object)defaultHttp2FrameStream.stateChanged);
    }

    void onHttp2Frame(ChannelHandlerContext channelHandlerContext, Http2Frame http2Frame) {
        channelHandlerContext.fireChannelRead((Object)http2Frame);
    }

    protected Http2StreamFrame newHttp2UnknownFrame(byte by, int n, Http2Flags http2Flags, ByteBuf byteBuf) {
        return new DefaultHttp2UnknownFrame(by, http2Flags, byteBuf);
    }

    void onHttp2FrameStreamException(ChannelHandlerContext channelHandlerContext, Http2FrameStreamException http2FrameStreamException) {
        channelHandlerContext.fireExceptionCaught((Throwable)http2FrameStreamException);
    }

    static class DefaultHttp2FrameStream
    implements Http2FrameStream {
        private volatile int id = -1;
        private volatile Http2Stream stream;
        final Http2FrameStreamEvent stateChanged = Http2FrameStreamEvent.stateChanged(this);
        final Http2FrameStreamEvent writabilityChanged = Http2FrameStreamEvent.writabilityChanged(this);
        Channel attachment;

        DefaultHttp2FrameStream() {
        }

        DefaultHttp2FrameStream setStreamAndProperty(Http2Connection.PropertyKey propertyKey, Http2Stream http2Stream) {
            assert (this.id == -1 || http2Stream.id() == this.id);
            this.stream = http2Stream;
            http2Stream.setProperty(propertyKey, this);
            return this;
        }

        @Override
        public int id() {
            Http2Stream http2Stream = this.stream;
            if (http2Stream == null) {
                return this.id;
            }
            return http2Stream.id();
        }

        @Override
        public Http2Stream.State state() {
            Http2Stream http2Stream = this.stream;
            if (http2Stream == null) {
                return Http2Stream.State.IDLE;
            }
            return http2Stream.state();
        }

        public String toString() {
            return String.valueOf(this.id());
        }
    }

    private final class Http2RemoteFlowControllerListener
    implements Http2RemoteFlowController.Listener {
        private Http2RemoteFlowControllerListener() {
        }

        @Override
        public final void writabilityChanged(Http2Stream http2Stream) {
            DefaultHttp2FrameStream defaultHttp2FrameStream = (DefaultHttp2FrameStream)http2Stream.getProperty(Http2FrameCodec.this.streamKey);
            if (defaultHttp2FrameStream == null) {
                return;
            }
            Http2FrameCodec.this.onHttp2StreamWritabilityChanged(Http2FrameCodec.this.ctx, defaultHttp2FrameStream, Http2FrameCodec.this.connection().remote().flowController().isWritable(http2Stream));
        }
    }

    private final class FrameListener
    implements Http2FrameListener {
        private FrameListener() {
        }

        @Override
        public final void onUnknownFrame(ChannelHandlerContext channelHandlerContext, byte by, int n, Http2Flags http2Flags, ByteBuf byteBuf) {
            if (n == 0) {
                return;
            }
            Http2FrameStream http2FrameStream = this.requireStream(n);
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, Http2FrameCodec.this.newHttp2UnknownFrame(by, n, http2Flags, byteBuf.retain()).stream(http2FrameStream));
        }

        @Override
        public final void onSettingsRead(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings) {
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, new DefaultHttp2SettingsFrame(http2Settings));
        }

        @Override
        public final void onPingRead(ChannelHandlerContext channelHandlerContext, long l) {
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, new DefaultHttp2PingFrame(l, false));
        }

        @Override
        public final void onPingAckRead(ChannelHandlerContext channelHandlerContext, long l) {
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, new DefaultHttp2PingFrame(l, true));
        }

        @Override
        public final void onRstStreamRead(ChannelHandlerContext channelHandlerContext, int n, long l) {
            Http2FrameStream http2FrameStream = this.requireStream(n);
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, new DefaultHttp2ResetFrame(l).stream(http2FrameStream));
        }

        @Override
        public final void onWindowUpdateRead(ChannelHandlerContext channelHandlerContext, int n, int n2) {
            if (n == 0) {
                return;
            }
            Http2FrameStream http2FrameStream = this.requireStream(n);
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, new DefaultHttp2WindowUpdateFrame(n2).stream(http2FrameStream));
        }

        @Override
        public final void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, short s, boolean bl, int n3, boolean bl2) {
            this.onHeadersRead(channelHandlerContext, n, http2Headers, n3, bl2);
        }

        @Override
        public final void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, boolean bl) {
            Http2FrameStream http2FrameStream = this.requireStream(n);
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, new DefaultHttp2HeadersFrame(http2Headers, bl, n2).stream(http2FrameStream));
        }

        @Override
        public final int onDataRead(ChannelHandlerContext channelHandlerContext, int n, ByteBuf byteBuf, int n2, boolean bl) {
            DefaultHttp2DataFrame defaultHttp2DataFrame;
            Http2FrameStream http2FrameStream = this.requireStream(n);
            try {
                defaultHttp2DataFrame = new DefaultHttp2DataFrame(byteBuf.retain(), bl, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                byteBuf.release();
                throw illegalArgumentException;
            }
            defaultHttp2DataFrame.stream(http2FrameStream);
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, defaultHttp2DataFrame);
            return 0;
        }

        @Override
        public final void onGoAwayRead(ChannelHandlerContext channelHandlerContext, int n, long l, ByteBuf byteBuf) {
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, new DefaultHttp2GoAwayFrame(n, l, byteBuf.retain()));
        }

        @Override
        public final void onPriorityRead(ChannelHandlerContext channelHandlerContext, int n, int n2, short s, boolean bl) {
            Http2Stream http2Stream = Http2FrameCodec.this.connection().stream(n);
            if (http2Stream == null) {
                return;
            }
            Http2FrameStream http2FrameStream = this.requireStream(n);
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, new DefaultHttp2PriorityFrame(n2, s, bl).stream(http2FrameStream));
        }

        @Override
        public final void onSettingsAckRead(ChannelHandlerContext channelHandlerContext) {
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, Http2SettingsAckFrame.INSTANCE);
        }

        @Override
        public final void onPushPromiseRead(ChannelHandlerContext channelHandlerContext, int n, int n2, Http2Headers http2Headers, int n3) {
            Http2FrameStream http2FrameStream = this.requireStream(n);
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, new DefaultHttp2PushPromiseFrame(http2Headers, n3, n2).pushStream(new DefaultHttp2FrameStream().setStreamAndProperty(Http2FrameCodec.this.streamKey, Http2FrameCodec.this.connection().stream(n2))).stream(http2FrameStream));
        }

        private Http2FrameStream requireStream(int n) {
            Http2FrameStream http2FrameStream = (Http2FrameStream)Http2FrameCodec.this.connection().stream(n).getProperty(Http2FrameCodec.this.streamKey);
            if (http2FrameStream == null) {
                throw new IllegalStateException("Stream object required for identifier: " + n);
            }
            return http2FrameStream;
        }
    }

    private final class ConnectionListener
    extends Http2ConnectionAdapter {
        private ConnectionListener() {
        }

        @Override
        public final void onStreamAdded(Http2Stream http2Stream) {
            DefaultHttp2FrameStream defaultHttp2FrameStream = (DefaultHttp2FrameStream)Http2FrameCodec.this.frameStreamToInitializeMap.remove(http2Stream.id());
            if (defaultHttp2FrameStream != null) {
                defaultHttp2FrameStream.setStreamAndProperty(Http2FrameCodec.this.streamKey, http2Stream);
            }
        }

        @Override
        public final void onStreamActive(Http2Stream http2Stream) {
            Http2FrameCodec.this.onStreamActive0(http2Stream);
        }

        @Override
        public final void onStreamClosed(Http2Stream http2Stream) {
            this.onHttp2StreamStateChanged0(http2Stream);
        }

        @Override
        public final void onStreamHalfClosed(Http2Stream http2Stream) {
            this.onHttp2StreamStateChanged0(http2Stream);
        }

        private void onHttp2StreamStateChanged0(Http2Stream object) {
            if ((object = (DefaultHttp2FrameStream)object.getProperty(Http2FrameCodec.this.streamKey)) != null) {
                Http2FrameCodec.this.onHttp2StreamStateChanged(Http2FrameCodec.this.ctx, (DefaultHttp2FrameStream)object);
            }
        }
    }
}

