/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.logging.LogLevel;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class Http2FrameLogger
extends ChannelHandlerAdapter {
    private static final int BUFFER_LENGTH_THRESHOLD = 64;
    private final InternalLogger logger;
    private final InternalLogLevel level;

    public Http2FrameLogger(LogLevel logLevel) {
        this(Http2FrameLogger.checkAndConvertLevel(logLevel), InternalLoggerFactory.getInstance(Http2FrameLogger.class));
    }

    public Http2FrameLogger(LogLevel logLevel, String string) {
        this(Http2FrameLogger.checkAndConvertLevel(logLevel), InternalLoggerFactory.getInstance((String)((String)ObjectUtil.checkNotNull((Object)string, (String)"name"))));
    }

    public Http2FrameLogger(LogLevel logLevel, Class<?> clazz) {
        this(Http2FrameLogger.checkAndConvertLevel(logLevel), InternalLoggerFactory.getInstance((Class)((Class)ObjectUtil.checkNotNull(clazz, (String)"clazz"))));
    }

    private Http2FrameLogger(InternalLogLevel internalLogLevel, InternalLogger internalLogger) {
        this.level = internalLogLevel;
        this.logger = internalLogger;
    }

    private static InternalLogLevel checkAndConvertLevel(LogLevel logLevel) {
        return ((LogLevel)ObjectUtil.checkNotNull((Object)logLevel, (String)"level")).toInternalLevel();
    }

    public boolean isEnabled() {
        return this.logger.isEnabled(this.level);
    }

    public void logData(Direction direction, ChannelHandlerContext channelHandlerContext, int n, ByteBuf byteBuf, int n2, boolean bl) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} DATA: streamId={} padding={} endStream={} length={} bytes={}", new Object[]{channelHandlerContext.channel(), direction.name(), n, n2, bl, byteBuf.readableBytes(), this.toString(byteBuf)});
        }
    }

    public void logHeaders(Direction direction, ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, boolean bl) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} HEADERS: streamId={} headers={} padding={} endStream={}", new Object[]{channelHandlerContext.channel(), direction.name(), n, http2Headers, n2, bl});
        }
    }

    public void logHeaders(Direction direction, ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, short s, boolean bl, int n3, boolean bl2) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} HEADERS: streamId={} headers={} streamDependency={} weight={} exclusive={} padding={} endStream={}", new Object[]{channelHandlerContext.channel(), direction.name(), n, http2Headers, n2, s, bl, n3, bl2});
        }
    }

    public void logPriority(Direction direction, ChannelHandlerContext channelHandlerContext, int n, int n2, short s, boolean bl) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} PRIORITY: streamId={} streamDependency={} weight={} exclusive={}", new Object[]{channelHandlerContext.channel(), direction.name(), n, n2, s, bl});
        }
    }

    public void logRstStream(Direction direction, ChannelHandlerContext channelHandlerContext, int n, long l) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} RST_STREAM: streamId={} errorCode={}", new Object[]{channelHandlerContext.channel(), direction.name(), n, l});
        }
    }

    public void logSettingsAck(Direction direction, ChannelHandlerContext channelHandlerContext) {
        this.logger.log(this.level, "{} {} SETTINGS: ack=true", (Object)channelHandlerContext.channel(), (Object)direction.name());
    }

    public void logSettings(Direction direction, ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} SETTINGS: ack=false settings={}", new Object[]{channelHandlerContext.channel(), direction.name(), http2Settings});
        }
    }

    public void logPing(Direction direction, ChannelHandlerContext channelHandlerContext, long l) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} PING: ack=false bytes={}", new Object[]{channelHandlerContext.channel(), direction.name(), l});
        }
    }

    public void logPingAck(Direction direction, ChannelHandlerContext channelHandlerContext, long l) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} PING: ack=true bytes={}", new Object[]{channelHandlerContext.channel(), direction.name(), l});
        }
    }

    public void logPushPromise(Direction direction, ChannelHandlerContext channelHandlerContext, int n, int n2, Http2Headers http2Headers, int n3) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} PUSH_PROMISE: streamId={} promisedStreamId={} headers={} padding={}", new Object[]{channelHandlerContext.channel(), direction.name(), n, n2, http2Headers, n3});
        }
    }

    public void logGoAway(Direction direction, ChannelHandlerContext channelHandlerContext, int n, long l, ByteBuf byteBuf) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} GO_AWAY: lastStreamId={} errorCode={} length={} bytes={}", new Object[]{channelHandlerContext.channel(), direction.name(), n, l, byteBuf.readableBytes(), this.toString(byteBuf)});
        }
    }

    public void logWindowsUpdate(Direction direction, ChannelHandlerContext channelHandlerContext, int n, int n2) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} WINDOW_UPDATE: streamId={} windowSizeIncrement={}", new Object[]{channelHandlerContext.channel(), direction.name(), n, n2});
        }
    }

    public void logUnknownFrame(Direction direction, ChannelHandlerContext channelHandlerContext, byte by, int n, Http2Flags http2Flags, ByteBuf byteBuf) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} UNKNOWN: frameType={} streamId={} flags={} length={} bytes={}", new Object[]{channelHandlerContext.channel(), direction.name(), by & 0xFF, n, http2Flags.value(), byteBuf.readableBytes(), this.toString(byteBuf)});
        }
    }

    private String toString(ByteBuf byteBuf) {
        if (this.level == InternalLogLevel.TRACE || byteBuf.readableBytes() <= 64) {
            return ByteBufUtil.hexDump((ByteBuf)byteBuf);
        }
        int n = Math.min(byteBuf.readableBytes(), 64);
        ByteBuf byteBuf2 = byteBuf;
        return ByteBufUtil.hexDump((ByteBuf)byteBuf2, (int)byteBuf2.readerIndex(), (int)n) + "...";
    }

    public static enum Direction {
        INBOUND,
        OUTBOUND;

    }
}

