/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.StreamByteDistributor;
import io.netty.util.collection.IntCollections;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.internal.DefaultPriorityQueue;
import io.netty.util.internal.EmptyPriorityQueue;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PriorityQueue;
import io.netty.util.internal.PriorityQueueNode;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public final class WeightedFairQueueByteDistributor
implements StreamByteDistributor {
    static final int INITIAL_CHILDREN_MAP_SIZE = Math.max(1, SystemPropertyUtil.getInt((String)"io.netty.http2.childrenMapSize", (int)2));
    private static final int DEFAULT_MAX_STATE_ONLY_SIZE = 5;
    private final Http2Connection.PropertyKey stateKey;
    private final IntObjectMap<State> stateOnlyMap;
    private final PriorityQueue<State> stateOnlyRemovalQueue;
    private final Http2Connection connection;
    private final State connectionState;
    private int allocationQuantum = 1024;
    private final int maxStateOnlySize;

    public WeightedFairQueueByteDistributor(Http2Connection http2Connection) {
        this(http2Connection, 5);
    }

    public WeightedFairQueueByteDistributor(Http2Connection http2Connection, int n) {
        ObjectUtil.checkPositiveOrZero((int)n, (String)"maxStateOnlySize");
        if (n == 0) {
            this.stateOnlyMap = IntCollections.emptyMap();
            this.stateOnlyRemovalQueue = EmptyPriorityQueue.instance();
        } else {
            this.stateOnlyMap = new IntObjectHashMap(n);
            this.stateOnlyRemovalQueue = new DefaultPriorityQueue((Comparator)StateOnlyComparator.INSTANCE, n + 2);
        }
        this.maxStateOnlySize = n;
        this.connection = http2Connection;
        this.stateKey = http2Connection.newKey();
        Http2Stream http2Stream = http2Connection.connectionStream();
        this.connectionState = new State(http2Stream, 16);
        http2Stream.setProperty(this.stateKey, this.connectionState);
        http2Connection.addListener(new Http2ConnectionAdapter(){

            @Override
            public void onStreamAdded(Http2Stream http2Stream) {
                State state = (State)WeightedFairQueueByteDistributor.this.stateOnlyMap.remove(http2Stream.id());
                if (state == null) {
                    state = new State(http2Stream);
                    ArrayList<ParentChangedEvent> arrayList = new ArrayList<ParentChangedEvent>(1);
                    WeightedFairQueueByteDistributor.this.connectionState.takeChild(state, false, arrayList);
                    WeightedFairQueueByteDistributor.this.notifyParentChanged(arrayList);
                } else {
                    WeightedFairQueueByteDistributor.this.stateOnlyRemovalQueue.removeTyped((Object)state);
                    state.stream = http2Stream;
                }
                switch (http2Stream.state()) {
                    case RESERVED_REMOTE: 
                    case RESERVED_LOCAL: {
                        state.setStreamReservedOrActivated();
                    }
                }
                http2Stream.setProperty(WeightedFairQueueByteDistributor.this.stateKey, state);
            }

            @Override
            public void onStreamActive(Http2Stream http2Stream) {
                WeightedFairQueueByteDistributor.this.state(http2Stream).setStreamReservedOrActivated();
            }

            @Override
            public void onStreamClosed(Http2Stream http2Stream) {
                WeightedFairQueueByteDistributor.this.state(http2Stream).close();
            }

            @Override
            public void onStreamRemoved(Http2Stream object) {
                object = WeightedFairQueueByteDistributor.this.state((Http2Stream)object);
                v0.stream = null;
                if (WeightedFairQueueByteDistributor.this.maxStateOnlySize == 0) {
                    ((State)object).parent.removeChild((State)object);
                    return;
                }
                if (WeightedFairQueueByteDistributor.this.stateOnlyRemovalQueue.size() == WeightedFairQueueByteDistributor.this.maxStateOnlySize) {
                    State state = (State)WeightedFairQueueByteDistributor.this.stateOnlyRemovalQueue.peek();
                    if (StateOnlyComparator.INSTANCE.compare(state, (State)object) >= 0) {
                        ((State)object).parent.removeChild((State)object);
                        return;
                    }
                    WeightedFairQueueByteDistributor.this.stateOnlyRemovalQueue.poll();
                    state.parent.removeChild(state);
                    WeightedFairQueueByteDistributor.this.stateOnlyMap.remove(state.streamId);
                }
                WeightedFairQueueByteDistributor.this.stateOnlyRemovalQueue.add(object);
                WeightedFairQueueByteDistributor.this.stateOnlyMap.put(((State)object).streamId, object);
            }
        });
    }

    @Override
    public final void updateStreamableBytes(StreamByteDistributor.StreamState streamState) {
        this.state(streamState.stream()).updateStreamableBytes(Http2CodecUtil.streamableBytes(streamState), streamState.hasFrame() && streamState.windowSize() >= 0);
    }

    @Override
    public final void updateDependencyTree(int n, int n2, short s, boolean bl) {
        State state;
        State state2 = this.state(n);
        if (state2 == null) {
            if (this.maxStateOnlySize == 0) {
                return;
            }
            state2 = new State(n);
            this.stateOnlyRemovalQueue.add((Object)state2);
            this.stateOnlyMap.put(n, (Object)state2);
        }
        if ((state = this.state(n2)) == null) {
            if (this.maxStateOnlySize == 0) {
                return;
            }
            state = new State(n2);
            this.stateOnlyRemovalQueue.add((Object)state);
            this.stateOnlyMap.put(n2, (Object)state);
            ArrayList<ParentChangedEvent> arrayList = new ArrayList<ParentChangedEvent>(1);
            this.connectionState.takeChild(state, false, arrayList);
            this.notifyParentChanged(arrayList);
        }
        if (state2.activeCountForTree != 0 && state2.parent != null) {
            state2.parent.totalQueuedWeights += (long)(s - state2.weight);
        }
        state2.weight = s;
        if (state != state2.parent || bl && state.children.size() != 1) {
            ArrayList<ParentChangedEvent> arrayList;
            if (state.isDescendantOf(state2)) {
                arrayList = new ArrayList<ParentChangedEvent>(2 + (bl ? state.children.size() : 0));
                state2.parent.takeChild(state, false, arrayList);
            } else {
                arrayList = new ArrayList(1 + (bl ? state.children.size() : 0));
            }
            state.takeChild(state2, bl, arrayList);
            this.notifyParentChanged(arrayList);
        }
        while (this.stateOnlyRemovalQueue.size() > this.maxStateOnlySize) {
            State state3 = (State)this.stateOnlyRemovalQueue.poll();
            state3.parent.removeChild(state3);
            this.stateOnlyMap.remove(state3.streamId);
        }
    }

    @Override
    public final boolean distribute(int n, StreamByteDistributor.Writer writer) {
        int n2;
        if (this.connectionState.activeCountForTree == 0) {
            return false;
        }
        do {
            n2 = this.connectionState.activeCountForTree;
            n -= this.distributeToChildren(n, writer, this.connectionState);
        } while (this.connectionState.activeCountForTree != 0 && (n > 0 || n2 != this.connectionState.activeCountForTree));
        return this.connectionState.activeCountForTree != 0;
    }

    public final void allocationQuantum(int n) {
        ObjectUtil.checkPositive((int)n, (String)"allocationQuantum");
        this.allocationQuantum = n;
    }

    private int distribute(int n, StreamByteDistributor.Writer writer, State state) {
        if (state.isActive()) {
            int n2 = Math.min(n, state.streamableBytes);
            state.write(n2, writer);
            if (n2 == 0 && n != 0) {
                State state2 = state;
                state2.updateStreamableBytes(state2.streamableBytes, false);
            }
            return n2;
        }
        return this.distributeToChildren(n, writer, state);
    }

    private int distributeToChildren(int n, StreamByteDistributor.Writer writer, State state) {
        long l = state.totalQueuedWeights;
        State state2 = state.pollPseudoTimeQueue();
        State state3 = state.peekPseudoTimeQueue();
        state2.setDistributing();
        try {
            assert (state3 == null || state3.pseudoTimeToWrite >= state2.pseudoTimeToWrite) : "nextChildState[" + state3.streamId + "].pseudoTime(" + state3.pseudoTimeToWrite + ") <  childState[" + state2.streamId + "].pseudoTime(" + state2.pseudoTimeToWrite + ')';
            n = this.distribute(state3 == null ? n : Math.min(n, (int)Math.min((state3.pseudoTimeToWrite - state2.pseudoTimeToWrite) * (long)state2.weight / l + (long)this.allocationQuantum, Integer.MAX_VALUE)), writer, state2);
            state.pseudoTime += (long)n;
            state2.updatePseudoTime(state, n, l);
            return n;
        }
        finally {
            state2.unsetDistributing();
            if (state2.activeCountForTree != 0) {
                state.offerPseudoTimeQueue(state2);
            }
        }
    }

    private State state(Http2Stream http2Stream) {
        return (State)http2Stream.getProperty(this.stateKey);
    }

    private State state(int n) {
        Http2Stream http2Stream = this.connection.stream(n);
        if (http2Stream != null) {
            return this.state(http2Stream);
        }
        return (State)this.stateOnlyMap.get(n);
    }

    final boolean isChild(int n, int n2, short s) {
        State state = this.state(n2);
        if (state.children.containsKey(n)) {
            State state2 = this.state(n);
            if (state2.parent == state && state2.weight == s) {
                return true;
            }
        }
        return false;
    }

    final int numChildren(int n) {
        State state = this.state(n);
        if (state == null) {
            return 0;
        }
        return state.children.size();
    }

    final void notifyParentChanged(List<ParentChangedEvent> list) {
        for (int i = 0; i < list.size(); ++i) {
            ParentChangedEvent parentChangedEvent = list.get(i);
            this.stateOnlyRemovalQueue.priorityChanged((Object)parentChangedEvent.state);
            if (parentChangedEvent.state.parent == null || parentChangedEvent.state.activeCountForTree == 0) continue;
            parentChangedEvent.state.parent.offerAndInitializePseudoTime(parentChangedEvent.state);
            parentChangedEvent.state.parent.activeCountChangeForTree(parentChangedEvent.state.activeCountForTree);
        }
    }

    private static final class ParentChangedEvent {
        final State state;
        final State oldParent;

        ParentChangedEvent(State state, State state2) {
            this.state = state;
            this.oldParent = state2;
        }
    }

    private final class State
    implements PriorityQueueNode {
        private static final byte STATE_IS_ACTIVE = 1;
        private static final byte STATE_IS_DISTRIBUTING = 2;
        private static final byte STATE_STREAM_ACTIVATED = 4;
        Http2Stream stream;
        State parent;
        IntObjectMap<State> children = IntCollections.emptyMap();
        private final PriorityQueue<State> pseudoTimeQueue;
        final int streamId;
        int streamableBytes;
        int dependencyTreeDepth;
        int activeCountForTree;
        private int pseudoTimeQueueIndex = -1;
        private int stateOnlyQueueIndex = -1;
        long pseudoTimeToWrite;
        long pseudoTime;
        long totalQueuedWeights;
        private byte flags;
        short weight = (short)16;

        State(int n) {
            this(n, null, 0);
        }

        State(Http2Stream http2Stream) {
            this(http2Stream, 0);
        }

        State(Http2Stream http2Stream, int n) {
            this(http2Stream.id(), http2Stream, n);
        }

        State(int n, Http2Stream http2Stream, int n2) {
            this.stream = http2Stream;
            this.streamId = n;
            this.pseudoTimeQueue = new DefaultPriorityQueue((Comparator)StatePseudoTimeComparator.INSTANCE, n2);
        }

        final boolean isDescendantOf(State state) {
            State state2 = this.parent;
            while (state2 != null) {
                if (state2 == state) {
                    return true;
                }
                state2 = state2.parent;
            }
            return false;
        }

        final void takeChild(State state, boolean bl, List<ParentChangedEvent> list) {
            this.takeChild(null, state, bl, list);
        }

        final void takeChild(Iterator<IntObjectMap.PrimitiveEntry<State>> object, State state, boolean bl, List<ParentChangedEvent> list) {
            State state2 = state.parent;
            if (state2 != this) {
                list.add(new ParentChangedEvent(state, state2));
                state.setParent(this);
                if (object != null) {
                    object.remove();
                } else if (state2 != null) {
                    state2.children.remove(state.streamId);
                }
                this.initChildrenIfEmpty();
                object = (State)this.children.put(state.streamId, (Object)state);
                assert (object == null) : "A stream with the same stream ID was already in the child map.";
            }
            if (bl && !this.children.isEmpty()) {
                object = this.removeAllChildrenExcept(state).entries().iterator();
                while (object.hasNext()) {
                    Iterator<Object> iterator = object;
                    state.takeChild(iterator, (State)((IntObjectMap.PrimitiveEntry)iterator.next()).value(), false, list);
                }
            }
        }

        final void removeChild(State state) {
            if (this.children.remove(state.streamId) != null) {
                ArrayList<ParentChangedEvent> arrayList = new ArrayList<ParentChangedEvent>(1 + state.children.size());
                State state2 = state;
                arrayList.add(new ParentChangedEvent(state2, state2.parent));
                state.setParent(null);
                if (!state.children.isEmpty()) {
                    Iterator<IntObjectMap.PrimitiveEntry<State>> iterator = state.children.entries().iterator();
                    long l = state.getTotalWeight();
                    do {
                        State state3 = (State)((IntObjectMap.PrimitiveEntry)iterator.next()).value();
                        ((State)((IntObjectMap.PrimitiveEntry)iterator.next()).value()).weight = (short)Math.max(1L, (long)(state3.weight * state.weight) / l);
                        this.takeChild(iterator, state3, false, arrayList);
                    } while (iterator.hasNext());
                }
                WeightedFairQueueByteDistributor.this.notifyParentChanged(arrayList);
            }
        }

        private long getTotalWeight() {
            long l = 0L;
            for (State state : this.children.values()) {
                l += (long)state.weight;
            }
            return l;
        }

        private IntObjectMap<State> removeAllChildrenExcept(State state) {
            state = (State)this.children.remove(state.streamId);
            IntObjectMap<State> intObjectMap = this.children;
            this.initChildren();
            if (state != null) {
                this.children.put(state.streamId, (Object)state);
            }
            return intObjectMap;
        }

        private void setParent(State state) {
            if (this.activeCountForTree != 0 && this.parent != null) {
                this.parent.removePseudoTimeQueue(this);
                this.parent.activeCountChangeForTree(-this.activeCountForTree);
            }
            this.parent = state;
            this.dependencyTreeDepth = state == null ? Integer.MAX_VALUE : state.dependencyTreeDepth + 1;
        }

        private void initChildrenIfEmpty() {
            if (this.children == IntCollections.emptyMap()) {
                this.initChildren();
            }
        }

        private void initChildren() {
            this.children = new IntObjectHashMap(INITIAL_CHILDREN_MAP_SIZE);
        }

        final void write(int n, StreamByteDistributor.Writer writer) {
            assert (this.stream != null);
            try {
                writer.write(this.stream, n);
                return;
            }
            catch (Throwable throwable) {
                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, throwable, "byte distribution write error", new Object[0]);
            }
        }

        final void activeCountChangeForTree(int n) {
            while (true) {
                assert (state.activeCountForTree + n >= 0);
                state.activeCountForTree += n;
                if (state.parent == null) break;
                assert (state.activeCountForTree != n || state.pseudoTimeQueueIndex == -1 || state.parent.pseudoTimeQueue.containsTyped((Object)state)) : "State[" + state.streamId + "].activeCountForTree changed from 0 to " + n + " is in a pseudoTimeQueue, but not in parent[ " + state.parent.streamId + "]'s pseudoTimeQueue";
                if (state.activeCountForTree == 0) {
                    state.parent.removePseudoTimeQueue(state);
                } else if (state.activeCountForTree == n && !state.isDistributing()) {
                    state.parent.offerAndInitializePseudoTime(state);
                }
                State state = state.parent;
            }
        }

        final void updateStreamableBytes(int n, boolean bl) {
            if (this.isActive() != bl) {
                if (bl) {
                    this.activeCountChangeForTree(1);
                    this.setActive();
                } else {
                    this.activeCountChangeForTree(-1);
                    this.unsetActive();
                }
            }
            this.streamableBytes = n;
        }

        final void updatePseudoTime(State state, int n, long l) {
            assert (this.streamId != 0 && n >= 0);
            this.pseudoTimeToWrite = Math.min(this.pseudoTimeToWrite, state.pseudoTime) + (long)n * l / (long)this.weight;
        }

        final void offerAndInitializePseudoTime(State state) {
            state.pseudoTimeToWrite = this.pseudoTime;
            this.offerPseudoTimeQueue(state);
        }

        final void offerPseudoTimeQueue(State state) {
            this.pseudoTimeQueue.offer((Object)state);
            this.totalQueuedWeights += (long)state.weight;
        }

        final State pollPseudoTimeQueue() {
            State state = (State)this.pseudoTimeQueue.poll();
            this.totalQueuedWeights -= (long)state.weight;
            return state;
        }

        final void removePseudoTimeQueue(State state) {
            if (this.pseudoTimeQueue.removeTyped((Object)state)) {
                this.totalQueuedWeights -= (long)state.weight;
            }
        }

        final State peekPseudoTimeQueue() {
            return (State)this.pseudoTimeQueue.peek();
        }

        final void close() {
            this.updateStreamableBytes(0, false);
            this.stream = null;
        }

        final boolean wasStreamReservedOrActivated() {
            return (this.flags & 4) != 0;
        }

        final void setStreamReservedOrActivated() {
            this.flags = (byte)(this.flags | 4);
        }

        final boolean isActive() {
            return (this.flags & 1) != 0;
        }

        private void setActive() {
            this.flags = (byte)(this.flags | 1);
        }

        private void unsetActive() {
            this.flags = (byte)(this.flags & 0xFFFFFFFE);
        }

        final boolean isDistributing() {
            return (this.flags & 2) != 0;
        }

        final void setDistributing() {
            this.flags = (byte)(this.flags | 2);
        }

        final void unsetDistributing() {
            this.flags = (byte)(this.flags & 0xFFFFFFFD);
        }

        public final int priorityQueueIndex(DefaultPriorityQueue<?> defaultPriorityQueue) {
            if (defaultPriorityQueue == WeightedFairQueueByteDistributor.this.stateOnlyRemovalQueue) {
                return this.stateOnlyQueueIndex;
            }
            return this.pseudoTimeQueueIndex;
        }

        public final void priorityQueueIndex(DefaultPriorityQueue<?> defaultPriorityQueue, int n) {
            if (defaultPriorityQueue == WeightedFairQueueByteDistributor.this.stateOnlyRemovalQueue) {
                this.stateOnlyQueueIndex = n;
                return;
            }
            this.pseudoTimeQueueIndex = n;
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder(256 * (this.activeCountForTree > 0 ? this.activeCountForTree : 1));
            this.toString(stringBuilder);
            return stringBuilder.toString();
        }

        private void toString(StringBuilder stringBuilder) {
            stringBuilder.append("{streamId ").append(this.streamId).append(" streamableBytes ").append(this.streamableBytes).append(" activeCountForTree ").append(this.activeCountForTree).append(" pseudoTimeQueueIndex ").append(this.pseudoTimeQueueIndex).append(" pseudoTimeToWrite ").append(this.pseudoTimeToWrite).append(" pseudoTime ").append(this.pseudoTime).append(" flags ").append(this.flags).append(" pseudoTimeQueue.size() ").append(this.pseudoTimeQueue.size()).append(" stateOnlyQueueIndex ").append(this.stateOnlyQueueIndex).append(" parent.streamId ").append(this.parent == null ? -1 : this.parent.streamId).append("} [");
            if (!this.pseudoTimeQueue.isEmpty()) {
                for (State state : this.pseudoTimeQueue) {
                    state.toString(stringBuilder);
                    stringBuilder.append(", ");
                }
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2.setLength(stringBuilder2.length() - 2);
            }
            stringBuilder.append(']');
        }
    }

    private static final class StatePseudoTimeComparator
    implements Serializable,
    Comparator<State> {
        private static final long serialVersionUID = -1437548640227161828L;
        static final StatePseudoTimeComparator INSTANCE = new StatePseudoTimeComparator();

        private StatePseudoTimeComparator() {
        }

        @Override
        public final int compare(State state, State state2) {
            return MathUtil.compare((long)state.pseudoTimeToWrite, (long)state2.pseudoTimeToWrite);
        }
    }

    private static final class StateOnlyComparator
    implements Serializable,
    Comparator<State> {
        private static final long serialVersionUID = -4806936913002105966L;
        static final StateOnlyComparator INSTANCE = new StateOnlyComparator();

        private StateOnlyComparator() {
        }

        @Override
        public final int compare(State state, State state2) {
            int n = state.wasStreamReservedOrActivated();
            if (n != state2.wasStreamReservedOrActivated()) {
                if (n != 0) {
                    return -1;
                }
                return 1;
            }
            n = state2.dependencyTreeDepth - state.dependencyTreeDepth;
            if (n != 0) {
                return n;
            }
            return state.streamId - state2.streamId;
        }
    }
}

