/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.ParagraphIntrinsics;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.platform.ParagraphLayouter;
import androidx.compose.ui.text.platform.SkiaParagraphIntrinsics_skikoKt;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextDirection;
import androidx.compose.ui.unit.Density;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\u0007\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0019H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001e\u0010 \u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001f\u00a8\u0006\""}, d2={"Landroidx/compose/ui/text/platform/SkiaParagraphIntrinsics;", "Landroidx/compose/ui/text/ParagraphIntrinsics;", "text", "", "style", "Landroidx/compose/ui/text/TextStyle;", "annotations", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/AnnotatedString$Annotation;", "placeholders", "Landroidx/compose/ui/text/Placeholder;", "density", "Landroidx/compose/ui/unit/Density;", "fontFamilyResolver", "Landroidx/compose/ui/text/font/FontFamily$Resolver;", "<init>", "(Ljava/lang/String;Landroidx/compose/ui/text/TextStyle;Ljava/util/List;Ljava/util/List;Landroidx/compose/ui/unit/Density;Landroidx/compose/ui/text/font/FontFamily$Resolver;)V", "getText", "()Ljava/lang/String;", "textDirection", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "getTextDirection", "()Landroidx/compose/ui/text/style/ResolvedTextDirection;", "layouter", "Landroidx/compose/ui/text/platform/ParagraphLayouter;", "newLayouter", "value", "", "minIntrinsicWidth", "getMinIntrinsicWidth", "()F", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "ui-text"})
public final class SkiaParagraphIntrinsics
implements ParagraphIntrinsics {
    private final String text;
    private final TextStyle style;
    private final List<AnnotatedString.Range<? extends AnnotatedString.Annotation>> annotations;
    private final List<AnnotatedString.Range<Placeholder>> placeholders;
    private final Density density;
    private final FontFamily.Resolver fontFamilyResolver;
    private final ResolvedTextDirection textDirection;
    private ParagraphLayouter layouter;
    private float minIntrinsicWidth;
    private float maxIntrinsicWidth;
    public static final int $stable = 8;

    public SkiaParagraphIntrinsics(String string, TextStyle textStyle, List<? extends AnnotatedString.Range<? extends AnnotatedString.Annotation>> list, List<AnnotatedString.Range<Placeholder>> list2, Density density, FontFamily.Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter(list2, (String)"");
        Intrinsics.checkNotNullParameter((Object)density, (String)"");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"");
        this.text = string;
        this.style = textStyle;
        this.annotations = list;
        this.placeholders = list2;
        this.density = density;
        this.fontFamilyResolver = resolver;
        this.textDirection = SkiaParagraphIntrinsics_skikoKt.resolveTextDirection-Ikz0yAw(this.text, TextDirection.box-impl(this.style.getTextDirection-s_7X-co()), this.style.getLocaleList());
        ParagraphLayouter paragraphLayouter = this.layouter = this.newLayouter();
        Intrinsics.checkNotNull((Object)paragraphLayouter);
        string = paragraphLayouter.layoutParagraph(Float.POSITIVE_INFINITY);
        this.minIntrinsicWidth = (float)Math.ceil(string.getMinIntrinsicWidth());
        this.maxIntrinsicWidth = (float)Math.ceil(string.getMaxIntrinsicWidth());
    }

    public final String getText() {
        return this.text;
    }

    public final ResolvedTextDirection getTextDirection() {
        return this.textDirection;
    }

    public final ParagraphLayouter layouter() {
        ParagraphLayouter paragraphLayouter = this.layouter;
        if (paragraphLayouter == null) {
            paragraphLayouter = this.newLayouter();
        }
        ParagraphLayouter paragraphLayouter2 = paragraphLayouter;
        this.layouter = null;
        return paragraphLayouter2;
    }

    private final ParagraphLayouter newLayouter() {
        return new ParagraphLayouter(this.text, this.textDirection, this.style, this.annotations, this.placeholders, this.density, this.fontFamilyResolver);
    }

    @Override
    public final float getMinIntrinsicWidth() {
        return this.minIntrinsicWidth;
    }

    @Override
    public final float getMaxIntrinsicWidth() {
        return this.maxIntrinsicWidth;
    }
}

