/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.style;

import androidx.compose.ui.util.ListUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0000H\u0086\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0013\u0010\u000f\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Landroidx/compose/ui/text/style/TextDecoration;", "", "mask", "", "<init>", "(I)V", "getMask", "()I", "plus", "decoration", "contains", "", "other", "toString", "", "equals", "hashCode", "Companion", "ui-text"})
public final class TextDecoration {
    public static final Companion Companion = new Companion(null);
    private final int mask;
    public static final int $stable;
    private static final TextDecoration None;
    private static final TextDecoration Underline;
    private static final TextDecoration LineThrough;

    public TextDecoration(int n) {
        this.mask = n;
    }

    public final int getMask() {
        return this.mask;
    }

    public final TextDecoration plus(TextDecoration textDecoration) {
        Intrinsics.checkNotNullParameter((Object)textDecoration, (String)"");
        return new TextDecoration(this.mask | textDecoration.mask);
    }

    public final boolean contains(TextDecoration textDecoration) {
        Intrinsics.checkNotNullParameter((Object)textDecoration, (String)"");
        return (this.mask | textDecoration.mask) == this.mask;
    }

    public final String toString() {
        if (this.mask == 0) {
            return "TextDecoration.None";
        }
        List list = new ArrayList();
        if ((this.mask & TextDecoration.Underline.mask) != 0) {
            list.add("Underline");
        }
        if ((this.mask & TextDecoration.LineThrough.mask) != 0) {
            list.add("LineThrough");
        }
        if (list.size() == 1) {
            return "TextDecoration." + list.get(0);
        }
        return "TextDecoration[" + ListUtilsKt.fastJoinToString$default((List)list, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "]";
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TextDecoration)) {
            return false;
        }
        return this.mask == ((TextDecoration)object).mask;
    }

    public final int hashCode() {
        return this.mask;
    }

    static {
        None = new TextDecoration(0);
        Underline = new TextDecoration(1);
        LineThrough = new TextDecoration(2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u000f\u001a\u00020\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\bR\u001c\u0010\f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u0012"}, d2={"Landroidx/compose/ui/text/style/TextDecoration$Companion;", "", "<init>", "()V", "None", "Landroidx/compose/ui/text/style/TextDecoration;", "getNone$annotations", "getNone", "()Landroidx/compose/ui/text/style/TextDecoration;", "Underline", "getUnderline$annotations", "getUnderline", "LineThrough", "getLineThrough$annotations", "getLineThrough", "combine", "decorations", "", "ui-text"})
    public static final class Companion {
        private Companion() {
        }

        public final TextDecoration getNone() {
            return None;
        }

        public static /* synthetic */ void getNone$annotations() {
        }

        public final TextDecoration getUnderline() {
            return Underline;
        }

        public static /* synthetic */ void getUnderline$annotations() {
        }

        public final TextDecoration getLineThrough() {
            return LineThrough;
        }

        public static /* synthetic */ void getLineThrough$annotations() {
        }

        public final TextDecoration combine(List<TextDecoration> list) {
            Intrinsics.checkNotNullParameter(list, (String)"");
            Object object = 0;
            int n = ((Collection)list).size();
            for (int k = 0; k < n; ++k) {
                TextDecoration textDecoration = list.get(k);
                Integer n2 = object;
                object = textDecoration;
                int n3 = ((Number)n2).intValue();
                object = n3 | ((TextDecoration)object).getMask();
            }
            int n4 = ((Number)object).intValue();
            return new TextDecoration(n4);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

