/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.helpers;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.MDC;

public class MDCInsertingServletFilter
implements Filter {
    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) {
        this.insertIntoMDC(servletRequest);
        try {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        finally {
            this.clearMDC();
        }
    }

    void insertIntoMDC(ServletRequest servletRequest) {
        MDC.put((String)"req.remoteHost", (String)servletRequest.getRemoteHost());
        if (servletRequest instanceof HttpServletRequest) {
            servletRequest = (HttpServletRequest)servletRequest;
            MDC.put((String)"req.requestURI", (String)servletRequest.getRequestURI());
            StringBuffer stringBuffer = servletRequest.getRequestURL();
            if (stringBuffer != null) {
                MDC.put((String)"req.requestURL", (String)stringBuffer.toString());
            }
            MDC.put((String)"req.method", (String)servletRequest.getMethod());
            MDC.put((String)"req.queryString", (String)servletRequest.getQueryString());
            MDC.put((String)"req.userAgent", (String)servletRequest.getHeader("User-Agent"));
            MDC.put((String)"req.xForwardedFor", (String)servletRequest.getHeader("X-Forwarded-For"));
        }
    }

    void clearMDC() {
        MDC.remove((String)"req.remoteHost");
        MDC.remove((String)"req.requestURI");
        MDC.remove((String)"req.queryString");
        MDC.remove((String)"req.requestURL");
        MDC.remove((String)"req.method");
        MDC.remove((String)"req.userAgent");
        MDC.remove((String)"req.xForwardedFor");
    }

    public void init(FilterConfig filterConfig) {
    }
}

