/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.selector;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.selector.ContextSelector;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.StatusUtil;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.JNDIUtil;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.StatusPrinter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;

public class ContextJNDISelector
implements ContextSelector {
    private final Map<String, LoggerContext> synchronizedContextMap = Collections.synchronizedMap(new HashMap());
    private final LoggerContext defaultContext;
    private static final ThreadLocal<LoggerContext> threadLocal = new ThreadLocal();

    public ContextJNDISelector(LoggerContext loggerContext) {
        this.defaultContext = loggerContext;
    }

    @Override
    public LoggerContext getDefaultLoggerContext() {
        return this.defaultContext;
    }

    @Override
    public LoggerContext detachLoggerContext(String string) {
        return this.synchronizedContextMap.remove(string);
    }

    @Override
    public LoggerContext getLoggerContext() {
        Object object = null;
        javax.naming.Context context = null;
        LoggerContext loggerContext = threadLocal.get();
        if (loggerContext != null) {
            return loggerContext;
        }
        try {
            context = JNDIUtil.getInitialContext();
            object = JNDIUtil.lookupString((javax.naming.Context)context, (String)"java:comp/env/logback/context-name");
        }
        catch (NamingException namingException) {}
        if (object == null) {
            return this.defaultContext;
        }
        loggerContext = this.synchronizedContextMap.get(object);
        if (loggerContext == null) {
            loggerContext = new LoggerContext();
            loggerContext.setName((String)object);
            this.synchronizedContextMap.put((String)object, loggerContext);
            object = this.findConfigFileURL(context, loggerContext);
            if (object != null) {
                this.configureLoggerContextByURL(loggerContext, (URL)object);
            } else {
                try {
                    new ContextInitializer(loggerContext).autoConfig();
                }
                catch (JoranException joranException) {}
            }
            if (!StatusUtil.contextHasStatusListener((Context)loggerContext)) {
                StatusPrinter.printInCaseOfErrorsOrWarnings((Context)loggerContext);
            }
        }
        return loggerContext;
    }

    private String conventionalConfigFileName(String string) {
        return "logback-" + string + ".xml";
    }

    private URL findConfigFileURL(javax.naming.Context object, LoggerContext object2) {
        StatusManager statusManager = object2.getStatusManager();
        String string = null;
        try {
            string = JNDIUtil.lookupString((javax.naming.Context)object, (String)"java:comp/env/logback/configuration-resource");
        }
        catch (NamingException namingException) {
            statusManager.add((Status)new WarnStatus("JNDI lookup failed", (Object)this, (Throwable)namingException));
        }
        if (string != null) {
            statusManager.add((Status)new InfoStatus("Searching for [" + string + "]", (Object)this));
            object = this.urlByResourceName(statusManager, string);
            if (object == null) {
                object2 = "The jndi resource [" + string + "] for context [" + object2.getName() + "] does not lead to a valid file";
                statusManager.add((Status)new WarnStatus((String)object2, (Object)this));
            }
            return object;
        }
        object = this.conventionalConfigFileName(object2.getName());
        return this.urlByResourceName(statusManager, (String)object);
    }

    private URL urlByResourceName(StatusManager object, String string) {
        object.add((Status)new InfoStatus("Searching for [" + string + "]", (Object)this));
        object = Loader.getResource((String)string, (ClassLoader)Loader.getTCL());
        if (object != null) {
            return object;
        }
        return Loader.getResourceBySelfClassLoader((String)string);
    }

    private void configureLoggerContextByURL(LoggerContext loggerContext, URL uRL) {
        try {
            JoranConfigurator joranConfigurator = new JoranConfigurator();
            loggerContext.reset();
            joranConfigurator.setContext((Context)loggerContext);
            joranConfigurator.doConfigure(uRL);
        }
        catch (JoranException joranException) {}
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)loggerContext);
    }

    @Override
    public List<String> getContextNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.synchronizedContextMap.keySet());
        return arrayList;
    }

    @Override
    public LoggerContext getLoggerContext(String string) {
        return this.synchronizedContextMap.get(string);
    }

    public int getCount() {
        return this.synchronizedContextMap.size();
    }

    public void setLocalContext(LoggerContext loggerContext) {
        threadLocal.set(loggerContext);
    }

    public void removeLocalContext() {
        threadLocal.remove();
    }
}

