/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelId;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.MacAddressUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public final class DefaultChannelId
implements ChannelId {
    private static final long serialVersionUID = 3884076183504074063L;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultChannelId.class);
    private static final byte[] MACHINE_ID;
    private static final int PROCESS_ID_LEN = 4;
    private static final int PROCESS_ID;
    private static final int SEQUENCE_LEN = 4;
    private static final int TIMESTAMP_LEN = 8;
    private static final int RANDOM_LEN = 4;
    private static final AtomicInteger nextSequence;
    private final byte[] data;
    private final int hashCode;
    private transient String shortValue;
    private transient String longValue;

    public static DefaultChannelId newInstance() {
        return new DefaultChannelId(MACHINE_ID, PROCESS_ID, nextSequence.getAndIncrement(), Long.reverse(System.nanoTime()) ^ System.currentTimeMillis(), PlatformDependent.threadLocalRandom().nextInt());
    }

    static int processHandlePid(ClassLoader object) {
        if (PlatformDependent.javaVersion() >= 9) {
            try {
                object = Class.forName("java.lang.ProcessHandle", true, (ClassLoader)object);
                Object object2 = ((Class)object).getMethod("current", new Class[0]);
                object2 = ((Method)object2).invoke(null, new Object[0]);
                object = ((Class)object).getMethod("pid", new Class[0]);
                object = (Long)((Method)object).invoke(object2, new Object[0]);
            }
            catch (Exception exception) {
                logger.debug("Could not invoke ProcessHandle.current().pid();", (Throwable)exception);
                return -1;
            }
            if ((Long)object > Integer.MAX_VALUE || (Long)object < Integer.MIN_VALUE) {
                throw new IllegalStateException("Current process ID exceeds int range: " + object);
            }
            return ((Long)object).intValue();
        }
        return -1;
    }

    static int jmxPid(ClassLoader classLoader) {
        int n;
        Object object;
        Class<?> clazz;
        try {
            GenericDeclaration genericDeclaration = Class.forName("java.lang.management.ManagementFactory", true, classLoader);
            clazz = Class.forName("java.lang.management.RuntimeMXBean", true, classLoader);
            object = genericDeclaration.getMethod("getRuntimeMXBean", EmptyArrays.EMPTY_CLASSES);
            object = ((Method)object).invoke(null, EmptyArrays.EMPTY_OBJECTS);
            genericDeclaration = clazz.getMethod("getName", EmptyArrays.EMPTY_CLASSES);
            object = (String)((Method)genericDeclaration).invoke(object, EmptyArrays.EMPTY_OBJECTS);
        }
        catch (Throwable throwable) {
            logger.debug("Could not invoke ManagementFactory.getRuntimeMXBean().getName(); Android?", throwable);
            try {
                clazz = Class.forName("android.os.Process", true, classLoader);
                object = clazz.getMethod("myPid", EmptyArrays.EMPTY_CLASSES);
                object = ((Method)object).invoke(null, EmptyArrays.EMPTY_OBJECTS).toString();
            }
            catch (Throwable throwable2) {
                logger.debug("Could not invoke Process.myPid(); not Android?", throwable2);
                object = "";
            }
        }
        int n2 = ((String)object).indexOf(64);
        if (n2 >= 0) {
            object = ((String)object).substring(0, n2);
        }
        try {
            n = Integer.parseInt((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        if (n < 0) {
            n = PlatformDependent.threadLocalRandom().nextInt();
            logger.warn("Failed to find the current process ID from '{}'; using a random value: {}", object, (Object)n);
        }
        return n;
    }

    static int defaultProcessId() {
        ClassLoader classLoader = PlatformDependent.getClassLoader(DefaultChannelId.class);
        int n = DefaultChannelId.processHandlePid(classLoader);
        if (n != -1) {
            return n;
        }
        return DefaultChannelId.jmxPid(classLoader);
    }

    DefaultChannelId(byte[] byArray, int n, int n2, long l, int n3) {
        byte[] byArray2 = new byte[byArray.length + 4 + 4 + 8 + 4];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        int n4 = 0 + byArray.length;
        DefaultChannelId.writeInt(byArray2, n4, n);
        DefaultChannelId.writeInt(byArray2, n4 += 4, n2);
        DefaultChannelId.writeLong(byArray2, n4 += 4, l);
        DefaultChannelId.writeInt(byArray2, n4 += 8, n3);
        assert ((n4 += 4) == byArray2.length);
        this.data = byArray2;
        this.hashCode = Arrays.hashCode(byArray2);
    }

    private static void writeInt(byte[] byArray, int n, int n2) {
        if (PlatformDependent.isUnaligned()) {
            PlatformDependent.putInt((byte[])byArray, (int)n, (int)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? n2 : Integer.reverseBytes(n2)));
            return;
        }
        byArray[n] = (byte)(n2 >>> 24);
        byArray[n + 1] = (byte)(n2 >>> 16);
        byArray[n + 2] = (byte)(n2 >>> 8);
        byArray[n + 3] = (byte)n2;
    }

    private static void writeLong(byte[] byArray, int n, long l) {
        if (PlatformDependent.isUnaligned()) {
            PlatformDependent.putLong((byte[])byArray, (int)n, (long)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? l : Long.reverseBytes(l)));
            return;
        }
        byArray[n] = (byte)(l >>> 56);
        byArray[n + 1] = (byte)(l >>> 48);
        byArray[n + 2] = (byte)(l >>> 40);
        byArray[n + 3] = (byte)(l >>> 32);
        byArray[n + 4] = (byte)(l >>> 24);
        byArray[n + 5] = (byte)(l >>> 16);
        byArray[n + 6] = (byte)(l >>> 8);
        byArray[n + 7] = (byte)l;
    }

    @Override
    public final String asShortText() {
        String string = this.shortValue;
        if (string == null) {
            this.shortValue = string = ByteBufUtil.hexDump((byte[])this.data, (int)(this.data.length - 4), (int)4);
        }
        return string;
    }

    @Override
    public final String asLongText() {
        String string = this.longValue;
        if (string == null) {
            this.longValue = string = this.newLongValue();
        }
        return string;
    }

    private String newLongValue() {
        StringBuilder stringBuilder = new StringBuilder(2 * this.data.length + 5);
        int n = this.data.length - 4 - 4 - 8 - 4;
        n = this.appendHexDumpField(stringBuilder, 0, n);
        n = this.appendHexDumpField(stringBuilder, n, 4);
        n = this.appendHexDumpField(stringBuilder, n, 4);
        n = this.appendHexDumpField(stringBuilder, n, 8);
        n = this.appendHexDumpField(stringBuilder, n, 4);
        assert (n == this.data.length);
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private int appendHexDumpField(StringBuilder stringBuilder, int n, int n2) {
        stringBuilder.append(ByteBufUtil.hexDump((byte[])this.data, (int)n, (int)n2));
        stringBuilder.append('-');
        return n += n2;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    @Override
    public final int compareTo(ChannelId object) {
        if (this == object) {
            return 0;
        }
        if (object instanceof DefaultChannelId) {
            object = ((DefaultChannelId)object).data;
            int n = this.data.length;
            int n2 = ((Object)object).length;
            int n3 = Math.min(n, n2);
            for (int i = 0; i < n3; ++i) {
                byte by = this.data[i];
                Object object2 = object[i];
                if (by == object2) continue;
                return (by & 0xFF) - (object2 & 0xFF);
            }
            return n - n2;
        }
        return this.asLongText().compareTo(object.asLongText());
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultChannelId)) {
            return false;
        }
        object = (DefaultChannelId)object;
        return this.hashCode == ((DefaultChannelId)object).hashCode && Arrays.equals(this.data, ((DefaultChannelId)object).data);
    }

    public final String toString() {
        return this.asShortText();
    }

    static {
        nextSequence = new AtomicInteger();
        int n = -1;
        String string = SystemPropertyUtil.get((String)"io.netty.processId");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
            if (n < 0) {
                n = -1;
                logger.warn("-Dio.netty.processId: {} (malformed)", (Object)string);
            } else if (logger.isDebugEnabled()) {
                logger.debug("-Dio.netty.processId: {} (user-set)", (Object)n);
            }
        }
        if (n < 0) {
            n = DefaultChannelId.defaultProcessId();
            if (logger.isDebugEnabled()) {
                logger.debug("-Dio.netty.processId: {} (auto-detected)", (Object)n);
            }
        }
        PROCESS_ID = n;
        byte[] byArray = null;
        string = SystemPropertyUtil.get((String)"io.netty.machineId");
        if (string != null) {
            try {
                byArray = MacAddressUtil.parseMAC((String)string);
            }
            catch (Exception exception) {
                logger.warn("-Dio.netty.machineId: {} (malformed)", (Object)string, (Object)exception);
            }
            if (byArray != null) {
                logger.debug("-Dio.netty.machineId: {} (user-set)", (Object)string);
            }
        }
        if (byArray == null) {
            byArray = MacAddressUtil.defaultMachineId();
            if (logger.isDebugEnabled()) {
                logger.debug("-Dio.netty.machineId: {} (auto-detected)", (Object)MacAddressUtil.formatAddress((byte[])byArray));
            }
        }
        MACHINE_ID = byArray;
    }
}

