/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.nio;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.AbstractNioChannel;
import java.io.IOException;
import java.net.PortUnreachableException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractNioMessageChannel
extends AbstractNioChannel {
    boolean inputShutdown;

    protected AbstractNioMessageChannel(Channel channel, SelectableChannel selectableChannel, int n) {
        super(channel, selectableChannel, n);
    }

    @Override
    protected AbstractNioChannel.AbstractNioUnsafe newUnsafe() {
        return new NioMessageUnsafe();
    }

    @Override
    protected void doBeginRead() {
        if (this.inputShutdown) {
            return;
        }
        super.doBeginRead();
    }

    protected boolean continueReading(RecvByteBufAllocator.Handle handle) {
        return handle.continueReading();
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        Object object;
        SelectionKey selectionKey = this.selectionKey();
        int n = selectionKey.interestOps();
        int n2 = this.maxMessagesPerWrite();
        while (n2 > 0 && (object = channelOutboundBuffer.current()) != null) {
            try {
                boolean bl = false;
                for (int i = this.config().getWriteSpinCount() - 1; i >= 0; --i) {
                    if (!this.doWriteMessage(object, channelOutboundBuffer)) continue;
                    bl = true;
                    break;
                }
                if (!bl) break;
                --n2;
                channelOutboundBuffer.remove();
            }
            catch (Exception exception) {
                if (this.continueOnWriteError()) {
                    --n2;
                    channelOutboundBuffer.remove(exception);
                    continue;
                }
                throw exception;
            }
        }
        if (channelOutboundBuffer.isEmpty()) {
            if ((n & 4) != 0) {
                selectionKey.interestOps(n & 0xFFFFFFFB);
                return;
            }
        } else if ((n & 4) == 0) {
            selectionKey.interestOps(n | 4);
        }
    }

    protected boolean continueOnWriteError() {
        return false;
    }

    protected boolean closeOnReadError(Throwable throwable) {
        if (!this.isActive()) {
            return true;
        }
        if (throwable instanceof PortUnreachableException) {
            return false;
        }
        if (throwable instanceof IOException) {
            return !(this instanceof ServerChannel);
        }
        return true;
    }

    protected abstract int doReadMessages(List<Object> var1);

    protected abstract boolean doWriteMessage(Object var1, ChannelOutboundBuffer var2);

    private final class NioMessageUnsafe
    extends AbstractNioChannel.AbstractNioUnsafe {
        private final List<Object> readBuf = new ArrayList<Object>();

        private NioMessageUnsafe() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final void read() {
            assert (AbstractNioMessageChannel.this.eventLoop().inEventLoop());
            ChannelConfig channelConfig = AbstractNioMessageChannel.this.config();
            ChannelPipeline channelPipeline = AbstractNioMessageChannel.this.pipeline();
            RecvByteBufAllocator.Handle handle = AbstractNioMessageChannel.this.unsafe().recvBufAllocHandle();
            handle.reset(channelConfig);
            boolean bl = false;
            Throwable throwable = null;
            try {
                int n;
                try {
                    while ((n = AbstractNioMessageChannel.this.doReadMessages(this.readBuf)) != 0) {
                        if (n < 0) {
                            bl = true;
                        } else {
                            handle.incMessagesRead(n);
                            if (AbstractNioMessageChannel.this.continueReading(handle)) continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                }
                n = this.readBuf.size();
                for (int i = 0; i < n; ++i) {
                    AbstractNioMessageChannel.this.readPending = false;
                    channelPipeline.fireChannelRead(this.readBuf.get(i));
                }
                this.readBuf.clear();
                handle.readComplete();
                channelPipeline.fireChannelReadComplete();
                if (throwable != null) {
                    bl = AbstractNioMessageChannel.this.closeOnReadError(throwable);
                    channelPipeline.fireExceptionCaught(throwable);
                }
                if (bl) {
                    AbstractNioMessageChannel.this.inputShutdown = true;
                    if (AbstractNioMessageChannel.this.isOpen()) {
                        NioMessageUnsafe nioMessageUnsafe = this;
                        nioMessageUnsafe.close(nioMessageUnsafe.voidPromise());
                    }
                }
                if (AbstractNioMessageChannel.this.readPending || channelConfig.isAutoRead()) return;
            }
            catch (Throwable throwable4) {
                if (AbstractNioMessageChannel.this.readPending || channelConfig.isAutoRead()) throw throwable4;
                this.removeReadOp();
                throw throwable4;
            }
            this.removeReadOp();
        }
    }
}

