/*
 * Decompiled with CFR 0.152.
 */
package kotlin.random;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.XorWowRandom;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.LongProgression;
import kotlin.ranges.LongRange;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0004H\u0007\u001a\u0014\u0010\u0005\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a\u0014\u0010\b\u001a\u00020\u0004*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\tH\u0007\u001a\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0000\u001a\u0014\u0010\f\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0000\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0015H\u0000\u00a8\u0006\u0016"}, d2={"Random", "Lkotlin/random/Random;", "seed", "", "", "nextInt", "range", "Lkotlin/ranges/IntRange;", "nextLong", "Lkotlin/ranges/LongRange;", "fastLog2", "value", "takeUpperBits", "bitCount", "checkRangeBounds", "", "from", "until", "", "boundsErrorMessage", "", "", "kotlin-stdlib"})
public final class RandomKt {
    public static final Random Random(int n) {
        int n2 = n;
        return new XorWowRandom(n2, n2 >> 31);
    }

    public static final Random Random(long l) {
        return new XorWowRandom((int)l, (int)(l >> 32));
    }

    public static final int nextInt(Random random, IntRange intRange) {
        Intrinsics.checkNotNullParameter(random, "");
        Intrinsics.checkNotNullParameter(intRange, "");
        if (((IntProgression)intRange).isEmpty()) {
            throw new IllegalArgumentException("Cannot get random in empty range: " + intRange);
        }
        if (intRange.getLast() < Integer.MAX_VALUE) {
            return random.nextInt(intRange.getFirst(), intRange.getLast() + 1);
        }
        if (intRange.getFirst() > Integer.MIN_VALUE) {
            return random.nextInt(intRange.getFirst() - 1, intRange.getLast()) + 1;
        }
        return random.nextInt();
    }

    public static final long nextLong(Random random, LongRange longRange) {
        Intrinsics.checkNotNullParameter(random, "");
        Intrinsics.checkNotNullParameter(longRange, "");
        if (((LongProgression)longRange).isEmpty()) {
            throw new IllegalArgumentException("Cannot get random in empty range: " + longRange);
        }
        if (longRange.getLast() < Long.MAX_VALUE) {
            return random.nextLong(longRange.getFirst(), longRange.getLast() + 1L);
        }
        if (longRange.getFirst() > Long.MIN_VALUE) {
            return random.nextLong(longRange.getFirst() - 1L, longRange.getLast()) + 1L;
        }
        return random.nextLong();
    }

    public static final int fastLog2(int n) {
        return 31 - Integer.numberOfLeadingZeros(n);
    }

    public static final int takeUpperBits(int n, int n2) {
        return n >>> 32 - n2 & -n2 >> 31;
    }

    public static final void checkRangeBounds(int n, int n2) {
        if (!(n2 > n)) {
            String string = RandomKt.boundsErrorMessage(n, n2);
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final void checkRangeBounds(long l, long l2) {
        if (!(l2 > l)) {
            String string = RandomKt.boundsErrorMessage(l, l2);
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final void checkRangeBounds(double d, double d2) {
        if (!(d2 > d)) {
            String string = RandomKt.boundsErrorMessage(d, d2);
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final String boundsErrorMessage(Object object, Object object2) {
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(object2, "");
        return "Random range is empty: [" + object + ", " + object2 + ").";
    }
}

