/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.xml.namespace.QName;
import org.e.a.a;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public final class RosterPacket
extends IQ {
    public static final String ELEMENT = "query";
    public static final String NAMESPACE = "jabber:iq:roster";
    private final List<Item> rosterItems = new ArrayList<Item>();
    private String rosterVersion;

    public RosterPacket() {
        super(ELEMENT, NAMESPACE);
    }

    public final void addRosterItem(Item item) {
        List<Item> list = this.rosterItems;
        synchronized (list) {
            this.rosterItems.add(item);
            return;
        }
    }

    public final int getRosterItemCount() {
        List<Item> list = this.rosterItems;
        synchronized (list) {
            return this.rosterItems.size();
        }
    }

    public final List<Item> getRosterItems() {
        List<Item> list = this.rosterItems;
        synchronized (list) {
            return new ArrayList<Item>(this.rosterItems);
        }
    }

    protected final IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder iQChildElementXmlStringBuilder) {
        iQChildElementXmlStringBuilder.optAttribute("ver", this.rosterVersion);
        iQChildElementXmlStringBuilder.rightAngleBracket();
        List<Item> list = this.rosterItems;
        synchronized (list) {
            for (Item item : this.rosterItems) {
                iQChildElementXmlStringBuilder.append(item.toXML());
            }
        }
        return iQChildElementXmlStringBuilder;
    }

    public final String getVersion() {
        return this.rosterVersion;
    }

    public final void setVersion(String string) {
        this.rosterVersion = string;
    }

    public static enum ItemType {
        none('\u22a5'),
        to('\u2190'),
        from('\u2192'),
        both('\u2194'),
        remove('\u26a1');

        private static final char ME = '\u25cf';
        private final String symbol;

        private ItemType(char c2) {
            charSequence = new StringBuilder(2);
            ((StringBuilder)charSequence).append('\u25cf').append(c2);
            this.symbol = ((StringBuilder)charSequence).toString();
        }

        public static ItemType fromString(String string) {
            if (StringUtils.isNullOrEmpty((CharSequence)string)) {
                return none;
            }
            return ItemType.valueOf(string.toLowerCase(Locale.US));
        }

        public final String asSymbol() {
            return this.symbol;
        }
    }

    public static final class Item
    implements ExtensionElement {
        public static final String ELEMENT = "item";
        public static final QName QNAME = new QName("jabber:iq:roster", "item");
        public static final String GROUP = "group";
        private final a jid;
        private boolean subscriptionPending;
        private String name;
        private ItemType itemType = ItemType.none;
        private boolean approved;
        private final Set<String> groupNames;

        public Item(a a2, String string) {
            this(a2, string, false);
        }

        public Item(a a2, String string, boolean bl) {
            this.jid = (a)Objects.requireNonNull((Object)a2);
            this.name = string;
            this.subscriptionPending = bl;
            this.groupNames = new CopyOnWriteArraySet<String>();
        }

        public final String getElementName() {
            return QNAME.getLocalPart();
        }

        public final String getNamespace() {
            return QNAME.getNamespaceURI();
        }

        @Deprecated
        public final String getUser() {
            return this.jid.toString();
        }

        public final a getJid() {
            return this.jid;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String string) {
            this.name = string;
        }

        public final ItemType getItemType() {
            return this.itemType;
        }

        public final void setItemType(ItemType itemType) {
            this.itemType = (ItemType)((Object)Objects.requireNonNull((Object)((Object)itemType), (String)"itemType must not be null"));
        }

        public final void setSubscriptionPending(boolean bl) {
            this.subscriptionPending = bl;
        }

        public final boolean isSubscriptionPending() {
            return this.subscriptionPending;
        }

        public final boolean isApproved() {
            return this.approved;
        }

        public final void setApproved(boolean bl) {
            this.approved = bl;
        }

        public final Set<String> getGroupNames() {
            return Collections.unmodifiableSet(this.groupNames);
        }

        public final void addGroupName(String string) {
            this.groupNames.add(string);
        }

        public final void removeGroupName(String string) {
            this.groupNames.remove(string);
        }

        public final XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            xmlEnvironment = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
            xmlEnvironment.attribute("jid", (CharSequence)this.jid);
            xmlEnvironment.optAttribute("name", this.name);
            xmlEnvironment.optAttribute("subscription", (Enum)this.itemType);
            if (this.subscriptionPending) {
                xmlEnvironment.append((CharSequence)" ask='subscribe'");
            }
            xmlEnvironment.optBooleanAttribute("approved", this.approved);
            xmlEnvironment.rightAngleBracket();
            for (String string : this.groupNames) {
                xmlEnvironment.openElement(GROUP).escape(string).closeElement(GROUP);
            }
            xmlEnvironment.closeElement((NamedElement)this);
            return xmlEnvironment;
        }

        public final int hashCode() {
            return HashCode.builder().append(this.groupNames).append(this.subscriptionPending).append((Object)this.itemType).append((Object)this.name).append((Object)this.jid).append(this.approved).build();
        }

        public final boolean equals(Object object) {
            return EqualsUtil.equals((Object)this, (Object)object, (builder, item) -> builder.append(this.groupNames, item.groupNames).append(this.subscriptionPending, item.subscriptionPending).append((Object)this.itemType, (Object)item.itemType).append((Object)this.name, (Object)item.name).append((Object)this.jid, (Object)item.jid).append(this.approved, item.approved));
        }
    }
}

