/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import java.lang.ref.Reference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skia.impl.NativeKt;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.context.ContextHandler;
import org.jetbrains.skiko.context.JvmContextHandler;
import org.jetbrains.skiko.redrawer.Direct3DRedrawer;
import org.jetbrains.skiko.redrawer.Redrawer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0012H\u0014J\u0019\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0082 J\b\u0010\u0017\u001a\u00020\u0012H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\b\u0010\u001d\u001a\u00020\u0019H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006 "}, d2={"Lorg/jetbrains/skiko/context/Direct3DContextHandler;", "Lorg/jetbrains/skiko/context/JvmContextHandler;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "(Lorg/jetbrains/skiko/SkiaLayer;)V", "bufferCount", "", "currentHeight", "currentWidth", "directXRedrawer", "Lorg/jetbrains/skiko/redrawer/Direct3DRedrawer;", "getDirectXRedrawer", "()Lorg/jetbrains/skiko/redrawer/Direct3DRedrawer;", "surfaces", "", "Lorg/jetbrains/skia/Surface;", "[Lorg/jetbrains/skia/Surface;", "disposeCanvas", "", "flush", "context", "", "surface", "initCanvas", "initContext", "", "isSizeChanged", "width", "height", "isSurfacesNull", "rendererInfo", "", "skiko"})
public final class Direct3DContextHandler
extends JvmContextHandler {
    private final int bufferCount;
    private Surface[] surfaces;
    private int currentWidth;
    private int currentHeight;

    public Direct3DContextHandler(SkiaLayer skiaLayer) {
        Intrinsics.checkNotNullParameter((Object)skiaLayer, (String)"");
        super(skiaLayer);
        this.bufferCount = 2;
        this.surfaces = new Surface[this.bufferCount];
    }

    private final boolean isSurfacesNull() {
        for (Surface surface : this.surfaces) {
            Surface surface2 = surface;
            surface2 = surface;
            if (surface == null) continue;
            return false;
        }
        return true;
    }

    private final Direct3DRedrawer getDirectXRedrawer() {
        Redrawer redrawer = this.getLayer().getRedrawer$skiko();
        Intrinsics.checkNotNull((Object)redrawer);
        return (Direct3DRedrawer)redrawer;
    }

    @Override
    protected final boolean initContext() {
        try {
            if (this.getContext() == null) {
                Object object;
                Direct3DContextHandler direct3DContextHandler = this;
                direct3DContextHandler.setContext(direct3DContextHandler.getDirectXRedrawer().makeContext());
                if (Intrinsics.areEqual((Object)System.getProperty("skiko.hardwareInfo.enabled"), (Object)"true") && ((Logger)(object = Logger.INSTANCE)).getLoggerImpl().isInfoEnabled()) {
                    object = ((Logger)object).getLoggerImpl();
                    object.info("Renderer info:\n " + ((ContextHandler)this).rendererInfo());
                }
            }
        }
        catch (Exception exception) {
            Object object = Logger.INSTANCE;
            if (((Logger)object).getLoggerImpl().isWarnEnabled()) {
                SkikoLoggerInterface skikoLoggerInterface = ((Logger)object).getLoggerImpl();
                object = exception;
                SkikoLoggerInterface skikoLoggerInterface2 = skikoLoggerInterface;
                String string = "Failed to create Skia Direct3D context!";
                skikoLoggerInterface2.warn((Throwable)object, string);
            }
            return false;
        }
        return true;
    }

    private final boolean isSizeChanged(int n, int n2) {
        if (n != this.currentWidth || n2 != this.currentHeight) {
            this.currentWidth = n;
            this.currentHeight = n2;
            return true;
        }
        return false;
    }

    @Override
    protected final void initCanvas() {
        int n;
        DirectContext directContext = this.getContext();
        if (directContext == null) {
            return;
        }
        DirectContext directContext2 = directContext;
        float f = this.getLayer().getContentScale();
        int n2 = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * f)), (int)1);
        if (this.isSizeChanged(n2, n = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * f)), (int)1)) || this.isSurfacesNull()) {
            this.disposeCanvas();
            directContext2.flush();
            boolean bl = this.getDirectXRedrawer().changeSize(n2, n);
            try {
                SurfaceProps surfaceProps = new SurfaceProps(false, this.getLayer().getPixelGeometry(), 1, null);
                int n3 = this.bufferCount;
                for (int i2 = 0; i2 < n3; ++i2) {
                    this.surfaces[i2] = this.getDirectXRedrawer().makeSurface(NativeKt.getPtr(directContext2), n2, n, surfaceProps, i2);
                }
            }
            finally {
                Reference.reachabilityFence(directContext2);
            }
            if (bl) {
                this.getDirectXRedrawer().initFence();
            }
        }
        Direct3DContextHandler direct3DContextHandler = this;
        direct3DContextHandler.setSurface(direct3DContextHandler.surfaces[this.getDirectXRedrawer().getBufferIndex()]);
        Direct3DContextHandler direct3DContextHandler2 = this;
        Surface surface = direct3DContextHandler2.getSurface();
        Intrinsics.checkNotNull((Object)surface);
        direct3DContextHandler2.setCanvas(surface.getCanvas());
    }

    @Override
    protected final void flush() {
        DirectContext directContext = this.getContext();
        if (directContext == null) {
            return;
        }
        DirectContext directContext2 = directContext;
        Surface surface = this.getSurface();
        if (surface == null) {
            return;
        }
        Surface surface2 = surface;
        try {
            this.flush(NativeKt.getPtr(directContext2), NativeKt.getPtr(surface2));
            return;
        }
        finally {
            Reference.reachabilityFence(directContext2);
            Reference.reachabilityFence(surface2);
        }
    }

    @Override
    protected final void disposeCanvas() {
        int n = this.bufferCount;
        for (int i2 = 0; i2 < n; ++i2) {
            Surface surface = this.surfaces[i2];
            if (surface == null) continue;
            surface.close();
        }
    }

    @Override
    public final String rendererInfo() {
        return super.rendererInfo() + "Video card: " + this.getDirectXRedrawer().getAdapterName() + "\nTotal VRAM: " + this.getDirectXRedrawer().getAdapterMemorySize() / 1024L / 1024L + " MB\n";
    }

    private final native void flush(long var1, long var3);
}

