/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.amp.provider;

import java.util.logging.Logger;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.amp.AMPDeliverCondition;
import org.jivesoftware.smackx.amp.AMPExpireAtCondition;
import org.jivesoftware.smackx.amp.AMPMatchResourceCondition;
import org.jivesoftware.smackx.amp.packet.AMPExtension;

public class AMPExtensionProvider
extends ExtensionElementProvider<AMPExtension> {
    private static final Logger LOGGER = Logger.getLogger(AMPExtensionProvider.class.getName());

    public AMPExtension parse(XmlPullParser xmlPullParser, int n, XmlEnvironment object) {
        Object object2 = xmlPullParser.getAttributeValue(null, "from");
        object = xmlPullParser.getAttributeValue(null, "to");
        Object object3 = xmlPullParser.getAttributeValue(null, "status");
        Object object4 = null;
        if (object3 != null) {
            try {
                object4 = AMPExtension.Status.valueOf((String)object3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.severe("Found invalid amp status " + (String)object3);
            }
        }
        object2 = new AMPExtension((String)object2, (String)object, (AMPExtension.Status)((Object)object4));
        object = xmlPullParser.getAttributeValue(null, "per-hop");
        if (object != null) {
            boolean bl = Boolean.parseBoolean((String)object);
            ((AMPExtension)object2).setPerHop(bl);
        }
        boolean bl = false;
        while (!bl) {
            object3 = xmlPullParser.next();
            if (object3 == XmlPullParser.Event.START_ELEMENT) {
                if (!xmlPullParser.getName().equals("rule")) continue;
                object3 = xmlPullParser.getAttributeValue(null, "action");
                object4 = xmlPullParser.getAttributeValue(null, "condition");
                Object object5 = xmlPullParser.getAttributeValue(null, "value");
                object4 = AMPExtensionProvider.createCondition((String)object4, object5);
                object5 = null;
                if (object3 != null) {
                    try {
                        object5 = AMPExtension.Action.valueOf((String)object3);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        LOGGER.severe("Found invalid rule action value " + (String)object3);
                    }
                }
                if (object5 == null || object4 == null) {
                    LOGGER.severe("Rule is skipped because either it's action or it's condition is invalid");
                    continue;
                }
                object3 = new AMPExtension.Rule((AMPExtension.Action)((Object)object5), (AMPExtension.Condition)object4);
                ((AMPExtension)object2).addRule((AMPExtension.Rule)object3);
                continue;
            }
            if (object3 != XmlPullParser.Event.END_ELEMENT || !xmlPullParser.getName().equals("amp")) continue;
            bl = true;
        }
        return object2;
    }

    private static AMPExtension.Condition createCondition(String string, String string2) {
        if (string == null || string2 == null) {
            LOGGER.severe("Can't create rule condition from null name and/or value");
            return null;
        }
        if ("deliver".equals(string)) {
            try {
                return new AMPDeliverCondition(AMPDeliverCondition.Value.valueOf(string2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.severe("Found invalid rule delivery condition value " + string2);
                return null;
            }
        }
        if ("expire-at".equals(string)) {
            return new AMPExpireAtCondition(string2);
        }
        if ("match-resource".equals(string)) {
            try {
                return new AMPMatchResourceCondition(AMPMatchResourceCondition.Value.valueOf(string2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.severe("Found invalid rule match-resource condition value " + string2);
                return null;
            }
        }
        LOGGER.severe("Found unknown rule condition name " + string);
        return null;
    }
}

