/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.util.CloseableUtil;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;

public class Socks5Proxy {
    private static final Logger LOGGER = Logger.getLogger(Socks5Proxy.class.getName());
    private static final List<Socks5Proxy> RUNNING_PROXIES = new CopyOnWriteArrayList<Socks5Proxy>();
    private static Socks5Proxy socks5Server;
    private static boolean localSocks5ProxyEnabled;
    private static int DEFAULT_LOCAL_SOCKS5_PROXY_PORT;
    private int localSocks5ProxyPort = -7777;
    private final Socks5ServerProcess serverProcess;
    private Thread serverThread;
    private ServerSocket serverSocket;
    private final Map<String, Socket> connectionMap = new ConcurrentHashMap<String, Socket>();
    private final List<String> allowedConnections = Collections.synchronizedList(new LinkedList());
    private final Set<InetAddress> localAddresses = new LinkedHashSet<InetAddress>(4);
    private final boolean allowAllConnections;

    Socks5Proxy() {
        Enumeration<NetworkInterface> enumeration;
        this.serverProcess = new Socks5ServerProcess();
        this.allowAllConnections = false;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            throw new IllegalStateException(socketException);
        }
        HashSet<InetAddress> hashSet = new HashSet<InetAddress>();
        for (NetworkInterface networkInterface : Collections.list(enumeration)) {
            List<InterfaceAddress> list = networkInterface.getInterfaceAddresses();
            for (InterfaceAddress interfaceAddress : list) {
                hashSet.add(interfaceAddress.getAddress());
            }
        }
        if (hashSet.isEmpty()) {
            throw new IllegalStateException("Could not determine any local internet address");
        }
        this.replaceLocalAddresses(hashSet);
    }

    protected Socks5Proxy(ServerSocket serverSocket) {
        this.serverProcess = new Socks5ServerProcess();
        this.serverSocket = serverSocket;
        this.allowAllConnections = true;
        this.startServerThread();
    }

    public static boolean isLocalSocks5ProxyEnabled() {
        return localSocks5ProxyEnabled;
    }

    public static void setLocalSocks5ProxyEnabled(boolean bl) {
        localSocks5ProxyEnabled = bl;
    }

    private static void checkLocalSocks5ProxyPortArgument(int n) {
        if (Math.abs(n) > 65535) {
            throw new IllegalArgumentException("Local SOCKS5 proxy port must be within (-65535,65535)");
        }
    }

    public static int getDefaultLocalSocks5ProxyPort() {
        return DEFAULT_LOCAL_SOCKS5_PROXY_PORT;
    }

    public static void setDefaultLocalSocsk5ProxyPort(int n) {
        Socks5Proxy.checkLocalSocks5ProxyPortArgument(n);
        DEFAULT_LOCAL_SOCKS5_PROXY_PORT = n;
    }

    public int getLocalSocks5ProxyPort() {
        return this.localSocks5ProxyPort;
    }

    public void setLocalSocks5ProxyPort(int n) {
        Socks5Proxy.checkLocalSocks5ProxyPortArgument(n);
        this.localSocks5ProxyPort = n;
    }

    public static synchronized Socks5Proxy getSocks5Proxy() {
        if (socks5Server == null) {
            socks5Server = new Socks5Proxy();
        }
        if (Socks5Proxy.isLocalSocks5ProxyEnabled()) {
            socks5Server.start();
        }
        return socks5Server;
    }

    public synchronized ServerSocket start() {
        if (this.isRunning()) {
            return this.serverSocket;
        }
        try {
            if (this.getLocalSocks5ProxyPort() < 0) {
                int n = Math.abs(this.getLocalSocks5ProxyPort());
                for (int j = 0; j < 65535 - n; ++j) {
                    try {
                        this.serverSocket = new ServerSocket(n + j);
                        break;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                }
            } else {
                this.serverSocket = new ServerSocket(this.getLocalSocks5ProxyPort());
            }
            if (this.serverSocket != null) {
                this.startServerThread();
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "couldn't setup local SOCKS5 proxy on port " + this.getLocalSocks5ProxyPort(), iOException);
        }
        return this.serverSocket;
    }

    private synchronized void startServerThread() {
        this.serverThread = new Thread(this.serverProcess);
        this.serverThread.setName("Smack Local SOCKS5 Proxy [" + this.serverSocket + ']');
        this.serverThread.setDaemon(true);
        RUNNING_PROXIES.add(this);
        this.serverThread.start();
    }

    public synchronized void stop() {
        if (!this.isRunning()) {
            return;
        }
        RUNNING_PROXIES.remove(this);
        CloseableUtil.maybeClose((Closeable)this.serverSocket, (Logger)LOGGER);
        if (this.serverThread != null && this.serverThread.isAlive()) {
            try {
                this.serverThread.interrupt();
                this.serverThread.join();
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.WARNING, "SOCKS5 server thread termination was interrupted", interruptedException);
            }
        }
        this.serverThread = null;
        this.serverSocket = null;
    }

    public void addLocalAddress(InetAddress inetAddress) {
        if (inetAddress == null) {
            return;
        }
        Set<InetAddress> set = this.localAddresses;
        synchronized (set) {
            this.localAddresses.add(inetAddress);
            return;
        }
    }

    public boolean removeLocalAddress(InetAddress inetAddress) {
        Set<InetAddress> set = this.localAddresses;
        synchronized (set) {
            return this.localAddresses.remove(inetAddress);
        }
    }

    public List<InetAddress> getLocalAddresses() {
        Set<InetAddress> set = this.localAddresses;
        synchronized (set) {
            return new LinkedList<InetAddress>(this.localAddresses);
        }
    }

    public void replaceLocalAddresses(Collection<? extends InetAddress> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("list must not be null");
        }
        Set<InetAddress> set = this.localAddresses;
        synchronized (set) {
            this.localAddresses.clear();
            this.localAddresses.addAll(collection);
            return;
        }
    }

    public int getPort() {
        if (!this.isRunning()) {
            return -1;
        }
        return this.serverSocket.getLocalPort();
    }

    protected Socket getSocket(String string) {
        return this.connectionMap.get(string);
    }

    public void addTransfer(String string) {
        this.allowedConnections.add(string);
    }

    protected void removeTransfer(String string) {
        this.allowedConnections.remove(string);
        this.connectionMap.remove(string);
    }

    public boolean isRunning() {
        return this.serverSocket != null;
    }

    public static Socket getSocketForDigest(String string) {
        for (Socks5Proxy socks5Proxy : RUNNING_PROXIES) {
            Socket object = socks5Proxy.getSocket(string);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    static List<Socks5Proxy> getRunningProxies() {
        return RUNNING_PROXIES;
    }

    static {
        localSocks5ProxyEnabled = true;
        DEFAULT_LOCAL_SOCKS5_PROXY_PORT = -7777;
    }

    private class Socks5ServerProcess
    implements Runnable {
        private Socks5ServerProcess() {
        }

        @Override
        public void run() {
            ServerSocket serverSocket;
            while ((serverSocket = Socks5Proxy.this.serverSocket) != null && !serverSocket.isClosed() && !Thread.currentThread().isInterrupted()) {
                Socket socket = null;
                try {
                    socket = serverSocket.accept();
                    this.establishConnection(socket);
                    continue;
                }
                catch (IOException | SmackException throwable) {
                    LOGGER.log(Level.FINE, "Exception while " + Socks5Proxy.this + " was handling connection", throwable);
                    CloseableUtil.maybeClose((Closeable)socket, (Logger)LOGGER);
                    continue;
                }
                break;
            }
            return;
        }

        private void establishConnection(Socket socket) {
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            Object object = new DataInputStream(socket.getInputStream());
            int n = ((FilterInputStream)object).read();
            if (n != 5) {
                throw new SmackException.SmackMessageException("Only SOCKS5 supported: Peer send " + n + " but we expect 5");
            }
            n = ((FilterInputStream)object).read();
            byte[] byArray = new byte[n];
            ((DataInputStream)object).readFully(byArray);
            byte[] byArray2 = new byte[2];
            byte[] byArray3 = byArray2;
            byArray2[0] = 5;
            boolean bl = false;
            for (int j = 0; j < byArray.length; ++j) {
                if (byArray[j] != 0) continue;
                bl = true;
                break;
            }
            if (!bl) {
                byArray3[1] = -1;
                dataOutputStream.write(byArray3);
                dataOutputStream.flush();
                throw new SmackException.SmackMessageException("Authentication method not supported");
            }
            byArray3[1] = 0;
            dataOutputStream.write(byArray3);
            dataOutputStream.flush();
            byte[] byArray4 = Socks5Utils.receiveSocks5Message((DataInputStream)object);
            object = new String(byArray4, 5, (int)byArray4[4], StandardCharsets.UTF_8);
            if (!Socks5Proxy.this.allowAllConnections && !Socks5Proxy.this.allowedConnections.contains(object)) {
                byArray4[1] = 5;
                dataOutputStream.write(byArray4);
                dataOutputStream.flush();
                throw new SmackException.SmackMessageException("Connection with digest '" + (String)object + "' is not allowed");
            }
            Socks5Proxy.this.connectionMap.put(object, socket);
            byArray4[1] = 0;
            dataOutputStream.write(byArray4);
            dataOutputStream.flush();
        }
    }
}

