/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import org.e.a.i;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamRequest;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamSession;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.si.packet.StreamInitiation;

public class Socks5TransferNegotiator
extends StreamNegotiator {
    private final Socks5BytestreamManager manager;

    Socks5TransferNegotiator(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.manager = Socks5BytestreamManager.getBytestreamManager(xMPPConnection);
    }

    @Override
    public OutputStream createOutgoingStream(String string, i i2, i i3) {
        try {
            return this.manager.establishSession(i3, string).getOutputStream();
        }
        catch (IOException iOException) {
            throw new SmackException.SmackWrappedException("error establishing SOCKS5 Bytestream", (Exception)iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new SmackException.SmackWrappedException("error establishing SOCKS5 Bytestream", (Exception)interruptedException);
        }
    }

    @Override
    public InputStream createIncomingStream(StreamInitiation streamInitiation) {
        this.manager.ignoreBytestreamRequestOnce(streamInitiation.getSessionID());
        Socks5TransferNegotiator socks5TransferNegotiator = this;
        streamInitiation = socks5TransferNegotiator.initiateIncomingStream(socks5TransferNegotiator.connection(), streamInitiation);
        return this.negotiateIncomingStream((Stanza)streamInitiation);
    }

    @Override
    public void newStreamInitiation(i i2, String string) {
        this.manager.ignoreBytestreamRequestOnce(string);
    }

    @Override
    public String getNamespace() {
        return "http://jabber.org/protocol/bytestreams";
    }

    @Override
    InputStream negotiateIncomingStream(Stanza object) {
        object = new ByteStreamRequest(this.manager, (Bytestream)((Object)object));
        object = ((Socks5BytestreamRequest)object).accept();
        try {
            object = new PushbackInputStream(((Socks5BytestreamSession)object).getInputStream());
            int n = ((PushbackInputStream)object).read();
            ((PushbackInputStream)object).unread(n);
            return object;
        }
        catch (IOException iOException) {
            throw new SmackException.SmackWrappedException("Error establishing input stream", (Exception)iOException);
        }
    }

    private static final class ByteStreamRequest
    extends Socks5BytestreamRequest {
        private ByteStreamRequest(Socks5BytestreamManager socks5BytestreamManager, Bytestream bytestream) {
            super(socks5BytestreamManager, bytestream);
        }
    }
}

