/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iqprivate;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.iqprivate.packet.DefaultPrivateData;
import org.jivesoftware.smackx.iqprivate.packet.PrivateData;
import org.jivesoftware.smackx.iqprivate.packet.PrivateDataIQ;
import org.jivesoftware.smackx.iqprivate.provider.PrivateDataProvider;

public final class PrivateDataManager
extends Manager {
    private static final Map<XMPPConnection, PrivateDataManager> instances = new WeakHashMap<XMPPConnection, PrivateDataManager>();
    private static final Map<QName, PrivateDataProvider> privateDataProviders = new HashMap<QName, PrivateDataProvider>();
    private static final PrivateData DUMMY_PRIVATE_DATA = new PrivateData(){

        @Override
        public String getElementName() {
            return "smackDummyPrivateData";
        }

        @Override
        public String getNamespace() {
            return "https://igniterealtime.org/projects/smack";
        }

        @Override
        public CharSequence toXML() {
            return "<" + this.getElementName() + " xmlns='" + this.getNamespace() + "'/>";
        }
    };

    public static synchronized PrivateDataManager getInstanceFor(XMPPConnection xMPPConnection) {
        PrivateDataManager privateDataManager = instances.get(xMPPConnection);
        if (privateDataManager == null) {
            privateDataManager = new PrivateDataManager(xMPPConnection);
        }
        return privateDataManager;
    }

    public static PrivateDataProvider getPrivateDataProvider(String object, String string) {
        object = new QName(string, (String)object);
        return privateDataProviders.get(object);
    }

    public static void addPrivateDataProvider(String object, String string, PrivateDataProvider privateDataProvider) {
        object = new QName(string, (String)object);
        privateDataProviders.put((QName)object, privateDataProvider);
    }

    public static void removePrivateDataProvider(String object, String string) {
        object = new QName(string, (String)object);
        privateDataProviders.remove(object);
    }

    private PrivateDataManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        instances.put(xMPPConnection, this);
    }

    public final PrivateData getPrivateData(String object, String string) {
        object = new PrivateDataIQ((String)object, string);
        object = (PrivateDataIQ)this.connection().createStanzaCollectorAndSend((IQ)object).nextResultOrThrow();
        return ((PrivateDataIQ)((Object)object)).getPrivateData();
    }

    public final void setPrivateData(PrivateData object) {
        object = new PrivateDataIQ((PrivateData)object);
        this.connection().createStanzaCollectorAndSend((IQ)object).nextResultOrThrow();
    }

    public final boolean isSupported() {
        try {
            this.setPrivateData(DUMMY_PRIVATE_DATA);
            return true;
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            XMPPException.XMPPErrorException xMPPErrorException2 = xMPPErrorException;
            if (xMPPErrorException.getStanzaError().getCondition() == StanzaError.Condition.service_unavailable) {
                return false;
            }
            throw xMPPErrorException2;
        }
    }

    public static class PrivateDataIQProvider
    extends IQProvider<PrivateDataIQ> {
        public PrivateDataIQ parse(XmlPullParser xmlPullParser, int n, XmlEnvironment xmlEnvironment) {
            Object object = null;
            boolean bl = false;
            while (!bl) {
                Object object2 = xmlPullParser.next();
                if (object2 == XmlPullParser.Event.START_ELEMENT) {
                    object = xmlPullParser.getName();
                    PrivateDataProvider privateDataProvider = PrivateDataManager.getPrivateDataProvider((String)object, (String)(object2 = xmlPullParser.getNamespace()));
                    if (privateDataProvider != null) {
                        object = privateDataProvider.parsePrivateData(xmlPullParser);
                        continue;
                    }
                    object2 = new DefaultPrivateData((String)object, (String)object2);
                    boolean bl2 = false;
                    while (!bl2) {
                        Object object3 = xmlPullParser.next();
                        if (object3 == XmlPullParser.Event.START_ELEMENT) {
                            String string = xmlPullParser.getName();
                            object3 = xmlPullParser.next();
                            if (object3 == XmlPullParser.Event.TEXT_CHARACTERS) {
                                object3 = xmlPullParser.getText();
                                ((DefaultPrivateData)object2).setValue(string, (String)object3);
                                continue;
                            }
                            if (object3 != XmlPullParser.Event.END_ELEMENT) continue;
                            ((DefaultPrivateData)object2).setValue(string, "");
                            continue;
                        }
                        if (object3 != XmlPullParser.Event.END_ELEMENT || !xmlPullParser.getName().equals(object)) continue;
                        bl2 = true;
                    }
                    object = object2;
                    continue;
                }
                if (object2 != XmlPullParser.Event.END_ELEMENT || !xmlPullParser.getName().equals("query")) continue;
                bl = true;
            }
            return new PrivateDataIQ((PrivateData)object);
        }
    }
}

