/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.element;

import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class JingleReason
implements FullyQualifiedElement {
    public static final String ELEMENT = "reason";
    public static final String NAMESPACE = "urn:xmpp:jingle:1";
    public static final String TEXT_ELEMENT = "text";
    public static final JingleReason Busy = new JingleReason(Reason.busy);
    public static final JingleReason Cancel = new JingleReason(Reason.cancel);
    public static final JingleReason ConnectivityError = new JingleReason(Reason.connectivity_error);
    public static final JingleReason Decline = new JingleReason(Reason.decline);
    public static final JingleReason Expired = new JingleReason(Reason.expired);
    public static final JingleReason FailedApplication = new JingleReason(Reason.failed_application);
    public static final JingleReason FailedTransport = new JingleReason(Reason.failed_transport);
    public static final JingleReason GeneralError = new JingleReason(Reason.general_error);
    public static final JingleReason Gone = new JingleReason(Reason.gone);
    public static final JingleReason IncompatibleParameters = new JingleReason(Reason.incompatible_parameters);
    public static final JingleReason MediaError = new JingleReason(Reason.media_error);
    public static final JingleReason SecurityError = new JingleReason(Reason.security_error);
    public static final JingleReason Success = new JingleReason(Reason.success);
    public static final JingleReason Timeout = new JingleReason(Reason.timeout);
    public static final JingleReason UnsupportedApplications = new JingleReason(Reason.unsupported_applications);
    public static final JingleReason UnsupportedTransports = new JingleReason(Reason.unsupported_transports);
    protected final Reason reason;
    private final String text;
    private final ExtensionElement element;

    public static AlternativeSession AlternativeSession(String string) {
        return new AlternativeSession(string);
    }

    public JingleReason(Reason reason) {
        this(reason, null, null);
    }

    public JingleReason(Reason reason, String string, ExtensionElement extensionElement) {
        this.reason = reason;
        this.text = string;
        this.element = extensionElement;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getText() {
        return this.text;
    }

    public ExtensionElement getElement() {
        return this.element;
    }

    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        xmlEnvironment = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
        xmlEnvironment.rightAngleBracket();
        xmlEnvironment.emptyElement((Enum)this.reason);
        xmlEnvironment.optElement(TEXT_ELEMENT, this.text);
        xmlEnvironment.optAppend((Element)this.element);
        xmlEnvironment.closeElement((NamedElement)this);
        return xmlEnvironment;
    }

    public Reason asEnum() {
        return this.reason;
    }

    public static class AlternativeSession
    extends JingleReason {
        public static final String SID = "sid";
        private final String sessionId;

        public AlternativeSession(String string) {
            this(string, null, null);
        }

        public AlternativeSession(String string, String string2, ExtensionElement extensionElement) {
            super(Reason.alternative_session, string2, extensionElement);
            if (StringUtils.isNullOrEmpty((CharSequence)string)) {
                throw new NullPointerException("SessionID must not be null or empty.");
            }
            this.sessionId = string;
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            xmlEnvironment = new XmlStringBuilder((NamedElement)this);
            xmlEnvironment.rightAngleBracket();
            xmlEnvironment.openElement(this.reason.asString);
            xmlEnvironment.openElement(SID);
            xmlEnvironment.append((CharSequence)this.sessionId);
            xmlEnvironment.closeElement(SID);
            xmlEnvironment.closeElement(this.reason.asString);
            xmlEnvironment.closeElement((NamedElement)this);
            return xmlEnvironment;
        }

        public String getAlternativeSessionId() {
            return this.sessionId;
        }
    }

    public static enum Reason {
        alternative_session,
        busy,
        cancel,
        connectivity_error,
        decline,
        expired,
        failed_application,
        failed_transport,
        general_error,
        gone,
        incompatible_parameters,
        media_error,
        security_error,
        success,
        timeout,
        unsupported_applications,
        unsupported_transports;

        protected static final Map<String, Reason> LUT;
        protected final String asString = this.name().replace('_', '-');

        public final String toString() {
            return this.asString;
        }

        public static Reason fromString(String string) {
            Reason reason = LUT.get(string);
            if (reason == null) {
                throw new IllegalArgumentException("Unknown reason: " + string);
            }
            return reason;
        }

        static {
            LUT = new HashMap<String, Reason>(Reason.values().length);
            for (Reason reason : Reason.values()) {
                LUT.put(reason.toString(), reason);
            }
        }
    }
}

