/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.offline;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaView;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.offline.OfflineMessageHeader;
import org.jivesoftware.smackx.offline.packet.OfflineMessageInfo;
import org.jivesoftware.smackx.offline.packet.OfflineMessageRequest;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public final class OfflineMessageManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(OfflineMessageManager.class.getName());
    public static final String NAMESPACE = "http://jabber.org/protocol/offline";
    private static final Map<XMPPConnection, OfflineMessageManager> INSTANCES = new WeakHashMap<XMPPConnection, OfflineMessageManager>();
    private static final StanzaFilter PACKET_FILTER = new AndFilter(new StanzaFilter[]{new StanzaExtensionFilter((ExtensionElement)new OfflineMessageInfo()), StanzaTypeFilter.MESSAGE});
    private ServiceDiscoveryManager serviceDiscoveryManager;

    private OfflineMessageManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
    }

    public static synchronized OfflineMessageManager getInstanceFor(XMPPConnection xMPPConnection) {
        OfflineMessageManager offlineMessageManager = INSTANCES.get(xMPPConnection);
        if (offlineMessageManager == null) {
            offlineMessageManager = new OfflineMessageManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, offlineMessageManager);
        }
        return offlineMessageManager;
    }

    public final boolean supportsFlexibleRetrieval() {
        return this.serviceDiscoveryManager.serverSupportsFeature(NAMESPACE);
    }

    public final int getMessageCount() {
        Object object = this.serviceDiscoveryManager.discoverInfo(null, NAMESPACE);
        if ((object = DataForm.from((StanzaView)object, NAMESPACE)) == null) {
            return 0;
        }
        object = ((DataForm)object).getField("number_of_messages").getFirstValue();
        return Integer.parseInt((String)object);
    }

    public final List<OfflineMessageHeader> getHeaders() {
        ArrayList<OfflineMessageHeader> arrayList = new ArrayList<OfflineMessageHeader>();
        DiscoverItems discoverItems = this.serviceDiscoveryManager.discoverItems(null, NAMESPACE);
        for (DiscoverItems.Item item : discoverItems.getItems()) {
            arrayList.add(new OfflineMessageHeader(item));
        }
        return arrayList;
    }

    public final List<Message> getMessages(List<String> message) {
        OfflineMessageRequest.Item item;
        ArrayList<Message> arrayList = new ArrayList<Message>(message.size());
        OfflineMessageRequest offlineMessageRequest = new OfflineMessageRequest();
        for (String string : message) {
            item = new OfflineMessageRequest.Item(string);
            item.setAction("view");
            offlineMessageRequest.addItem(item);
        }
        AndFilter andFilter = new AndFilter(new StanzaFilter[]{PACKET_FILTER, new StanzaFilter((List)message){
            final /* synthetic */ List val$nodes;
            {
                this.val$nodes = list;
            }

            public boolean accept(Stanza object) {
                object = (OfflineMessageInfo)object.getExtension(OfflineMessageInfo.class);
                return this.val$nodes.contains(((OfflineMessageInfo)object).getNode());
            }
        }});
        int n = message.size();
        item = this.connection().createStanzaCollector((StanzaFilter)andFilter);
        try {
            this.connection().createStanzaCollectorAndSend((IQ)offlineMessageRequest).nextResultOrThrow();
            do {
                if ((message = (Message)item.nextResult()) != null) {
                    arrayList.add(message);
                    --n;
                    continue;
                }
                if (message != null || n <= 0) continue;
                LOGGER.log(Level.WARNING, "Did not receive all expected offline messages. " + n + " are missing.");
            } while (message != null && n > 0);
        }
        finally {
            if (item != null) {
                item.close();
            }
        }
        return arrayList;
    }

    public final List<Message> getMessages() {
        Object object = new OfflineMessageRequest();
        ((OfflineMessageRequest)((Object)object)).setFetch(true);
        object = this.connection().createStanzaCollectorAndSend((IQ)object);
        StanzaCollector.Configuration configuration = StanzaCollector.newConfiguration().setStanzaFilter(PACKET_FILTER).setCollectorToReset((StanzaCollector)object);
        configuration = this.connection().createStanzaCollector(configuration);
        try {
            Message message;
            object.nextResultOrThrow();
            configuration.cancel();
            object = new ArrayList(configuration.getCollectedCount());
            while ((message = (Message)configuration.pollResult()) != null) {
                object.add(message);
            }
        }
        finally {
            if (configuration != null) {
                configuration.close();
            }
        }
        return object;
    }

    public final void deleteMessages(List<String> object) {
        OfflineMessageRequest offlineMessageRequest = new OfflineMessageRequest();
        offlineMessageRequest.setType(IQ.Type.set);
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (String)object.next();
            object2 = new OfflineMessageRequest.Item((String)object2);
            ((OfflineMessageRequest.Item)object2).setAction("remove");
            offlineMessageRequest.addItem((OfflineMessageRequest.Item)object2);
        }
        this.connection().createStanzaCollectorAndSend((IQ)offlineMessageRequest).nextResultOrThrow();
    }

    public final void deleteMessages() {
        OfflineMessageRequest offlineMessageRequest = new OfflineMessageRequest();
        offlineMessageRequest.setType(IQ.Type.set);
        offlineMessageRequest.setPurge(true);
        this.connection().createStanzaCollectorAndSend((IQ)offlineMessageRequest).nextResultOrThrow();
    }
}

