/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaView;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class ReportedData {
    private final List<Column> columns = new ArrayList<Column>();
    private final List<Row> rows = new ArrayList<Row>();
    private String title = "";

    public static ReportedData getReportedDataFrom(Stanza object) {
        if ((object = DataForm.from((StanzaView)object)) != null && ((DataForm)object).getReportedData() != null) {
            return new ReportedData((DataForm)object);
        }
        return null;
    }

    private ReportedData(DataForm dataForm) {
        for (FormField iterator : dataForm.getReportedData().getFields()) {
            this.columns.add(new Column(iterator.getLabel(), iterator.getFieldName(), iterator.getType()));
        }
        for (DataForm.Item item : dataForm.getItems()) {
            ArrayList<Field> arrayList = new ArrayList<Field>(this.columns.size());
            for (FormField formField : item.getFields()) {
                ArrayList<? extends CharSequence> arrayList2 = new ArrayList<CharSequence>();
                arrayList2.addAll(formField.getValues());
                arrayList.add(new Field(formField.getFieldName(), arrayList2));
            }
            this.rows.add(new Row(arrayList));
        }
        this.title = dataForm.getTitle();
    }

    public ReportedData() {
    }

    public void addRow(Row row) {
        this.rows.add(row);
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public List<Row> getRows() {
        return Collections.unmodifiableList(new ArrayList<Row>(this.rows));
    }

    public List<Column> getColumns() {
        return Collections.unmodifiableList(new ArrayList<Column>(this.columns));
    }

    public String getTitle() {
        return this.title;
    }

    public static class Field {
        private final String variable;
        private final List<? extends CharSequence> values;

        public Field(String string, List<? extends CharSequence> list) {
            this.variable = string;
            this.values = list;
        }

        public String getVariable() {
            return this.variable;
        }

        public List<CharSequence> getValues() {
            return Collections.unmodifiableList(this.values);
        }
    }

    public static class Row {
        private List<Field> fields = new ArrayList<Field>();

        public Row(List<Field> list) {
            this.fields = list;
        }

        public List<CharSequence> getValues(String string) {
            for (Field field : this.getFields()) {
                if (!string.equalsIgnoreCase(field.getVariable())) continue;
                return field.getValues();
            }
            return null;
        }

        private List<Field> getFields() {
            return Collections.unmodifiableList(new ArrayList<Field>(this.fields));
        }
    }

    public static class Column {
        private final String label;
        private final String variable;
        private final FormField.Type type;

        public Column(String string, String string2, FormField.Type type) {
            this.label = string;
            this.variable = string2;
            this.type = type;
        }

        public String getLabel() {
            return this.label;
        }

        public FormField.Type getType() {
            return this.type;
        }

        public String getVariable() {
            return this.variable;
        }
    }
}

