/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xhtmlim.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.MessageView;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.XmlStringBuilder;

public final class XHTMLExtension
implements ExtensionElement {
    public static final String ELEMENT = "html";
    public static final String NAMESPACE = "http://jabber.org/protocol/xhtml-im";
    public static final QName QNAME = new QName("http://jabber.org/protocol/xhtml-im", "html");
    private final List<CharSequence> bodies = new ArrayList<CharSequence>();

    public final String getElementName() {
        return ELEMENT;
    }

    public final String getNamespace() {
        return NAMESPACE;
    }

    public final XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        xmlEnvironment = new XmlStringBuilder((ExtensionElement)this);
        xmlEnvironment.rightAngleBracket();
        for (CharSequence charSequence : this.getBodies()) {
            xmlEnvironment.append(charSequence);
        }
        xmlEnvironment.closeElement((NamedElement)this);
        return xmlEnvironment;
    }

    public final List<CharSequence> getBodies() {
        List<CharSequence> list = this.bodies;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<CharSequence>(this.bodies));
        }
    }

    public final void addBody(CharSequence charSequence) {
        List<CharSequence> list = this.bodies;
        synchronized (list) {
            this.bodies.add(charSequence);
            return;
        }
    }

    public final int getBodiesCount() {
        List<CharSequence> list = this.bodies;
        synchronized (list) {
            return this.bodies.size();
        }
    }

    public static XHTMLExtension from(MessageView messageView) {
        return (XHTMLExtension)messageView.getExtension(XHTMLExtension.class);
    }
}

