/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import com.jcraft.jzlib.Inflater;
import com.jcraft.jzlib.JZlib;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.compression.ZlibDecoder;
import io.netty.handler.codec.compression.ZlibUtil;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

public class JZlibDecoder
extends ZlibDecoder {
    private final Inflater z = new Inflater();
    private byte[] dictionary;
    private volatile boolean finished;

    public JZlibDecoder() {
        this(ZlibWrapper.ZLIB, 0);
    }

    public JZlibDecoder(int n) {
        this(ZlibWrapper.ZLIB, n);
    }

    public JZlibDecoder(ZlibWrapper zlibWrapper) {
        this(zlibWrapper, 0);
    }

    public JZlibDecoder(ZlibWrapper zlibWrapper, int n) {
        super(n);
        ObjectUtil.checkNotNull((Object)((Object)zlibWrapper), (String)"wrapper");
        int n2 = this.z.init(ZlibUtil.convertWrapperType(zlibWrapper));
        if (n2 != 0) {
            ZlibUtil.fail(this.z, "initialization failure", n2);
        }
    }

    public JZlibDecoder(byte[] byArray) {
        this(byArray, 0);
    }

    public JZlibDecoder(byte[] byArray, int n) {
        super(n);
        this.dictionary = (byte[])ObjectUtil.checkNotNull((Object)byArray, (String)"dictionary");
        int n2 = this.z.inflateInit(JZlib.W_ZLIB);
        if (n2 != 0) {
            ZlibUtil.fail(this.z, "initialization failure", n2);
        }
    }

    @Override
    public boolean isClosed() {
        return this.finished;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (this.finished) {
            ByteBuf byteBuf2 = byteBuf;
            byteBuf2.skipBytes(byteBuf2.readableBytes());
            return;
        }
        int n = byteBuf.readableBytes();
        if (n == 0) {
            return;
        }
        try {
            this.z.avail_in = n;
            if (byteBuf.hasArray()) {
                this.z.next_in = byteBuf.array();
                this.z.next_in_index = byteBuf.arrayOffset() + byteBuf.readerIndex();
            } else {
                byte[] byArray = new byte[n];
                ByteBuf byteBuf3 = byteBuf;
                byteBuf3.getBytes(byteBuf3.readerIndex(), byArray);
                this.z.next_in = byArray;
                this.z.next_in_index = 0;
            }
            int n2 = this.z.next_in_index;
            ByteBuf byteBuf4 = this.prepareDecompressBuffer(channelHandlerContext, null, n << 1);
            try {
                block12: while (true) {
                    byteBuf4 = this.prepareDecompressBuffer(channelHandlerContext, byteBuf4, this.z.avail_in << 1);
                    this.z.avail_out = byteBuf4.writableBytes();
                    this.z.next_out = byteBuf4.array();
                    int n3 = this.z.next_out_index = byteBuf4.arrayOffset() + byteBuf4.writerIndex();
                    int n4 = this.z.inflate(2);
                    if ((n3 = this.z.next_out_index - n3) > 0) {
                        ByteBuf byteBuf5 = byteBuf4;
                        byteBuf5.writerIndex(byteBuf5.writerIndex() + n3);
                    }
                    switch (n4) {
                        case 2: {
                            if (this.dictionary == null) break;
                            n4 = this.z.inflateSetDictionary(this.dictionary, this.dictionary.length);
                            if (n4 == 0) continue block12;
                            ZlibUtil.fail(this.z, "failed to set the dictionary", n4);
                            continue block12;
                        }
                        case 1: {
                            this.finished = true;
                            this.z.inflateEnd();
                            return;
                        }
                        case 0: {
                            continue block12;
                        }
                        case -5: {
                            if (this.z.avail_in > 0) continue block12;
                            return;
                        }
                    }
                    ZlibUtil.fail(this.z, "decompression failure", n4);
                }
            }
            finally {
                byteBuf.skipBytes(this.z.next_in_index - n2);
                if (byteBuf4.isReadable()) {
                    list.add(byteBuf4);
                } else {
                    byteBuf4.release();
                }
            }
        }
        finally {
            this.z.next_in = null;
            this.z.next_out = null;
        }
    }

    @Override
    protected void decompressionBufferExhausted(ByteBuf byteBuf) {
        this.finished = true;
    }
}

