/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.compression.ByteBufChecksum;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.compression.ZlibDecoder;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.util.internal.ObjectUtil;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class JdkZlibDecoder
extends ZlibDecoder {
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;
    private static final int FRESERVED = 224;
    private Inflater inflater;
    private final byte[] dictionary;
    private final ByteBufChecksum crc;
    private final boolean decompressConcatenated;
    private GzipState gzipState = GzipState.HEADER_START;
    private int flags = -1;
    private int xlen = -1;
    private volatile boolean finished;
    private boolean decideZlibOrNone;

    public JdkZlibDecoder() {
        this(ZlibWrapper.ZLIB, null, false, 0);
    }

    public JdkZlibDecoder(int n) {
        this(ZlibWrapper.ZLIB, null, false, n);
    }

    public JdkZlibDecoder(byte[] byArray) {
        this(ZlibWrapper.ZLIB, byArray, false, 0);
    }

    public JdkZlibDecoder(byte[] byArray, int n) {
        this(ZlibWrapper.ZLIB, byArray, false, n);
    }

    public JdkZlibDecoder(ZlibWrapper zlibWrapper) {
        this(zlibWrapper, null, false, 0);
    }

    public JdkZlibDecoder(ZlibWrapper zlibWrapper, int n) {
        this(zlibWrapper, null, false, n);
    }

    public JdkZlibDecoder(ZlibWrapper zlibWrapper, boolean bl) {
        this(zlibWrapper, null, bl, 0);
    }

    public JdkZlibDecoder(ZlibWrapper zlibWrapper, boolean bl, int n) {
        this(zlibWrapper, null, bl, n);
    }

    public JdkZlibDecoder(boolean bl) {
        this(ZlibWrapper.GZIP, null, bl, 0);
    }

    public JdkZlibDecoder(boolean bl, int n) {
        this(ZlibWrapper.GZIP, null, bl, n);
    }

    private JdkZlibDecoder(ZlibWrapper zlibWrapper, byte[] byArray, boolean bl, int n) {
        super(n);
        ObjectUtil.checkNotNull((Object)((Object)zlibWrapper), (String)"wrapper");
        this.decompressConcatenated = bl;
        switch (zlibWrapper) {
            case GZIP: {
                this.inflater = new Inflater(true);
                this.crc = ByteBufChecksum.wrapChecksum(new CRC32());
                break;
            }
            case NONE: {
                this.inflater = new Inflater(true);
                this.crc = null;
                break;
            }
            case ZLIB: {
                this.inflater = new Inflater();
                this.crc = null;
                break;
            }
            case ZLIB_OR_NONE: {
                this.decideZlibOrNone = true;
                this.crc = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only GZIP or ZLIB is supported, but you used " + (Object)((Object)zlibWrapper));
            }
        }
        this.dictionary = byArray;
    }

    @Override
    public boolean isClosed() {
        return this.finished;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        ByteBuf byteBuf2;
        block28: {
            if (this.finished) {
                ByteBuf byteBuf3 = byteBuf;
                byteBuf3.skipBytes(byteBuf3.readableBytes());
                return;
            }
            int n = byteBuf.readableBytes();
            if (n == 0) {
                return;
            }
            if (this.decideZlibOrNone) {
                if (n < 2) {
                    return;
                }
                ByteBuf byteBuf4 = byteBuf;
                boolean bl = !JdkZlibDecoder.looksLikeZlib(byteBuf4.getShort(byteBuf4.readerIndex()));
                this.inflater = new Inflater(bl);
                this.decideZlibOrNone = false;
            }
            if (this.crc != null && this.gzipState != GzipState.HEADER_END) {
                if (this.gzipState == GzipState.FOOTER_START) {
                    if (!this.handleGzipFooter(byteBuf)) {
                        return;
                    }
                    assert (this.gzipState == GzipState.HEADER_START);
                }
                if (!this.readGZIPHeader(byteBuf)) {
                    return;
                }
                n = byteBuf.readableBytes();
                if (n == 0) {
                    return;
                }
            }
            if (this.inflater.needsInput()) {
                if (byteBuf.hasArray()) {
                    this.inflater.setInput(byteBuf.array(), byteBuf.arrayOffset() + byteBuf.readerIndex(), n);
                } else {
                    byte[] byArray = new byte[n];
                    ByteBuf byteBuf5 = byteBuf;
                    byteBuf5.getBytes(byteBuf5.readerIndex(), byArray);
                    this.inflater.setInput(byArray);
                }
            }
            byteBuf2 = this.prepareDecompressBuffer(channelHandlerContext, null, this.inflater.getRemaining() << 1);
            try {
                boolean bl = false;
                while (!this.inflater.needsInput()) {
                    byte[] byArray = byteBuf2.array();
                    int n2 = byteBuf2.writerIndex();
                    int n3 = byteBuf2.arrayOffset() + n2;
                    int n4 = byteBuf2.writableBytes();
                    if ((n4 = this.inflater.inflate(byArray, n3, n4)) > 0) {
                        byteBuf2.writerIndex(n2 + n4);
                        if (this.crc != null) {
                            this.crc.update(byArray, n3, n4);
                        }
                    } else if (this.inflater.needsDictionary()) {
                        if (this.dictionary == null) {
                            throw new DecompressionException("decompression failure, unable to set dictionary as non was specified");
                        }
                        this.inflater.setDictionary(this.dictionary);
                    }
                    if (this.inflater.finished()) {
                        if (this.crc == null) {
                            this.finished = true;
                            break;
                        }
                        bl = true;
                        break;
                    }
                    byteBuf2 = this.prepareDecompressBuffer(channelHandlerContext, byteBuf2, this.inflater.getRemaining() << 1);
                }
                byteBuf.skipBytes(n - this.inflater.getRemaining());
                if (!bl) break block28;
                this.gzipState = GzipState.FOOTER_START;
                this.handleGzipFooter(byteBuf);
            }
            catch (DataFormatException dataFormatException) {
                try {
                    throw new DecompressionException("decompression failure", dataFormatException);
                }
                catch (Throwable throwable) {
                    if (byteBuf2.isReadable()) {
                        list.add(byteBuf2);
                    } else {
                        byteBuf2.release();
                    }
                    throw throwable;
                }
            }
        }
        if (byteBuf2.isReadable()) {
            list.add(byteBuf2);
            return;
        }
        byteBuf2.release();
        return;
    }

    private boolean handleGzipFooter(ByteBuf byteBuf) {
        if (this.readGZIPFooter(byteBuf)) {
            boolean bl = this.finished = !this.decompressConcatenated;
            if (!this.finished) {
                this.inflater.reset();
                this.crc.reset();
                this.gzipState = GzipState.HEADER_START;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void decompressionBufferExhausted(ByteBuf byteBuf) {
        this.finished = true;
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        super.handlerRemoved0(channelHandlerContext);
        if (this.inflater != null) {
            this.inflater.end();
        }
    }

    private boolean readGZIPHeader(ByteBuf byteBuf) {
        switch (this.gzipState) {
            case HEADER_START: {
                if (byteBuf.readableBytes() < 10) {
                    return false;
                }
                short s = byteBuf.readByte();
                short s2 = byteBuf.readByte();
                if (s != 31) {
                    throw new DecompressionException("Input is not in the GZIP format");
                }
                this.crc.update(s);
                this.crc.update(s2);
                s = byteBuf.readUnsignedByte();
                if (s != 8) {
                    throw new DecompressionException("Unsupported compression method " + s + " in the GZIP header");
                }
                this.crc.update(s);
                this.flags = byteBuf.readUnsignedByte();
                this.crc.update(this.flags);
                if ((this.flags & 0xE0) != 0) {
                    throw new DecompressionException("Reserved flags are set in the GZIP header");
                }
                ByteBuf byteBuf2 = byteBuf;
                this.crc.update(byteBuf2, byteBuf2.readerIndex(), 4);
                byteBuf.skipBytes(4);
                this.crc.update(byteBuf.readUnsignedByte());
                this.crc.update(byteBuf.readUnsignedByte());
                this.gzipState = GzipState.FLG_READ;
            }
            case FLG_READ: {
                short s2;
                short s;
                if ((this.flags & 4) != 0) {
                    if (byteBuf.readableBytes() < 2) {
                        return false;
                    }
                    s = byteBuf.readUnsignedByte();
                    s2 = byteBuf.readUnsignedByte();
                    this.crc.update(s);
                    this.crc.update(s2);
                    this.xlen |= s << 8 | s2;
                }
                this.gzipState = GzipState.XLEN_READ;
            }
            case XLEN_READ: {
                if (this.xlen != -1) {
                    if (byteBuf.readableBytes() < this.xlen) {
                        return false;
                    }
                    ByteBuf byteBuf3 = byteBuf;
                    this.crc.update(byteBuf3, byteBuf3.readerIndex(), this.xlen);
                    byteBuf.skipBytes(this.xlen);
                }
                this.gzipState = GzipState.SKIP_FNAME;
            }
            case SKIP_FNAME: {
                if (!this.skipIfNeeded(byteBuf, 8)) {
                    return false;
                }
                this.gzipState = GzipState.SKIP_COMMENT;
            }
            case SKIP_COMMENT: {
                if (!this.skipIfNeeded(byteBuf, 16)) {
                    return false;
                }
                this.gzipState = GzipState.PROCESS_FHCRC;
            }
            case PROCESS_FHCRC: {
                if ((this.flags & 2) != 0 && !this.verifyCrc16(byteBuf)) {
                    return false;
                }
                this.crc.reset();
                this.gzipState = GzipState.HEADER_END;
            }
            case HEADER_END: {
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private boolean skipIfNeeded(ByteBuf byteBuf, int n) {
        if ((this.flags & n) != 0) {
            do {
                if (!byteBuf.isReadable()) {
                    return false;
                }
                n = byteBuf.readUnsignedByte();
                this.crc.update(n);
            } while (n != 0);
        }
        return true;
    }

    private boolean readGZIPFooter(ByteBuf byteBuf) {
        int n;
        if (byteBuf.readableBytes() < 8) {
            return false;
        }
        int n2 = this.verifyCrc(byteBuf);
        assert (n2 != 0);
        n2 = 0;
        for (n = 0; n < 4; ++n) {
            n2 |= byteBuf.readUnsignedByte() << (n << 3);
        }
        n = this.inflater.getTotalOut();
        if (n2 != n) {
            throw new DecompressionException("Number of bytes mismatch. Expected: " + n2 + ", Got: " + n);
        }
        return true;
    }

    private boolean verifyCrc(ByteBuf byteBuf) {
        if (byteBuf.readableBytes() < 4) {
            return false;
        }
        long l = 0L;
        for (int i = 0; i < 4; ++i) {
            l |= (long)byteBuf.readUnsignedByte() << (i << 3);
        }
        long l2 = this.crc.getValue();
        if (l != l2) {
            throw new DecompressionException("CRC value mismatch. Expected: " + l + ", Got: " + l2);
        }
        return true;
    }

    private boolean verifyCrc16(ByteBuf byteBuf) {
        if (byteBuf.readableBytes() < 2) {
            return false;
        }
        long l = this.crc.getValue();
        long l2 = 0L;
        long l3 = 0L;
        for (int i = 0; i < 2; ++i) {
            l2 |= (long)byteBuf.readUnsignedByte() << (i << 3);
            l3 |= (l >> (i << 3) & 0xFFL) << (i << 3);
        }
        if (l2 != l3) {
            throw new DecompressionException("CRC16 value mismatch. Expected: " + l2 + ", Got: " + l3);
        }
        return true;
    }

    private static boolean looksLikeZlib(short s) {
        return (s & 0x7800) == 30720 && s % 31 == 0;
    }

    private static enum GzipState {
        HEADER_START,
        HEADER_END,
        FLG_READ,
        XLEN_READ,
        SKIP_FNAME,
        SKIP_COMMENT,
        PROCESS_FHCRC,
        FOOTER_START;

    }
}

