/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.ImmediateExecutor;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;

public class HashedWheelTimer
implements Timer {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(HashedWheelTimer.class);
    private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger();
    private static final AtomicBoolean WARNED_TOO_MANY_INSTANCES = new AtomicBoolean();
    private static final int INSTANCE_COUNT_LIMIT = 64;
    private static final long MILLISECOND_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ResourceLeakDetector<HashedWheelTimer> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(HashedWheelTimer.class, 1);
    private static final AtomicIntegerFieldUpdater<HashedWheelTimer> WORKER_STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(HashedWheelTimer.class, "workerState");
    private final ResourceLeakTracker<HashedWheelTimer> leak;
    private final Worker worker = new Worker();
    private final Thread workerThread;
    public static final int WORKER_STATE_INIT = 0;
    public static final int WORKER_STATE_STARTED = 1;
    public static final int WORKER_STATE_SHUTDOWN = 2;
    private volatile int workerState;
    private final long tickDuration;
    private final HashedWheelBucket[] wheel;
    private final int mask;
    private final CountDownLatch startTimeInitialized = new CountDownLatch(1);
    private final Queue<HashedWheelTimeout> timeouts = PlatformDependent.newMpscQueue();
    private final Queue<HashedWheelTimeout> cancelledTimeouts = PlatformDependent.newMpscQueue();
    private final AtomicLong pendingTimeouts = new AtomicLong(0L);
    private final long maxPendingTimeouts;
    private final Executor taskExecutor;
    private volatile long startTime;

    public HashedWheelTimer() {
        this(Executors.defaultThreadFactory());
    }

    public HashedWheelTimer(long l, TimeUnit timeUnit) {
        this(Executors.defaultThreadFactory(), l, timeUnit);
    }

    public HashedWheelTimer(long l, TimeUnit timeUnit, int n) {
        this(Executors.defaultThreadFactory(), l, timeUnit, n);
    }

    public HashedWheelTimer(ThreadFactory threadFactory) {
        this(threadFactory, 100L, TimeUnit.MILLISECONDS);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long l, TimeUnit timeUnit) {
        this(threadFactory, l, timeUnit, 512);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long l, TimeUnit timeUnit, int n) {
        this(threadFactory, l, timeUnit, n, true);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long l, TimeUnit timeUnit, int n, boolean bl) {
        this(threadFactory, l, timeUnit, n, bl, -1L);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long l, TimeUnit timeUnit, int n, boolean bl, long l2) {
        this(threadFactory, l, timeUnit, n, bl, l2, ImmediateExecutor.INSTANCE);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long l, TimeUnit timeUnit, int n, boolean bl, long l2, Executor executor) {
        ObjectUtil.checkNotNull(threadFactory, "threadFactory");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        ObjectUtil.checkPositive(l, "tickDuration");
        ObjectUtil.checkPositive(n, "ticksPerWheel");
        this.taskExecutor = ObjectUtil.checkNotNull(executor, "taskExecutor");
        this.wheel = HashedWheelTimer.createWheel(n);
        this.mask = this.wheel.length - 1;
        long l3 = timeUnit.toNanos(l);
        if (l3 >= Long.MAX_VALUE / (long)this.wheel.length) {
            throw new IllegalArgumentException(String.format("tickDuration: %d (expected: 0 < tickDuration in nanos < %d", l, Long.MAX_VALUE / (long)this.wheel.length));
        }
        if (l3 < MILLISECOND_NANOS) {
            logger.warn("Configured tickDuration {} smaller than {}, using 1ms.", (Object)l, (Object)MILLISECOND_NANOS);
            this.tickDuration = MILLISECOND_NANOS;
        } else {
            this.tickDuration = l3;
        }
        this.workerThread = threadFactory.newThread(this.worker);
        this.leak = bl || !this.workerThread.isDaemon() ? leakDetector.track(this) : null;
        this.maxPendingTimeouts = l2;
        if (INSTANCE_COUNTER.incrementAndGet() > 64 && WARNED_TOO_MANY_INSTANCES.compareAndSet(false, true)) {
            HashedWheelTimer.reportTooManyInstances();
        }
    }

    protected void finalize() {
        block3: {
            try {
                super.finalize();
                if (WORKER_STATE_UPDATER.getAndSet(this, 2) == 2) break block3;
                INSTANCE_COUNTER.decrementAndGet();
            }
            catch (Throwable throwable) {
                if (WORKER_STATE_UPDATER.getAndSet(this, 2) != 2) {
                    INSTANCE_COUNTER.decrementAndGet();
                }
                throw throwable;
            }
            return;
        }
    }

    private static HashedWheelBucket[] createWheel(int n) {
        n = MathUtil.findNextPositivePowerOfTwo(n);
        HashedWheelBucket[] hashedWheelBucketArray = new HashedWheelBucket[n];
        for (int i = 0; i < hashedWheelBucketArray.length; ++i) {
            hashedWheelBucketArray[i] = new HashedWheelBucket();
        }
        return hashedWheelBucketArray;
    }

    public void start() {
        switch (WORKER_STATE_UPDATER.get(this)) {
            case 0: {
                if (!WORKER_STATE_UPDATER.compareAndSet(this, 0, 1)) break;
                this.workerThread.start();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                throw new IllegalStateException("cannot be started once stopped");
            }
            default: {
                throw new Error("Invalid WorkerState");
            }
        }
        while (this.startTime == 0L) {
            try {
                this.startTimeInitialized.await();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public Set<Timeout> stop() {
        boolean bl;
        if (Thread.currentThread() == this.workerThread) {
            throw new IllegalStateException(HashedWheelTimer.class.getSimpleName() + ".stop() cannot be called from " + TimerTask.class.getSimpleName());
        }
        if (!WORKER_STATE_UPDATER.compareAndSet(this, 1, 2)) {
            if (WORKER_STATE_UPDATER.getAndSet(this, 2) != 2) {
                INSTANCE_COUNTER.decrementAndGet();
                if (this.leak != null) {
                    boolean bl2 = this.leak.close(this);
                    assert (bl2);
                }
            }
            return Collections.emptySet();
        }
        try {
            bl = false;
            while (this.workerThread.isAlive()) {
                this.workerThread.interrupt();
                try {
                    this.workerThread.join(100L);
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            INSTANCE_COUNTER.decrementAndGet();
            if (this.leak != null) {
                bl = this.leak.close(this);
                assert (bl);
            }
        }
        Object object = this.worker.unprocessedTimeouts();
        HashSet<Timeout> hashSet = new HashSet<Timeout>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            Timeout timeout = (Timeout)object.next();
            if (!timeout.cancel()) continue;
            hashSet.add(timeout);
        }
        return hashSet;
    }

    @Override
    public Timeout newTimeout(TimerTask object, long l, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(object, "task");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        long l2 = this.pendingTimeouts.incrementAndGet();
        if (this.maxPendingTimeouts > 0L && l2 > this.maxPendingTimeouts) {
            this.pendingTimeouts.decrementAndGet();
            throw new RejectedExecutionException("Number of pending timeouts (" + l2 + ") is greater than or equal to maximum allowed pending timeouts (" + this.maxPendingTimeouts + ")");
        }
        this.start();
        long l3 = System.nanoTime() + timeUnit.toNanos(l) - this.startTime;
        if (l > 0L && l3 < 0L) {
            l3 = Long.MAX_VALUE;
        }
        object = new HashedWheelTimeout(this, (TimerTask)object, l3);
        this.timeouts.add((HashedWheelTimeout)object);
        return object;
    }

    public long pendingTimeouts() {
        return this.pendingTimeouts.get();
    }

    private static void reportTooManyInstances() {
        if (logger.isErrorEnabled()) {
            String string = StringUtil.simpleClassName(HashedWheelTimer.class);
            logger.error("You are creating too many " + string + " instances. " + string + " is a shared resource that must be reused across the JVM, so that only a few instances are created.");
        }
    }

    private static final class HashedWheelBucket {
        private HashedWheelTimeout head;
        private HashedWheelTimeout tail;

        private HashedWheelBucket() {
        }

        public final void addTimeout(HashedWheelTimeout hashedWheelTimeout) {
            assert (hashedWheelTimeout.bucket == null);
            hashedWheelTimeout.bucket = this;
            if (this.head == null) {
                HashedWheelBucket hashedWheelBucket = this;
                hashedWheelBucket.head = hashedWheelBucket.tail = hashedWheelTimeout;
                return;
            }
            this.tail.next = hashedWheelTimeout;
            hashedWheelTimeout.prev = this.tail;
            this.tail = hashedWheelTimeout;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void expireTimeouts(long l) {
            HashedWheelTimeout hashedWheelTimeout = this.head;
            while (hashedWheelTimeout != null) {
                HashedWheelTimeout hashedWheelTimeout2 = hashedWheelTimeout.next;
                if (hashedWheelTimeout.remainingRounds <= 0L) {
                    hashedWheelTimeout2 = this.remove(hashedWheelTimeout);
                    if (hashedWheelTimeout.deadline > l) throw new IllegalStateException(String.format("timeout.deadline (%d) > deadline (%d)", hashedWheelTimeout.deadline, l));
                    hashedWheelTimeout.expire();
                } else if (hashedWheelTimeout.isCancelled()) {
                    hashedWheelTimeout2 = this.remove(hashedWheelTimeout);
                } else {
                    --hashedWheelTimeout.remainingRounds;
                }
                hashedWheelTimeout = hashedWheelTimeout2;
            }
        }

        public final HashedWheelTimeout remove(HashedWheelTimeout hashedWheelTimeout) {
            HashedWheelTimeout hashedWheelTimeout2 = hashedWheelTimeout.next;
            if (hashedWheelTimeout.prev != null) {
                hashedWheelTimeout.prev.next = hashedWheelTimeout2;
            }
            if (hashedWheelTimeout.next != null) {
                hashedWheelTimeout.next.prev = hashedWheelTimeout.prev;
            }
            if (hashedWheelTimeout == this.head) {
                if (hashedWheelTimeout == this.tail) {
                    this.tail = null;
                    this.head = null;
                } else {
                    this.head = hashedWheelTimeout2;
                }
            } else if (hashedWheelTimeout == this.tail) {
                this.tail = hashedWheelTimeout.prev;
            }
            hashedWheelTimeout.prev = null;
            hashedWheelTimeout.next = null;
            hashedWheelTimeout.bucket = null;
            hashedWheelTimeout.timer.pendingTimeouts.decrementAndGet();
            return hashedWheelTimeout2;
        }

        public final void clearTimeouts(Set<Timeout> set) {
            HashedWheelTimeout hashedWheelTimeout;
            while ((hashedWheelTimeout = this.pollTimeout()) != null) {
                if (hashedWheelTimeout.isExpired() || hashedWheelTimeout.isCancelled()) continue;
                set.add(hashedWheelTimeout);
            }
            return;
        }

        private HashedWheelTimeout pollTimeout() {
            HashedWheelTimeout hashedWheelTimeout = this.head;
            if (hashedWheelTimeout == null) {
                return null;
            }
            HashedWheelTimeout hashedWheelTimeout2 = hashedWheelTimeout.next;
            if (hashedWheelTimeout2 == null) {
                HashedWheelBucket hashedWheelBucket = this;
                hashedWheelBucket.head = null;
                hashedWheelBucket.tail = null;
            } else {
                this.head = hashedWheelTimeout2;
                hashedWheelTimeout2.prev = null;
            }
            hashedWheelTimeout.next = null;
            hashedWheelTimeout.prev = null;
            hashedWheelTimeout.bucket = null;
            return hashedWheelTimeout;
        }
    }

    private static final class HashedWheelTimeout
    implements Timeout,
    Runnable {
        private static final int ST_INIT = 0;
        private static final int ST_CANCELLED = 1;
        private static final int ST_EXPIRED = 2;
        private static final AtomicIntegerFieldUpdater<HashedWheelTimeout> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(HashedWheelTimeout.class, "state");
        private final HashedWheelTimer timer;
        private final TimerTask task;
        private final long deadline;
        private volatile int state = 0;
        long remainingRounds;
        HashedWheelTimeout next;
        HashedWheelTimeout prev;
        HashedWheelBucket bucket;

        HashedWheelTimeout(HashedWheelTimer hashedWheelTimer, TimerTask timerTask, long l) {
            this.timer = hashedWheelTimer;
            this.task = timerTask;
            this.deadline = l;
        }

        @Override
        public final Timer timer() {
            return this.timer;
        }

        @Override
        public final TimerTask task() {
            return this.task;
        }

        @Override
        public final boolean cancel() {
            if (!this.compareAndSetState(0, 1)) {
                return false;
            }
            this.timer.cancelledTimeouts.add(this);
            return true;
        }

        final void remove() {
            HashedWheelBucket hashedWheelBucket = this.bucket;
            if (hashedWheelBucket != null) {
                hashedWheelBucket.remove(this);
                return;
            }
            this.timer.pendingTimeouts.decrementAndGet();
        }

        public final boolean compareAndSetState(int n, int n2) {
            return STATE_UPDATER.compareAndSet(this, n, n2);
        }

        public final int state() {
            return this.state;
        }

        @Override
        public final boolean isCancelled() {
            return this.state() == 1;
        }

        @Override
        public final boolean isExpired() {
            return this.state() == 2;
        }

        public final void expire() {
            if (!this.compareAndSetState(0, 2)) {
                return;
            }
            try {
                this.timer.taskExecutor.execute(this);
                return;
            }
            catch (Throwable throwable) {
                if (logger.isWarnEnabled()) {
                    logger.warn("An exception was thrown while submit " + TimerTask.class.getSimpleName() + " for execution.", throwable);
                }
                return;
            }
        }

        @Override
        public final void run() {
            try {
                this.task.run(this);
                return;
            }
            catch (Throwable throwable) {
                if (logger.isWarnEnabled()) {
                    logger.warn("An exception was thrown by " + TimerTask.class.getSimpleName() + '.', throwable);
                }
                return;
            }
        }

        public final String toString() {
            long l = System.nanoTime();
            long l2 = this.deadline - l + this.timer.startTime;
            StringBuilder stringBuilder = new StringBuilder(192).append(StringUtil.simpleClassName(this)).append('(').append("deadline: ");
            if (l2 > 0L) {
                stringBuilder.append(l2).append(" ns later");
            } else if (l2 < 0L) {
                stringBuilder.append(-l2).append(" ns ago");
            } else {
                stringBuilder.append("now");
            }
            if (this.isCancelled()) {
                stringBuilder.append(", cancelled");
            }
            return stringBuilder.append(", task: ").append(this.task()).append(')').toString();
        }
    }

    private final class Worker
    implements Runnable {
        private final Set<Timeout> unprocessedTimeouts = new HashSet<Timeout>();
        private long tick;

        private Worker() {
        }

        @Override
        public final void run() {
            HashedWheelBucket hashedWheelBucket;
            int n;
            HashedWheelTimer.this.startTime = System.nanoTime();
            if (HashedWheelTimer.this.startTime == 0L) {
                HashedWheelTimer.this.startTime = 1L;
            }
            HashedWheelTimer.this.startTimeInitialized.countDown();
            do {
                long l;
                if ((l = this.waitForNextTick()) <= 0L) continue;
                n = (int)(this.tick & (long)HashedWheelTimer.this.mask);
                this.processCancelledTasks();
                hashedWheelBucket = HashedWheelTimer.this.wheel[n];
                this.transferTimeoutsToBuckets();
                hashedWheelBucket.expireTimeouts(l);
                ++this.tick;
            } while (WORKER_STATE_UPDATER.get(HashedWheelTimer.this) == 1);
            Object object = HashedWheelTimer.this.wheel;
            int n2 = ((HashedWheelBucket[])object).length;
            for (n = 0; n < n2; ++n) {
                hashedWheelBucket = object[n];
                hashedWheelBucket.clearTimeouts(this.unprocessedTimeouts);
            }
            while ((object = (HashedWheelTimeout)HashedWheelTimer.this.timeouts.poll()) != null) {
                if (((HashedWheelTimeout)object).isCancelled()) continue;
                this.unprocessedTimeouts.add((Timeout)object);
            }
            this.processCancelledTasks();
        }

        private void transferTimeoutsToBuckets() {
            HashedWheelTimeout hashedWheelTimeout;
            for (int i = 0; i < 100000 && (hashedWheelTimeout = (HashedWheelTimeout)HashedWheelTimer.this.timeouts.poll()) != null; ++i) {
                if (hashedWheelTimeout.state() == 1) continue;
                long l = hashedWheelTimeout.deadline / HashedWheelTimer.this.tickDuration;
                hashedWheelTimeout.remainingRounds = (l - this.tick) / (long)HashedWheelTimer.this.wheel.length;
                long l2 = Math.max(l, this.tick);
                int n = (int)(l2 & (long)HashedWheelTimer.this.mask);
                HashedWheelBucket hashedWheelBucket = HashedWheelTimer.this.wheel[n];
                hashedWheelBucket.addTimeout(hashedWheelTimeout);
            }
        }

        private void processCancelledTasks() {
            HashedWheelTimeout hashedWheelTimeout;
            while ((hashedWheelTimeout = (HashedWheelTimeout)HashedWheelTimer.this.cancelledTimeouts.poll()) != null) {
                try {
                    hashedWheelTimeout.remove();
                }
                catch (Throwable throwable) {
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn("An exception was thrown while process a cancellation task", throwable);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private long waitForNextTick() {
            long l = HashedWheelTimer.this.tickDuration * (this.tick + 1L);
            while (true) {
                long l2;
                long l3;
                if ((l3 = (l - (l2 = System.nanoTime() - HashedWheelTimer.this.startTime) + 999999L) / 1000000L) <= 0L) {
                    if (l2 != Long.MIN_VALUE) return l2;
                    return -9223372036854775807L;
                }
                if (PlatformDependent.isWindows() && (l3 = l3 / 10L * 10L) == 0L) {
                    l3 = 1L;
                }
                try {
                    Thread.sleep(l3);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    if (WORKER_STATE_UPDATER.get(HashedWheelTimer.this) == 2) return Long.MIN_VALUE;
                    continue;
                }
                break;
            }
        }

        public final Set<Timeout> unprocessedTimeouts() {
            return Collections.unmodifiableSet(this.unprocessedTimeouts);
        }
    }
}

