/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.CharObjectMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class CharCollections {
    private static final CharObjectMap<Object> EMPTY_MAP = new EmptyMap();

    private CharCollections() {
    }

    public static <V> CharObjectMap<V> emptyMap() {
        return EMPTY_MAP;
    }

    public static <V> CharObjectMap<V> unmodifiableMap(CharObjectMap<V> charObjectMap) {
        return new UnmodifiableMap<V>(charObjectMap);
    }

    private static final class UnmodifiableMap<V>
    implements CharObjectMap<V> {
        private final CharObjectMap<V> map;
        private Set<Character> keySet;
        private Set<Map.Entry<Character, V>> entrySet;
        private Collection<V> values;
        private Iterable<CharObjectMap.PrimitiveEntry<V>> entries;

        UnmodifiableMap(CharObjectMap<V> charObjectMap) {
            this.map = charObjectMap;
        }

        @Override
        public final V get(char c) {
            return this.map.get(c);
        }

        @Override
        public final V put(char c, V v) {
            throw new UnsupportedOperationException("put");
        }

        @Override
        public final V remove(char c) {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public final int size() {
            return this.map.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public final void clear() {
            throw new UnsupportedOperationException("clear");
        }

        @Override
        public final boolean containsKey(char c) {
            return this.map.containsKey(c);
        }

        @Override
        public final boolean containsValue(Object object) {
            return this.map.containsValue(object);
        }

        @Override
        public final boolean containsKey(Object object) {
            return this.map.containsKey(object);
        }

        @Override
        public final V get(Object object) {
            return this.map.get(object);
        }

        @Override
        public final V put(Character c, V v) {
            throw new UnsupportedOperationException("put");
        }

        @Override
        public final V remove(Object object) {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public final void putAll(Map<? extends Character, ? extends V> map) {
            throw new UnsupportedOperationException("putAll");
        }

        @Override
        public final Iterable<CharObjectMap.PrimitiveEntry<V>> entries() {
            if (this.entries == null) {
                this.entries = new Iterable<CharObjectMap.PrimitiveEntry<V>>(){

                    @Override
                    public Iterator<CharObjectMap.PrimitiveEntry<V>> iterator() {
                        return new IteratorImpl(UnmodifiableMap.this.map.entries().iterator());
                    }
                };
            }
            return this.entries;
        }

        @Override
        public final Set<Character> keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.unmodifiableSet(this.map.keySet());
            }
            return this.keySet;
        }

        @Override
        public final Set<Map.Entry<Character, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = Collections.unmodifiableSet(this.map.entrySet());
            }
            return this.entrySet;
        }

        @Override
        public final Collection<V> values() {
            if (this.values == null) {
                this.values = Collections.unmodifiableCollection(this.map.values());
            }
            return this.values;
        }

        private class EntryImpl
        implements CharObjectMap.PrimitiveEntry<V> {
            private final CharObjectMap.PrimitiveEntry<V> entry;

            EntryImpl(CharObjectMap.PrimitiveEntry<V> primitiveEntry) {
                this.entry = primitiveEntry;
            }

            @Override
            public char key() {
                return this.entry.key();
            }

            @Override
            public V value() {
                return this.entry.value();
            }

            @Override
            public void setValue(V v) {
                throw new UnsupportedOperationException("setValue");
            }
        }

        private class IteratorImpl
        implements Iterator<CharObjectMap.PrimitiveEntry<V>> {
            final Iterator<CharObjectMap.PrimitiveEntry<V>> iter;

            IteratorImpl(Iterator<CharObjectMap.PrimitiveEntry<V>> iterator) {
                this.iter = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public CharObjectMap.PrimitiveEntry<V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return new EntryImpl(this.iter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        }
    }

    private static final class EmptyMap
    implements CharObjectMap<Object> {
        private EmptyMap() {
        }

        @Override
        public final Object get(char c) {
            return null;
        }

        @Override
        public final Object put(char c, Object object) {
            throw new UnsupportedOperationException("put");
        }

        @Override
        public final Object remove(char c) {
            return null;
        }

        @Override
        public final int size() {
            return 0;
        }

        @Override
        public final boolean isEmpty() {
            return true;
        }

        @Override
        public final boolean containsKey(Object object) {
            return false;
        }

        @Override
        public final void clear() {
        }

        @Override
        public final Set<Character> keySet() {
            return Collections.emptySet();
        }

        @Override
        public final boolean containsKey(char c) {
            return false;
        }

        @Override
        public final boolean containsValue(Object object) {
            return false;
        }

        @Override
        public final Iterable<CharObjectMap.PrimitiveEntry<Object>> entries() {
            return Collections.emptySet();
        }

        @Override
        public final Object get(Object object) {
            return null;
        }

        @Override
        public final Object put(Character c, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Object remove(Object object) {
            return null;
        }

        @Override
        public final void putAll(Map<? extends Character, ?> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Collection<Object> values() {
            return Collections.emptyList();
        }

        @Override
        public final Set<Map.Entry<Character, Object>> entrySet() {
            return Collections.emptySet();
        }
    }
}

