/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.IntObjectMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class IntCollections {
    private static final IntObjectMap<Object> EMPTY_MAP = new EmptyMap();

    private IntCollections() {
    }

    public static <V> IntObjectMap<V> emptyMap() {
        return EMPTY_MAP;
    }

    public static <V> IntObjectMap<V> unmodifiableMap(IntObjectMap<V> intObjectMap) {
        return new UnmodifiableMap<V>(intObjectMap);
    }

    private static final class UnmodifiableMap<V>
    implements IntObjectMap<V> {
        private final IntObjectMap<V> map;
        private Set<Integer> keySet;
        private Set<Map.Entry<Integer, V>> entrySet;
        private Collection<V> values;
        private Iterable<IntObjectMap.PrimitiveEntry<V>> entries;

        UnmodifiableMap(IntObjectMap<V> intObjectMap) {
            this.map = intObjectMap;
        }

        @Override
        public final V get(int n) {
            return this.map.get(n);
        }

        @Override
        public final V put(int n, V v) {
            throw new UnsupportedOperationException("put");
        }

        @Override
        public final V remove(int n) {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public final int size() {
            return this.map.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public final void clear() {
            throw new UnsupportedOperationException("clear");
        }

        @Override
        public final boolean containsKey(int n) {
            return this.map.containsKey(n);
        }

        @Override
        public final boolean containsValue(Object object) {
            return this.map.containsValue(object);
        }

        @Override
        public final boolean containsKey(Object object) {
            return this.map.containsKey(object);
        }

        @Override
        public final V get(Object object) {
            return this.map.get(object);
        }

        @Override
        public final V put(Integer n, V v) {
            throw new UnsupportedOperationException("put");
        }

        @Override
        public final V remove(Object object) {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public final void putAll(Map<? extends Integer, ? extends V> map) {
            throw new UnsupportedOperationException("putAll");
        }

        @Override
        public final Iterable<IntObjectMap.PrimitiveEntry<V>> entries() {
            if (this.entries == null) {
                this.entries = new Iterable<IntObjectMap.PrimitiveEntry<V>>(){

                    @Override
                    public Iterator<IntObjectMap.PrimitiveEntry<V>> iterator() {
                        return new IteratorImpl(UnmodifiableMap.this.map.entries().iterator());
                    }
                };
            }
            return this.entries;
        }

        @Override
        public final Set<Integer> keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.unmodifiableSet(this.map.keySet());
            }
            return this.keySet;
        }

        @Override
        public final Set<Map.Entry<Integer, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = Collections.unmodifiableSet(this.map.entrySet());
            }
            return this.entrySet;
        }

        @Override
        public final Collection<V> values() {
            if (this.values == null) {
                this.values = Collections.unmodifiableCollection(this.map.values());
            }
            return this.values;
        }

        private class EntryImpl
        implements IntObjectMap.PrimitiveEntry<V> {
            private final IntObjectMap.PrimitiveEntry<V> entry;

            EntryImpl(IntObjectMap.PrimitiveEntry<V> primitiveEntry) {
                this.entry = primitiveEntry;
            }

            @Override
            public int key() {
                return this.entry.key();
            }

            @Override
            public V value() {
                return this.entry.value();
            }

            @Override
            public void setValue(V v) {
                throw new UnsupportedOperationException("setValue");
            }
        }

        private class IteratorImpl
        implements Iterator<IntObjectMap.PrimitiveEntry<V>> {
            final Iterator<IntObjectMap.PrimitiveEntry<V>> iter;

            IteratorImpl(Iterator<IntObjectMap.PrimitiveEntry<V>> iterator) {
                this.iter = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public IntObjectMap.PrimitiveEntry<V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return new EntryImpl(this.iter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        }
    }

    private static final class EmptyMap
    implements IntObjectMap<Object> {
        private EmptyMap() {
        }

        @Override
        public final Object get(int n) {
            return null;
        }

        @Override
        public final Object put(int n, Object object) {
            throw new UnsupportedOperationException("put");
        }

        @Override
        public final Object remove(int n) {
            return null;
        }

        @Override
        public final int size() {
            return 0;
        }

        @Override
        public final boolean isEmpty() {
            return true;
        }

        @Override
        public final boolean containsKey(Object object) {
            return false;
        }

        @Override
        public final void clear() {
        }

        @Override
        public final Set<Integer> keySet() {
            return Collections.emptySet();
        }

        @Override
        public final boolean containsKey(int n) {
            return false;
        }

        @Override
        public final boolean containsValue(Object object) {
            return false;
        }

        @Override
        public final Iterable<IntObjectMap.PrimitiveEntry<Object>> entries() {
            return Collections.emptySet();
        }

        @Override
        public final Object get(Object object) {
            return null;
        }

        @Override
        public final Object put(Integer n, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Object remove(Object object) {
            return null;
        }

        @Override
        public final void putAll(Map<? extends Integer, ?> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Collection<Object> values() {
            return Collections.emptyList();
        }

        @Override
        public final Set<Map.Entry<Integer, Object>> entrySet() {
            return Collections.emptySet();
        }
    }
}

