/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.util.PortableJvmInfo;

public final class MessagePassingQueueUtil {
    public static <E> int drain(MessagePassingQueue<E> messagePassingQueue, MessagePassingQueue.Consumer<E> consumer, int n) {
        E e;
        int n2;
        if (consumer == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("limit is negative: " + n);
        }
        if (n == 0) {
            return 0;
        }
        for (n2 = 0; n2 < n && (e = messagePassingQueue.relaxedPoll()) != null; ++n2) {
            consumer.accept(e);
        }
        return n2;
    }

    public static <E> int drain(MessagePassingQueue<E> messagePassingQueue, MessagePassingQueue.Consumer<E> consumer) {
        E e;
        if (consumer == null) {
            throw new IllegalArgumentException("c is null");
        }
        int n = 0;
        while ((e = messagePassingQueue.relaxedPoll()) != null) {
            ++n;
            consumer.accept(e);
        }
        return n;
    }

    public static <E> void drain(MessagePassingQueue<E> messagePassingQueue, MessagePassingQueue.Consumer<E> consumer, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        if (consumer == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (waitStrategy == null) {
            throw new IllegalArgumentException("wait is null");
        }
        if (exitCondition == null) {
            throw new IllegalArgumentException("exit condition is null");
        }
        int n = 0;
        while (exitCondition.keepRunning()) {
            E e = messagePassingQueue.relaxedPoll();
            if (e == null) {
                n = waitStrategy.idle(n);
                continue;
            }
            n = 0;
            consumer.accept(e);
        }
    }

    public static <E> void fill(MessagePassingQueue<E> messagePassingQueue, MessagePassingQueue.Supplier<E> supplier, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        if (waitStrategy == null) {
            throw new IllegalArgumentException("waiter is null");
        }
        if (exitCondition == null) {
            throw new IllegalArgumentException("exit condition is null");
        }
        int n = 0;
        while (exitCondition.keepRunning()) {
            if (messagePassingQueue.fill(supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH) == 0) {
                n = waitStrategy.idle(n);
                continue;
            }
            n = 0;
        }
    }

    public static <E> int fillBounded(MessagePassingQueue<E> messagePassingQueue, MessagePassingQueue.Supplier<E> supplier) {
        return MessagePassingQueueUtil.fillInBatchesToLimit(messagePassingQueue, supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH, messagePassingQueue.capacity());
    }

    public static <E> int fillInBatchesToLimit(MessagePassingQueue<E> messagePassingQueue, MessagePassingQueue.Supplier<E> supplier, int n, int n2) {
        int n3;
        long l = 0L;
        do {
            if ((n3 = messagePassingQueue.fill(supplier, n)) != 0) continue;
            return (int)l;
        } while ((l += (long)n3) <= (long)n2);
        return (int)l;
    }

    public static <E> int fillUnbounded(MessagePassingQueue<E> messagePassingQueue, MessagePassingQueue.Supplier<E> supplier) {
        return MessagePassingQueueUtil.fillInBatchesToLimit(messagePassingQueue, supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH, 4096);
    }
}

