/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

import io.netty.util.internal.shaded.org.jctools.queues.BaseLinkedQueue;
import io.netty.util.internal.shaded.org.jctools.queues.LinkedQueueNode;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueueUtil;

public class SpscLinkedQueue<E>
extends BaseLinkedQueue<E> {
    public SpscLinkedQueue() {
        LinkedQueueNode linkedQueueNode = this.newNode();
        this.spProducerNode(linkedQueueNode);
        this.spConsumerNode(linkedQueueNode);
        linkedQueueNode.soNext(null);
    }

    @Override
    public boolean offer(E object) {
        if (object == null) {
            throw new NullPointerException();
        }
        object = this.newNode(object);
        LinkedQueueNode linkedQueueNode = this.lpProducerNode();
        this.soProducerNode(object);
        linkedQueueNode.soNext(object);
        return true;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier) {
        return MessagePassingQueueUtil.fillUnbounded(this, supplier);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier, int n) {
        LinkedQueueNode<E> linkedQueueNode;
        if (supplier == null) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("limit is negative:" + n);
        }
        if (n == 0) {
            return 0;
        }
        LinkedQueueNode<E> linkedQueueNode2 = linkedQueueNode = this.newNode(supplier.get());
        for (int i = 1; i < n; ++i) {
            LinkedQueueNode<E> linkedQueueNode3 = this.newNode(supplier.get());
            linkedQueueNode.spNext(linkedQueueNode3);
            linkedQueueNode = linkedQueueNode3;
        }
        LinkedQueueNode<E> linkedQueueNode4 = this.lpProducerNode();
        this.soProducerNode(linkedQueueNode);
        linkedQueueNode4.soNext(linkedQueueNode2);
        return n;
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> supplier, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.fill(this, supplier, waitStrategy, exitCondition);
    }
}

