/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues.atomic;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.BaseLinkedAtomicQueuePad2;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.LinkedQueueAtomicNode;
import java.util.Iterator;

abstract class BaseLinkedAtomicQueue<E>
extends BaseLinkedAtomicQueuePad2<E> {
    BaseLinkedAtomicQueue() {
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    protected final LinkedQueueAtomicNode<E> newNode() {
        return new LinkedQueueAtomicNode();
    }

    protected final LinkedQueueAtomicNode<E> newNode(E e) {
        return new LinkedQueueAtomicNode<E>(e);
    }

    @Override
    public final int size() {
        int n;
        LinkedQueueAtomicNode linkedQueueAtomicNode = this.lvConsumerNode();
        LinkedQueueAtomicNode linkedQueueAtomicNode2 = this.lvProducerNode();
        for (n = 0; linkedQueueAtomicNode != linkedQueueAtomicNode2 && linkedQueueAtomicNode != null && n < Integer.MAX_VALUE; ++n) {
            LinkedQueueAtomicNode linkedQueueAtomicNode3 = linkedQueueAtomicNode.lvNext();
            if (linkedQueueAtomicNode3 == linkedQueueAtomicNode) {
                return n;
            }
            linkedQueueAtomicNode = linkedQueueAtomicNode3;
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        LinkedQueueAtomicNode linkedQueueAtomicNode;
        LinkedQueueAtomicNode linkedQueueAtomicNode2 = this.lvConsumerNode();
        return linkedQueueAtomicNode2 == (linkedQueueAtomicNode = this.lvProducerNode());
    }

    protected E getSingleConsumerNodeValue(LinkedQueueAtomicNode<E> linkedQueueAtomicNode, LinkedQueueAtomicNode<E> linkedQueueAtomicNode2) {
        E e = linkedQueueAtomicNode2.getAndNullValue();
        LinkedQueueAtomicNode<E> linkedQueueAtomicNode3 = linkedQueueAtomicNode;
        linkedQueueAtomicNode3.soNext(linkedQueueAtomicNode3);
        this.spConsumerNode(linkedQueueAtomicNode2);
        return e;
    }

    @Override
    public E poll() {
        LinkedQueueAtomicNode linkedQueueAtomicNode = this.lpConsumerNode();
        LinkedQueueAtomicNode linkedQueueAtomicNode2 = linkedQueueAtomicNode.lvNext();
        if (linkedQueueAtomicNode2 != null) {
            return this.getSingleConsumerNodeValue(linkedQueueAtomicNode, linkedQueueAtomicNode2);
        }
        if (linkedQueueAtomicNode != this.lvProducerNode()) {
            linkedQueueAtomicNode2 = this.spinWaitForNextNode(linkedQueueAtomicNode);
            return this.getSingleConsumerNodeValue(linkedQueueAtomicNode, linkedQueueAtomicNode2);
        }
        return null;
    }

    @Override
    public E peek() {
        LinkedQueueAtomicNode linkedQueueAtomicNode = this.lpConsumerNode();
        LinkedQueueAtomicNode linkedQueueAtomicNode2 = linkedQueueAtomicNode.lvNext();
        if (linkedQueueAtomicNode2 != null) {
            return linkedQueueAtomicNode2.lpValue();
        }
        if (linkedQueueAtomicNode != this.lvProducerNode()) {
            linkedQueueAtomicNode2 = this.spinWaitForNextNode(linkedQueueAtomicNode);
            return linkedQueueAtomicNode2.lpValue();
        }
        return null;
    }

    LinkedQueueAtomicNode<E> spinWaitForNextNode(LinkedQueueAtomicNode<E> linkedQueueAtomicNode) {
        LinkedQueueAtomicNode<E> linkedQueueAtomicNode2;
        while ((linkedQueueAtomicNode2 = linkedQueueAtomicNode.lvNext()) == null) {
        }
        return linkedQueueAtomicNode2;
    }

    @Override
    public E relaxedPoll() {
        LinkedQueueAtomicNode linkedQueueAtomicNode = this.lpConsumerNode();
        LinkedQueueAtomicNode linkedQueueAtomicNode2 = linkedQueueAtomicNode.lvNext();
        if (linkedQueueAtomicNode2 != null) {
            return this.getSingleConsumerNodeValue(linkedQueueAtomicNode, linkedQueueAtomicNode2);
        }
        return null;
    }

    @Override
    public E relaxedPeek() {
        LinkedQueueAtomicNode linkedQueueAtomicNode = this.lpConsumerNode().lvNext();
        if (linkedQueueAtomicNode != null) {
            return linkedQueueAtomicNode.lpValue();
        }
        return null;
    }

    @Override
    public boolean relaxedOffer(E e) {
        return this.offer(e);
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer, int n) {
        if (consumer == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("limit is negative: " + n);
        }
        if (n == 0) {
            return 0;
        }
        LinkedQueueAtomicNode linkedQueueAtomicNode = this.lpConsumerNode();
        for (int i = 0; i < n; ++i) {
            LinkedQueueAtomicNode linkedQueueAtomicNode2 = linkedQueueAtomicNode.lvNext();
            if (linkedQueueAtomicNode2 == null) {
                return i;
            }
            Object e = this.getSingleConsumerNodeValue(linkedQueueAtomicNode, linkedQueueAtomicNode2);
            linkedQueueAtomicNode = linkedQueueAtomicNode2;
            consumer.accept(e);
        }
        return n;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer) {
        return MessagePassingQueueUtil.drain(this, consumer);
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> consumer, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.drain(this, consumer, waitStrategy, exitCondition);
    }

    @Override
    public int capacity() {
        return -1;
    }
}

