/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.EventLoopTaskQueueFactory;
import io.netty.channel.SelectStrategy;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventArray;
import io.netty.channel.kqueue.Native;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.IovArray;
import io.netty.util.IntSupplier;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class KQueueEventLoop
extends SingleThreadEventLoop {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(KQueueEventLoop.class);
    private static final AtomicIntegerFieldUpdater<KQueueEventLoop> WAKEN_UP_UPDATER = AtomicIntegerFieldUpdater.newUpdater(KQueueEventLoop.class, "wakenUp");
    private static final int KQUEUE_WAKE_UP_IDENT = 0;
    private static final int KQUEUE_MAX_TIMEOUT_SECONDS = 86399;
    private final boolean allowGrowing;
    private final FileDescriptor kqueueFd;
    private final KQueueEventArray changeList;
    private final KQueueEventArray eventList;
    private final SelectStrategy selectStrategy;
    private final IovArray iovArray = new IovArray();
    private final IntSupplier selectNowSupplier = new IntSupplier(){

        public int get() {
            return KQueueEventLoop.this.kqueueWaitNow();
        }
    };
    private final IntObjectMap<AbstractKQueueChannel> channels = new IntObjectHashMap(4096);
    private volatile int wakenUp;
    private volatile int ioRatio = 50;

    KQueueEventLoop(EventLoopGroup eventLoopGroup, Executor executor, int n, SelectStrategy selectStrategy, RejectedExecutionHandler rejectedExecutionHandler, EventLoopTaskQueueFactory eventLoopTaskQueueFactory, EventLoopTaskQueueFactory eventLoopTaskQueueFactory2) {
        super(eventLoopGroup, executor, false, KQueueEventLoop.newTaskQueue(eventLoopTaskQueueFactory), KQueueEventLoop.newTaskQueue(eventLoopTaskQueueFactory2), rejectedExecutionHandler);
        this.selectStrategy = (SelectStrategy)ObjectUtil.checkNotNull((Object)selectStrategy, (String)"strategy");
        this.kqueueFd = Native.newKQueue();
        if (n == 0) {
            this.allowGrowing = true;
            n = 4096;
        } else {
            this.allowGrowing = false;
        }
        this.changeList = new KQueueEventArray(n);
        this.eventList = new KQueueEventArray(n);
        int n2 = Native.keventAddUserEvent(this.kqueueFd.intValue(), 0);
        if (n2 < 0) {
            this.cleanup();
            throw new IllegalStateException("kevent failed to add user event with errno: " + -n2);
        }
    }

    private static Queue<Runnable> newTaskQueue(EventLoopTaskQueueFactory eventLoopTaskQueueFactory) {
        if (eventLoopTaskQueueFactory == null) {
            return KQueueEventLoop.newTaskQueue0(DEFAULT_MAX_PENDING_TASKS);
        }
        return eventLoopTaskQueueFactory.newTaskQueue(DEFAULT_MAX_PENDING_TASKS);
    }

    final void add(AbstractKQueueChannel abstractKQueueChannel) {
        assert (this.inEventLoop());
        abstractKQueueChannel = (AbstractKQueueChannel)((Object)this.channels.put(abstractKQueueChannel.fd().intValue(), (Object)abstractKQueueChannel));
        assert (abstractKQueueChannel == null || !abstractKQueueChannel.isOpen());
    }

    final void evSet(AbstractKQueueChannel abstractKQueueChannel, short s, short s2, int n) {
        assert (this.inEventLoop());
        this.changeList.evSet(abstractKQueueChannel, s, s2, n);
    }

    final void remove(AbstractKQueueChannel abstractKQueueChannel) {
        assert (this.inEventLoop());
        int n = abstractKQueueChannel.fd().intValue();
        AbstractKQueueChannel abstractKQueueChannel2 = (AbstractKQueueChannel)((Object)this.channels.remove(n));
        if (abstractKQueueChannel2 != null && abstractKQueueChannel2 != abstractKQueueChannel) {
            this.channels.put(n, (Object)abstractKQueueChannel2);
            assert (!abstractKQueueChannel.isOpen());
        } else if (abstractKQueueChannel.isOpen()) {
            abstractKQueueChannel.unregisterFilters();
        }
    }

    final IovArray cleanArray() {
        this.iovArray.clear();
        return this.iovArray;
    }

    protected final void wakeup(boolean bl) {
        if (!bl && WAKEN_UP_UPDATER.compareAndSet(this, 0, 1)) {
            this.wakeup();
        }
    }

    private void wakeup() {
        Native.keventTriggerUserEvent(this.kqueueFd.intValue(), 0);
    }

    private int kqueueWait(boolean bl) {
        if (bl && this.hasTasks()) {
            return this.kqueueWaitNow();
        }
        long n = this.delayNanos(System.nanoTime());
        int n2 = (int)Math.min(n / 1000000000L, 86399L);
        int n3 = (int)(n % 1000000000L);
        return this.kqueueWait(n2, n3);
    }

    private int kqueueWaitNow() {
        return this.kqueueWait(0, 0);
    }

    private int kqueueWait(int n, int n2) {
        n = Native.keventWait(this.kqueueFd.intValue(), this.changeList, this.eventList, n, n2);
        this.changeList.clear();
        return n;
    }

    private void processReady(int n) {
        for (int i = 0; i < n; ++i) {
            short s = this.eventList.filter(i);
            short s2 = this.eventList.flags(i);
            int n2 = this.eventList.fd(i);
            if (s == Native.EVFILT_USER || (s2 & Native.EV_ERROR) != 0) {
                assert (s != Native.EVFILT_USER || s == Native.EVFILT_USER && n2 == 0);
                continue;
            }
            Object object = (AbstractKQueueChannel)((Object)this.channels.get(n2));
            if (object == null) {
                logger.warn("events[{}]=[{}, {}] had no channel!", new Object[]{i, this.eventList.fd(i), s});
                continue;
            }
            object = (AbstractKQueueChannel.AbstractKQueueUnsafe)object.unsafe();
            if (s == Native.EVFILT_WRITE) {
                ((AbstractKQueueChannel.AbstractKQueueUnsafe)((Object)object)).writeReady();
            } else if (s == Native.EVFILT_READ) {
                ((AbstractKQueueChannel.AbstractKQueueUnsafe)((Object)object)).readReady(this.eventList.data(i));
            } else if (s == Native.EVFILT_SOCK && (this.eventList.fflags(i) & Native.NOTE_RDHUP) != 0) {
                ((AbstractKQueueChannel.AbstractKQueueUnsafe)((Object)object)).readEOF();
            }
            if ((s2 & Native.EV_EOF) == 0) continue;
            ((AbstractKQueueChannel.AbstractKQueueUnsafe)((Object)object)).readEOF();
        }
    }

    /*
     * Exception decompiling
     */
    protected final void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final Queue<Runnable> newTaskQueue(int n) {
        return KQueueEventLoop.newTaskQueue0(n);
    }

    private static Queue<Runnable> newTaskQueue0(int n) {
        if (n == Integer.MAX_VALUE) {
            return PlatformDependent.newMpscQueue();
        }
        return PlatformDependent.newMpscQueue((int)n);
    }

    public final int getIoRatio() {
        return this.ioRatio;
    }

    public final void setIoRatio(int n) {
        if (n <= 0 || n > 100) {
            throw new IllegalArgumentException("ioRatio: " + n + " (expected: 0 < ioRatio <= 100)");
        }
        this.ioRatio = n;
    }

    public final int registeredChannels() {
        return this.channels.size();
    }

    public final Iterator<Channel> registeredChannelsIterator() {
        assert (this.inEventLoop());
        IntObjectMap<AbstractKQueueChannel> intObjectMap = this.channels;
        if (intObjectMap.isEmpty()) {
            return SingleThreadEventLoop.ChannelsReadOnlyIterator.empty();
        }
        return new SingleThreadEventLoop.ChannelsReadOnlyIterator((Iterable)intObjectMap.values());
    }

    protected final void cleanup() {
        try {
            try {
                this.kqueueFd.close();
            }
            catch (IOException iOException) {
                logger.warn("Failed to close the kqueue fd.", (Throwable)iOException);
            }
            return;
        }
        finally {
            this.iovArray.release();
            this.changeList.free();
            this.eventList.free();
        }
    }

    private void closeAll() {
        try {
            this.kqueueWaitNow();
        }
        catch (IOException iOException) {}
        AbstractKQueueChannel[] abstractKQueueChannelArray = this.channels.values().toArray(new AbstractKQueueChannel[0]);
        AbstractKQueueChannel[] abstractKQueueChannelArray2 = abstractKQueueChannelArray;
        abstractKQueueChannelArray2 = abstractKQueueChannelArray;
        int n = abstractKQueueChannelArray.length;
        for (int i = 0; i < n; ++i) {
            AbstractKQueueChannel abstractKQueueChannel = abstractKQueueChannelArray2[i];
            abstractKQueueChannel.unsafe().close(abstractKQueueChannel.unsafe().voidPromise());
        }
    }

    private static void handleLoopException(Throwable throwable) {
        logger.warn("Unexpected exception in the selector loop.", throwable);
        try {
            Thread.sleep(1000L);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    static {
        KQueue.ensureAvailability();
    }
}

