/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.Channel;
import io.netty.channel.kqueue.AbstractKQueueServerChannel;
import io.netty.channel.kqueue.BsdSocket;
import io.netty.channel.kqueue.KQueueDomainSocketChannel;
import io.netty.channel.kqueue.KQueueServerChannelConfig;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.ServerDomainSocketChannel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.net.SocketAddress;

public final class KQueueServerDomainSocketChannel
extends AbstractKQueueServerChannel
implements ServerDomainSocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(KQueueServerDomainSocketChannel.class);
    private final KQueueServerChannelConfig config = new KQueueServerChannelConfig(this);
    private volatile DomainSocketAddress local;

    public KQueueServerDomainSocketChannel() {
        super(BsdSocket.newSocketDomain(), false);
    }

    public KQueueServerDomainSocketChannel(int n) {
        this(new BsdSocket(n), false);
    }

    KQueueServerDomainSocketChannel(BsdSocket bsdSocket, boolean bl) {
        super(bsdSocket, bl);
    }

    @Override
    protected final Channel newChildChannel(int n, byte[] byArray, int n2, int n3) {
        return new KQueueDomainSocketChannel((Channel)this, new BsdSocket(n));
    }

    protected final DomainSocketAddress localAddress0() {
        return this.local;
    }

    @Override
    protected final void doBind(SocketAddress socketAddress) {
        this.socket.bind(socketAddress);
        this.socket.listen(this.config.getBacklog());
        this.local = (DomainSocketAddress)socketAddress;
        this.active = true;
    }

    @Override
    protected final void doClose() {
        try {
            super.doClose();
            return;
        }
        finally {
            File file;
            boolean bl;
            DomainSocketAddress domainSocketAddress = this.local;
            if (domainSocketAddress != null && !(bl = (file = new File(domainSocketAddress.path())).delete()) && logger.isDebugEnabled()) {
                logger.debug("Failed to delete a domain socket file: {}", (Object)domainSocketAddress.path());
            }
        }
    }

    @Override
    public final KQueueServerChannelConfig config() {
        return this.config;
    }

    public final DomainSocketAddress remoteAddress() {
        return (DomainSocketAddress)super.remoteAddress();
    }

    public final DomainSocketAddress localAddress() {
        return (DomainSocketAddress)super.localAddress();
    }
}

