/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.util;

import io.netty.util.internal.PlatformDependent;
import java.security.SecureRandom;
import java.util.Random;

final class ThreadLocalInsecureRandom
extends SecureRandom {
    private static final long serialVersionUID = -8209473337192526191L;
    private static final SecureRandom INSTANCE = new ThreadLocalInsecureRandom();

    static SecureRandom current() {
        return INSTANCE;
    }

    private ThreadLocalInsecureRandom() {
    }

    @Override
    public final String getAlgorithm() {
        return "insecure";
    }

    @Override
    public final void setSeed(byte[] byArray) {
    }

    @Override
    public final void setSeed(long l) {
    }

    @Override
    public final void nextBytes(byte[] byArray) {
        ThreadLocalInsecureRandom.random().nextBytes(byArray);
    }

    @Override
    public final byte[] generateSeed(int n) {
        byte[] byArray = new byte[n];
        ThreadLocalInsecureRandom.random().nextBytes(byArray);
        return byArray;
    }

    @Override
    public final int nextInt() {
        return ThreadLocalInsecureRandom.random().nextInt();
    }

    @Override
    public final int nextInt(int n) {
        return ThreadLocalInsecureRandom.random().nextInt(n);
    }

    @Override
    public final boolean nextBoolean() {
        return ThreadLocalInsecureRandom.random().nextBoolean();
    }

    @Override
    public final long nextLong() {
        return ThreadLocalInsecureRandom.random().nextLong();
    }

    @Override
    public final float nextFloat() {
        return ThreadLocalInsecureRandom.random().nextFloat();
    }

    @Override
    public final double nextDouble() {
        return ThreadLocalInsecureRandom.random().nextDouble();
    }

    @Override
    public final double nextGaussian() {
        return ThreadLocalInsecureRandom.random().nextGaussian();
    }

    private static Random random() {
        return PlatformDependent.threadLocalRandom();
    }
}

