/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.awt;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.DensityKt;
import androidx.compose.ui.unit.IntRect;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0000\u001a0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0000\u001a\u0016\u0010\u0004\u001a\u00020\u0005*\u00020\f2\b\b\u0002\u0010\u000b\u001a\u00020\rH\u0000\u001a\u0014\u0010\u000e\u001a\u00020\u0005*\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\rH\u0000\u001a\u0013\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\"(\u0010\u001a\u001a\u00020\u0001*\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u00018B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\"(\u0010\u001a\u001a\u00020\u0001*\u00020 2\u0006\u0010\u0019\u001a\u00020\u00018@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010!\"\u0004\b\u001e\u0010\"\"(\u0010\u001a\u001a\u00020\u0001*\u00020#2\u0006\u0010\u0019\u001a\u00020\u00018@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010$\"\u0004\b\u001e\u0010%\u00a8\u0006&"}, d2={"isParentOf", "", "Ljava/awt/Component;", "component", "toAwtRectangle", "Ljava/awt/Rectangle;", "left", "", "top", "right", "bottom", "density", "Landroidx/compose/ui/unit/IntRect;", "Landroidx/compose/ui/unit/Density;", "toAwtRectangleRounded", "Landroidx/compose/ui/geometry/Rect;", "toAwtColor", "Ljava/awt/Color;", "Landroidx/compose/ui/graphics/Color;", "toAwtColor-8_81llA", "(J)Ljava/awt/Color;", "getTransparentWindowBackground", "isWindowTransparent", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "value", "hasMacOsShadow", "Ljavax/swing/JComponent;", "getHasMacOsShadow", "(Ljavax/swing/JComponent;)Z", "setHasMacOsShadow", "(Ljavax/swing/JComponent;Z)V", "Ljavax/swing/JFrame;", "(Ljavax/swing/JFrame;)Z", "(Ljavax/swing/JFrame;Z)V", "Ljavax/swing/JDialog;", "(Ljavax/swing/JDialog;)Z", "(Ljavax/swing/JDialog;Z)V", "ui"})
public final class Utils_desktopKt {
    public static final boolean isParentOf(Component component, Component component2) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"");
        Component component3 = component2;
        Component component4 = component2 = component3 != null ? component3.getParent() : null;
        while (component4 != null) {
            if (Intrinsics.areEqual((Object)component2, (Object)component)) {
                return true;
            }
            component4 = component2.getParent();
        }
        return false;
    }

    public static final Rectangle toAwtRectangle(float f2, float f3, float f4, float f5, float f6) {
        int n = (int)Math.floor(f2 / f6);
        int n2 = (int)Math.floor(f3 / f6);
        int n3 = (int)Math.ceil(f4 / f6);
        int n4 = (int)Math.ceil(f5 / f6);
        return new Rectangle(n, n2, n3 -= n, n4 -= n2);
    }

    public static final Rectangle toAwtRectangle(IntRect intRect, Density density) {
        Intrinsics.checkNotNullParameter((Object)intRect, (String)"");
        Intrinsics.checkNotNullParameter((Object)density, (String)"");
        return Utils_desktopKt.toAwtRectangle(intRect.getLeft(), intRect.getTop(), intRect.getRight(), intRect.getBottom(), density.getDensity());
    }

    public static /* synthetic */ Rectangle toAwtRectangle$default(IntRect intRect, Density density, int n, Object object) {
        if ((n & 1) != 0) {
            density = DensityKt.Density$default((float)1.0f, (float)0.0f, (int)2, null);
        }
        return Utils_desktopKt.toAwtRectangle(intRect, density);
    }

    public static final Rectangle toAwtRectangleRounded(Rect rect, Density density) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"");
        Intrinsics.checkNotNullParameter((Object)density, (String)"");
        float f2 = density.getDensity();
        int n = MathKt.roundToInt((float)(rect.getLeft() / f2));
        int n2 = MathKt.roundToInt((float)(rect.getTop() / f2));
        int n3 = MathKt.roundToInt((float)(rect.getRight() / f2));
        int n4 = MathKt.roundToInt((float)(rect.getBottom() / f2));
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    public static final Color toAwtColor-8_81llA(long l2) {
        return new Color(androidx.compose.ui.graphics.Color.getRed-impl((long)l2), androidx.compose.ui.graphics.Color.getGreen-impl((long)l2), androidx.compose.ui.graphics.Color.getBlue-impl((long)l2), androidx.compose.ui.graphics.Color.getAlpha-impl((long)l2));
    }

    public static final Color getTransparentWindowBackground(boolean bl, GraphicsApi graphicsApi) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)graphicsApi, (String)"");
        boolean bl3 = bl2 = OsArch_jvmKt.getHostOs() == OS.Windows && graphicsApi != GraphicsApi.DIRECT3D;
        if (bl && !bl2) {
            return new Color(0, 0, 0, 0);
        }
        return null;
    }

    private static final boolean getHasMacOsShadow(JComponent object) {
        Boolean bl = (object = ((JComponent)object).getClientProperty("Window.shadow")) instanceof Boolean ? (Boolean)object : null;
        if (bl != null) {
            return bl;
        }
        return false;
    }

    private static final void setHasMacOsShadow(JComponent jComponent, boolean bl) {
        jComponent.putClientProperty("Window.shadow", bl);
    }

    public static final boolean getHasMacOsShadow(JFrame jFrame) {
        Intrinsics.checkNotNullParameter((Object)jFrame, (String)"");
        JRootPane jRootPane = jFrame.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"");
        return Utils_desktopKt.getHasMacOsShadow(jRootPane);
    }

    public static final void setHasMacOsShadow(JFrame jFrame, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)jFrame, (String)"");
        JRootPane jRootPane = jFrame.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"");
        Utils_desktopKt.setHasMacOsShadow(jRootPane, bl);
    }

    public static final boolean getHasMacOsShadow(JDialog jDialog) {
        Intrinsics.checkNotNullParameter((Object)jDialog, (String)"");
        JRootPane jRootPane = jDialog.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"");
        return Utils_desktopKt.getHasMacOsShadow(jRootPane);
    }

    public static final void setHasMacOsShadow(JDialog jDialog, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)jDialog, (String)"");
        JRootPane jRootPane = jDialog.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"");
        Utils_desktopKt.setHasMacOsShadow(jRootPane, bl);
    }
}

