/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ByteBufOutputStream
extends OutputStream
implements DataOutput {
    private final ByteBuf buffer;
    private final int startIndex;
    private DataOutputStream utf8out;
    private boolean closed;
    private final boolean releaseOnClose;

    public ByteBufOutputStream(ByteBuf byteBuf) {
        this(byteBuf, false);
    }

    public ByteBufOutputStream(ByteBuf byteBuf, boolean bl) {
        this.releaseOnClose = bl;
        this.buffer = (ByteBuf)ObjectUtil.checkNotNull((Object)byteBuf, (String)"buffer");
        this.startIndex = byteBuf.writerIndex();
    }

    public int writtenBytes() {
        return this.buffer.writerIndex() - this.startIndex;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.buffer.writeBytes(byArray, n, n2);
    }

    @Override
    public void write(byte[] byArray) {
        this.buffer.writeBytes(byArray);
    }

    @Override
    public void write(int n) {
        this.buffer.writeByte(n);
    }

    @Override
    public void writeBoolean(boolean bl) {
        this.buffer.writeBoolean(bl);
    }

    @Override
    public void writeByte(int n) {
        this.buffer.writeByte(n);
    }

    @Override
    public void writeBytes(String string) {
        this.buffer.writeCharSequence(string, CharsetUtil.US_ASCII);
    }

    @Override
    public void writeChar(int n) {
        this.buffer.writeChar(n);
    }

    @Override
    public void writeChars(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.buffer.writeChar(string.charAt(i));
        }
    }

    @Override
    public void writeDouble(double d) {
        this.buffer.writeDouble(d);
    }

    @Override
    public void writeFloat(float f) {
        this.buffer.writeFloat(f);
    }

    @Override
    public void writeInt(int n) {
        this.buffer.writeInt(n);
    }

    @Override
    public void writeLong(long l) {
        this.buffer.writeLong(l);
    }

    @Override
    public void writeShort(int n) {
        this.buffer.writeShort((short)n);
    }

    @Override
    public void writeUTF(String string) {
        DataOutputStream dataOutputStream = this.utf8out;
        if (dataOutputStream == null) {
            if (this.closed) {
                throw new IOException("The stream is closed");
            }
            this.utf8out = dataOutputStream = new DataOutputStream(this);
        }
        dataOutputStream.writeUTF(string);
    }

    public ByteBuf buffer() {
        return this.buffer;
    }

    @Override
    public void close() {
        block6: {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                super.close();
                if (this.utf8out == null) break block6;
            }
            catch (Throwable throwable) {
                if (this.utf8out != null) {
                    this.utf8out.close();
                }
                if (this.releaseOnClose) {
                    this.buffer.release();
                }
                throw throwable;
            }
            this.utf8out.close();
        }
        if (this.releaseOnClose) {
            this.buffer.release();
            return;
        }
    }
}

