/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.HeapByteBufUtil;
import io.netty.buffer.PooledByteBuf;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.PlatformDependent;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

class PooledHeapByteBuf
extends PooledByteBuf<byte[]> {
    private static final ObjectPool<PooledHeapByteBuf> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<PooledHeapByteBuf>(){

        public final PooledHeapByteBuf newObject(ObjectPool.Handle<PooledHeapByteBuf> handle) {
            return new PooledHeapByteBuf((ObjectPool.Handle<? extends PooledHeapByteBuf>)handle, 0);
        }
    });

    static PooledHeapByteBuf newInstance(int n) {
        PooledHeapByteBuf pooledHeapByteBuf = (PooledHeapByteBuf)RECYCLER.get();
        pooledHeapByteBuf.reuse(n);
        return pooledHeapByteBuf;
    }

    PooledHeapByteBuf(ObjectPool.Handle<? extends PooledHeapByteBuf> handle, int n) {
        super(handle, n);
    }

    @Override
    public final boolean isDirect() {
        return false;
    }

    @Override
    protected byte _getByte(int n) {
        return HeapByteBufUtil.getByte((byte[])this.memory, this.idx(n));
    }

    @Override
    protected short _getShort(int n) {
        return HeapByteBufUtil.getShort((byte[])this.memory, this.idx(n));
    }

    @Override
    protected short _getShortLE(int n) {
        return HeapByteBufUtil.getShortLE((byte[])this.memory, this.idx(n));
    }

    @Override
    protected int _getUnsignedMedium(int n) {
        return HeapByteBufUtil.getUnsignedMedium((byte[])this.memory, this.idx(n));
    }

    @Override
    protected int _getUnsignedMediumLE(int n) {
        return HeapByteBufUtil.getUnsignedMediumLE((byte[])this.memory, this.idx(n));
    }

    @Override
    protected int _getInt(int n) {
        return HeapByteBufUtil.getInt((byte[])this.memory, this.idx(n));
    }

    @Override
    protected int _getIntLE(int n) {
        return HeapByteBufUtil.getIntLE((byte[])this.memory, this.idx(n));
    }

    @Override
    protected long _getLong(int n) {
        return HeapByteBufUtil.getLong((byte[])this.memory, this.idx(n));
    }

    @Override
    protected long _getLongLE(int n) {
        return HeapByteBufUtil.getLongLE((byte[])this.memory, this.idx(n));
    }

    @Override
    public final ByteBuf getBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        this.checkDstIndex(n, n3, n2, byteBuf.capacity());
        if (byteBuf.hasMemoryAddress()) {
            PlatformDependent.copyMemory((byte[])((byte[])this.memory), (int)this.idx(n), (long)(byteBuf.memoryAddress() + (long)n2), (long)n3);
        } else if (byteBuf.hasArray()) {
            ((ByteBuf)this).getBytes(n, byteBuf.array(), byteBuf.arrayOffset() + n2, n3);
        } else {
            byteBuf.setBytes(n2, (byte[])this.memory, this.idx(n), n3);
        }
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n, byte[] byArray, int n2, int n3) {
        this.checkDstIndex(n, n3, n2, byArray.length);
        System.arraycopy(this.memory, this.idx(n), byArray, n2, n3);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n, ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        this.checkIndex(n, n2);
        byteBuffer.put((byte[])this.memory, this.idx(n), n2);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n, OutputStream outputStream, int n2) {
        this.checkIndex(n, n2);
        outputStream.write((byte[])this.memory, this.idx(n), n2);
        return this;
    }

    @Override
    protected void _setByte(int n, int n2) {
        HeapByteBufUtil.setByte((byte[])this.memory, this.idx(n), n2);
    }

    @Override
    protected void _setShort(int n, int n2) {
        HeapByteBufUtil.setShort((byte[])this.memory, this.idx(n), n2);
    }

    @Override
    protected void _setShortLE(int n, int n2) {
        HeapByteBufUtil.setShortLE((byte[])this.memory, this.idx(n), n2);
    }

    @Override
    protected void _setMedium(int n, int n2) {
        HeapByteBufUtil.setMedium((byte[])this.memory, this.idx(n), n2);
    }

    @Override
    protected void _setMediumLE(int n, int n2) {
        HeapByteBufUtil.setMediumLE((byte[])this.memory, this.idx(n), n2);
    }

    @Override
    protected void _setInt(int n, int n2) {
        HeapByteBufUtil.setInt((byte[])this.memory, this.idx(n), n2);
    }

    @Override
    protected void _setIntLE(int n, int n2) {
        HeapByteBufUtil.setIntLE((byte[])this.memory, this.idx(n), n2);
    }

    @Override
    protected void _setLong(int n, long l) {
        HeapByteBufUtil.setLong((byte[])this.memory, this.idx(n), l);
    }

    @Override
    protected void _setLongLE(int n, long l) {
        HeapByteBufUtil.setLongLE((byte[])this.memory, this.idx(n), l);
    }

    @Override
    public final ByteBuf setBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        this.checkSrcIndex(n, n3, n2, byteBuf.capacity());
        if (byteBuf.hasMemoryAddress()) {
            PlatformDependent.copyMemory((long)(byteBuf.memoryAddress() + (long)n2), (byte[])((byte[])this.memory), (int)this.idx(n), (long)n3);
        } else if (byteBuf.hasArray()) {
            ((ByteBuf)this).setBytes(n, byteBuf.array(), byteBuf.arrayOffset() + n2, n3);
        } else {
            byteBuf.getBytes(n2, (byte[])this.memory, this.idx(n), n3);
        }
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n, byte[] byArray, int n2, int n3) {
        this.checkSrcIndex(n, n3, n2, byArray.length);
        System.arraycopy(byArray, n2, this.memory, this.idx(n), n3);
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n, ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        this.checkIndex(n, n2);
        byteBuffer.get((byte[])this.memory, this.idx(n), n2);
        return this;
    }

    @Override
    public final int setBytes(int n, InputStream inputStream, int n2) {
        this.checkIndex(n, n2);
        return inputStream.read((byte[])this.memory, this.idx(n), n2);
    }

    @Override
    public final ByteBuf copy(int n, int n2) {
        this.checkIndex(n, n2);
        ByteBuf byteBuf = ((ByteBuf)this).alloc().heapBuffer(n2, ((ByteBuf)this).maxCapacity());
        return byteBuf.writeBytes((byte[])this.memory, this.idx(n), n2);
    }

    @Override
    final ByteBuffer duplicateInternalNioBuffer(int n, int n2) {
        this.checkIndex(n, n2);
        return ByteBuffer.wrap((byte[])this.memory, this.idx(n), n2).slice();
    }

    @Override
    public final boolean hasArray() {
        return true;
    }

    @Override
    public final byte[] array() {
        this.ensureAccessible();
        return (byte[])this.memory;
    }

    @Override
    public final int arrayOffset() {
        return this.offset;
    }

    @Override
    public final boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public final long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final ByteBuffer newInternalNioBuffer(byte[] byArray) {
        return ByteBuffer.wrap(byArray);
    }
}

