/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractPooledDerivedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.WrappedByteBuf;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteOrder;

class SimpleLeakAwareByteBuf
extends WrappedByteBuf {
    private final ByteBuf trackedByteBuf;
    final ResourceLeakTracker<ByteBuf> leak;

    SimpleLeakAwareByteBuf(ByteBuf byteBuf, ByteBuf byteBuf2, ResourceLeakTracker<ByteBuf> resourceLeakTracker) {
        super(byteBuf);
        this.trackedByteBuf = (ByteBuf)ObjectUtil.checkNotNull((Object)byteBuf2, (String)"trackedByteBuf");
        this.leak = (ResourceLeakTracker)ObjectUtil.checkNotNull(resourceLeakTracker, (String)"leak");
    }

    SimpleLeakAwareByteBuf(ByteBuf byteBuf, ResourceLeakTracker<ByteBuf> resourceLeakTracker) {
        ByteBuf byteBuf2 = byteBuf;
        this(byteBuf2, byteBuf2, resourceLeakTracker);
    }

    @Override
    public ByteBuf slice() {
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.newSharedLeakAwareByteBuf(super.slice());
    }

    @Override
    public ByteBuf retainedSlice() {
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.unwrappedDerived(super.retainedSlice());
    }

    @Override
    public ByteBuf retainedSlice(int n, int n2) {
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.unwrappedDerived(super.retainedSlice(n, n2));
    }

    @Override
    public ByteBuf retainedDuplicate() {
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.unwrappedDerived(super.retainedDuplicate());
    }

    @Override
    public ByteBuf readRetainedSlice(int n) {
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.unwrappedDerived(super.readRetainedSlice(n));
    }

    @Override
    public ByteBuf slice(int n, int n2) {
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.newSharedLeakAwareByteBuf(super.slice(n, n2));
    }

    @Override
    public ByteBuf duplicate() {
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.newSharedLeakAwareByteBuf(super.duplicate());
    }

    @Override
    public ByteBuf readSlice(int n) {
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.newSharedLeakAwareByteBuf(super.readSlice(n));
    }

    @Override
    public ByteBuf asReadOnly() {
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.newSharedLeakAwareByteBuf(super.asReadOnly());
    }

    @Override
    public ByteBuf touch() {
        return this;
    }

    @Override
    public ByteBuf touch(Object object) {
        return this;
    }

    @Override
    public boolean release() {
        if (super.release()) {
            this.closeLeak();
            return true;
        }
        return false;
    }

    @Override
    public boolean release(int n) {
        if (super.release(n)) {
            this.closeLeak();
            return true;
        }
        return false;
    }

    private void closeLeak() {
        boolean bl = this.leak.close((Object)this.trackedByteBuf);
        assert (bl);
    }

    @Override
    public ByteBuf order(ByteOrder byteOrder) {
        if (((ByteBuf)this).order() == byteOrder) {
            return this;
        }
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.newSharedLeakAwareByteBuf(super.order(byteOrder));
    }

    private ByteBuf unwrappedDerived(ByteBuf byteBuf) {
        ByteBuf byteBuf2 = SimpleLeakAwareByteBuf.unwrapSwapped(byteBuf);
        if (byteBuf2 instanceof AbstractPooledDerivedByteBuf) {
            ((AbstractPooledDerivedByteBuf)byteBuf2).parent(this);
            return this.newLeakAwareByteBuf(byteBuf, (ResourceLeakTracker<ByteBuf>)AbstractByteBuf.leakDetector.trackForcibly((Object)byteBuf));
        }
        return this.newSharedLeakAwareByteBuf(byteBuf);
    }

    private static ByteBuf unwrapSwapped(ByteBuf byteBuf) {
        if (byteBuf instanceof SwappedByteBuf) {
            while ((byteBuf = byteBuf.unwrap()) instanceof SwappedByteBuf) {
            }
            return byteBuf;
        }
        return byteBuf;
    }

    private SimpleLeakAwareByteBuf newSharedLeakAwareByteBuf(ByteBuf byteBuf) {
        return this.newLeakAwareByteBuf(byteBuf, this.trackedByteBuf, this.leak);
    }

    private SimpleLeakAwareByteBuf newLeakAwareByteBuf(ByteBuf byteBuf, ResourceLeakTracker<ByteBuf> resourceLeakTracker) {
        ByteBuf byteBuf2 = byteBuf;
        return this.newLeakAwareByteBuf(byteBuf2, byteBuf2, resourceLeakTracker);
    }

    protected SimpleLeakAwareByteBuf newLeakAwareByteBuf(ByteBuf byteBuf, ByteBuf byteBuf2, ResourceLeakTracker<ByteBuf> resourceLeakTracker) {
        return new SimpleLeakAwareByteBuf(byteBuf, byteBuf2, resourceLeakTracker);
    }
}

