/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0019\u0010\u0002\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0011\u0010\u0004\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0013\u0010\u0006\u001a\u00020\u0000*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0005\u001a\u0019\u0010\u0002\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\b\u00a8\u0006\t"}, d2={"Ljava/nio/file/Path;", "relativePath", "combineSafe", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)Ljava/nio/file/Path;", "normalizeAndRelativize", "(Ljava/nio/file/Path;)Ljava/nio/file/Path;", "dropLeadingTopDirs", "Ljava/io/File;", "(Ljava/io/File;Ljava/nio/file/Path;)Ljava/io/File;", "ktor-utils"})
public final class NioPathKt {
    public static final Path combineSafe(Path object, Path path) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)path, (String)"");
        Path path2 = NioPathKt.normalizeAndRelativize(path);
        if (path2.startsWith("..")) {
            throw new InvalidPathException(((Object)path).toString(), "Relative path " + path + " beginning with .. is invalid");
        }
        if (!(!path2.isAbsolute())) {
            object = "Bad relative path " + path;
            throw new IllegalStateException(object.toString());
        }
        if (object.getNameCount() == 0) {
            return path2;
        }
        Path path3 = object.resolve(path2);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"");
        return path3;
    }

    public static final Path normalizeAndRelativize(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"");
        Path path2 = path.getRoot();
        if (path2 == null || (path2 = path2.relativize(path)) == null || (path2 = path2.normalize()) == null || (path2 = NioPathKt.dropLeadingTopDirs(path2)) == null) {
            Path path3 = path.normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"");
            path2 = NioPathKt.dropLeadingTopDirs(path3);
        }
        return path2;
    }

    private static final Path dropLeadingTopDirs(Path path) {
        int n;
        int n2;
        block4: {
            Object object = path;
            int n3 = 0;
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                if (n3 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                if (!Intrinsics.areEqual((Object)(object2 = (Path)object2).toString(), (Object)"..")) {
                    n2 = n3;
                    break block4;
                }
                ++n3;
            }
            n2 = n = -1;
        }
        if (n2 <= 0) {
            return path;
        }
        Path path2 = path.subpath(n, path.getNameCount());
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"");
        return path2;
    }

    public static final File combineSafe(File object, Path path) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)path, (String)"");
        Path path2 = NioPathKt.normalizeAndRelativize(path);
        if (path2.startsWith("..")) {
            throw new InvalidPathException(((Object)path).toString(), "Relative path " + path + " beginning with .. is invalid");
        }
        if (!(!path2.isAbsolute())) {
            object = "Bad relative path " + path;
            throw new IllegalStateException(object.toString());
        }
        return new File((File)object, ((Object)path2).toString());
    }
}

