/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ArrayBlockingQueueWithShutdown<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final E[] items;
    private int takeIndex;
    private int putIndex;
    private int count;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;
    private volatile boolean isShutdown = false;

    private int inc(int n) {
        if (++n == this.items.length) {
            return 0;
        }
        return n;
    }

    private void insert(E e2) {
        this.insert(e2, true);
    }

    private void insert(E e2, boolean bl) {
        this.items[this.putIndex] = e2;
        this.putIndex = this.inc(this.putIndex);
        ++this.count;
        if (bl) {
            this.notEmpty.signal();
        }
    }

    private E extract() {
        E e2 = this.items[this.takeIndex];
        this.items[this.takeIndex] = null;
        this.takeIndex = this.inc(this.takeIndex);
        --this.count;
        this.notFull.signal();
        return e2;
    }

    private void removeAt(int n) {
        if (n == this.takeIndex) {
            this.items[this.takeIndex] = null;
            this.takeIndex = this.inc(this.takeIndex);
        } else {
            int n2;
            while ((n2 = this.inc(n)) != this.putIndex) {
                this.items[n] = this.items[n2];
                n = n2;
            }
            this.items[n] = null;
            this.putIndex = n;
        }
        --this.count;
        this.notFull.signal();
    }

    private static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    private void checkNotShutdown() {
        if (this.isShutdown) {
            throw new InterruptedException("Queue was already shut down");
        }
    }

    private boolean hasNoElements() {
        return this.count == 0;
    }

    private boolean hasElements() {
        return !this.hasNoElements();
    }

    private boolean isFull() {
        return this.count == this.items.length;
    }

    private boolean isNotFull() {
        return !this.isFull();
    }

    public ArrayBlockingQueueWithShutdown(int n) {
        this(n, false);
    }

    public ArrayBlockingQueueWithShutdown(int n, boolean bl) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.items = new Object[n];
        this.lock = new ReentrantLock(bl);
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
    }

    public void shutdown() {
        this.lock.lock();
        try {
            this.isShutdown = true;
            this.notEmpty.signalAll();
            this.notFull.signalAll();
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean start() {
        boolean bl;
        this.lock.lock();
        try {
            bl = this.isShutdown;
            this.isShutdown = false;
        }
        finally {
            this.lock.unlock();
        }
        return bl;
    }

    public boolean isShutdown() {
        this.lock.lock();
        try {
            boolean bl = this.isShutdown;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E poll() {
        this.lock.lock();
        try {
            if (this.hasNoElements()) {
                return null;
            }
            E e2 = this.extract();
            return e2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E peek() {
        this.lock.lock();
        try {
            E e2 = this.hasNoElements() ? null : (E)this.items[this.takeIndex];
            return e2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean offer(E e2) {
        ArrayBlockingQueueWithShutdown.checkNotNull(e2);
        this.lock.lock();
        try {
            if (this.isFull() || this.isShutdown) {
                return false;
            }
            this.insert(e2);
            return true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean offerAndShutdown(E e2) {
        boolean bl;
        ArrayBlockingQueueWithShutdown.checkNotNull(e2);
        this.lock.lock();
        try {
            bl = this.offer(e2);
            this.shutdown();
        }
        finally {
            this.lock.unlock();
        }
        return bl;
    }

    private void putInternal(E e2, boolean bl) {
        assert (this.lock.isHeldByCurrentThread());
        while (this.isFull()) {
            try {
                this.notFull.await();
                this.checkNotShutdown();
            }
            catch (InterruptedException interruptedException) {
                this.notFull.signal();
                throw interruptedException;
            }
        }
        this.insert(e2, bl);
    }

    @Override
    public void put(E e2) {
        ArrayBlockingQueueWithShutdown.checkNotNull(e2);
        this.lock.lockInterruptibly();
        try {
            this.putInternal(e2, true);
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean putIfNotShutdown(E e2) {
        ArrayBlockingQueueWithShutdown.checkNotNull(e2);
        this.lock.lockInterruptibly();
        try {
            if (this.isShutdown) {
                return false;
            }
            this.putInternal(e2, true);
            return true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void putAll(Collection<? extends E> object) {
        ArrayBlockingQueueWithShutdown.checkNotNull(object);
        this.lock.lockInterruptibly();
        try {
            object = object.iterator();
            while (object.hasNext()) {
                Object e2 = object.next();
                this.putInternal(e2, false);
            }
            return;
        }
        finally {
            this.notEmpty.signalAll();
            this.lock.unlock();
        }
    }

    public TryPutResult tryPut(E object) {
        ArrayBlockingQueueWithShutdown.checkNotNull(object);
        boolean bl = this.lock.tryLock();
        if (!bl) {
            return TryPutResult.couldNotLock;
        }
        try {
            if (this.isShutdown) {
                object = TryPutResult.queueWasShutDown;
                return object;
            }
            if (this.isFull()) {
                object = TryPutResult.queueWasFull;
                return object;
            }
            this.insert(object);
            object = TryPutResult.putSuccessful;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean offer(E e2, long l, TimeUnit timeUnit) {
        ArrayBlockingQueueWithShutdown.checkNotNull(e2);
        long l2 = timeUnit.toNanos(l);
        this.lock.lockInterruptibly();
        while (true) {
            try {
                if (this.isNotFull()) {
                    this.insert(e2);
                    this.lock.unlock();
                    return true;
                }
                if (l2 <= 0L) {
                    this.lock.unlock();
                    return false;
                }
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                throw throwable;
            }
            {
                try {
                    l2 = this.notFull.awaitNanos(l2);
                    this.checkNotShutdown();
                }
                catch (InterruptedException interruptedException) {
                    this.notFull.signal();
                    throw interruptedException;
                }
            }
        }
    }

    @Override
    public E take() {
        this.lock.lockInterruptibly();
        try {
            this.checkNotShutdown();
            try {
                while (this.hasNoElements()) {
                    this.notEmpty.await();
                    this.checkNotShutdown();
                }
            }
            catch (InterruptedException interruptedException) {
                this.notEmpty.signal();
                throw interruptedException;
            }
            E e2 = this.extract();
            return e2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public TryTakeResult<E> tryTake() {
        boolean bl = this.lock.tryLock();
        if (!bl) {
            return new TryTakeResult(TryTakeResultCode.couldNotLock);
        }
        try {
            if (this.isShutdown) {
                TryTakeResult tryTakeResult = new TryTakeResult(TryTakeResultCode.queueWasShutDown);
                return tryTakeResult;
            }
            if (this.hasNoElements()) {
                TryTakeResult tryTakeResult = new TryTakeResult(TryTakeResultCode.queueWasEmpty);
                return tryTakeResult;
            }
            Object object = this.extract();
            object = new TryTakeResult(object);
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public E poll(long var1_1, TimeUnit var3_5) {
        var4_6 = var3_5.toNanos(var1_1);
        this.lock.lockInterruptibly();
        try {
            this.checkNotShutdown();
            while (true) lbl-1000:
            // 2 sources

            {
                if (!this.hasElements()) break block7;
                var1_2 = this.extract();
                this.lock.unlock();
                break;
            }
        }
        catch (Throwable var1_4) {
            this.lock.unlock();
            throw var1_4;
        }
        {
            block7: {
                return var1_2;
            }
            if (var4_6 <= 0L) {
                this.lock.unlock();
                return null;
            }
            try {
                var4_6 = this.notEmpty.awaitNanos(var4_6);
                this.checkNotShutdown();
                continue;
            }
            catch (InterruptedException var1_3) {
                this.notEmpty.signal();
                throw var1_3;
            }
            ** while (true)
        }
    }

    @Override
    public int remainingCapacity() {
        this.lock.lock();
        try {
            int n = this.items.length - this.count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        ArrayBlockingQueueWithShutdown.checkNotNull(collection);
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            int n;
            int n2 = this.takeIndex;
            for (n = 0; n < this.count; ++n) {
                collection.add(this.items[n2]);
                this.items[n2] = null;
                n2 = this.inc(n2);
            }
            if (n > 0) {
                this.count = 0;
                this.putIndex = 0;
                this.takeIndex = 0;
                this.notFull.signalAll();
            }
            int n3 = n;
            return n3;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        ArrayBlockingQueueWithShutdown.checkNotNull(collection);
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        if (n <= 0) {
            return 0;
        }
        this.lock.lock();
        try {
            int n2;
            int n3 = this.takeIndex;
            int n4 = n = n < this.count ? n : this.count;
            for (n2 = 0; n2 < n; ++n2) {
                collection.add(this.items[n3]);
                this.items[n3] = null;
                n3 = this.inc(n3);
            }
            if (n2 > 0) {
                this.count -= n2;
                this.takeIndex = n3;
                this.notFull.signalAll();
            }
            int n5 = n2;
            return n5;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        this.lock.lock();
        try {
            Itr itr = new Itr();
            return itr;
        }
        finally {
            this.lock.unlock();
        }
    }

    private class Itr
    implements Iterator<E> {
        private int nextIndex;
        private E nextItem;
        private int lastRet = -1;

        Itr() {
            if (ArrayBlockingQueueWithShutdown.this.count == 0) {
                this.nextIndex = -1;
                return;
            }
            this.nextIndex = ArrayBlockingQueueWithShutdown.this.takeIndex;
            this.nextItem = ArrayBlockingQueueWithShutdown.this.items[ArrayBlockingQueueWithShutdown.this.takeIndex];
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        private void checkNext() {
            if (this.nextIndex == ArrayBlockingQueueWithShutdown.this.putIndex) {
                this.nextIndex = -1;
                this.nextItem = null;
                return;
            }
            this.nextItem = ArrayBlockingQueueWithShutdown.this.items[this.nextIndex];
            if (this.nextItem == null) {
                this.nextIndex = -1;
            }
        }

        @Override
        public E next() {
            ArrayBlockingQueueWithShutdown.this.lock.lock();
            try {
                if (this.nextIndex < 0) {
                    throw new NoSuchElementException();
                }
                this.lastRet = this.nextIndex;
                Object e2 = this.nextItem;
                this.nextIndex = ArrayBlockingQueueWithShutdown.this.inc(this.nextIndex);
                this.checkNext();
                return e2;
            }
            finally {
                ArrayBlockingQueueWithShutdown.this.lock.unlock();
            }
        }

        @Override
        public void remove() {
            ArrayBlockingQueueWithShutdown.this.lock.lock();
            try {
                int n = this.lastRet;
                if (n < 0) {
                    throw new IllegalStateException();
                }
                this.lastRet = -1;
                int n2 = ArrayBlockingQueueWithShutdown.this.takeIndex;
                ArrayBlockingQueueWithShutdown.this.removeAt(n);
                this.nextIndex = n == n2 ? ArrayBlockingQueueWithShutdown.this.takeIndex : n;
                this.checkNext();
                return;
            }
            finally {
                ArrayBlockingQueueWithShutdown.this.lock.unlock();
            }
        }
    }

    public static final class TryTakeResult<E> {
        private final E element;
        private final TryTakeResultCode resultCode;

        private TryTakeResult(TryTakeResultCode tryTakeResultCode) {
            assert (tryTakeResultCode != null);
            this.resultCode = tryTakeResultCode;
            this.element = null;
        }

        private TryTakeResult(E e2) {
            assert (e2 != null);
            this.resultCode = TryTakeResultCode.takeSuccessful;
            this.element = e2;
        }

        public final TryTakeResultCode getResultCode() {
            return this.resultCode;
        }

        public final E getElement() {
            return this.element;
        }
    }

    public static enum TryTakeResultCode {
        couldNotLock,
        queueWasShutDown,
        queueWasEmpty,
        takeSuccessful;

    }

    public static enum TryPutResult {
        couldNotLock,
        queueWasShutDown,
        queueWasFull,
        putSuccessful;

    }
}

