/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CleaningWeakReferenceMap<K, V>
extends HashMap<K, WeakReference<V>> {
    private static final long serialVersionUID = 0L;
    private final int cleanInterval;
    private int numberOfInsertsSinceLastClean = 0;

    public CleaningWeakReferenceMap() {
        this(50);
    }

    public CleaningWeakReferenceMap(int n) {
        this.cleanInterval = n;
    }

    @Override
    public WeakReference<V> put(K object, WeakReference<V> weakReference) {
        object = super.put(object, weakReference);
        if (this.numberOfInsertsSinceLastClean++ > this.cleanInterval) {
            this.numberOfInsertsSinceLastClean = 0;
            this.clean();
        }
        return object;
    }

    private void clean() {
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry == null || entry.getValue() == null || ((WeakReference)entry.getValue()).get() != null) continue;
            iterator.remove();
        }
    }
}

