/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.security.SecureRandom;
import java.util.Random;

public class RandomUtil {
    static final ThreadLocal<SecureRandom> SECURE_RANDOM = new ThreadLocal<SecureRandom>(){

        @Override
        protected SecureRandom initialValue() {
            return new SecureRandom();
        }
    };
    static final ThreadLocal<Random> RANDOM = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };

    public static int nextSecureRandomInt(int n) {
        return SECURE_RANDOM.get().nextInt(n);
    }

    public static int nextSecureRandomInt() {
        return SECURE_RANDOM.get().nextInt();
    }

    public static void fillWithSecureRandom(byte[] byArray) {
        SECURE_RANDOM.get().nextBytes(byArray);
    }
}

