/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.FromNativeContext;
import com.sun.jna.Function;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeContext;
import com.sun.jna.WString;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class Pointer {
    public static final Pointer NULL = null;
    protected long peer;

    public static final Pointer createConstant(long l) {
        return new Opaque(l);
    }

    public static final Pointer createConstant(int n) {
        return new Opaque((long)n & 0xFFFFFFFFL);
    }

    Pointer() {
    }

    public Pointer(long l) {
        this.peer = l;
    }

    public Pointer share(long l) {
        return this.share(l, 0L);
    }

    public Pointer share(long l, long l2) {
        if (l == 0L) {
            return this;
        }
        return new Pointer(this.peer + l);
    }

    public void clear(long l) {
        this.setMemory(0L, l, (byte)0);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return object instanceof Pointer && ((Pointer)object).peer == this.peer;
    }

    public int hashCode() {
        return (int)((this.peer >>> 32) + (this.peer & 0xFFFFFFFFL));
    }

    public long indexOf(long l, byte by) {
        Pointer pointer = this;
        return Native.indexOf(pointer, pointer.peer, l, by);
    }

    public void read(long l, byte[] byArray, int n, int n2) {
        Pointer pointer = this;
        Native.read(pointer, pointer.peer, l, byArray, n, n2);
    }

    public void read(long l, short[] sArray, int n, int n2) {
        Pointer pointer = this;
        Native.read(pointer, pointer.peer, l, sArray, n, n2);
    }

    public void read(long l, char[] cArray, int n, int n2) {
        Pointer pointer = this;
        Native.read(pointer, pointer.peer, l, cArray, n, n2);
    }

    public void read(long l, int[] nArray, int n, int n2) {
        Pointer pointer = this;
        Native.read(pointer, pointer.peer, l, nArray, n, n2);
    }

    public void read(long l, long[] lArray, int n, int n2) {
        Pointer pointer = this;
        Native.read(pointer, pointer.peer, l, lArray, n, n2);
    }

    public void read(long l, float[] fArray, int n, int n2) {
        Pointer pointer = this;
        Native.read(pointer, pointer.peer, l, fArray, n, n2);
    }

    public void read(long l, double[] dArray, int n, int n2) {
        Pointer pointer = this;
        Native.read(pointer, pointer.peer, l, dArray, n, n2);
    }

    public void read(long l, Pointer[] pointerArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            Pointer pointer = this.getPointer(l + (long)(i * Native.POINTER_SIZE));
            Pointer pointer2 = pointerArray[i + n];
            if (pointer2 != null && pointer != null && pointer.peer == pointer2.peer) continue;
            pointerArray[i + n] = pointer;
        }
    }

    public void write(long l, byte[] byArray, int n, int n2) {
        Pointer pointer = this;
        Native.write(pointer, pointer.peer, l, byArray, n, n2);
    }

    public void write(long l, short[] sArray, int n, int n2) {
        Pointer pointer = this;
        Native.write(pointer, pointer.peer, l, sArray, n, n2);
    }

    public void write(long l, char[] cArray, int n, int n2) {
        Pointer pointer = this;
        Native.write(pointer, pointer.peer, l, cArray, n, n2);
    }

    public void write(long l, int[] nArray, int n, int n2) {
        Pointer pointer = this;
        Native.write(pointer, pointer.peer, l, nArray, n, n2);
    }

    public void write(long l, long[] lArray, int n, int n2) {
        Pointer pointer = this;
        Native.write(pointer, pointer.peer, l, lArray, n, n2);
    }

    public void write(long l, float[] fArray, int n, int n2) {
        Pointer pointer = this;
        Native.write(pointer, pointer.peer, l, fArray, n, n2);
    }

    public void write(long l, double[] dArray, int n, int n2) {
        Pointer pointer = this;
        Native.write(pointer, pointer.peer, l, dArray, n, n2);
    }

    public void write(long l, Pointer[] pointerArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.setPointer(l + (long)(i * Native.POINTER_SIZE), pointerArray[n + i]);
        }
    }

    Object getValue(long l, Class<?> clazz, Object object) {
        Object object2 = null;
        if (Structure.class.isAssignableFrom(clazz)) {
            Structure structure = (Structure)object;
            if (Structure.ByReference.class.isAssignableFrom(clazz)) {
                structure = Structure.updateStructureByReference(clazz, structure, this.getPointer(l));
            } else {
                structure.useMemory(this, (int)l, true);
                structure.read();
            }
            object2 = structure;
        } else if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            object2 = Function.valueOf(this.getInt(l) != 0);
        } else if (clazz == Byte.TYPE || clazz == Byte.class) {
            object2 = this.getByte(l);
        } else if (clazz == Short.TYPE || clazz == Short.class) {
            object2 = this.getShort(l);
        } else if (clazz == Character.TYPE || clazz == Character.class) {
            object2 = Character.valueOf(this.getChar(l));
        } else if (clazz == Integer.TYPE || clazz == Integer.class) {
            object2 = this.getInt(l);
        } else if (clazz == Long.TYPE || clazz == Long.class) {
            object2 = this.getLong(l);
        } else if (clazz == Float.TYPE || clazz == Float.class) {
            object2 = Float.valueOf(this.getFloat(l));
        } else if (clazz == Double.TYPE || clazz == Double.class) {
            object2 = this.getDouble(l);
        } else if (Pointer.class.isAssignableFrom(clazz)) {
            Pointer pointer = this.getPointer(l);
            if (pointer != null) {
                object2 = object instanceof Pointer ? (Pointer)object : null;
                if (object2 == null || pointer.peer != ((Pointer)object2).peer) {
                    object2 = pointer;
                }
            }
        } else if (clazz == String.class) {
            Pointer pointer = this.getPointer(l);
            object2 = pointer != null ? pointer.getString(0L) : null;
        } else if (clazz == WString.class) {
            Pointer pointer = this.getPointer(l);
            object2 = pointer != null ? new WString(pointer.getWideString(0L)) : null;
        } else if (Callback.class.isAssignableFrom(clazz)) {
            Pointer pointer = this.getPointer(l);
            if (pointer == null) {
                object2 = null;
            } else {
                object2 = (Callback)object;
                Pointer pointer2 = CallbackReference.getFunctionPointer((Callback)object2);
                if (!pointer.equals(pointer2)) {
                    object2 = CallbackReference.getCallback(clazz, pointer);
                }
            }
        } else if (Platform.HAS_BUFFERS && Buffer.class.isAssignableFrom(clazz)) {
            Pointer pointer = this.getPointer(l);
            if (pointer == null) {
                object2 = null;
            } else {
                object2 = object == null ? null : Native.getDirectBufferPointer((Buffer)object);
                if (object2 == null || !((Pointer)object2).equals(pointer)) {
                    throw new IllegalStateException("Can't autogenerate a direct buffer on memory read");
                }
                object2 = object;
            }
        } else if (NativeMapped.class.isAssignableFrom(clazz)) {
            NativeMapped nativeMapped = (NativeMapped)object;
            if (nativeMapped != null) {
                object2 = this.getValue(l, nativeMapped.nativeType(), null);
                if (nativeMapped.equals(object2 = nativeMapped.fromNative(object2, new FromNativeContext(clazz)))) {
                    object2 = nativeMapped;
                }
            } else {
                object2 = NativeMappedConverter.getInstance(clazz);
                Object object3 = this.getValue(l, ((NativeMappedConverter)object2).nativeType(), null);
                object2 = ((NativeMappedConverter)object2).fromNative(object3, new FromNativeContext(clazz));
            }
        } else if (clazz.isArray()) {
            object2 = object;
            if (object2 == null) {
                throw new IllegalStateException("Need an initialized array");
            }
            this.readArray(l, object2, clazz.getComponentType());
        } else {
            throw new IllegalArgumentException("Reading \"" + clazz + "\" from memory is not supported");
        }
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readArray(long l, Object structureArray, Class<?> clazz) {
        Structure structure;
        Structure[] structureArray2;
        int n = Array.getLength(structureArray);
        if (clazz == Byte.TYPE) {
            this.read(l, (byte[])structureArray, 0, n);
            return;
        }
        if (clazz == Short.TYPE) {
            this.read(l, (short[])structureArray, 0, n);
            return;
        }
        if (clazz == Character.TYPE) {
            this.read(l, (char[])structureArray, 0, n);
            return;
        }
        if (clazz == Integer.TYPE) {
            this.read(l, (int[])structureArray, 0, n);
            return;
        }
        if (clazz == Long.TYPE) {
            this.read(l, (long[])structureArray, 0, n);
            return;
        }
        if (clazz == Float.TYPE) {
            this.read(l, (float[])structureArray, 0, n);
            return;
        }
        if (clazz == Double.TYPE) {
            this.read(l, (double[])structureArray, 0, n);
            return;
        }
        if (Pointer.class.isAssignableFrom(clazz)) {
            this.read(l, (Pointer[])structureArray, 0, n);
            return;
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            structureArray2 = structureArray;
            if (Structure.ByReference.class.isAssignableFrom(clazz)) {
                Pointer[] pointerArray = this.getPointerArray(l, structureArray2.length);
                int n2 = 0;
                while (true) {
                    if (n2 >= structureArray2.length) {
                        return;
                    }
                    structureArray2[n2] = Structure.updateStructureByReference(clazz, structureArray2[n2], pointerArray[n2]);
                    ++n2;
                }
            }
            structure = structureArray2[0];
            if (structure == null) {
                structure = Structure.newInstance(clazz, this.share(l));
                structure.conditionalAutoRead();
                structureArray2[0] = structure;
            } else {
                structure.useMemory(this, (int)l, true);
                structure.read();
            }
        } else {
            if (!NativeMapped.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Reading array of " + clazz + " from memory not supported");
            }
            NativeMapped[] nativeMappedArray = (NativeMapped[])structureArray;
            NativeMappedConverter nativeMappedConverter = NativeMappedConverter.getInstance(clazz);
            int n3 = Native.getNativeSize(structureArray.getClass(), structureArray) / nativeMappedArray.length;
            int n4 = 0;
            while (true) {
                if (n4 >= nativeMappedArray.length) {
                    return;
                }
                Object object = this.getValue(l + (long)(n3 * n4), nativeMappedConverter.nativeType(), nativeMappedArray[n4]);
                nativeMappedArray[n4] = (NativeMapped)nativeMappedConverter.fromNative(object, new FromNativeContext(clazz));
                ++n4;
            }
        }
        structureArray = structure.toArray(structureArray2.length);
        int n5 = 1;
        while (n5 < structureArray2.length) {
            if (structureArray2[n5] == null) {
                structureArray2[n5] = structureArray[n5];
            } else {
                structureArray2[n5].useMemory(this, (int)(l + (long)(n5 * structureArray2[n5].size())), true);
                structureArray2[n5].read();
            }
            ++n5;
        }
        return;
    }

    public byte getByte(long l) {
        Pointer pointer = this;
        return Native.getByte(pointer, pointer.peer, l);
    }

    public char getChar(long l) {
        Pointer pointer = this;
        return Native.getChar(pointer, pointer.peer, l);
    }

    public short getShort(long l) {
        Pointer pointer = this;
        return Native.getShort(pointer, pointer.peer, l);
    }

    public int getInt(long l) {
        Pointer pointer = this;
        return Native.getInt(pointer, pointer.peer, l);
    }

    public long getLong(long l) {
        Pointer pointer = this;
        return Native.getLong(pointer, pointer.peer, l);
    }

    public NativeLong getNativeLong(long l) {
        return new NativeLong(NativeLong.SIZE == 8 ? this.getLong(l) : (long)this.getInt(l));
    }

    public float getFloat(long l) {
        Pointer pointer = this;
        return Native.getFloat(pointer, pointer.peer, l);
    }

    public double getDouble(long l) {
        Pointer pointer = this;
        return Native.getDouble(pointer, pointer.peer, l);
    }

    public Pointer getPointer(long l) {
        return Native.getPointer(this.peer + l);
    }

    public ByteBuffer getByteBuffer(long l, long l2) {
        Pointer pointer = this;
        return Native.getDirectByteBuffer(pointer, pointer.peer, l, l2).order(ByteOrder.nativeOrder());
    }

    public String getWideString(long l) {
        Pointer pointer = this;
        return Native.getWideString(pointer, pointer.peer, l);
    }

    public String getString(long l) {
        return this.getString(l, Native.getDefaultStringEncoding());
    }

    public String getString(long l, String string) {
        return Native.getString(this, l, string);
    }

    public byte[] getByteArray(long l, int n) {
        byte[] byArray = new byte[n];
        this.read(l, byArray, 0, n);
        return byArray;
    }

    public char[] getCharArray(long l, int n) {
        char[] cArray = new char[n];
        this.read(l, cArray, 0, n);
        return cArray;
    }

    public short[] getShortArray(long l, int n) {
        short[] sArray = new short[n];
        this.read(l, sArray, 0, n);
        return sArray;
    }

    public int[] getIntArray(long l, int n) {
        int[] nArray = new int[n];
        this.read(l, nArray, 0, n);
        return nArray;
    }

    public long[] getLongArray(long l, int n) {
        long[] lArray = new long[n];
        this.read(l, lArray, 0, n);
        return lArray;
    }

    public float[] getFloatArray(long l, int n) {
        float[] fArray = new float[n];
        this.read(l, fArray, 0, n);
        return fArray;
    }

    public double[] getDoubleArray(long l, int n) {
        double[] dArray = new double[n];
        this.read(l, dArray, 0, n);
        return dArray;
    }

    public Pointer[] getPointerArray(long l) {
        ArrayList<Pointer> arrayList = new ArrayList<Pointer>();
        int n = 0;
        Pointer pointer = this.getPointer(l);
        while (pointer != null) {
            arrayList.add(pointer);
            pointer = this.getPointer(l + (long)(n += Native.POINTER_SIZE));
        }
        return arrayList.toArray(new Pointer[0]);
    }

    public Pointer[] getPointerArray(long l, int n) {
        Pointer[] pointerArray = new Pointer[n];
        this.read(l, pointerArray, 0, n);
        return pointerArray;
    }

    public String[] getStringArray(long l) {
        return this.getStringArray(l, -1, Native.getDefaultStringEncoding());
    }

    public String[] getStringArray(long l, String string) {
        return this.getStringArray(l, -1, string);
    }

    public String[] getStringArray(long l, int n) {
        return this.getStringArray(l, n, Native.getDefaultStringEncoding());
    }

    public String[] getWideStringArray(long l) {
        return this.getWideStringArray(l, -1);
    }

    public String[] getWideStringArray(long l, int n) {
        return this.getStringArray(l, n, "--WIDE-STRING--");
    }

    public String[] getStringArray(long l, int n, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        if (n != -1) {
            Pointer pointer = this.getPointer(l);
            int n3 = 0;
            while (n3++ < n) {
                String string2 = pointer == null ? null : ("--WIDE-STRING--".equals(string) ? pointer.getWideString(0L) : pointer.getString(0L, string));
                arrayList.add(string2);
                if (n3 >= n) continue;
                pointer = this.getPointer(l + (long)(n2 += Native.POINTER_SIZE));
            }
        } else {
            Pointer pointer;
            while ((pointer = this.getPointer(l + (long)n2)) != null) {
                String string3 = "--WIDE-STRING--".equals(string) ? pointer.getWideString(0L) : pointer.getString(0L, string);
                arrayList.add(string3);
                n2 += Native.POINTER_SIZE;
            }
        }
        return arrayList.toArray(new String[0]);
    }

    void setValue(long l, Object object, Class<?> clazz) {
        Structure structure;
        block18: {
            block15: {
                block17: {
                    block16: {
                        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                            this.setInt(l, Boolean.TRUE.equals(object) ? -1 : 0);
                            return;
                        }
                        if (clazz == Byte.TYPE || clazz == Byte.class) {
                            this.setByte(l, object == null ? (byte)0 : (Byte)object);
                            return;
                        }
                        if (clazz == Short.TYPE || clazz == Short.class) {
                            this.setShort(l, object == null ? (short)0 : (Short)object);
                            return;
                        }
                        if (clazz == Character.TYPE || clazz == Character.class) {
                            this.setChar(l, object == null ? (char)'\u0000' : ((Character)object).charValue());
                            return;
                        }
                        if (clazz == Integer.TYPE || clazz == Integer.class) {
                            this.setInt(l, object == null ? 0 : (Integer)object);
                            return;
                        }
                        if (clazz == Long.TYPE || clazz == Long.class) {
                            this.setLong(l, object == null ? 0L : (Long)object);
                            return;
                        }
                        if (clazz == Float.TYPE || clazz == Float.class) {
                            this.setFloat(l, object == null ? 0.0f : ((Float)object).floatValue());
                            return;
                        }
                        if (clazz == Double.TYPE || clazz == Double.class) {
                            this.setDouble(l, object == null ? 0.0 : (Double)object);
                            return;
                        }
                        if (clazz == Pointer.class) {
                            this.setPointer(l, (Pointer)object);
                            return;
                        }
                        if (clazz == String.class) {
                            this.setPointer(l, (Pointer)object);
                            return;
                        }
                        if (clazz == WString.class) {
                            this.setPointer(l, (Pointer)object);
                            return;
                        }
                        if (!Structure.class.isAssignableFrom(clazz)) break block15;
                        structure = (Structure)object;
                        if (!Structure.ByReference.class.isAssignableFrom(clazz)) break block16;
                        this.setPointer(l, structure == null ? null : structure.getPointer());
                        if (structure == null) break block17;
                        break block18;
                    }
                    structure.useMemory(this, (int)l, true);
                    structure.write();
                }
                return;
            }
            if (Callback.class.isAssignableFrom(clazz)) {
                this.setPointer(l, CallbackReference.getFunctionPointer((Callback)object));
                return;
            }
            if (Platform.HAS_BUFFERS && Buffer.class.isAssignableFrom(clazz)) {
                Pointer pointer = object == null ? null : Native.getDirectBufferPointer((Buffer)object);
                this.setPointer(l, pointer);
                return;
            }
            if (NativeMapped.class.isAssignableFrom(clazz)) {
                NativeMappedConverter nativeMappedConverter = NativeMappedConverter.getInstance(clazz);
                clazz = nativeMappedConverter.nativeType();
                this.setValue(l, nativeMappedConverter.toNative(object, new ToNativeContext()), clazz);
                return;
            }
            if (clazz.isArray()) {
                this.writeArray(l, object, clazz.getComponentType());
                return;
            }
            throw new IllegalArgumentException("Writing " + clazz + " to memory is not supported");
        }
        structure.autoWrite();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writeArray(long l, Object object, Class<?> object2) {
        Structure structure;
        Structure[] structureArray;
        block18: {
            block20: {
                block19: {
                    if (object2 == Byte.TYPE) {
                        byte[] byArray = (byte[])object;
                        this.write(l, byArray, 0, byArray.length);
                        return;
                    }
                    if (object2 == Short.TYPE) {
                        short[] sArray = (short[])object;
                        this.write(l, sArray, 0, sArray.length);
                        return;
                    }
                    if (object2 == Character.TYPE) {
                        char[] cArray = (char[])object;
                        this.write(l, cArray, 0, cArray.length);
                        return;
                    }
                    if (object2 == Integer.TYPE) {
                        int[] nArray = (int[])object;
                        this.write(l, nArray, 0, nArray.length);
                        return;
                    }
                    if (object2 == Long.TYPE) {
                        long[] lArray = (long[])object;
                        this.write(l, lArray, 0, lArray.length);
                        return;
                    }
                    if (object2 == Float.TYPE) {
                        float[] fArray = (float[])object;
                        this.write(l, fArray, 0, fArray.length);
                        return;
                    }
                    if (object2 == Double.TYPE) {
                        double[] dArray = (double[])object;
                        this.write(l, dArray, 0, dArray.length);
                        return;
                    }
                    if (Pointer.class.isAssignableFrom((Class<?>)object2)) {
                        Pointer[] pointerArray = (Pointer[])object;
                        this.write(l, pointerArray, 0, pointerArray.length);
                        return;
                    }
                    if (!Structure.class.isAssignableFrom((Class<?>)object2)) break block19;
                    structureArray = (Structure[])object;
                    if (Structure.ByReference.class.isAssignableFrom((Class<?>)object2)) break block20;
                    structure = structureArray[0];
                    if (structure == null) {
                        structureArray[0] = structure = Structure.newInstance(object2, this.share(l));
                        break block18;
                    } else {
                        structure.useMemory(this, (int)l, true);
                    }
                    break block18;
                }
                if (!NativeMapped.class.isAssignableFrom((Class<?>)object2)) throw new IllegalArgumentException("Writing array of " + object2 + " to memory not supported");
                NativeMapped[] nativeMappedArray = (NativeMapped[])object;
                NativeMappedConverter nativeMappedConverter = NativeMappedConverter.getInstance(object2);
                object2 = nativeMappedConverter.nativeType();
                int n = Native.getNativeSize(object.getClass(), object) / nativeMappedArray.length;
                int n2 = 0;
                while (n2 < nativeMappedArray.length) {
                    Object object3 = nativeMappedConverter.toNative(nativeMappedArray[n2], new ToNativeContext());
                    this.setValue(l + (long)(n2 * n), object3, (Class<?>)object2);
                    ++n2;
                }
                return;
            }
            Pointer[] pointerArray = new Pointer[structureArray.length];
            int n = 0;
            while (true) {
                if (n >= structureArray.length) {
                    this.write(l, pointerArray, 0, pointerArray.length);
                    return;
                }
                if (structureArray[n] == null) {
                    pointerArray[n] = null;
                } else {
                    pointerArray[n] = structureArray[n].getPointer();
                    structureArray[n].write();
                }
                ++n;
            }
        }
        structure.write();
        object2 = structure.toArray(structureArray.length);
        int n = 1;
        while (n < structureArray.length) {
            if (structureArray[n] == null) {
                structureArray[n] = object2[n];
            } else {
                structureArray[n].useMemory(this, (int)(l + (long)(n * structureArray[n].size())), true);
            }
            structureArray[n].write();
            ++n;
        }
    }

    public void setMemory(long l, long l2, byte by) {
        Pointer pointer = this;
        Native.setMemory(pointer, pointer.peer, l, l2, by);
    }

    public void setByte(long l, byte by) {
        Pointer pointer = this;
        Native.setByte(pointer, pointer.peer, l, by);
    }

    public void setShort(long l, short s) {
        Pointer pointer = this;
        Native.setShort(pointer, pointer.peer, l, s);
    }

    public void setChar(long l, char c) {
        Pointer pointer = this;
        Native.setChar(pointer, pointer.peer, l, c);
    }

    public void setInt(long l, int n) {
        Pointer pointer = this;
        Native.setInt(pointer, pointer.peer, l, n);
    }

    public void setLong(long l, long l2) {
        Pointer pointer = this;
        Native.setLong(pointer, pointer.peer, l, l2);
    }

    public void setNativeLong(long l, NativeLong nativeLong) {
        if (NativeLong.SIZE == 8) {
            this.setLong(l, nativeLong.longValue());
            return;
        }
        this.setInt(l, nativeLong.intValue());
    }

    public void setFloat(long l, float f) {
        Pointer pointer = this;
        Native.setFloat(pointer, pointer.peer, l, f);
    }

    public void setDouble(long l, double d) {
        Pointer pointer = this;
        Native.setDouble(pointer, pointer.peer, l, d);
    }

    public void setPointer(long l, Pointer pointer) {
        Pointer pointer2 = this;
        Native.setPointer(pointer2, pointer2.peer, l, pointer != null ? pointer.peer : 0L);
    }

    public void setWideString(long l, String string) {
        Pointer pointer = this;
        Native.setWideString(pointer, pointer.peer, l, string);
    }

    public void setString(long l, WString wString) {
        this.setWideString(l, wString == null ? null : wString.toString());
    }

    public void setString(long l, String string) {
        this.setString(l, string, Native.getDefaultStringEncoding());
    }

    public void setString(long l, String object, String string) {
        object = Native.getBytes((String)object, string);
        this.write(l, (byte[])object, 0, ((Object)object).length);
        this.setByte(l + (long)((Object)object).length, (byte)0);
    }

    public String dump(long l, int n) {
        StringWriter stringWriter = new StringWriter(11 + 2 + (n << 1) + (n / 4 << 2));
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("memory dump");
        for (int i = 0; i < n; ++i) {
            byte by = this.getByte(l + (long)i);
            if (i % 4 == 0) {
                printWriter.print("[");
            }
            if (by >= 0 && by < 16) {
                printWriter.print("0");
            }
            printWriter.print(Integer.toHexString(by & 0xFF));
            if (i % 4 != 3 || i >= n - 1) continue;
            printWriter.println("]");
        }
        if (stringWriter.getBuffer().charAt(stringWriter.getBuffer().length() - 2) != ']') {
            printWriter.println("]");
        }
        return stringWriter.toString();
    }

    public String toString() {
        return "native@0x" + Long.toHexString(this.peer);
    }

    public static long nativeValue(Pointer pointer) {
        if (pointer == null) {
            return 0L;
        }
        return pointer.peer;
    }

    public static void nativeValue(Pointer pointer, long l) {
        pointer.peer = l;
    }

    private static class Opaque
    extends Pointer {
        private final String MSG = "This pointer is opaque: " + this;

        private Opaque(long l) {
            super(l);
        }

        @Override
        public Pointer share(long l, long l2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void clear(long l) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public long indexOf(long l, byte by) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long l, byte[] byArray, int n, int n2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long l, char[] cArray, int n, int n2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long l, short[] sArray, int n, int n2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long l, int[] nArray, int n, int n2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long l, long[] lArray, int n, int n2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long l, float[] fArray, int n, int n2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long l, double[] dArray, int n, int n2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long l, Pointer[] pointerArray, int n, int n2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long l, byte[] byArray, int n, int n2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long l, char[] cArray, int n, int n2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long l, short[] sArray, int n, int n2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long l, int[] nArray, int n, int n2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long l, long[] lArray, int n, int n2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long l, float[] fArray, int n, int n2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long l, double[] dArray, int n, int n2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long l, Pointer[] pointerArray, int n, int n2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public ByteBuffer getByteBuffer(long l, long l2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public byte getByte(long l) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public char getChar(long l) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public short getShort(long l) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public int getInt(long l) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public long getLong(long l) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public float getFloat(long l) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public double getDouble(long l) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public Pointer getPointer(long l) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public String getString(long l, String string) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public String getWideString(long l) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setByte(long l, byte by) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setChar(long l, char c) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setShort(long l, short s) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setInt(long l, int n) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setLong(long l, long l2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setFloat(long l, float f) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setDouble(long l, double d) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setPointer(long l, Pointer pointer) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setString(long l, String string, String string2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setWideString(long l, String string) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setMemory(long l, long l2, byte by) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public String dump(long l, int n) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public String toString() {
            return "const@0x" + Long.toHexString(this.peer);
        }
    }
}

